/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.texturing;

import exnihiloadscensio.texturing.Color;
import exnihiloadscensio.texturing.ImageManipulator;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class TextureDynamic
extends TextureAtlasSprite {
    private ResourceLocation template;
    private ResourceLocation base;
    private Color color;

    public TextureDynamic(String name, ResourceLocation base, ResourceLocation template, Color color) {
        super(name);
        this.template = template;
        this.base = base;
        this.color = color;
    }

    public static String getTextureName(String name) {
        return "exnihiloadscensio:" + name;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        try {
            manager.func_110536_a(location);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        int mipmapLevels = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        try {
            BufferedImage imgBase;
            BufferedImage[] imgFinal = new BufferedImage[1 + mipmapLevels];
            imgFinal[0] = this.tryLoadImage(manager, this.template);
            if (this.color != null) {
                imgFinal[0] = ImageManipulator.Recolor(imgFinal[0], this.color);
            }
            if (this.base != null && (imgBase = this.tryLoadImage(manager, this.base)) != null) {
                imgFinal[0] = ImageManipulator.Composite(imgBase, imgFinal[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    private BufferedImage tryLoadImage(IResourceManager manager, ResourceLocation location) {
        try {
            IResource res = manager.func_110536_a(location);
            BufferedImage imgOutput = ImageIO.read(res.func_110527_b());
            return imgOutput;
        }
        catch (Exception e) {
            return null;
        }
    }
}

