/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.registries;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihiloadscensio.json.CustomBlockInfoJson;
import exnihiloadscensio.json.CustomItemInfoJson;
import exnihiloadscensio.registries.manager.ISieveDefaultRegistryProvider;
import exnihiloadscensio.registries.manager.RegistryManager;
import exnihiloadscensio.registries.types.Siftable;
import exnihiloadscensio.util.BlockInfo;
import exnihiloadscensio.util.ItemInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class SieveRegistry {
    private static HashMap<BlockInfo, ArrayList<Siftable>> registry = new HashMap();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).create();

    public static void register(BlockInfo block, ItemInfo drop, float chance, int meshLevel) {
        SieveRegistry.register(block, new Siftable(drop, chance, meshLevel));
    }

    public static void register(IBlockState state, ItemInfo drop, float chance, int meshLevel) {
        SieveRegistry.register(new BlockInfo(state), new Siftable(drop, chance, meshLevel));
    }

    public static void register(IBlockState state, ItemStack drop, float chance, int meshLevel) {
        SieveRegistry.register(new BlockInfo(state), new Siftable(new ItemInfo(drop), chance, meshLevel));
    }

    public static void register(BlockInfo block, Siftable drop) {
        if (block == null) {
            return;
        }
        ArrayList<Siftable> drops = registry.get(block);
        if (drops == null) {
            drops = new ArrayList();
        }
        drops.add(drop);
        registry.put(block, drops);
    }

    public static ArrayList<Siftable> getDrops(BlockInfo block) {
        if (!registry.containsKey(block)) {
            return null;
        }
        return registry.get(block);
    }

    public static ArrayList<Siftable> getDrops(ItemStack block) {
        return SieveRegistry.getDrops(new BlockInfo(block));
    }

    public static List<ItemStack> getRewardDrops(Random random, IBlockState block, int meshLevel, int fortuneLevel) {
        if (block == null) {
            return null;
        }
        ArrayList<Siftable> siftables = SieveRegistry.getDrops(new BlockInfo(block));
        if (siftables == null) {
            return null;
        }
        ArrayList drops = Lists.newArrayList();
        for (Siftable siftable : siftables) {
            if (meshLevel != siftable.getMeshLevel()) continue;
            int triesWithFortune = Math.max(random.nextInt(fortuneLevel + 2), 1);
            for (int i = 0; i < triesWithFortune; ++i) {
                if (!(random.nextDouble() < (double)siftable.getChance())) continue;
                drops.add(siftable.getDrop().getItemStack());
            }
        }
        return drops;
    }

    public static boolean canBeSifted(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return registry.containsKey(new BlockInfo(stack));
    }

    public static void registerDefaults() {
        for (ISieveDefaultRegistryProvider provider : RegistryManager.getDefaultSieveRecipeHandlers()) {
            provider.registerSieveRecipeDefaults();
        }
    }

    public static void loadJson(File file) {
        registry.clear();
        if (file.exists()) {
            try {
                FileReader fr = new FileReader(file);
                HashMap gsonInput = (HashMap)gson.fromJson((Reader)fr, new TypeToken<HashMap<String, ArrayList<Siftable>>>(){}.getType());
                for (Map.Entry input : gsonInput.entrySet()) {
                    BlockInfo block = new BlockInfo((String)input.getKey());
                    registry.put(block, (ArrayList<Siftable>)input.getValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            SieveRegistry.registerDefaults();
            SieveRegistry.saveJson(file);
        }
    }

    public static void saveJson(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            gson.toJson(registry, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<BlockInfo, ArrayList<Siftable>> getRegistry() {
        return registry;
    }
}

