/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.registries;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihiloadscensio.json.CustomItemStackJson;
import exnihiloadscensio.registries.HammerReward;
import exnihiloadscensio.registries.manager.IHammerDefaultRegistryProvider;
import exnihiloadscensio.registries.manager.RegistryManager;
import exnihiloadscensio.util.ItemInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class HammerRegistry {
    private static HashMap<ItemInfo, List<HammerReward>> registry = new HashMap();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemStack.class, (Object)new CustomItemStackJson()).create();

    public static void loadJson(File file) {
        registry.clear();
        if (file.exists()) {
            try {
                FileReader fr = new FileReader(file);
                HashMap gsonInput = (HashMap)gson.fromJson((Reader)fr, new TypeToken<HashMap<String, ArrayList<HammerReward>>>(){}.getType());
                for (String s : gsonInput.keySet()) {
                    ItemInfo stack = new ItemInfo(s);
                    registry.put(stack, (List<HammerReward>)gsonInput.get(s));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            HammerRegistry.registerDefaults();
            HammerRegistry.saveJson(file);
        }
    }

    public static void saveJson(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            gson.toJson(registry, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void addHammerRecipe(IBlockState state, ItemStack reward, int miningLevel, float chance, float fortuneChance) {
        HammerRegistry.register(state, reward, miningLevel, chance, fortuneChance);
    }

    public static void register(IBlockState state, ItemStack reward, int miningLevel, float chance, float fortuneChance) {
        HammerRegistry.register(state, reward, miningLevel, chance, fortuneChance, false);
    }

    public static void register(IBlockState state, ItemStack reward, int miningLevel, float chance, float fortuneChance, boolean wildcard) {
        List<HammerReward> rewards;
        ItemInfo key = new ItemInfo(state);
        if (wildcard) {
            key.setMeta(-1);
        }
        if ((rewards = registry.get(key)) == null) {
            rewards = new ArrayList<HammerReward>();
        }
        rewards.add(new HammerReward(reward, miningLevel, chance, fortuneChance));
        registry.put(key, rewards);
    }

    public static List<ItemStack> getRewardDrops(Random random, IBlockState block, int miningLevel, int fortuneLevel) {
        ArrayList<ItemStack> rewards = new ArrayList<ItemStack>();
        for (HammerReward reward : HammerRegistry.getRewards(block)) {
            if (miningLevel < reward.getMiningLevel() || !(random.nextFloat() <= reward.getChance() + reward.getFortuneChance() * (float)fortuneLevel)) continue;
            rewards.add(reward.getStack().func_77946_l());
        }
        return rewards;
    }

    public static List<HammerReward> getRewards(IBlockState block) {
        return registry.getOrDefault(new ItemInfo(block), Collections.EMPTY_LIST);
    }

    public static boolean registered(Block block) {
        return registry.containsKey(new ItemInfo(block.func_176223_P()));
    }

    public static void registerDefaults() {
        for (IHammerDefaultRegistryProvider provider : RegistryManager.getDefaultHammerRecipeHandlers()) {
            provider.registerHammerRecipeDefaults();
        }
    }

    @Deprecated
    public static ArrayList<HammerReward> getRewards(IBlockState state, int miningLevel) {
        List<HammerReward> mapList = registry.getOrDefault(new ItemInfo(state), Collections.EMPTY_LIST);
        ArrayList<HammerReward> ret = new ArrayList<HammerReward>();
        for (HammerReward reward : mapList) {
            if (reward.getMiningLevel() > miningLevel) continue;
            ret.add(reward);
        }
        return ret;
    }

    public static HashMap<ItemInfo, List<HammerReward>> getRegistry() {
        return registry;
    }
}

