/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.registries;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihiloadscensio.json.CustomItemInfoJson;
import exnihiloadscensio.registries.manager.IFluidOnTopDefaultRegistryProvider;
import exnihiloadscensio.registries.manager.RegistryManager;
import exnihiloadscensio.registries.types.FluidFluidBlock;
import exnihiloadscensio.util.ItemInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.Fluid;

public class FluidOnTopRegistry {
    private static ArrayList<FluidFluidBlock> registry = new ArrayList();
    private static List<FluidFluidBlock> externalRegistry = new ArrayList<FluidFluidBlock>();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).create();

    public static void register(Fluid fluidInBarrel, Fluid fluidOnTop, ItemInfo result) {
        FluidOnTopRegistry.registerInternal(fluidInBarrel, fluidOnTop, result);
        externalRegistry.add(new FluidFluidBlock(fluidInBarrel.getName(), fluidOnTop.getName(), result));
    }

    private static void registerInternal(Fluid fluidInBarrel, Fluid fluidOnTop, ItemInfo result) {
        registry.add(new FluidFluidBlock(fluidInBarrel.getName(), fluidOnTop.getName(), result));
    }

    public static boolean isValidRecipe(Fluid fluidInBarrel, Fluid fluidOnTop) {
        if (fluidInBarrel == null || fluidOnTop == null) {
            return false;
        }
        for (FluidFluidBlock fBlock : registry) {
            if (!fBlock.getFluidInBarrel().equals(fluidInBarrel.getName()) || !fBlock.getFluidOnTop().equals(fluidOnTop.getName())) continue;
            return true;
        }
        return false;
    }

    public static ItemInfo getTransformedBlock(Fluid fluidInBarrel, Fluid fluidOnTop) {
        for (FluidFluidBlock fBlock : registry) {
            if (!fBlock.getFluidInBarrel().equals(fluidInBarrel.getName()) || !fBlock.getFluidOnTop().equals(fluidOnTop.getName())) continue;
            return fBlock.getResult();
        }
        return null;
    }

    public static void loadJson(File file) {
        registry.clear();
        if (file.exists()) {
            try {
                FileReader fr = new FileReader(file);
                List gsonInput = (List)gson.fromJson((Reader)fr, new TypeToken<List<FluidFluidBlock>>(){}.getType());
                registry.addAll(gsonInput);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            FluidOnTopRegistry.registerDefaults();
            FluidOnTopRegistry.saveJson(file);
        }
        registry.addAll(externalRegistry);
    }

    public static void saveJson(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            gson.toJson(registry, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerDefaults() {
        for (IFluidOnTopDefaultRegistryProvider provider : RegistryManager.getDefaultFluidOnTopRecipeHandlers()) {
            provider.registerFluidOnTopRecipeDefaults();
        }
    }

    public static ArrayList<FluidFluidBlock> getRegistry() {
        return registry;
    }
}

