/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.registries;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihiloadscensio.json.CustomBlockInfoJson;
import exnihiloadscensio.json.CustomItemInfoJson;
import exnihiloadscensio.registries.manager.ICrucibleDefaultRegistryProvider;
import exnihiloadscensio.registries.manager.RegistryManager;
import exnihiloadscensio.registries.types.Meltable;
import exnihiloadscensio.util.BlockInfo;
import exnihiloadscensio.util.ItemInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class CrucibleRegistry {
    private static Map<ItemInfo, Meltable> registry = new HashMap<ItemInfo, Meltable>();
    private static Map<ItemInfo, Meltable> externalRegistry = new HashMap<ItemInfo, Meltable>();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).create();

    public static void register(ItemInfo item, Fluid fluid, int amount) {
        CrucibleRegistry.register(item, new Meltable(fluid.getName(), amount));
    }

    public static void register(ItemStack stack, Fluid fluid, int amount) {
        CrucibleRegistry.register(new ItemInfo(stack), new Meltable(fluid.getName(), amount));
    }

    public static void register(ItemInfo item, Meltable meltable) {
        CrucibleRegistry.registerInternal(item, meltable);
        externalRegistry.put(item, meltable);
    }

    private static void registerInternal(ItemStack stack, Fluid fluid, int amount) {
        CrucibleRegistry.registerInternal(new ItemInfo(stack), new Meltable(fluid.getName(), amount));
    }

    private static void registerInternal(ItemInfo item, Meltable meltable) {
        registry.put(item, meltable);
    }

    public static boolean canBeMelted(ItemStack stack) {
        return CrucibleRegistry.canBeMelted(new ItemInfo(stack));
    }

    public static boolean canBeMelted(ItemInfo info) {
        return registry.containsKey(info) && FluidRegistry.isFluidRegistered((String)registry.get(info).getFluid());
    }

    public static Meltable getMeltable(ItemStack stack) {
        ItemInfo info = new ItemInfo(stack);
        return registry.get(info);
    }

    public static Meltable getMeltable(ItemInfo info) {
        return registry.get(info);
    }

    public static void registerDefaults() {
        for (ICrucibleDefaultRegistryProvider provider : RegistryManager.getDefaultCrucibleRecipeHandlers()) {
            provider.registerCrucibleRecipeDefaults();
        }
    }

    public static void loadJson(File file) {
        registry.clear();
        if (file.exists()) {
            try {
                FileReader fr = new FileReader(file);
                Map gsonInput = (Map)gson.fromJson((Reader)fr, new TypeToken<Map<String, Meltable>>(){}.getType());
                for (Map.Entry entry : gsonInput.entrySet()) {
                    registry.put(new ItemInfo((String)entry.getKey()), (Meltable)entry.getValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            CrucibleRegistry.registerDefaults();
            CrucibleRegistry.saveJson(file);
        }
        registry.putAll(externalRegistry);
    }

    public static void saveJson(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            gson.toJson(registry, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

