/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.registries;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihiloadscensio.json.CustomBlockInfoJson;
import exnihiloadscensio.json.CustomItemStackJson;
import exnihiloadscensio.registries.manager.ICrookDefaultRegistryProvider;
import exnihiloadscensio.registries.manager.RegistryManager;
import exnihiloadscensio.registries.types.CrookReward;
import exnihiloadscensio.util.BlockInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class CrookRegistry {
    private static Map<BlockInfo, List<CrookReward>> registry = new HashMap<BlockInfo, List<CrookReward>>();
    private static Map<BlockInfo, List<CrookReward>> externalRegistry = new HashMap<BlockInfo, List<CrookReward>>();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemStack.class, (Object)new CustomItemStackJson()).registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).create();

    @Deprecated
    public static void addCrookRecipe(IBlockState state, ItemStack reward, float chance, float fortuneChance) {
        CrookRegistry.register(new BlockInfo(state), reward, chance, fortuneChance);
    }

    @Deprecated
    public static void addCrookRecipe(BlockInfo info, ItemStack reward, float chance, float fortuneChance) {
        CrookRegistry.register(info, reward, chance, fortuneChance);
    }

    public static void register(BlockInfo info, ItemStack reward, float chance, float fortuneChance) {
        CrookRegistry.registerInternal(info, reward, chance, fortuneChance);
        List<CrookReward> list = externalRegistry.get(info);
        if (list == null) {
            list = new ArrayList<CrookReward>();
        }
        list.add(new CrookReward(reward, chance, fortuneChance));
        externalRegistry.put(info, list);
    }

    private static void registerInternal(BlockInfo info, ItemStack reward, float chance, float fortuneChance) {
        List<CrookReward> list = registry.get(info);
        if (list == null) {
            list = new ArrayList<CrookReward>();
        }
        list.add(new CrookReward(reward, chance, fortuneChance));
        registry.put(info, list);
    }

    public static boolean registered(Block block) {
        return registry.containsKey(new BlockInfo(block.func_176223_P()));
    }

    public static ArrayList<CrookReward> getRewards(IBlockState state) {
        BlockInfo info = new BlockInfo(state);
        if (!registry.containsKey(info)) {
            return null;
        }
        return (ArrayList)registry.get(info);
    }

    public static void registerDefaults() {
        for (ICrookDefaultRegistryProvider provider : RegistryManager.getDefaultCrookRecipeHandlers()) {
            provider.registerCrookRecipeDefaults();
        }
    }

    public static void loadJson(File file) {
        registry.clear();
        if (file.exists()) {
            try {
                FileReader fr = new FileReader(file);
                HashMap gsonInput = (HashMap)gson.fromJson((Reader)fr, new TypeToken<HashMap<String, ArrayList<CrookReward>>>(){}.getType());
                for (String s : gsonInput.keySet()) {
                    BlockInfo stack = new BlockInfo(s);
                    registry.put(stack, (List<CrookReward>)gsonInput.get(s));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            CrookRegistry.registerDefaults();
            CrookRegistry.saveJson(file);
        }
    }

    public static void saveJson(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            gson.toJson(registry, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

