/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.registries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihiloadscensio.json.CustomItemInfoJson;
import exnihiloadscensio.registries.manager.ICompostDefaultRegistryProvider;
import exnihiloadscensio.registries.manager.RegistryManager;
import exnihiloadscensio.registries.types.Compostable;
import exnihiloadscensio.texturing.Color;
import exnihiloadscensio.util.ItemInfo;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CompostRegistry {
    private static Map<ItemInfo, Compostable> registry = new HashMap<ItemInfo, Compostable>();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).create();

    public static void loadJson(File file) {
        registry.clear();
        if (file.exists()) {
            try {
                FileReader fr = new FileReader(file);
                Map gsonInput = (Map)gson.fromJson((Reader)fr, new TypeToken<Map<String, Compostable>>(){}.getType());
                for (Map.Entry entry : gsonInput.entrySet()) {
                    registry.put(new ItemInfo((String)entry.getKey()), (Compostable)entry.getValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            CompostRegistry.registerDefaults();
            CompostRegistry.saveJson(file);
        }
    }

    public static void saveJson(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            gson.toJson(registry, (Appendable)fw);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void register(ItemInfo item, Compostable compostable) {
        registry.put(item, compostable);
    }

    public static void register(Item item, int meta, float value, IBlockState state, Color color) {
        CompostRegistry.register(new ItemInfo(item, meta), new Compostable(value, color, new ItemInfo(state)));
    }

    public static void register(Block block, int meta, float value, IBlockState state, Color color) {
        CompostRegistry.register(Item.func_150898_a((Block)block), meta, value, state, color);
    }

    public static Compostable getItem(Item item, int meta) {
        return CompostRegistry.getItem(new ItemInfo(item, meta));
    }

    public static Compostable getItem(ItemStack stack) {
        return CompostRegistry.getItem(new ItemInfo(stack));
    }

    public static Compostable getItem(ItemInfo info) {
        return registry.get(info);
    }

    public static boolean containsItem(Item item, int meta) {
        return CompostRegistry.containsItem(new ItemInfo(item, meta));
    }

    public static boolean containsItem(ItemStack stack) {
        return CompostRegistry.containsItem(new ItemInfo(stack));
    }

    public static boolean containsItem(ItemInfo info) {
        return registry.containsKey(info);
    }

    public static void registerDefaults() {
        for (ICompostDefaultRegistryProvider provider : RegistryManager.getDefaultCompostRecipeHandlers()) {
            provider.registerCompostRecipeDefaults();
        }
    }

    public static void recommendAllFood(File file) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return;
        }
        IBlockState dirt = Blocks.field_150346_d.func_176223_P();
        Color brown = new Color("7F3F0F");
        HashMap recommended = Maps.newHashMap();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemFood)) continue;
            ItemFood food = (ItemFood)item;
            ArrayList stacks = Lists.newArrayList();
            food.func_150895_a((Item)food, null, (List)stacks);
            for (ItemStack foodStack : stacks) {
                ItemInfo foodItemInfo = new ItemInfo(foodStack);
                if (CompostRegistry.containsItem(foodItemInfo)) continue;
                int hungerRestored = food.func_150905_g(foodStack);
                recommended.put(foodItemInfo.toString(), new Compostable((float)hungerRestored * 0.025f, brown, new ItemInfo(dirt)));
            }
        }
        String json = gson.toJson((Object)recommended, new TypeToken<Map<String, Compostable>>(){}.getType());
        try {
            Files.write(file.toPath(), json.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<ItemInfo, Compostable> getRegistry() {
        return registry;
    }
}

