/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.items.ore;

import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ItemFMLRegistryWrapper<T extends IForgeRegistryEntry<T>> {
    public static final int INVALID_ID = 32766;
    private final FMLControlledNamespacedRegistry<T> registry;
    private final Item item;
    private String defaultPrefix = "minecraft";

    public ItemFMLRegistryWrapper(FMLControlledNamespacedRegistry<T> registry, Item item) {
        this.registry = registry;
        this.item = item;
    }

    public ItemStack getStack(String name) {
        return this.getStack(name, 1);
    }

    public ItemStack getStack(String name, int amount) {
        return this.getStack(name.contains(":") ? new ResourceLocation(name) : new ResourceLocation(this.getDefaultPrefix(), name), amount);
    }

    public ItemStack getStack(ResourceLocation objectKey) {
        return this.getStack(objectKey, 1);
    }

    public ItemStack getStack(ResourceLocation objectKey, int amount) {
        int meta = this.getRegistry().getId(objectKey);
        return new ItemStack(this.getItem(), amount, meta == -1 ? 32766 : meta);
    }

    public ItemStack getStack(Item customItem, ResourceLocation objectKey, int amount) {
        int meta = this.getRegistry().getId(objectKey);
        return new ItemStack(customItem, amount, meta == -1 ? 32766 : meta);
    }

    @Nullable
    public T getType(ItemStack stack) {
        return (T)this.getRegistry().getObjectById(stack.func_77952_i());
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public ItemFMLRegistryWrapper<T> setDefaultPrefix(String defaultPrefix) {
        this.defaultPrefix = defaultPrefix;
        return this;
    }

    public FMLControlledNamespacedRegistry<T> getRegistry() {
        return this.registry;
    }

    public Item getItem() {
        return this.item;
    }
}

