/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.compatibility.jei.sieve;

import com.google.common.collect.HashMultiset;
import exnihiloadscensio.compatibility.jei.sieve.SieveRecipe;
import exnihiloadscensio.registries.SieveRegistry;
import exnihiloadscensio.registries.types.Siftable;
import exnihiloadscensio.util.ItemInfo;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SieveRecipeCategory
implements IRecipeCategory<SieveRecipe> {
    public static final String UID = "exnihiloadscensio:sieve";
    private static final ResourceLocation texture = new ResourceLocation("exnihiloadscensio", "textures/gui/jei_sieve.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private boolean hasHighlight;
    private int highlightX;
    private int highlightY;

    public SieveRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(texture, 0, 0, 166, 128);
        this.slotHighlight = helper.createDrawable(texture, 166, 0, 18, 18);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return "Sieve";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        if (this.hasHighlight) {
            this.slotHighlight.draw(minecraft, this.highlightX, this.highlightY);
        }
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, final SieveRecipe recipeWrapper) {
        recipeLayout.getItemStacks().init(0, true, 61, 9);
        recipeLayout.getItemStacks().set(0, (ItemStack)recipeWrapper.getInputs().get(0));
        recipeLayout.getItemStacks().init(1, true, 87, 9);
        recipeLayout.getItemStacks().set(1, (ItemStack)recipeWrapper.getInputs().get(1));
        IFocus focus = recipeLayout.getFocus();
        this.hasHighlight = focus.getMode() == IFocus.Mode.OUTPUT;
        int slotIndex = 2;
        for (int i = 0; i < recipeWrapper.getOutputs().size(); ++i) {
            int slotX = 2 + i % 9 * 18;
            int slotY = 36 + i / 9 * 18;
            ItemStack outputStack = (ItemStack)recipeWrapper.getOutputs().get(i);
            recipeLayout.getItemStacks().init(slotIndex + i, false, slotX, slotY);
            recipeLayout.getItemStacks().set(slotIndex + i, outputStack);
            ItemStack focusStack = (ItemStack)focus.getValue();
            if (focus.getMode() != IFocus.Mode.OUTPUT || focusStack == null || focusStack.func_77973_b() != outputStack.func_77973_b() || focusStack.func_77952_i() != outputStack.func_77952_i()) continue;
            this.highlightX = slotX;
            this.highlightY = slotY;
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new ITooltipCallback<ItemStack>(){

            public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
                if (!input) {
                    ItemStack mesh = (ItemStack)recipeWrapper.getInputs().get(0);
                    HashMultiset condensedTooltips = HashMultiset.create();
                    for (Siftable siftable : SieveRegistry.getDrops((ItemStack)recipeWrapper.getInputs().get(1))) {
                        ItemInfo info;
                        if (siftable.getMeshLevel() != mesh.func_77952_i() || (info = siftable.getDrop()).getItem() != ingredient.func_77973_b() || info.getMeta() != ingredient.func_77952_i()) continue;
                        int iChance = (int)(siftable.getChance() * 100.0f);
                        String s = iChance > 0 ? String.format("%3d%%", (int)(siftable.getChance() * 100.0f)) : String.format("%1.1f%%", Float.valueOf(siftable.getChance() * 100.0f));
                        condensedTooltips.add((Object)s);
                    }
                    tooltip.add(I18n.func_135052_a((String)"jei.sieve.dropChance", (Object[])new Object[0]));
                    for (String line : condensedTooltips.elementSet()) {
                        tooltip.add(" * " + condensedTooltips.count((Object)line) + "x " + line);
                    }
                }
            }
        });
    }

    public void setRecipe(IRecipeLayout recipeLayout, SieveRecipe recipeWrapper, IIngredients ingredients) {
        this.setRecipe(recipeLayout, recipeWrapper);
    }

    public IDrawable getIcon() {
        return null;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }
}

