/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.barrel.modes.fluid;

import exnihiloadscensio.barrel.BarrelFluidHandler;
import exnihiloadscensio.barrel.IBarrelMode;
import exnihiloadscensio.barrel.modes.fluid.BarrelItemHandlerFluid;
import exnihiloadscensio.barrel.modes.transform.BarrelModeFluidTransform;
import exnihiloadscensio.networking.MessageBarrelModeUpdate;
import exnihiloadscensio.networking.PacketHandler;
import exnihiloadscensio.registries.BarrelLiquidBlacklistRegistry;
import exnihiloadscensio.registries.FluidOnTopRegistry;
import exnihiloadscensio.registries.FluidTransformRegistry;
import exnihiloadscensio.registries.types.FluidTransformer;
import exnihiloadscensio.texturing.Color;
import exnihiloadscensio.tiles.TileBarrel;
import exnihiloadscensio.util.ItemInfo;
import exnihiloadscensio.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelModeFluid
implements IBarrelMode {
    private BarrelItemHandlerFluid handler = new BarrelItemHandlerFluid(null);

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public boolean isTriggerItemStack(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isTriggerFluidStack(FluidStack stack) {
        return stack != null;
    }

    @Override
    public String getName() {
        return "fluid";
    }

    @Override
    public List<String> getWailaTooltip(TileBarrel barrel, List<String> currenttip) {
        if (barrel.getTank().getFluid() != null) {
            currenttip.add(barrel.getTank().getFluid().getLocalizedName());
            currenttip.add("Amount: " + String.valueOf(barrel.getTank().getFluidAmount()) + "mb");
        } else {
            currenttip.add("Empty");
        }
        return currenttip;
    }

    @Override
    public boolean onBlockActivated(World world, TileBarrel barrel, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack != null) {
            int size;
            ItemStack remainder = this.getHandler(barrel).insertItem(0, stack, false);
            int n = size = remainder == null ? 0 : remainder.field_77994_a;
            if (stack.func_77973_b().hasContainerItem(stack)) {
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                container.field_77994_a = stack.field_77994_a - size;
                if (!player.field_71071_by.func_70441_a(container)) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, container));
                }
            }
            player.func_184611_a(EnumHand.MAIN_HAND, remainder);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForRender(TileBarrel barrel) {
        return Util.getTextureFromFluidStack(barrel.getTank().getFluid());
    }

    @Override
    public Color getColorForRender() {
        return Util.whiteColor;
    }

    @Override
    public float getFilledLevelForRender(TileBarrel barrel) {
        double amount = barrel.getTank().getFluidAmount();
        return (float)(amount / 1000.0);
    }

    @Override
    public void update(TileBarrel barrel) {
        if (barrel.getTank().getFluid() != null) {
            BarrelFluidHandler tank = barrel.getTank();
            if (tank.getFluid().amount != tank.getCapacity()) {
                return;
            }
            Fluid fluidInBarrel = tank.getFluid().getFluid();
            BlockPos barrelPos = barrel.func_174877_v();
            BlockPos pos = new BlockPos(barrelPos.func_177958_n(), barrelPos.func_177956_o() + 1, barrelPos.func_177952_p());
            Block onTop = barrel.func_145831_w().func_180495_p(pos).func_177230_c();
            Fluid fluidOnTop = null;
            if (onTop instanceof BlockLiquid) {
                Fluid fluid = fluidOnTop = onTop.func_149688_o(barrel.func_145831_w().func_180495_p(pos)) == Material.field_151586_h ? FluidRegistry.WATER : FluidRegistry.LAVA;
            }
            if (onTop != null && onTop instanceof IFluidBlock) {
                fluidOnTop = ((BlockFluidBase)onTop).getFluid();
            }
            if (FluidOnTopRegistry.isValidRecipe(fluidInBarrel, fluidOnTop)) {
                ItemInfo info = FluidOnTopRegistry.getTransformedBlock(fluidInBarrel, fluidOnTop);
                tank.drain(tank.getCapacity(), true);
                barrel.setMode("block");
                PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("block", barrel.func_174877_v()), barrel);
                barrel.getMode().addItem(info.getItemStack(), barrel);
                return;
            }
            if (FluidTransformRegistry.containsKey(barrel.getTank().getFluid().getFluid().getName())) {
                ArrayList<FluidTransformer> transformers = FluidTransformRegistry.getFluidTransformers(barrel.getTank().getFluid().getFluid().getName());
                boolean found = false;
                for (int radius = 0; radius <= 2; ++radius) {
                    for (FluidTransformer transformer : transformers) {
                        if (BarrelLiquidBlacklistRegistry.isBlacklisted(barrel.getTier(), transformer.getOutputFluid()) || !Util.isSurroundingBlocksAtLeastOneOf(transformer.getTransformingBlocks(), barrel.func_174877_v().func_177982_a(0, -1, 0), barrel.func_145831_w(), radius) && !Util.isSurroundingBlocksAtLeastOneOf(transformer.getTransformingBlocks(), barrel.func_174877_v(), barrel.func_145831_w(), radius)) continue;
                        FluidStack fstack = tank.getFluid();
                        tank.setFluid(null);
                        barrel.setMode("fluidTransform");
                        BarrelModeFluidTransform mode = (BarrelModeFluidTransform)barrel.getMode();
                        mode.setTransformer(transformer);
                        mode.setInputStack(fstack);
                        mode.setOutputStack(FluidRegistry.getFluidStack((String)transformer.getOutputFluid(), (int)1000));
                        PacketHandler.sendNBTUpdate(barrel);
                        found = true;
                    }
                    if (found) break;
                }
            }
        }
    }

    @Override
    public boolean addItem(ItemStack stack, TileBarrel barrel) {
        return false;
    }

    @Override
    public ItemStackHandler getHandler(TileBarrel barrel) {
        this.handler.setBarrel(barrel);
        return this.handler;
    }

    @Override
    public FluidTank getFluidHandler(TileBarrel barrel) {
        BarrelFluidHandler handler = barrel.getTank();
        handler.setBarrel(barrel);
        return handler;
    }

    @Override
    public boolean canFillWithFluid(TileBarrel barrel) {
        return true;
    }
}

