/*
 * Decompiled with CFR 0.152.
 */
package air_support.configs;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration CONFIG;
    public static String[] ENTITIES;
    public static String[] UTILITY_DROPS;
    public static String[] usedCategories;
    public static boolean MONSTER;
    public static boolean CREATURE;
    public static boolean WATER_CREATURE;
    public static boolean AMBIENT;
    public static boolean GRIEF_DROPS;
    public static int GRIEF_DROPS_CHANCE;
    public static int GRIEF_DROPS_AMOUNT;
    public static boolean GRIEF_DROPS_ONLY_TNT;

    public void loadConfig(FMLPreInitializationEvent event) {
        this.CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        this.CONFIG.load();
        this.syncConfigs();
    }

    private void syncConfigs() {
        ENTITIES = this.CONFIG.getStringList("Mobs contained in crate drops", "Entities In Crate Drops", new String[]{"Cow:10"}, "Must Have a weight.");
        this.CONFIG.addCustomCategoryComment("Vanilla Mob Spawn Control", "If normal spawning is required set option to true and a re-start is required");
        MONSTER = this.CONFIG.get("Vanilla Mob Spawn Control", "MONSTER Mobs can spawn in the world", false, "Zombies, Skeletons etc.").getBoolean(false);
        CREATURE = this.CONFIG.get("Vanilla Mob Spawn Control", "CREATURE Mobs can spawn in the world", false, "Cows, Pigs etc.").getBoolean(false);
        WATER_CREATURE = this.CONFIG.get("Vanilla Mob Spawn Control", "WATER_CREATURE Mobs can spawn in the world", false, "Squids etc.").getBoolean(false);
        AMBIENT = this.CONFIG.get("Vanilla Mob Spawn Control", "AMBIENT Mobs can spawn in the world", false, "Bats etc.").getBoolean(false);
        this.CONFIG.addCustomCategoryComment("Items In Utility Crate Drops", "syntax is: modName:itemName,amount,metaData,itemWeight");
        UTILITY_DROPS = this.CONFIG.getStringList("Items contained in utility crate drops", "Items In Utility Crate Drops", new String[]{"minecraft:redstone,5,0,1", "air_support:circuit_board,2,0,1"}, "Happy Birthday!");
        GRIEF_DROPS = this.CONFIG.get("Random Grief Drops", "Enable Random Grief Drops", true, "Good Luck.").getBoolean(true);
        GRIEF_DROPS_CHANCE = this.CONFIG.get("Random Grief Drops", "Random Chance of Grief Drops lower numbers = more chance.", 5).getInt(5);
        GRIEF_DROPS_AMOUNT = this.CONFIG.get("Random Grief Drops", "Amount of Grief Drops", 8).getInt(8);
        GRIEF_DROPS_ONLY_TNT = this.CONFIG.get("Random Grief Drops", "Only Drop TNT When Griefing", false, "Because of Kehaan.").getBoolean(false);
        if (this.CONFIG.hasChanged()) {
            this.CONFIG.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("air_support")) {
            this.syncConfigs();
        }
    }

    static {
        usedCategories = new String[]{"Entities In Crate Drops", "Items In Utility Crate Drops", "Vanilla Mob Spawn Control", "Random Grief Drops"};
    }
}

