/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public enum ScrollWheelHandler implements Function<Action.ActionContext, Void>
{
    ONEITEMIN(-1),
    ONEITEMOUT(1);

    private final int moveAmount;

    private ScrollWheelHandler(int amount) {
        this.moveAmount = amount;
    }

    @Nullable
    public Void apply(@Nullable Action.ActionContext context) {
        Slot source;
        if (context == null) {
            throw new NullPointerException("WHUT");
        }
        if (context.slotMapping == null) {
            return null;
        }
        ItemStack is = InventoryHandler.INSTANCE.getItemStack(context);
        if (is == null) {
            return null;
        }
        final ImmutableBiMap<IInventory, InventoryHandler.InventoryMapping> mapping = context.mapping;
        if (this.moveAmount < 0 && is.func_77976_d() > is.field_77994_a) {
            source = InventoryHandler.INSTANCE.findStackWithItem(is, context);
        } else if (this.moveAmount > 0) {
            source = context.slot;
        } else {
            return null;
        }
        if (source == null) {
            return null;
        }
        if (InventorySorter.INSTANCE.slotblacklist.contains(source.getClass().getName())) {
            return null;
        }
        if (InventorySorter.INSTANCE.slotblacklist.contains(context.slot.getClass().getName())) {
            return null;
        }
        if (!source.func_82869_a((EntityPlayer)context.player)) {
            return null;
        }
        if (!source.func_75214_a(is)) {
            return null;
        }
        ItemStack sourceStack = InventoryHandler.INSTANCE.getItemStack(source);
        if (sourceStack == null) {
            return null;
        }
        ItemStack iscopy = sourceStack.func_77946_l();
        iscopy.field_77994_a = 1;
        ArrayList mappingCandidates = Lists.newArrayList();
        if (this.moveAmount < 0) {
            InventoryHandler.InventoryMapping inventoryMapping = new InventoryHandler.InventoryMapping(context.slot.field_75224_c, context.player.field_71070_bA, context.slot.field_75224_c, context.slot.getClass());
            mappingCandidates.add(inventoryMapping);
            inventoryMapping.begin = context.slot.field_75222_d;
            inventoryMapping.end = context.slot.field_75222_d;
        } else if (context.player.field_71070_bA == context.player.field_71069_bz) {
            if (InventoryHandler.preferredOrders.containsKey(context.slotMapping.inv)) {
                mappingCandidates.addAll(Lists.transform((List)((List)InventoryHandler.preferredOrders.get(context.slotMapping.inv)), (Function)new Function<IInventory, InventoryHandler.InventoryMapping>(){

                    @Nullable
                    public InventoryHandler.InventoryMapping apply(@Nullable IInventory input) {
                        return (InventoryHandler.InventoryMapping)mapping.get(input);
                    }
                }));
            }
            Collections.reverse(mappingCandidates);
        } else {
            for (Map.Entry<IInventory, InventoryHandler.InventoryMapping> entry : InventoryHandler.INSTANCE.getSortedMapping(context)) {
                if (entry.getValue().proxy == context.slot.field_75224_c || InventorySorter.INSTANCE.slotblacklist.contains(entry.getValue().slotType.getName())) continue;
                mappingCandidates.add(entry.getValue());
            }
        }
        Collections.reverse(mappingCandidates);
        for (InventoryHandler.InventoryMapping mappingCandidate : mappingCandidates) {
            if (mappingCandidate.inv == Action.ActionContext.PLAYER_OFFHAND && this.moveAmount > 0) {
                boolean empty = true;
                for (ItemStack itemStack : context.player.field_71071_by.field_184439_c) {
                    if (itemStack == null) continue;
                    empty = false;
                }
                if (empty) continue;
            }
            if (mappingCandidate.inv == Action.ActionContext.PLAYER_HOTBAR && this.moveAmount > 0) {
                boolean hasTarget = false;
                boolean found = false;
                for (int i = 0; i < 9; ++i) {
                    ItemStack itemStack = context.player.field_71071_by.field_70462_a[i];
                    if (ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)sourceStack) && itemStack.field_77994_a < itemStack.func_77976_d()) {
                        hasTarget = true;
                        continue;
                    }
                    if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)sourceStack)) continue;
                    found = true;
                }
                if (!hasTarget && found) continue;
            }
            InventoryHandler.INSTANCE.moveItemToOtherInventory(context, iscopy, mappingCandidate.begin, mappingCandidate.end + 1, this.moveAmount < 0);
            if (iscopy.field_77994_a != 0) continue;
            --sourceStack.field_77994_a;
            if (sourceStack.field_77994_a == 0) {
                source.func_75215_d(null);
                break;
            }
            source.func_75218_e();
            break;
        }
        return null;
    }
}

