/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.tconstruct.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import com.blamejared.mtlib.utils.BaseMapAddition;
import com.blamejared.mtlib.utils.BaseMapRemoval;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.entity.IEntityDefinition;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker.mods.tconstruct.TConstructHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.plugin.jei.SmeltingRecipeWrapper;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Smeltery")
public class Smeltery {
    public static final String nameFuel = "TConstruct Smeltery - Fuel";
    public static final String nameMelting = "TConstruct Smeltery - Melting";
    public static final String nameAlloy = "TConstruct Smeltery - Alloy";
    public static final String nameEntityMelting = "TConstruct Smeltery - Entity Melting";

    @ZenMethod
    public static void addEntityMelting(ILiquidStack output, IEntityDefinition entity) {
        if (entity == null || output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", nameEntityMelting));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AddEntityMelting(entity.getName(), InputHelper.toFluid((ILiquidStack)output)));
    }

    @ZenMethod
    public static void removeEntityMelting(IEntityDefinition entity) {
        HashMap<String, FluidStack> recipes = new HashMap<String, FluidStack>();
        TConstructHelper.entityMeltingRegistry.forEach((key, val) -> {
            if (key.equals(entity.getName())) {
                recipes.put((String)key, (FluidStack)val);
            }
        });
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveEntityMelting(recipes));
        } else {
            LogHelper.logError((String)String.format("No %s recipes found for %s. Command ignored!", nameEntityMelting, entity.toString()));
        }
    }

    @ZenMethod
    public static void addAlloy(ILiquidStack output, ILiquidStack[] input) {
        if (input == null || output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", nameAlloy));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AddAlloy(new AlloyRecipe(InputHelper.toFluid((ILiquidStack)output), InputHelper.toFluids((ILiquidStack[])input))));
    }

    @ZenMethod
    public static void removeAlloy(IIngredient output) {
        LinkedList<AlloyRecipe> recipes = new LinkedList<AlloyRecipe>();
        for (AlloyRecipe r : TConstructHelper.alloys) {
            if (r == null || !StackHelper.matches((IIngredient)output, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)r.getResult()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveAlloy(recipes));
        } else {
            LogHelper.logError((String)String.format("No %s recipes found for %s. Command ignored!", nameAlloy, output.toString()));
        }
    }

    @ZenMethod
    public static void addMelting(ILiquidStack output, IIngredient input, int temp) {
        if (input == null || output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", nameMelting));
            return;
        }
        LinkedList<MeltingRecipe> recipes = new LinkedList<MeltingRecipe>();
        for (IItemStack in : input.getItems()) {
            recipes.add(new MeltingRecipe(InputHelper.toStack((IItemStack)in), InputHelper.toFluid((ILiquidStack)output), temp));
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new AddMelting(recipes));
        } else {
            LogHelper.logError((String)String.format("No %s recipes could be added for input %s.", nameMelting, input.toString()));
        }
    }

    @ZenMethod
    public static void removeMelting(IItemStack input) {
        LinkedList<slimeknights.tconstruct.library.smeltery.MeltingRecipe> recipes = new LinkedList<slimeknights.tconstruct.library.smeltery.MeltingRecipe>();
        for (slimeknights.tconstruct.library.smeltery.MeltingRecipe meta : TConstructHelper.smeltingList) {
            if (meta.input.matches(InputHelper.toStacks((IItemStack[])input.getItems().toArray(new IItemStack[0]))) == null) continue;
            recipes.add(meta);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMelting(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", nameMelting, input.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(ILiquidStack liquid, @Optional int temp) {
        if (liquid == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", nameFuel));
            return;
        }
        HashMap<FluidStack, Integer> recipes = new HashMap<FluidStack, Integer>();
        recipes.put(InputHelper.toFluid((ILiquidStack)liquid), temp != 0 ? temp : InputHelper.toFluid((ILiquidStack)liquid).getFluid().getTemperature());
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(recipes));
    }

    @ZenMethod
    public static void removeFuel(IIngredient input) {
        HashMap<FluidStack, Integer> recipes = new HashMap<FluidStack, Integer>();
        for (Map.Entry<FluidStack, Integer> entry : TConstructHelper.fuelMap.entrySet()) {
            if (entry == null || !StackHelper.matches((IIngredient)input, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)entry.getKey()))) continue;
            recipes.put(entry.getKey(), entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe for %s found. Command ignored!", nameFuel, input.toString()));
        }
    }

    public static class RemoveFuel
    extends BaseMapRemoval<FluidStack, Integer> {
        protected RemoveFuel(Map<FluidStack, Integer> recipes) {
            super(Smeltery.nameFuel, TConstructHelper.fuelMap, recipes);
        }

        protected String getRecipeInfo(Map.Entry<FluidStack, Integer> recipe) {
            return LogHelper.getStackDescription(recipe);
        }
    }

    public static class AddFuel
    extends BaseMapAddition<FluidStack, Integer> {
        protected AddFuel(Map<FluidStack, Integer> recipes) {
            super(Smeltery.nameFuel, TConstructHelper.fuelMap, recipes);
        }

        protected String getRecipeInfo(Map.Entry<FluidStack, Integer> recipe) {
            return LogHelper.getStackDescription(recipe);
        }
    }

    protected static class MeltingRecipe {
        public final ItemStack input;
        public final FluidStack fluid;
        public final int temp;

        public MeltingRecipe(ItemStack input, FluidStack fluid, int temp) {
            this.input = input;
            this.fluid = fluid;
            this.temp = temp;
        }
    }

    private static class RemoveMelting
    extends BaseListRemoval<slimeknights.tconstruct.library.smeltery.MeltingRecipe> {
        public RemoveMelting(List<slimeknights.tconstruct.library.smeltery.MeltingRecipe> recipes) {
            super(Smeltery.nameMelting, TConstructHelper.smeltingList, recipes);
        }

        public void apply() {
            for (slimeknights.tconstruct.library.smeltery.MeltingRecipe recipe : this.recipes) {
                TConstructHelper.smeltingList.remove(recipe);
                this.successful.add(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new SmeltingRecipeWrapper(recipe));
            }
        }

        public void undo() {
            for (slimeknights.tconstruct.library.smeltery.MeltingRecipe recipe : this.successful) {
                TinkerRegistry.registerMelting((slimeknights.tconstruct.library.smeltery.MeltingRecipe)recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new SmeltingRecipeWrapper(recipe));
            }
        }

        public String getRecipeInfo(slimeknights.tconstruct.library.smeltery.MeltingRecipe recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe.getResult());
        }
    }

    private static class AddMelting
    extends BaseListAddition<MeltingRecipe> {
        public AddMelting(List<MeltingRecipe> recipes) {
            super(Smeltery.nameMelting, null, recipes);
        }

        public void apply() {
            for (MeltingRecipe recipe : this.recipes) {
                TinkerRegistry.registerMelting((slimeknights.tconstruct.library.smeltery.MeltingRecipe)new slimeknights.tconstruct.library.smeltery.MeltingRecipe(RecipeMatch.of((ItemStack)recipe.input, (int)recipe.fluid.amount), recipe.fluid, recipe.temp));
                this.successful.add(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new slimeknights.tconstruct.library.smeltery.MeltingRecipe(RecipeMatch.of((ItemStack)recipe.input, (int)recipe.fluid.amount), recipe.fluid));
            }
        }

        public void undo() {
            for (MeltingRecipe recipe : this.successful) {
                TConstructHelper.smeltingList.remove(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new slimeknights.tconstruct.library.smeltery.MeltingRecipe(RecipeMatch.of((ItemStack)recipe.input, (int)recipe.fluid.amount), recipe.fluid, recipe.temp));
            }
        }

        public String getRecipeInfo(MeltingRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.input);
        }
    }

    private static class RemoveAlloy
    extends BaseListRemoval<AlloyRecipe> {
        public RemoveAlloy(List<AlloyRecipe> recipes) {
            super(Smeltery.nameAlloy, TConstructHelper.alloys, recipes);
        }

        protected String getRecipeInfo(AlloyRecipe recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe.getResult());
        }
    }

    private static class AddAlloy
    extends BaseListAddition<AlloyRecipe> {
        public AddAlloy(AlloyRecipe recipe) {
            super(Smeltery.nameAlloy, TConstructHelper.alloys);
            this.recipes.add(recipe);
        }

        protected String getRecipeInfo(AlloyRecipe recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe.getResult());
        }
    }

    private static class RemoveEntityMelting
    extends BaseMapRemoval<String, FluidStack> {
        protected RemoveEntityMelting(Map<String, FluidStack> map) {
            super(Smeltery.nameEntityMelting, TConstructHelper.entityMeltingRegistry, map);
        }

        protected String getRecipeInfo(Map.Entry<String, FluidStack> recipe) {
            return LogHelper.getStackDescription(recipe);
        }
    }

    private static class AddEntityMelting
    extends BaseMapAddition<String, FluidStack> {
        protected AddEntityMelting(String entityName, FluidStack fluid) {
            super(Smeltery.nameEntityMelting, TConstructHelper.entityMeltingRegistry);
            this.recipes.put(entityName, fluid);
        }

        protected String getRecipeInfo(Map.Entry<String, FluidStack> recipe) {
            return LogHelper.getStackDescription(recipe);
        }
    }
}

