/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.tconstruct.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker.mods.tconstruct.TConstructHelper;
import net.minecraft.item.ItemStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.DryingRecipe;
import slimeknights.tconstruct.library.TinkerRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Drying")
public class Drying {
    protected static final String name = "TConstruct Drying Rack";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int time) {
        if (input == null || output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        RecipeMatch.Item match = new RecipeMatch.Item(InputHelper.toStack((IItemStack)input), InputHelper.toStack((IItemStack)input).field_77994_a);
        MineTweakerAPI.apply((IUndoableAction)new Add(TConstructHelper.getDryingRecipe(InputHelper.toStack((IItemStack)output), (RecipeMatch)match, time)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient ingredient) {
        LinkedList<DryingRecipe> recipes = new LinkedList<DryingRecipe>();
        for (DryingRecipe recipe : TinkerRegistry.getAllDryingRecipes()) {
            if (recipe == null || recipe.getResult() == null || !ingredient.matches(InputHelper.toIItemStack((ItemStack)recipe.getResult()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, ingredient.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<DryingRecipe> {
        public Remove(List<DryingRecipe> list) {
            super(Drying.name, TConstructHelper.dryingList, list);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (DryingRecipe recipe : this.recipes) {
                if (recipe != null) {
                    if (this.list.remove(recipe)) {
                        this.successful.add(recipe);
                        MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe);
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }

        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (DryingRecipe recipe : this.successful) {
                if (recipe != null) {
                    if (!this.list.add(recipe)) {
                        LogHelper.logError((String)String.format("Error restoring %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                        continue;
                    }
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                    continue;
                }
                LogHelper.logError((String)String.format("Error restoring %s Recipe: null object", this.name));
            }
        }

        protected String getRecipeInfo(DryingRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getResult());
        }
    }

    private static class Add
    extends BaseListAddition<DryingRecipe> {
        public Add(DryingRecipe recipe) {
            super(Drying.name, TConstructHelper.dryingList);
            this.recipes.add(recipe);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (DryingRecipe recipe : this.recipes) {
                if (recipe != null) {
                    if (this.list.add(recipe)) {
                        this.successful.add(recipe);
                        MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error adding %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error adding %s Recipe: null object", this.name));
            }
        }

        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (DryingRecipe recipe : this.successful) {
                if (recipe != null) {
                    if (!this.list.remove(recipe)) {
                        LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                        continue;
                    }
                    MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe);
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }

        protected String getRecipeInfo(DryingRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getResult());
        }
    }
}

