/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.tconstruct.actions;

import minetweaker.IUndoableAction;
import modtweaker.brackets.util.IMaterial;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class SetMiningSpeedAction
implements IUndoableAction {
    private final IMaterial material;
    private final String stat;
    private final float newValue;
    private final float oldValue;

    public SetMiningSpeedAction(IMaterial material, String stat, float newValue) {
        this.material = material;
        this.stat = stat;
        this.newValue = newValue;
        this.oldValue = ((HeadMaterialStats)((Material)material.getInternal()).getStats((String)"head")).miningspeed;
    }

    private static void set(Material material, String stat, float miningSpeed) {
        IMaterialStats oldStat = material.getStats(stat);
        if (oldStat instanceof HeadMaterialStats) {
            HeadMaterialStats headStat = (HeadMaterialStats)oldStat;
            HeadMaterialStats newHead = new HeadMaterialStats(headStat.durability, miningSpeed, headStat.attack, headStat.harvestLevel);
            material.addStats((IMaterialStats)newHead);
        }
    }

    public void apply() {
        SetMiningSpeedAction.set((Material)this.material.getInternal(), this.stat, this.newValue);
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        SetMiningSpeedAction.set((Material)this.material.getInternal(), this.stat, this.oldValue);
    }

    public String describe() {
        return "Setting MiningSpeed of " + this.material.getName() + " to " + this.newValue + " for " + this.stat;
    }

    public String describeUndo() {
        return "Reverting MiningSpeed of " + this.material.getName() + " to " + this.oldValue + " for " + this.stat;
    }

    public Object getOverrideKey() {
        return null;
    }
}

