/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry;

import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IForestryRecipe;
import java.util.ArrayList;
import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.MineTweakerAPI;

public abstract class ForestryListAddition<T extends IForestryRecipe>
extends BaseListAddition<T> {
    private final ICraftingProvider manager;

    protected ForestryListAddition(String name, ICraftingProvider manager) {
        super(name, new ArrayList(manager.recipes()));
        this.manager = manager;
    }

    protected abstract String getRecipeInfo(T var1);

    public void apply() {
        for (IForestryRecipe recipe : this.recipes) {
            if (recipe != null) {
                if (this.manager.addRecipe(recipe)) {
                    this.successful.add(recipe);
                    IRecipeWrapper wrapped = this.wrapRecipe(recipe);
                    if (wrapped == null) continue;
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)wrapped);
                    continue;
                }
                LogHelper.logError((String)String.format("Error adding %s Recipe for %s", this.name, this.getRecipeInfo((T)recipe)));
                continue;
            }
            LogHelper.logError((String)String.format("Error adding %s Recipe: null object", this.name));
        }
    }

    public final void undo() {
        for (IForestryRecipe recipe : this.successful) {
            if (recipe != null) {
                if (!this.manager.removeRecipe(recipe)) {
                    LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo((T)recipe)));
                    continue;
                }
                IRecipeWrapper wrapped = this.wrapRecipe(recipe);
                if (wrapped == null) continue;
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)wrapped);
                continue;
            }
            LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
        }
    }
}

