/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.embers.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseMapAddition;
import com.blamejared.mtlib.utils.BaseMapRemoval;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.compat.jei.MeltingRecipeWrapper;
import teamroots.embers.recipe.ItemMeltingOreRecipe;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@ZenClass(value="mods.embers.Melter")
public class Melter {
    public static String name = "Embers Melter";

    @ZenMethod
    public static void addRecipe(IItemStack input, ILiquidStack outputOne, boolean matchMeta, boolean matchNBT) {
        MineTweakerAPI.apply((IUndoableAction)new Add(InputHelper.toStack((IItemStack)input), new ItemMeltingRecipe(InputHelper.toStack((IItemStack)input), InputHelper.toFluid((ILiquidStack)outputOne), matchMeta, matchNBT)));
    }

    @ZenMethod
    public static void addOreRecipe(IOreDictEntry key, ILiquidStack outputOne, boolean matchMeta, boolean matchNBT) {
        MineTweakerAPI.apply((IUndoableAction)new AddOre(key.getName(), new ItemMeltingOreRecipe(key.getName(), InputHelper.toFluid((ILiquidStack)outputOne))));
    }

    @ZenMethod
    public static void remove(ILiquidStack fluid) {
        int i;
        ArrayList<ItemStack> recipes = new ArrayList<ItemStack>();
        ArrayList<String> oreRecipes = new ArrayList<String>();
        if (fluid == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        for (i = 0; i < RecipeRegistry.meltingRecipes.size(); ++i) {
            if (!((ItemMeltingRecipe)RecipeRegistry.meltingRecipes.values().toArray()[i]).getFluid().getFluid().getName().equals(InputHelper.toFluid((ILiquidStack)fluid).getFluid().getName())) continue;
            recipes.add((ItemStack)RecipeRegistry.meltingRecipes.keySet().toArray()[i]);
        }
        for (i = 0; i < RecipeRegistry.meltingOreRecipes.size(); ++i) {
            if (!((ItemMeltingOreRecipe)RecipeRegistry.meltingOreRecipes.values().toArray()[i]).getFluid().getFluid().getName().equals(InputHelper.toFluid((ILiquidStack)fluid).getFluid().getName())) continue;
            oreRecipes.add((String)RecipeRegistry.meltingOreRecipes.keySet().toArray()[i]);
        }
        if (!recipes.isEmpty()) {
            HashMap<ItemStack, ItemMeltingRecipe> map = new HashMap<ItemStack, ItemMeltingRecipe>();
            for (int i2 = 0; i2 < recipes.size(); ++i2) {
                map.put((ItemStack)recipes.get(i2), (ItemMeltingRecipe)RecipeRegistry.meltingRecipes.get(recipes.get(i2)));
            }
            MineTweakerAPI.apply((IUndoableAction)new Remove(map));
        } else if (!oreRecipes.isEmpty()) {
            HashMap<String, ItemMeltingOreRecipe> map = new HashMap<String, ItemMeltingOreRecipe>();
            for (int i3 = 0; i3 < oreRecipes.size(); ++i3) {
                map.put((String)oreRecipes.get(i3), (ItemMeltingOreRecipe)RecipeRegistry.meltingOreRecipes.get(oreRecipes.get(i3)));
            }
            MineTweakerAPI.apply((IUndoableAction)new RemoveOre(map));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, fluid.toString()));
        }
    }

    private static class RemoveOre
    extends BaseMapRemoval<String, ItemMeltingOreRecipe> {
        public RemoveOre(Map<String, ItemMeltingOreRecipe> recipes) {
            super(name, RecipeRegistry.meltingOreRecipes, recipes);
        }

        public void apply() {
            super.apply();
            this.successful.forEach((stack, recipe) -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new MeltingRecipeWrapper(recipe)));
        }

        public void undo() {
            super.undo();
            this.successful.forEach((stack, recipe) -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new MeltingRecipeWrapper(recipe)));
        }

        protected String getRecipeInfo(Map.Entry<String, ItemMeltingOreRecipe> arg0) {
            return arg0.getValue().getOreName();
        }
    }

    private static class Remove
    extends BaseMapRemoval<ItemStack, ItemMeltingRecipe> {
        public Remove(Map<ItemStack, ItemMeltingRecipe> recipes) {
            super(name, RecipeRegistry.meltingRecipes, recipes);
        }

        public void apply() {
            super.apply();
            this.successful.forEach((stack, recipe) -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new MeltingRecipeWrapper(recipe)));
        }

        public void undo() {
            super.undo();
            this.successful.forEach((stack, recipe) -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new MeltingRecipeWrapper(recipe)));
        }

        protected String getRecipeInfo(Map.Entry<ItemStack, ItemMeltingRecipe> arg0) {
            return LogHelper.getStackDescription((Object)arg0.getValue().getStack());
        }
    }

    private static class Add
    extends BaseMapAddition<ItemStack, ItemMeltingRecipe> {
        public Add(ItemStack stack, ItemMeltingRecipe recipe) {
            super(name, RecipeRegistry.meltingRecipes);
            this.recipes.put(stack, recipe);
        }

        public void apply() {
            super.apply();
            this.successful.forEach((stack, recipe) -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new MeltingRecipeWrapper(recipe)));
        }

        public void undo() {
            super.undo();
            this.successful.forEach((stack, recipe) -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new MeltingRecipeWrapper(recipe)));
        }

        protected String getRecipeInfo(Map.Entry<ItemStack, ItemMeltingRecipe> arg0) {
            return LogHelper.getStackDescription((Object)arg0.getValue().getStack());
        }
    }

    private static class AddOre
    extends BaseMapAddition<String, ItemMeltingOreRecipe> {
        public AddOre(String stack, ItemMeltingOreRecipe recipe) {
            super(name, RecipeRegistry.meltingOreRecipes);
            this.recipes.put(stack, recipe);
        }

        public void apply() {
            super.apply();
            this.successful.forEach((stack, recipe) -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new MeltingRecipeWrapper(recipe)));
        }

        public void undo() {
            super.undo();
            this.successful.forEach((stack, recipe) -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new MeltingRecipeWrapper(recipe)));
        }

        protected String getRecipeInfo(Map.Entry<String, ItemMeltingOreRecipe> arg0) {
            return arg0.getValue().getOreName();
        }
    }
}

