/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.botania.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeRuneAltar;

@ZenClass(value="mods.botania.RuneAltar")
public class RuneAltar {
    protected static final String name = "Botania Rune Altar";

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] input, int mana) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipeRuneAltar(InputHelper.toStack((IItemStack)output), mana, InputHelper.toObjects((IIngredient[])input))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<RecipeRuneAltar> recipes = new LinkedList<RecipeRuneAltar>();
        for (RecipeRuneAltar r : BotaniaAPI.runeAltarRecipes) {
            if (r == null || r.getOutput() == null || !StackHelper.matches((IIngredient)output, (IItemStack)InputHelper.toIItemStack((ItemStack)r.getOutput()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", "Botania Eleven Trade", output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<RecipeRuneAltar> {
        public Remove(List<RecipeRuneAltar> recipes) {
            super(RuneAltar.name, BotaniaAPI.runeAltarRecipes, recipes);
        }

        public String getRecipeInfo(RecipeRuneAltar recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutput());
        }
    }

    private static class Add
    extends BaseListAddition<RecipeRuneAltar> {
        public Add(RecipeRuneAltar recipe) {
            super(RuneAltar.name, BotaniaAPI.runeAltarRecipes);
            this.recipes.add(recipe);
        }

        public String getRecipeInfo(RecipeRuneAltar recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutput());
        }
    }
}

