/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.bloodmagic.handlers;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.ItemStackWrapper;
import WayofTime.bloodmagic.api.altar.EnumAltarTier;
import WayofTime.bloodmagic.api.registry.AltarRecipeRegistry;
import WayofTime.bloodmagic.compat.jei.altar.AltarRecipeJEI;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.ReflectionHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseMapAddition;
import com.blamejared.mtlib.utils.BaseMapRemoval;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.IRecipeCategory;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker.JEIAddonPlugin;
import modtweaker.mods.bloodmagic.BloodMagicHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeModContainer;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.Altar")
public class Altar {
    protected static final String name = "Blood Magic Altar";
    private static final EnumAltarTier[] altarTiers = EnumAltarTier.values();

    @ZenMethod
    public static void addRecipe(IItemStack output, int minTier, int syphon, int consumeRate, int drainRate, IItemStack[] input) {
        if (output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (minTier <= 0 || minTier > altarTiers.length) {
            LogHelper.logWarning((String)String.format("Invalid altar tier (%d) required for %s Recipe", minTier, name));
            return;
        }
        if (syphon < 0) {
            LogHelper.logWarning((String)String.format("Syphon can't be below 0 (%d) for %s Recipe", syphon, name));
            return;
        }
        if (consumeRate < 0) {
            LogHelper.logWarning((String)String.format("Consume rate can't be below 0 (%d) for %s Recipe", consumeRate, name));
            return;
        }
        if (drainRate < 0) {
            LogHelper.logWarning((String)String.format("Drain rate can't be below 0 (%d) for %s Recipe", drainRate, name));
            return;
        }
        List<ItemStack> inputs = Arrays.asList(InputHelper.toStacks((IItemStack[])input));
        AltarRecipeRegistry.AltarRecipe temp = new AltarRecipeRegistry.AltarRecipe(inputs, InputHelper.toStack((IItemStack)output), altarTiers[minTier - 1], syphon, consumeRate, drainRate);
        MineTweakerAPI.apply((IUndoableAction)new Add(temp.getInput(), temp, (Map<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe>)BloodMagicHelper.altarBiMap));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        Altar.remove(output, BloodMagicHelper.altarBiMap);
    }

    public static void remove(IIngredient output, Map<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe> map) {
        if (output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        HashMap<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe> recipes = new HashMap<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe>();
        for (AltarRecipeRegistry.AltarRecipe altarRecipe : map.values()) {
            ItemStack recipeOutput = (ItemStack)ReflectionHelper.getFinalObject((Object)altarRecipe, (String[])new String[]{"output"});
            if (!StackHelper.matches((IIngredient)output, (IItemStack)InputHelper.toIItemStack((ItemStack)recipeOutput))) continue;
            recipes.put(altarRecipe.getInput(), altarRecipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(map, recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseMapRemoval<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe> {
        public Remove(Map<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe> map, Map<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe> inputs) {
            super(Altar.name, map, inputs);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (List key : this.recipes.keySet()) {
                AltarRecipeRegistry.AltarRecipe oldValue = (AltarRecipeRegistry.AltarRecipe)this.map.remove(key);
                if (oldValue != null) {
                    this.successful.put(key, oldValue);
                    if (JEIAddonPlugin.recipeRegistry == null) continue;
                    List list = JEIAddonPlugin.recipeRegistry.getRecipeWrappers((IRecipeCategory)JEIAddonPlugin.recipeRegistry.getRecipeCategories(Arrays.asList("BloodMagic:altar")).get(0));
                    AltarRecipeJEI[] recipe = new AltarRecipeJEI[]{null};
                    list.forEach(rec -> {
                        ItemStack input = (ItemStack)((List)ReflectionHelper.getFinalObject((Object)rec, (String[])new String[]{"input"})).get(0);
                        ItemStack output = (ItemStack)ReflectionHelper.getFinalObject((Object)rec, (String[])new String[]{"output"});
                        if (input.func_77969_a(((ItemStackWrapper)oldValue.getInput().get(0)).toStack()) && output.func_77969_a(oldValue.getOutput())) {
                            recipe[0] = rec;
                        }
                    });
                    if (recipe[0] == null) continue;
                    MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe[0]);
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe : null object", this.name));
            }
        }

        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (Map.Entry<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe> entry : this.successful.entrySet()) {
                if (entry == null) continue;
                AltarRecipeRegistry.AltarRecipe oldValue = (AltarRecipeRegistry.AltarRecipe)this.map.put(entry.getKey(), entry.getValue());
                if (oldValue != null) {
                    LogHelper.logWarning((String)String.format("Overwritten %s Recipe for %s while restoring.", this.name, this.getRecipeInfo(entry)));
                    continue;
                }
                List input = ItemStackWrapper.toStackList((List)((AltarRecipeRegistry.AltarRecipe)entry.getValue()).getInput());
                ItemStack output = ((AltarRecipeRegistry.AltarRecipe)entry.getValue()).getOutput();
                int requiredTier = entry.getValue().getMinTier().toInt();
                int requiredLP = entry.getValue().getSyphon();
                int consumptionRate = entry.getValue().getConsumeRate();
                int drainRate = entry.getValue().getDrainRate();
                if (output.func_77973_b() == ForgeModContainer.getInstance().universalBucket && requiredLP == 1000) {
                    output = BloodMagicAPI.getLifeEssenceBucket();
                }
                AltarRecipeJEI recipe = new AltarRecipeJEI(input, output, requiredTier, requiredLP, consumptionRate, drainRate);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe);
            }
        }

        public String getRecipeInfo(Map.Entry<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe> recipe) {
            ItemStack output = (ItemStack)ReflectionHelper.getFinalObject((Object)recipe.getValue(), (String[])new String[]{"output"});
            return LogHelper.getStackDescription((Object)output);
        }
    }

    private static class Add
    extends BaseMapAddition<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe> {
        public Add(List<ItemStackWrapper> inputs, AltarRecipeRegistry.AltarRecipe altarRecipe, Map<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe> map) {
            super(Altar.name, map);
            this.recipes.put(inputs, altarRecipe);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (Map.Entry entry : this.recipes.entrySet()) {
                AltarRecipeRegistry.AltarRecipe value;
                List key = (List)entry.getKey();
                AltarRecipeRegistry.AltarRecipe oldValue = this.map.put(key, value = (AltarRecipeRegistry.AltarRecipe)entry.getValue());
                if (oldValue != null) {
                    LogHelper.logWarning((String)String.format("Overwritten %s Recipe for %s", this.name, this.getRecipeInfo(new AbstractMap.SimpleEntry<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe>((List<ItemStackWrapper>)entry.getKey(), value))));
                    this.overwritten.put(key, oldValue);
                }
                this.successful.put(key, value);
                List input = ItemStackWrapper.toStackList((List)value.getInput());
                ItemStack output = value.getOutput();
                int requiredTier = value.getMinTier().toInt();
                int requiredLP = value.getSyphon();
                int consumptionRate = value.getConsumeRate();
                int drainRate = value.getDrainRate();
                if (output.func_77973_b() == ForgeModContainer.getInstance().universalBucket && requiredLP == 1000) {
                    output = BloodMagicAPI.getLifeEssenceBucket();
                }
                AltarRecipeJEI recipe = new AltarRecipeJEI(input, output, requiredTier, requiredLP, consumptionRate, drainRate);
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
            }
        }

        public void undo() {
            AltarRecipeRegistry.AltarRecipe value;
            List key;
            if (this.successful.isEmpty() && this.overwritten.isEmpty()) {
                return;
            }
            for (Map.Entry entry : this.successful.entrySet()) {
                key = (List)entry.getKey();
                value = (AltarRecipeRegistry.AltarRecipe)this.map.remove(key);
                if (value == null) {
                    LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
                    continue;
                }
                this.successful.put(key, value);
                if (JEIAddonPlugin.recipeRegistry == null) continue;
                List list = JEIAddonPlugin.recipeRegistry.getRecipeWrappers((IRecipeCategory)JEIAddonPlugin.recipeRegistry.getRecipeCategories(Arrays.asList("BloodMagic:altar")).get(0));
                AltarRecipeJEI[] recipe = new AltarRecipeJEI[]{null};
                list.forEach(rec -> {
                    ItemStack input = (ItemStack)((List)ReflectionHelper.getFinalObject((Object)rec, (String[])new String[]{"input"})).get(0);
                    ItemStack output = (ItemStack)ReflectionHelper.getFinalObject((Object)rec, (String[])new String[]{"output"});
                    if (input.func_77969_a(((ItemStackWrapper)value.getInput().get(0)).toStack()) && output.func_77969_a(value.getOutput())) {
                        recipe[0] = rec;
                    }
                });
                if (recipe[0] == null) continue;
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)recipe[0]);
            }
            for (Map.Entry entry : this.overwritten.entrySet()) {
                key = (List)entry.getKey();
                AltarRecipeRegistry.AltarRecipe oldValue = this.map.put(key, value = (AltarRecipeRegistry.AltarRecipe)entry.getValue());
                if (oldValue == null) continue;
                LogHelper.logWarning((String)String.format("Overwritten %s Recipe which should not exist for %s", this.name, this.getRecipeInfo(new AbstractMap.SimpleEntry<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe>((List<ItemStackWrapper>)entry.getKey(), value))));
            }
        }

        public String getRecipeInfo(Map.Entry<List<ItemStackWrapper>, AltarRecipeRegistry.AltarRecipe> recipe) {
            ItemStack output = (ItemStack)ReflectionHelper.getFinalObject((Object)recipe.getValue(), (String[])new String[]{"output"});
            return LogHelper.getStackDescription((Object)output);
        }
    }
}

