/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.actuallyadditions.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.actuallyadditions.AtomicReconstructor")
public class AtomicReconstructor {
    protected static final String name = "Actually Additions Atomic Reconstructor";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int energyUse) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new LensConversionRecipe(InputHelper.toStack((IItemStack)input), InputHelper.toStack((IItemStack)output), energyUse, ActuallyAdditionsAPI.lensDefaultConversion)));
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        LinkedList<LensConversionRecipe> recipes = new LinkedList<LensConversionRecipe>();
        if (output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        for (LensConversionRecipe recipe : ActuallyAdditionsAPI.RECONSTRUCTOR_LENS_CONVERSION_RECIPES) {
            if (!StackHelper.matches((IIngredient)output, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.inputStack))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<LensConversionRecipe> {
        public Remove(List<LensConversionRecipe> recipes) {
            super(AtomicReconstructor.name, ActuallyAdditionsAPI.RECONSTRUCTOR_LENS_CONVERSION_RECIPES, recipes);
        }

        protected String getRecipeInfo(LensConversionRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.inputStack);
        }
    }

    private static class Add
    extends BaseListAddition<LensConversionRecipe> {
        public Add(LensConversionRecipe recipe) {
            super(AtomicReconstructor.name, ActuallyAdditionsAPI.RECONSTRUCTOR_LENS_CONVERSION_RECIPES);
            this.recipes.add(recipe);
        }

        public String getRecipeInfo(LensConversionRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.inputStack);
        }
    }
}

