/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter;

import com.google.common.collect.Maps;
import cubex2.mods.chesttransporter.CommonProxy;
import cubex2.mods.chesttransporter.ItemChestTransporter;
import cubex2.mods.chesttransporter.TransporterType;
import cubex2.mods.chesttransporter.chests.BasicDrawer;
import cubex2.mods.chesttransporter.chests.BasicDrawerExtra;
import cubex2.mods.chesttransporter.chests.BiblioFramedChest;
import cubex2.mods.chesttransporter.chests.CharsetBarrel;
import cubex2.mods.chesttransporter.chests.ChestRegistry;
import cubex2.mods.chesttransporter.chests.CompDrawer;
import cubex2.mods.chesttransporter.chests.CompactChest;
import cubex2.mods.chesttransporter.chests.QuarkChest;
import cubex2.mods.chesttransporter.chests.SortingChestIron;
import cubex2.mods.chesttransporter.chests.SortingChestWood;
import cubex2.mods.chesttransporter.chests.Spawner;
import cubex2.mods.chesttransporter.chests.StorageCrate;
import cubex2.mods.chesttransporter.chests.TransportableChestImpl;
import cubex2.mods.chesttransporter.chests.TransportableChestOld;
import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="ChestTransporter", name="Chest Transporter", version="2.5.17", acceptedMinecraftVersions="[1.10.2]")
public class ChestTransporter {
    @Mod.Instance(value="ChestTransporter")
    public static ChestTransporter instance;
    @SidedProxy(clientSide="cubex2.mods.chesttransporter.ClientProxy", serverSide="cubex2.mods.chesttransporter.CommonProxy")
    public static CommonProxy proxy;
    private static boolean pickupSpawners;
    public static boolean debuffSlowness;
    public static boolean debuffMiningFatigue;
    public static boolean debuffJump;
    public static boolean debuffHunger;
    public static final EnumMap<TransporterType, ItemChestTransporter> items;
    public static final EnumMap<TransporterType, Boolean> canUseSpawner;
    public static final String ID = "ChestTransporter";

    public ChestTransporter() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ChestRegistry.init();
        proxy.preInit();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
            pickupSpawners = config.getBoolean("pickupSpawners", "general", true, "Set this to false to prevent picking up of mob spawners");
            debuffSlowness = config.getBoolean("debuffSlowness", "general", true, "Set to false to disable the slowness debuff");
            debuffMiningFatigue = config.getBoolean("debuffMiningFatigue", "general", true, "Set to false to disable the mining fatigue debuff");
            debuffJump = config.getBoolean("debuffJump", "general", true, "Set to false to disable the jump debuff");
            debuffHunger = config.getBoolean("debuffHunger", "general", true, "Set to false to disable the hunger debuff");
            for (TransporterType type : TransporterType.values()) {
                canUseSpawner.put(type, config.getBoolean(type.spawnerConfigName(), "general", true, "Set this to false to prevent the " + type.name().toLowerCase() + " transporter to pick up mob spawners"));
            }
        }
        finally {
            config.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (TransporterType type : TransporterType.values()) {
            ItemChestTransporter item = new ItemChestTransporter(type);
            items.put(type, item);
            item.setRegistryName("chesttransporter", "chesttransporter" + type.nameSuffix);
            GameRegistry.register((IForgeRegistryEntry)item);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)item), new Object[]{"S S", "SSS", " M ", Character.valueOf('S'), "stickWood", Character.valueOf('M'), type.recipeMaterial}));
        }
        proxy.registerModels();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        String[] classNames;
        Block barrel;
        int i;
        String[] names;
        Block block;
        TransportableChestOld chest = new TransportableChestOld((Block)Blocks.field_150486_ae, -1, 1, "vanilla");
        ChestRegistry.register(chest);
        ChestRegistry.registerMinecart(EntityMinecartChest.class, chest);
        ChestRegistry.register(new TransportableChestOld(Blocks.field_150447_bR, -1, 2, "vanilla_trapped"));
        if (Loader.isModLoaded((String)"ironchest") && (block = Block.func_149684_b((String)"ironchest:BlockIronChest")) != null && block != Blocks.field_150350_a) {
            names = new String[]{"iron", "gold", "diamond", "copper", "tin", "crystal", "obsidian"};
            for (i = 0; i < 7; ++i) {
                ChestRegistry.register(new TransportableChestOld(block, i, 3 + i, names[i]));
            }
        }
        if (Loader.isModLoaded((String)"MultiPageChest") && (block = Block.func_149684_b((String)"MultiPageChest:multipagechest")) != null && block != Blocks.field_150350_a) {
            ChestRegistry.register(new TransportableChestOld(block, -1, 10, "multipagechest"));
        }
        if (Loader.isModLoaded((String)"compactstorage") && (block = Block.func_149684_b((String)"compactstorage:compactChest")) != null && block != Blocks.field_150350_a) {
            ChestRegistry.register(new CompactChest(block, -1, 14, "compact_chest"));
        }
        if (Loader.isModLoaded((String)"StorageDrawers")) {
            block = Block.func_149684_b((String)"storagedrawers:basicDrawers");
            if (block != null && block != Blocks.field_150350_a) {
                names = new String[]{"full1", "full2", "full4", "half2", "half4"};
                for (i = 0; i < names.length; ++i) {
                    int dv = 19 + i;
                    if (dv == 23) {
                        dv = 27;
                    }
                    ChestRegistry.register(new BasicDrawer(block, i, dv, "basic_drawer_" + names[i]));
                }
            }
            if ((block = Block.func_149684_b((String)"storagedrawers:compDrawers")) != null && block != Blocks.field_150350_a) {
                ChestRegistry.register(new CompDrawer(block, 0, 23, "comp_drawer"));
            }
        }
        if (pickupSpawners) {
            ChestRegistry.register(new Spawner(Blocks.field_150474_ac, -1, 24, "spawner"));
        }
        if (Loader.isModLoaded((String)"Quark")) {
            block = Block.func_149684_b((String)"quark:custom_chest");
            if (block != null && block != Blocks.field_150350_a) {
                ChestRegistry.register(new QuarkChest(block, 25, "quark_chest"));
            }
            if ((block = Block.func_149684_b((String)"quark:custom_chest_trap")) != null && block != Blocks.field_150350_a) {
                ChestRegistry.register(new QuarkChest(block, 26, "quark_chest_trap"));
            }
        }
        if (Loader.isModLoaded((String)"fluidity") && (block = Block.func_149684_b((String)"fluidity:fluidity_iron_chest")) != null && block != Blocks.field_150350_a) {
            names = new String[]{"bronze", "invar", "electrum", "tin", "brass", "lead", "steel", "nickel", "cold_iron", "adamantine", "aquarium", "mithril", "star_steel", "cupronickel", "platinum"};
            for (i = 0; i < names.length; ++i) {
                ChestRegistry.register(new TransportableChestOld(block, i, 28 + i, "fluidity_" + names[i]));
            }
        }
        if (Loader.isModLoaded((String)"BiblioCraft") && (block = Block.func_149684_b((String)"BiblioCraft:FramedChest")) != null && block != Blocks.field_150350_a) {
            names = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "framed"};
            for (i = 0; i < names.length; ++i) {
                TransportableChestOld chest1 = i == names.length - 1 ? new BiblioFramedChest(block, i, 43 + i, "biblio_chest_" + names[i]) : new TransportableChestOld(block, i, 43 + i, "biblio_chest_" + names[i]);
                ChestRegistry.register(chest1);
            }
        }
        if (Loader.isModLoaded((String)"actuallyadditions")) {
            Block small = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("actuallyadditions:blockGiantChest"));
            Block medium = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("actuallyadditions:blockGiantChestMedium"));
            Block large = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("actuallyadditions:blockGiantChestLarge"));
            if (small != null && small != Blocks.field_150350_a) {
                ChestRegistry.register(new StorageCrate(small, 0, 50, "crate_small"));
            }
            if (medium != null && medium != Blocks.field_150350_a) {
                ChestRegistry.register(new StorageCrate(medium, 0, 51, "crate_medium"));
            }
            if (large != null && large != Blocks.field_150350_a) {
                ChestRegistry.register(new StorageCrate(large, 0, 52, "crate_large"));
            }
        }
        if (Loader.isModLoaded((String)"refinedrelocation")) {
            Block chestWood = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("refinedrelocation:sortingChest"));
            Block chestIron = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("refinedrelocation:sorting_iron_chest"));
            if (chestWood != null && chestWood != Blocks.field_150350_a) {
                ChestRegistry.register(new SortingChestWood(chestWood, -1, "sorting_chest"));
            }
            if (chestIron != null && chestIron != Blocks.field_150350_a) {
                String[] variants = new String[]{"iron", "gold", "diamond", "copper", "tin", "crystal", "obsidian", "dirt"};
                for (int i2 = 0; i2 < variants.length; ++i2) {
                    ChestRegistry.register(new SortingChestIron(chestIron, i2, "sorting_iron_chest_" + variants[i2]));
                }
            }
        }
        if (Loader.isModLoaded((String)"CharsetStorage") && (barrel = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("charsetstorage:barrel"))) != null && barrel != Blocks.field_150350_a) {
            ChestRegistry.register(new CharsetBarrel(barrel, 0, "charset_barrel"));
        }
        if (Loader.isModLoaded((String)"forestry") && (block = Block.func_149684_b((String)"forestry:bee_chest")) != null && block != Blocks.field_150350_a) {
            ChestRegistry.register(new TransportableChestImpl(block, -1, "bee_chest"));
        }
        if (Loader.isModLoaded((String)"storagedrawersextra") && (block = Block.func_149684_b((String)"storagedrawersextra:extra_drawers")) != null && block != Blocks.field_150350_a) {
            String[] variants = new String[]{"forestry_acacia", "forestry_balsa", "forestry_baobab", "forestry_cherry", "forestry_chestnut", "forestry_citrus", "forestry_cocobolo", "forestry_ebony", "forestry_giganteum", "forestry_greenheart", "forestry_ipe", "forestry_kapok", "forestry_larch", "forestry_lime", "forestry_mahoe", "forestry_mahogany", "forestry_maple", "forestry_padauk", "forestry_palm", "forestry_papaya", "forestry_pine", "forestry_plum", "forestry_poplar", "forestry_sequoia", "forestry_teak", "forestry_walnut", "forestry_wenge", "forestry_willow", "forestry_zebrawood", "natura_bloodwood", "natura_darkwood", "natura_eucalyptus", "natura_fusewood", "natura_ghostwood", "natura_hopseed", "natura_maple", "natura_purpleheart", "natura_redwood", "natura_sakura", "natura_silverbell", "natura_tigerwood", "natura_willow", "biomesoplenty_cherry", "biomesoplenty_dark", "biomesoplenty_ebony", "biomesoplenty_ethereal", "biomesoplenty_eucalyptus", "biomesoplenty_fir", "biomesoplenty_hellbark", "biomesoplenty_jacaranda", "biomesoplenty_magic", "biomesoplenty_mahogany", "biomesoplenty_mangrove", "biomesoplenty_palm", "biomesoplenty_pine", "biomesoplenty_redwood", "biomesoplenty_sacredoak", "biomesoplenty_willow", "immersiveengineering_treated"};
            String[] names2 = new String[]{"full1", "full2", "full4", "half2", "half4"};
            for (int i3 = 0; i3 < names2.length; ++i3) {
                ChestRegistry.register(new BasicDrawerExtra(block, i3, "extra_drawer_" + names2[i3], variants));
            }
        }
        if (Loader.isModLoaded((String)"ironchestminecarts") && Loader.isModLoaded((String)"ironchest")) {
            classNames = new String[]{"ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartIronChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartGoldChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartDiamondChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartCopperChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartSilverChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartCrystalChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartObsidianChest"};
            try {
                for (int i4 = 0; i4 < 7; ++i4) {
                    ChestRegistry.registerMinecart(Class.forName(classNames[i4]), ChestRegistry.getChestFromType(3 + i4).get());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"extracarts") && Loader.isModLoaded((String)"ironchest")) {
            classNames = new String[]{"com.dta.extracarts.mods.ironchest.entities.EntityIronChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityGoldChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityDiamondChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityCopperChestCart", "com.dta.extracarts.mods.ironchest.entities.EntitySilverChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityCrystalChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityObsidianChestCart"};
            try {
                for (int i5 = 0; i5 < 7; ++i5) {
                    ChestRegistry.registerMinecart(Class.forName(classNames[i5]), ChestRegistry.getChestFromType(3 + i5).get());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        pickupSpawners = true;
        debuffSlowness = true;
        debuffMiningFatigue = true;
        debuffJump = true;
        debuffHunger = true;
        items = Maps.newEnumMap(TransporterType.class);
        canUseSpawner = Maps.newEnumMap(TransporterType.class);
    }
}

