/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.lttweaker;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minetweaker.IBracketHandler;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.mc1102.brackets.ItemBracketHandler;
import minetweaker.runtime.IScriptProvider;
import minetweaker.runtime.providers.ScriptProviderDirectory;
import net.darkhax.lttweaker.CommandTableDump;
import net.darkhax.lttweaker.LootTableTweaker;
import net.minecraft.command.ICommand;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Mod(modid="lttweaker", name="Loot Table Tweaker", version="1.0.0.8", dependencies="required-after:MineTweaker3", acceptedMinecraftVersions="[1.10.2]")
public class LTTMod {
    @Mod.Instance(value="lttweaker")
    public static LTTMod instance;
    private static Field pools;
    private static Field lootEntries;
    public static Map<String, LootTable> tables;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File scriptDir = new File("scripts", "loottabletweaker");
        if (!scriptDir.exists()) {
            scriptDir.mkdir();
        }
        if (scriptDir.exists()) {
            MineTweakerAPI.registerBracketHandler((IBracketHandler)new ItemBracketHandler());
            ItemBracketHandler.rebuildItemRegistry();
            MineTweakerAPI.registerClass(LootTableTweaker.class);
            MineTweakerAPI.tweaker.setScriptProvider((IScriptProvider)new ScriptProviderDirectory(scriptDir));
            MineTweakerImplementationAPI.reload();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MineTweakerAPI.registerClass(LootTableTweaker.class);
        pools = ReflectionHelper.findField(LootTable.class, (String[])new String[]{"pools", "field_186466_c", "c"});
        lootEntries = ReflectionHelper.findField(LootPool.class, (String[])new String[]{"lootEntries", "field_186453_a", "a"});
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTableDump());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTablesLoad(LootTableLoadEvent event) {
        String tableName = event.getName().toString();
        if (LootTableTweaker.tablesToClear.contains(tableName)) {
            LTTMod.getPools(event.getTable()).clear();
        }
        if (LootTableTweaker.poolsToClear.containsKey(tableName)) {
            for (String poolName : LootTableTweaker.poolsToClear.get(tableName)) {
                event.getTable().removePool(poolName);
            }
        }
        if (LootTableTweaker.entriesToClear.containsKey(tableName)) {
            Map<String, List<String>> pools = LootTableTweaker.entriesToClear.get(tableName);
            for (String poolName : pools.keySet()) {
                LootPool pool = event.getTable().getPool(poolName);
                if (pool == null) continue;
                for (String entryName : pools.get(pool.getName())) {
                    pool.removeEntry(entryName);
                }
            }
        }
        tables.put(tableName, event.getTable());
    }

    public static List<LootPool> getPools(LootTable table) {
        try {
            return (List)pools.get(table);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return new ArrayList<LootPool>();
        }
    }

    public static List<LootEntry> getLootEntries(LootPool pool) {
        try {
            return (List)lootEntries.get(pool);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        tables = new HashMap<String, LootTable>();
    }
}

