/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.rocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.Survivalist;
import gigaherz.survivalist.shadow.common.OreDictionaryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RocksEventHandling {
    private final Random rnd = new Random();

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new RocksEventHandling());
    }

    @SubscribeEvent
    public void onHarvestBlock(BlockEvent.HarvestDropsEvent ev) {
        if (ev.isSilkTouching()) {
            return;
        }
        List drops = ev.getDrops();
        if (drops instanceof ImmutableList) {
            Survivalist.logger.warn("WARNING: Some mod is returning an ImmutableList from HarvestBlocks, replacing drops will NOT be possible.");
            return;
        }
        boolean anyChanged = false;
        ArrayList newDrops = Lists.newArrayList();
        block6: for (ItemStack drop : drops) {
            if (drop == null || drop.field_77994_a <= 0) continue;
            if (drop.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e) && ConfigManager.instance.replaceStoneDrops) {
                newDrops.add(new ItemStack((Item)Survivalist.rock, 4));
                anyChanged = true;
                continue;
            }
            if (drop.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150348_b) && ConfigManager.instance.replaceStoneDrops) {
                switch (drop.func_77960_j()) {
                    case 0: {
                        newDrops.add(new ItemStack((Item)Survivalist.rock, 4, 0));
                        anyChanged = true;
                        continue block6;
                    }
                    case 5: {
                        newDrops.add(new ItemStack((Item)Survivalist.rock, 4, 1));
                        anyChanged = true;
                        continue block6;
                    }
                    case 3: {
                        newDrops.add(new ItemStack((Item)Survivalist.rock, 4, 2));
                        anyChanged = true;
                        continue block6;
                    }
                    case 1: {
                        newDrops.add(new ItemStack((Item)Survivalist.rock, 4, 3));
                        anyChanged = true;
                        continue block6;
                    }
                }
                newDrops.add(drop);
                continue;
            }
            if (drop.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150366_p) && ConfigManager.instance.replaceIronOreDrops) {
                newDrops.add(new ItemStack((Item)Survivalist.rock_ore, 2 + Math.round(2.0f * this.rnd.nextFloat()), 0));
                anyChanged = true;
                continue;
            }
            if (drop.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150352_o) && ConfigManager.instance.replaceGoldOreDrops) {
                newDrops.add(new ItemStack((Item)Survivalist.rock_ore, 2 + Math.round(2.0f * this.rnd.nextFloat()), 1));
                anyChanged = true;
                continue;
            }
            if (ConfigManager.instance.replaceModOreDrops) {
                if (OreDictionaryHelper.hasOreName(drop, "oreCopper")) {
                    newDrops.add(new ItemStack((Item)Survivalist.rock_ore, 2 + Math.round(2.0f * this.rnd.nextFloat()), 2));
                    anyChanged = true;
                    continue;
                }
                if (OreDictionaryHelper.hasOreName(drop, "oreTin")) {
                    newDrops.add(new ItemStack((Item)Survivalist.rock_ore, 2 + Math.round(2.0f * this.rnd.nextFloat()), 3));
                    anyChanged = true;
                    continue;
                }
                if (OreDictionaryHelper.hasOreName(drop, "oreLead")) {
                    newDrops.add(new ItemStack((Item)Survivalist.rock_ore, 2 + Math.round(2.0f * this.rnd.nextFloat()), 4));
                    anyChanged = true;
                    continue;
                }
                if (OreDictionaryHelper.hasOreName(drop, "oreSilver")) {
                    newDrops.add(new ItemStack((Item)Survivalist.rock_ore, 2 + Math.round(2.0f * this.rnd.nextFloat()), 5));
                    anyChanged = true;
                    continue;
                }
                newDrops.add(drop);
                continue;
            }
            newDrops.add(drop);
        }
        if (anyChanged) {
            drops.clear();
            drops.addAll(newDrops);
        }
    }
}

