/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.integration.drying;

import com.google.common.collect.Lists;
import gigaherz.survivalist.api.Dryable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class DryingRecipeWrapper
extends BlankRecipeWrapper {
    private int time;
    private ItemStack output;

    public static List<DryingRecipeWrapper> getRecipes() {
        ArrayList list = Lists.newArrayList();
        for (Dryable.DryingRecipe pair : Dryable.RECIPES) {
            Object p = DryingRecipeWrapper.wrap(pair);
            if (p == null) continue;
            list.add((DryingRecipeWrapper)((Object)p));
        }
        return list;
    }

    @Nullable
    public static Object wrap(Dryable.DryingRecipe pair) {
        if (pair instanceof Dryable.DryingItemRecipe) {
            return new ItemInput((Dryable.DryingItemRecipe)pair);
        }
        if (pair instanceof Dryable.DryingOreRecipe) {
            return new OreInput((Dryable.DryingOreRecipe)pair);
        }
        return null;
    }

    private static ItemStack copyWithSize(ItemStack middle) {
        middle = middle.func_77946_l();
        middle.field_77994_a = 1;
        return middle;
    }

    private DryingRecipeWrapper(ItemStack output, int time) {
        this.output = output;
        this.time = time;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public void drawInfo(@Nonnull Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(mc, recipeWidth, recipeHeight, mouseX, mouseY);
        String label = (double)this.time / 20.0 + "s";
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)150.0f);
        mc.field_71466_p.func_175065_a(label, (float)(58 - mc.field_71466_p.func_78256_a(label)), 14.0f, -1, true);
        GlStateManager.func_179121_F();
    }

    private static class OreInput
    extends DryingRecipeWrapper {
        private String inputOredict;

        private OreInput(String input, ItemStack output, int time) {
            super(output, time);
            this.inputOredict = input;
        }

        public OreInput(Dryable.DryingOreRecipe recipe) {
            this(recipe.getOreName(), DryingRecipeWrapper.copyWithSize(recipe.getOutput()), recipe.getTime());
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(ItemStack.class, Collections.singletonList(OreDictionary.getOres((String)this.inputOredict)));
            super.getIngredients(ingredients);
        }
    }

    private static class ItemInput
    extends DryingRecipeWrapper {
        private ItemStack inputStack;

        private ItemInput(ItemStack input, ItemStack output, int time) {
            super(output, time);
            this.inputStack = input;
        }

        public ItemInput(Dryable.DryingItemRecipe recipe) {
            this(recipe.getInput(), DryingRecipeWrapper.copyWithSize(recipe.getOutput()), recipe.getTime());
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(ItemStack.class, (Object)this.inputStack);
            super.getIngredients(ingredients);
        }
    }
}

