/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.chopblock;

import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.api.Choppable;
import gigaherz.survivalist.chopblock.TileChopping;
import gigaherz.survivalist.shadow.common.BlockRegistered;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockChopping
extends BlockRegistered {
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)2);
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final String[] subNames = new String[]{".pristine_chopping_block", ".used_chopping_block", ".weathered_chopping_block"};

    public BlockChopping(String name) {
        super(name, Material.field_151575_d);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(5.0f);
        this.func_149752_b(5.0f);
        this.func_149713_g(0);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(0)));
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (ConfigManager.instance.enableChopping) {
            for (int i = 0; i < subNames.length; ++i) {
                list.add(new ItemStack((Block)this, 1, i));
            }
        }
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileChopping();
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DAMAGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf((meta & 3) % 3));
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileChopping) || playerIn.func_70093_af()) {
            return false;
        }
        TileChopping chopper = (TileChopping)tileEntity;
        if (heldItem == null) {
            ItemStack extracted = chopper.getSlotInventory().extractItem(0, 1, false);
            if (extracted != null && extracted.field_77994_a > 0) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)extracted);
                return true;
            }
            return false;
        }
        if (Choppable.isValidInput(heldItem)) {
            ItemStack remaining = chopper.getSlotInventory().insertItem(0, heldItem, false);
            if (!playerIn.func_184812_l_()) {
                if (remaining != null && remaining.field_77994_a > 0) {
                    playerIn.func_184611_a(hand, remaining);
                } else {
                    playerIn.func_184611_a(hand, null);
                }
            }
            return remaining == null || remaining.field_77994_a < heldItem.field_77994_a;
        }
        return false;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        ItemStack heldItem;
        int harvestLevel;
        TileChopping chopper;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileChopping && (chopper = (TileChopping)tileentity).chop(playerIn, harvestLevel = this.getAxeLevel(heldItem = playerIn.func_184586_b(EnumHand.MAIN_HAND), playerIn), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem))) {
            if (worldIn.field_73012_v.nextFloat() < ConfigManager.instance.choppingDegradeChance) {
                int damage = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)DAMAGE);
                if (damage < 2) {
                    worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(damage + 1)));
                } else {
                    worldIn.func_175698_g(pos);
                }
            }
            if (ConfigManager.instance.choppingExhaustion > 0.0f) {
                playerIn.func_71020_j(ConfigManager.instance.choppingExhaustion);
            }
            if (heldItem != null && !playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
                if (heldItem.field_77994_a <= 0) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)playerIn, (ItemStack)heldItem, (EnumHand)EnumHand.MAIN_HAND);
                    playerIn.func_184611_a(EnumHand.MAIN_HAND, null);
                }
            }
        }
        super.func_180649_a(worldIn, pos, playerIn);
    }

    private int getAxeLevel(@Nullable ItemStack heldItem, @Nullable EntityPlayer playerIn) {
        if (heldItem == null) {
            return -1;
        }
        int level = ConfigManager.instance.getAxeLevel(heldItem);
        if (level >= 0) {
            return level;
        }
        return heldItem.func_77973_b().getHarvestLevel(heldItem, "axe", playerIn, null);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileChopping) {
            BlockChopping.dropInventoryItems(worldIn, pos, (IItemHandler)((TileChopping)tileentity).getSlotInventory());
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack == null) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
    }

    @Override
    public ItemBlock createItemBlock() {
        return (ItemBlock)new AsItem(this).setRegistryName(this.getRegistryName());
    }

    public static class AsItem
    extends ItemBlock {
        public AsItem(Block block) {
            super(block);
            this.func_77627_a(true);
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            int meta = stack.func_77960_j();
            if (meta > subNames.length) {
                return this.func_77658_a();
            }
            return "tile.survivalist" + subNames[meta];
        }
    }
}

