/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.api;

import com.google.common.collect.Lists;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.shadow.common.OreDictionaryHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class Choppable {
    public static final List<ChoppingRecipe> RECIPES = Lists.newArrayList();

    public static void registerStockRecipes() {
        Choppable.registerRecipe("plankWood", new ItemStack(Items.field_151055_y)).setOutputMultiplier(2.0);
        if (ConfigManager.instance.enableStringCrafting) {
            Choppable.registerRecipe(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new ItemStack(Items.field_151007_F)).setMaxOutput(4);
        }
    }

    public static ChoppingRecipe registerRecipe(ItemStack input, ItemStack output) {
        return Choppable.registerRecipe(new ChoppingItemRecipe(input, output));
    }

    public static ChoppingRecipe registerRecipe(String input, ItemStack output) {
        return Choppable.registerRecipe(new ChoppingOreRecipe(input, output));
    }

    private static ChoppingRecipe registerRecipe(ChoppingRecipe recipe) {
        RECIPES.add(recipe);
        return recipe;
    }

    public static boolean isValidInput(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (ChoppingRecipe recipe : RECIPES) {
            if (!recipe.accepts(stack)) continue;
            return true;
        }
        return false;
    }

    public static ChoppingRecipe find(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (ChoppingRecipe recipe : RECIPES) {
            if (!recipe.accepts(stack)) continue;
            return recipe;
        }
        return null;
    }

    public static double getHitCountMultiplier(ItemStack stack) {
        if (stack == null) {
            return 0.0;
        }
        for (ChoppingRecipe recipe : RECIPES) {
            if (!recipe.accepts(stack)) continue;
            return recipe.getHitCountMultiplier();
        }
        return 0.0;
    }

    public static class ChoppingOreRecipe
    extends ChoppingRecipe {
        private String oreName;

        public ChoppingOreRecipe(String oreName, ItemStack output) {
            super(output);
            this.oreName = oreName;
        }

        public String getOreName() {
            return this.oreName;
        }

        @Override
        public boolean accepts(ItemStack stack) {
            return OreDictionaryHelper.hasOreName(stack, this.oreName);
        }
    }

    public static class ChoppingItemRecipe
    extends ChoppingRecipe {
        private ItemStack input;

        public ChoppingItemRecipe(ItemStack input, ItemStack output) {
            super(output);
            this.input = input;
        }

        public ItemStack getInput() {
            return this.input;
        }

        @Override
        public boolean accepts(ItemStack stack) {
            return OreDictionary.itemMatches((ItemStack)this.input, (ItemStack)stack, (boolean)false);
        }
    }

    public static abstract class ChoppingRecipe {
        private ItemStack output;
        private double outputMultiplier = 1.0;
        private double hitCountMultiplier = 1.0;
        private int maxOutput;

        public ChoppingRecipe(ItemStack output) {
            this.output = output;
        }

        public abstract boolean accepts(ItemStack var1);

        public ItemStack getOutput() {
            return this.output;
        }

        public double getOutputMultiplier() {
            return this.outputMultiplier;
        }

        public ChoppingRecipe setOutputMultiplier(double outputMultiplier) {
            this.outputMultiplier = outputMultiplier;
            return this;
        }

        public double getHitCountMultiplier() {
            return this.hitCountMultiplier;
        }

        public ChoppingRecipe setHitCountMultiplier(double hitCountMultiplier) {
            this.hitCountMultiplier = hitCountMultiplier;
            return this;
        }

        public int getMaxOutput() {
            return this.maxOutput;
        }

        public void setMaxOutput(int maxOutput) {
            this.maxOutput = maxOutput;
        }

        public ItemStack getResults(ItemStack input, EntityPlayer player, int axeLevel, int fortune, Random random) {
            double number = (double)0.4f * this.getOutputMultiplier();
            if (axeLevel >= 0) {
                number = Math.max(0.0, this.getOutputMultiplier() * (double)(1 + axeLevel)) * (double)(1.0f + random.nextFloat() * (float)fortune);
            }
            int whole = (int)Math.floor(number);
            double remainder = number - (double)whole;
            if ((double)random.nextFloat() < remainder) {
                ++whole;
            }
            if (this.getMaxOutput() > 0) {
                whole = Math.min(whole, this.getMaxOutput());
            }
            if (number > 0.0) {
                ItemStack out = this.getOutput().func_77946_l();
                out.field_77994_a = whole;
                return out;
            }
            return null;
        }
    }
}

