/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist;

import com.google.common.collect.Lists;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.GuiHandler;
import gigaherz.survivalist.IModProxy;
import gigaherz.survivalist.api.Choppable;
import gigaherz.survivalist.api.Dryable;
import gigaherz.survivalist.chopblock.BlockChopping;
import gigaherz.survivalist.chopblock.TileChopping;
import gigaherz.survivalist.common.ItemTannedArmor;
import gigaherz.survivalist.misc.FibersEventHandling;
import gigaherz.survivalist.misc.StringEventHandling;
import gigaherz.survivalist.rack.BlockRack;
import gigaherz.survivalist.rack.TileRack;
import gigaherz.survivalist.rocks.EntityRock;
import gigaherz.survivalist.rocks.ItemNugget;
import gigaherz.survivalist.rocks.ItemOreRock;
import gigaherz.survivalist.rocks.ItemRock;
import gigaherz.survivalist.rocks.OreMaterial;
import gigaherz.survivalist.rocks.RockMaterial;
import gigaherz.survivalist.rocks.RocksEventHandling;
import gigaherz.survivalist.scraping.EnchantmentScraping;
import gigaherz.survivalist.scraping.ItemBreakingTracker;
import gigaherz.survivalist.scraping.MessageScraping;
import gigaherz.survivalist.shadow.common.BlockRegistered;
import gigaherz.survivalist.shadow.common.ItemRegistered;
import gigaherz.survivalist.shadow.common.ItemRegisteredAxe;
import gigaherz.survivalist.shadow.common.ItemRegisteredFood;
import gigaherz.survivalist.shadow.common.ItemRegisteredPick;
import gigaherz.survivalist.shadow.common.ItemRegisteredSpade;
import gigaherz.survivalist.shadow.common.OreDictionaryHelper;
import gigaherz.survivalist.torchfire.TorchFireEventHandling;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="survivalist", version="1.10.1", acceptedMinecraftVersions="[1.9.4,1.11.0)", dependencies="required-after:Forge@[12.17.0.1916,)")
public class Survivalist {
    public static final String MODID = "survivalist";
    public static final String VERSION = "1.10.1";
    private static final String CHANNEL = "survivalist";
    @Mod.Instance(value="survivalist")
    public static Survivalist instance;
    @SidedProxy(clientSide="gigaherz.survivalist.client.ClientProxy", serverSide="gigaherz.survivalist.server.ServerProxy")
    public static IModProxy proxy;
    public static Logger logger;
    private GuiHandler guiHandler = new GuiHandler();
    public static EnchantmentScraping scraping;
    public static Item chainmail;
    public static Item tanned_leather;
    public static Item jerky;
    public static ItemNugget nugget;
    public static ItemRock rock;
    public static ItemOreRock rock_ore;
    public static Item dough;
    public static Item round_bread;
    public static Item hatchet;
    public static Item pick;
    public static Item spade;
    public static Item plant_fibres;
    public static Item tanned_helmet;
    public static Item tanned_chestplate;
    public static Item tanned_leggings;
    public static Item tanned_boots;
    public static BlockRegistered rack;
    public static BlockRegistered chopping_block;
    public static ItemArmor.ArmorMaterial TANNED_LEATHER;
    public static Item.ToolMaterial TOOL_FLINT;
    public static SimpleNetworkWrapper channel;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blockArray = new Block[2];
        rack = new BlockRack("rack");
        blockArray[0] = rack;
        chopping_block = new BlockChopping("chopping_block");
        blockArray[1] = chopping_block;
        event.getRegistry().registerAll((IForgeRegistryEntry[])blockArray);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntityWithAlternatives(TileRack.class, (String)rack.getRegistryName().toString(), (String[])new String[]{"tileRack"});
        GameRegistry.registerTileEntityWithAlternatives(TileChopping.class, (String)chopping_block.getRegistryName().toString(), (String[])new String[]{"tile_chopping_block"});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[18];
        itemArray[0] = rack.createItemBlock();
        itemArray[1] = chopping_block.createItemBlock();
        itemArray[2] = chainmail = new ItemRegistered("chainmail"){

            public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
                if (ConfigManager.instance.enableChainmailCrafting) {
                    super.func_150895_a(itemIn, tab, subItems);
                }
            }
        }.func_77637_a(CreativeTabs.field_78035_l);
        itemArray[3] = tanned_leather = new ItemRegistered("tanned_leather"){

            public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
                if (ConfigManager.instance.enableLeatherTanning) {
                    super.func_150895_a(itemIn, tab, subItems);
                }
            }
        }.func_77637_a(CreativeTabs.field_78035_l);
        itemArray[4] = tanned_helmet = new ItemTannedArmor("tanned_helmet", TANNED_LEATHER, 0, EntityEquipmentSlot.HEAD);
        itemArray[5] = tanned_chestplate = new ItemTannedArmor("tanned_chestplate", TANNED_LEATHER, 0, EntityEquipmentSlot.CHEST);
        itemArray[6] = tanned_leggings = new ItemTannedArmor("tanned_leggings", TANNED_LEATHER, 0, EntityEquipmentSlot.LEGS);
        itemArray[7] = tanned_boots = new ItemTannedArmor("tanned_boots", TANNED_LEATHER, 0, EntityEquipmentSlot.FEET);
        itemArray[8] = jerky = new ItemRegisteredFood("jerky", 4, 1.0f, true){

            public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
                if (ConfigManager.instance.enableLeatherTanning) {
                    super.func_150895_a(itemIn, tab, subItems);
                }
            }
        };
        nugget = new ItemNugget("nugget");
        itemArray[9] = nugget;
        rock = new ItemRock("rock");
        itemArray[10] = rock;
        rock_ore = new ItemOreRock("rock_ore");
        itemArray[11] = rock_ore;
        itemArray[12] = dough = new ItemRegisteredFood("dough", 5, 0.6f, true){

            public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
                if (ConfigManager.instance.enableBread) {
                    super.func_150895_a(itemIn, tab, subItems);
                }
            }
        };
        itemArray[13] = round_bread = new ItemRegisteredFood("round_bread", 8, 0.6f, true){

            public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
                if (ConfigManager.instance.enableBread) {
                    super.func_150895_a(itemIn, tab, subItems);
                }
            }
        };
        itemArray[14] = hatchet = new ItemRegisteredAxe("hatchet", TOOL_FLINT, 8.0f, -3.1f){

            public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
                if (ConfigManager.instance.enableHatchet) {
                    super.func_150895_a(itemIn, tab, subItems);
                }
            }
        }.func_77637_a(CreativeTabs.field_78040_i);
        itemArray[15] = pick = new ItemRegisteredPick("pick", TOOL_FLINT){

            public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
                if (ConfigManager.instance.enablePick) {
                    super.func_150895_a(itemIn, tab, subItems);
                }
            }
        }.func_77637_a(CreativeTabs.field_78040_i);
        itemArray[16] = spade = new ItemRegisteredSpade("spade", TOOL_FLINT){

            public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
                if (ConfigManager.instance.enableSpade) {
                    super.func_150895_a(itemIn, tab, subItems);
                }
            }
        }.func_77637_a(CreativeTabs.field_78040_i);
        itemArray[17] = plant_fibres = new ItemRegistered("plant_fibres"){

            public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
                if (ConfigManager.instance.enableFibres) {
                    super.func_150895_a(itemIn, tab, subItems);
                }
            }
        }.func_77637_a(CreativeTabs.field_78035_l);
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
    }

    private static void registerOredictNames() {
        OreDictionary.registerOre((String)"materialLeather", (Item)tanned_leather);
        OreDictionary.registerOre((String)"materialTannedLeather", (Item)tanned_leather);
        OreDictionary.registerOre((String)"materialHardenedLeather", (Item)tanned_leather);
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)nugget.getStack(OreMaterial.IRON));
        OreDictionary.registerOre((String)"nuggetCopper", (ItemStack)nugget.getStack(OreMaterial.COPPER));
        OreDictionary.registerOre((String)"nuggetTin", (ItemStack)nugget.getStack(OreMaterial.TIN));
        OreDictionary.registerOre((String)"nuggetLead", (ItemStack)nugget.getStack(OreMaterial.LEAD));
        OreDictionary.registerOre((String)"nuggetSilver", (ItemStack)nugget.getStack(OreMaterial.SILVER));
        OreDictionary.registerOre((String)"rockOreIron", (ItemStack)rock_ore.getStack(OreMaterial.IRON));
        OreDictionary.registerOre((String)"rockOreGold", (ItemStack)rock_ore.getStack(OreMaterial.GOLD));
        OreDictionary.registerOre((String)"rockOreCopper", (ItemStack)rock_ore.getStack(OreMaterial.COPPER));
        OreDictionary.registerOre((String)"rockOreTin", (ItemStack)rock_ore.getStack(OreMaterial.TIN));
        OreDictionary.registerOre((String)"rockOreLead", (ItemStack)rock_ore.getStack(OreMaterial.LEAD));
        OreDictionary.registerOre((String)"rockOreSilver", (ItemStack)rock_ore.getStack(OreMaterial.SILVER));
        OreDictionary.registerOre((String)"rock", (ItemStack)rock.getStack(RockMaterial.NORMAL));
        OreDictionary.registerOre((String)"rock", (ItemStack)rock.getStack(RockMaterial.ANDESITE));
        OreDictionary.registerOre((String)"rock", (ItemStack)rock.getStack(RockMaterial.DIORITE));
        OreDictionary.registerOre((String)"rock", (ItemStack)rock.getStack(RockMaterial.GRANITE));
        OreDictionary.registerOre((String)"rockAndesite", (ItemStack)rock.getStack(RockMaterial.ANDESITE));
        OreDictionary.registerOre((String)"rockDiorite", (ItemStack)rock.getStack(RockMaterial.DIORITE));
        OreDictionary.registerOre((String)"rockGranite", (ItemStack)rock.getStack(RockMaterial.GRANITE));
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        scraping = EnchantmentScraping.register();
    }

    private void registerNetwork() {
        logger.info("Registering network channel...");
        channel = NetworkRegistry.INSTANCE.newSimpleChannel("survivalist");
        int messageNumber = 0;
        channel.registerMessage(MessageScraping.Handler.class, MessageScraping.class, messageNumber++, Side.CLIENT);
        logger.debug("Final message number: " + messageNumber);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ConfigManager.loadConfig(new Configuration(event.getSuggestedConfigurationFile()));
        if (ConfigManager.instance.enableTorchFire) {
            TorchFireEventHandling.register();
        }
        if (ConfigManager.instance.enableScraping) {
            ItemBreakingTracker.register();
        }
        if (ConfigManager.instance.enableRocks) {
            RocksEventHandling.register();
        }
        if (ConfigManager.instance.dropFibersFromGrass) {
            FibersEventHandling.register();
        }
        if (ConfigManager.instance.dropStringFromSheep) {
            StringEventHandling.register();
        }
        this.registerTileEntities();
        Survivalist.registerOredictNames();
        this.registerNetwork();
        proxy.preInit();
        if (Loader.isModLoaded((String)"MineTweaker3")) {
            try {
                Class.forName("gigaherz.survivalist.integration.MineTweakerPlugin").getMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new ReportedException(new CrashReport("Error initializing minetweaker integration", (Throwable)e));
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        int entityId = 1;
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
        if (ConfigManager.instance.enableBread) {
            if (ConfigManager.instance.removeVanillaBread) {
                List recipes = CraftingManager.func_77594_a().func_77592_b();
                int i = 0;
                while (i < recipes.size()) {
                    ItemStack output;
                    boolean removed = false;
                    IRecipe r = (IRecipe)recipes.get(i);
                    if (r instanceof ShapedOreRecipe && (output = r.func_77571_b()) != null && output.func_77973_b() == Items.field_151025_P) {
                        recipes.remove(r);
                        removed = true;
                    }
                    if (removed) continue;
                    ++i;
                }
            }
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(dough), (Object[])new Object[]{Items.field_151015_O, Items.field_151015_O, Items.field_151015_O, Items.field_151015_O});
            GameRegistry.addSmelting((Item)dough, (ItemStack)new ItemStack(round_bread), (float)0.0f);
        }
        if (ConfigManager.instance.enableDryingRack) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)rack), new Object[]{"sss", " p ", "p p", Character.valueOf('s'), "stickWood", Character.valueOf('p'), "plankWood"}));
            Dryable.registerStockRecipes();
            if (ConfigManager.instance.enableLeatherTanning) {
                if (ConfigManager.instance.enableSaddleCrafting) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151141_av), new Object[]{"ttt", "tst", "i i", Character.valueOf('t'), "materialTannedLeather", Character.valueOf('s'), new ItemStack(Items.field_151007_F), Character.valueOf('i'), "ingotIron"}));
                }
                GameRegistry.addRecipe((ItemStack)new ItemStack(tanned_helmet), (Object[])new Object[]{"ttt", "t t", Character.valueOf('t'), tanned_leather});
                GameRegistry.addRecipe((ItemStack)new ItemStack(tanned_chestplate), (Object[])new Object[]{"t t", "ttt", "ttt", Character.valueOf('t'), tanned_leather});
                GameRegistry.addRecipe((ItemStack)new ItemStack(tanned_leggings), (Object[])new Object[]{"ttt", "t t", "t t", Character.valueOf('t'), tanned_leather});
                GameRegistry.addRecipe((ItemStack)new ItemStack(tanned_boots), (Object[])new Object[]{"t t", "t t", Character.valueOf('t'), tanned_leather});
            }
        }
        if (ConfigManager.instance.sticksFromLeaves) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Items.field_151055_y, new Object[]{"treeLeaves"}));
        }
        if (ConfigManager.instance.sticksFromSaplings) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Items.field_151055_y, new Object[]{"treeSapling"}));
        }
        if (ConfigManager.instance.enableNuggetRecipes) {
            Survivalist.addIngotToNuggets("ingotIron", "nuggetIron");
            Survivalist.addIngotToNuggets("ingotCopper", "nuggetCopper");
            Survivalist.addIngotToNuggets("ingotTin", "nuggetTin");
            Survivalist.addIngotToNuggets("ingotLead", "nuggetLead");
            Survivalist.addIngotToNuggets("ingotSilver", "nuggetSilver");
        }
        if (ConfigManager.instance.enableChainmailCrafting) {
            if (ConfigManager.instance.enableNuggets) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(chainmail), new Object[]{" n ", "n n", " n ", Character.valueOf('n'), "nuggetIron"}));
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(chainmail, 9), new Object[]{" n ", "n n", " n ", Character.valueOf('n'), "ingotIron"}));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151020_U), (Object[])new Object[]{"ccc", "c c", Character.valueOf('c'), chainmail});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151023_V), (Object[])new Object[]{"c c", "ccc", "ccc", Character.valueOf('c'), chainmail});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151022_W), (Object[])new Object[]{"ccc", "c c", "c c", Character.valueOf('c'), chainmail});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151029_X), (Object[])new Object[]{"c c", "c c", Character.valueOf('c'), chainmail});
        }
        if (ConfigManager.instance.enableRocks) {
            EntityRegistry.registerModEntity(EntityRock.class, (String)"ThrownRock", (int)entityId++, (Object)this, (int)80, (int)3, (boolean)true);
            logger.debug("Last used id: %i", new Object[]{entityId});
            Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.IRON), "nuggetIron");
            Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.GOLD), "nuggetGold");
            Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.COPPER), "nuggetCopper");
            Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.TIN), "nuggetTin");
            Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.LEAD), "nuggetLead");
            Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.SILVER), "nuggetSilver");
            if (ConfigManager.instance.cobbleRequiresClay) {
                GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150347_e), (Object[])new Object[]{"rrr", "rcr", "rrr", Character.valueOf('r'), rock.getStack(RockMaterial.NORMAL), Character.valueOf('c'), Items.field_151119_aD});
                GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 5), (Object[])new Object[]{"rrr", "rcr", "rrr", Character.valueOf('r'), rock.getStack(RockMaterial.ANDESITE), Character.valueOf('c'), Items.field_151119_aD});
                GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 3), (Object[])new Object[]{"rrr", "rcr", "rrr", Character.valueOf('r'), rock.getStack(RockMaterial.DIORITE), Character.valueOf('c'), Items.field_151119_aD});
                GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 1), (Object[])new Object[]{"rrr", "rcr", "rrr", Character.valueOf('r'), rock.getStack(RockMaterial.GRANITE), Character.valueOf('c'), Items.field_151119_aD});
            } else {
                GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150347_e), (Object[])new Object[]{"rrr", "rrr", "rrr", Character.valueOf('r'), rock.getStack(RockMaterial.NORMAL)});
                GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 5), (Object[])new Object[]{"rrr", "rrr", "rrr", Character.valueOf('r'), rock.getStack(RockMaterial.ANDESITE)});
                GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 3), (Object[])new Object[]{"rrr", "rrr", "rrr", Character.valueOf('r'), rock.getStack(RockMaterial.DIORITE)});
                GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 1, 1), (Object[])new Object[]{"rrr", "rrr", "rrr", Character.valueOf('r'), rock.getStack(RockMaterial.GRANITE)});
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150351_n), new Object[]{"rr", "rr", Character.valueOf('r'), "rock"}));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)rock, 4, 0), (Object[])new Object[]{Blocks.field_150351_n});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151145_ak), (Object[])new Object[]{Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n, Blocks.field_150351_n});
        }
        if (ConfigManager.instance.enableSpade) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(spade), new Object[]{"stickWood", Items.field_151145_ak}));
        }
        if (ConfigManager.instance.enableHatchet) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(hatchet), new Object[]{"stickWood", "string", Items.field_151145_ak}));
        }
        if (ConfigManager.instance.enablePick) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(pick), new Object[]{"stickWood", "string", Items.field_151145_ak, Items.field_151145_ak}));
        }
        if (ConfigManager.instance.enableStringCrafting) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151007_F), new Object[]{plant_fibres, plant_fibres, plant_fibres, plant_fibres}));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ItemStack output;
        IRecipe r;
        boolean removed;
        int i;
        List recipes;
        ConfigManager.instance.parseChoppingAxes();
        if (ConfigManager.instance.removeSticksFromPlanks) {
            recipes = CraftingManager.func_77594_a().func_77592_b();
            i = 0;
            while (i < recipes.size()) {
                removed = false;
                r = (IRecipe)recipes.get(i);
                if (r instanceof ShapedOreRecipe && (output = r.func_77571_b()) != null && output.func_77973_b() == Items.field_151055_y) {
                    recipes.remove(r);
                    removed = true;
                }
                if (removed) continue;
                ++i;
            }
        }
        if (ConfigManager.instance.enableChopping) {
            if (ConfigManager.instance.importPlanksRecipes || ConfigManager.instance.removePlanksRecipes) {
                recipes = CraftingManager.func_77594_a().func_77592_b();
                i = 0;
                while (i < recipes.size()) {
                    removed = false;
                    r = (IRecipe)recipes.get(i);
                    output = r.func_77571_b();
                    if (output != null && OreDictionaryHelper.hasOreName(output, "plankWood")) {
                        ShapedRecipes rcp;
                        ArrayList inputs = null;
                        if (r instanceof ShapedRecipes) {
                            rcp = (ShapedRecipes)r;
                            inputs = Lists.newArrayList((Object[])rcp.field_77574_d);
                        } else if (r instanceof ShapelessRecipes) {
                            rcp = (ShapelessRecipes)r;
                            inputs = Lists.newArrayList((Iterable)rcp.field_77579_b);
                        } else if (r instanceof ShapedOreRecipe) {
                            rcp = (ShapedOreRecipe)r;
                            inputs = Lists.newArrayList((Object[])rcp.getInput());
                        } else if (r instanceof ShapelessOreRecipe) {
                            rcp = (ShapelessOreRecipe)r;
                            inputs = Lists.newArrayList((Iterable)rcp.getInput());
                        } else {
                            logger.warn("Unknown recipe type with planks output (" + output.func_77973_b().getRegistryName() + "): " + r.getClass().getName());
                        }
                        if (inputs != null) {
                            ItemStack logInput = null;
                            for (Object input : inputs) {
                                if (input instanceof ItemStack) {
                                    ItemStack stack = (ItemStack)input;
                                    if (!OreDictionaryHelper.hasOreName(stack, "logWood") || logInput != null) {
                                        logInput = null;
                                        break;
                                    }
                                    logInput = stack;
                                    continue;
                                }
                                if (!(input instanceof String)) continue;
                                logger.warn("A recipe with planks output uses ore dictionary string as input. This is not supported yet.");
                                logInput = null;
                                break;
                            }
                            if (logInput != null) {
                                if (ConfigManager.instance.removePlanksRecipes) {
                                    removed = recipes.remove(r);
                                }
                                if (ConfigManager.instance.importPlanksRecipes) {
                                    Choppable.registerRecipe(logInput.func_77946_l(), output.func_77946_l());
                                }
                            }
                        }
                    }
                    if (removed) continue;
                    ++i;
                }
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)chopping_block), new Object[]{"logWood"}));
            }
            if (ConfigManager.instance.removeSticksFromPlanks) {
                Choppable.registerStockRecipes();
            }
        }
    }

    private static void addIngotToNuggets(String oreIngot, String oreNugget) {
        List matches2;
        List matches1 = OreDictionary.getOres((String)oreIngot);
        if (matches1.size() > 0) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)matches1.get(0), new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), oreNugget}));
        }
        if ((matches2 = OreDictionary.getOres((String)oreNugget)).size() > 0) {
            ItemStack output = ((ItemStack)matches2.get(0)).func_77946_l();
            output.field_77994_a = 9;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(output, new Object[]{oreIngot}));
        }
    }

    private static void addSmeltingNugget(ItemStack stack, String ore) {
        List matches = OreDictionary.getOres((String)ore);
        if (matches.size() > 0) {
            GameRegistry.addSmelting((ItemStack)stack, (ItemStack)((ItemStack)matches.get(0)), (float)0.1f);
        }
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation("survivalist", path);
    }

    static {
        TANNED_LEATHER = EnumHelper.addArmorMaterial((String)"tanned_leather", (String)"survivalist:tanned_leather", (int)12, (int[])new int[]{2, 4, 3, 1}, (int)15, (SoundEvent)SoundEvents.field_187728_s, (float)1.0f);
        TOOL_FLINT = EnumHelper.addToolMaterial((String)"flint", (int)1, (int)150, (float)5.0f, (float)1.5f, (int)5);
    }
}

