/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import gigaherz.survivalist.Survivalist;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigManager {
    public static ConfigManager instance;
    public final boolean sticksFromLeaves;
    public final boolean sticksFromSaplings;
    public final boolean removeSticksFromPlanks;
    public final boolean enableRocks;
    public final boolean replaceStoneDrops;
    public final boolean replaceIronOreDrops;
    public final boolean replaceGoldOreDrops;
    public final boolean replaceModOreDrops;
    public final boolean cobbleRequiresClay;
    public final boolean enableScraping;
    public final boolean enableToolScraping;
    public final boolean enableArmorScraping;
    public final boolean enableDryingRack;
    public final boolean enableMeatRotting;
    public final boolean enableJerky;
    public final boolean enableRottenDrying;
    public final boolean enableMeatDrying;
    public final boolean enableLeatherTanning;
    public final boolean enableNuggets;
    public final boolean enableNuggetRecipes;
    public final boolean enableChainmailCrafting;
    public final boolean enableTorchFire;
    public final boolean enableBread;
    public final boolean removeVanillaBread;
    public final boolean enableSaddleCrafting;
    public final boolean enableChopping;
    public final boolean importPlanksRecipes;
    public final boolean removePlanksRecipes;
    public final float choppingDegradeChance;
    public final float choppingExhaustion;
    public final boolean enableHatchet;
    public final boolean enablePick;
    public final boolean enableSpade;
    public final boolean enableFibres;
    public final boolean enableStringCrafting;
    public final boolean dropFibersFromGrass;
    public final boolean dropStringFromSheep;
    public final List<Pair<ItemStack, Integer>> customChoppingAxes = Lists.newArrayList();
    private final ConfigCategory customAxes;
    private final Pattern itemRegex = Pattern.compile("^(?<item>[a-zA-Z-0-9_]+:[a-zA-Z-0-9_]+)(?:@(?<meta>[0-9]+))?$");

    public static void loadConfig(Configuration configuration) {
        instance = new ConfigManager(configuration);
    }

    public ConfigManager(Configuration configuration) {
        configuration.addCustomCategoryComment("Sticks", "Settings for stick crafting");
        Property p_sticksFromLeaves = configuration.get("Sticks", "CraftSticksFromLeaves", true);
        Property p_sticksFromSaplings = configuration.get("Sticks", "CraftSticksFromSaplings", true);
        Property p_removeSticksFromPlanks = configuration.get("Sticks", "RemoveSticksFromPlanksRecipes", true);
        configuration.addCustomCategoryComment("Rocks", "Settings for rock and ore rock drops");
        Property p_enableRocks = configuration.get("Rocks", "Enables", true);
        Property p_replaceStoneDrops = configuration.get("Rocks", "ReplaceStoneDrops", true);
        Property p_replaceIronOreDrops = configuration.get("Rocks", "ReplaceIronOreDrops", true);
        Property p_replaceGoldOreDrops = configuration.get("Rocks", "ReplaceGoldOreDrops", true);
        Property p_replaceModOreDrops = configuration.get("Rocks", "ReplaceModOreDrops", true);
        Property p_cobbleRequiresClay = configuration.get("Rocks", "CobbleRequiresClay", true);
        configuration.addCustomCategoryComment("Scraping", "Settings for the Scraping feature and enchant");
        Property p_enableScraping = configuration.get("Scraping", "Enable", true);
        Property p_enableToolScraping = configuration.get("Scraping", "EnableToolScraping", true);
        Property p_enableArmorScraping = configuration.get("Scraping", "EnableArmorScraping", true);
        configuration.addCustomCategoryComment("DryingRack", "Settings for the drying rack block");
        Property p_enableDryingRack = configuration.get("DryingRack", "Enable", true);
        Property p_enableMeatRotting = configuration.get("DryingRack", "EnableMeatRotting", true);
        Property p_enableRottenDrying = configuration.get("DryingRack", "EnableRottenDrying", true);
        Property p_enableJerky = configuration.get("DryingRack", "EnableJerky", true);
        Property p_enableMeatDrying = configuration.get("DryingRack", "EnableMeatDrying", true);
        Property p_enableLeatherTanning = configuration.get("DryingRack", "EnableLeatherTanning", true);
        Property p_enableSaddleCrafting = configuration.get("DryingRack", "EnableSaddleCrafting", true);
        configuration.addCustomCategoryComment("Nuggets", "Settings for enabling custom nuggets");
        Property p_enableNuggets = configuration.get("Nuggets", "Enable", true);
        Property p_enableNuggetRecipes = configuration.get("Nuggets", "EnableNuggetRecipes", true);
        p_enableNuggetRecipes.setComment("Independent of Nuggets being enabled, allows adding recipes also when different mods don't play together.");
        configuration.addCustomCategoryComment("Chainmail", "Settings for the chainmail crafting");
        Property p_enableChainmailCrafting = configuration.get("Chainmail", "EnableChainmailCrafting", true);
        configuration.addCustomCategoryComment("TorchFire", "Settings for the torch setting fire to entities");
        Property p_enableTorchFire = configuration.get("TorchFire", "Enable", true);
        configuration.addCustomCategoryComment("Bread", "Settings for the dough/bread replacements");
        Property p_enableBread = configuration.get("Bread", "Enable", true);
        Property p_removeVanillaBread = configuration.get("Bread", "RemoveVanillaBread", true);
        configuration.addCustomCategoryComment("Chopping", "Settings for the chopping block");
        Property p_enableChopping = configuration.get("Chopping", "Enable", true);
        Property p_importPlanksRecipes = configuration.get("Chopping", "ImportPlanksRecipes", true);
        Property p_removePlanksRecipes = configuration.get("Chopping", "RemovePlanksRecipes", true);
        Property p_choppingDegradeChance = configuration.get("Chopping", "DegradeChance", 0.06);
        Property p_choppingExhaustion = configuration.get("Chopping", "DegradeChance", 0.0025);
        Property p_enableStringCrafting = configuration.get("Chopping", "EnableStringCraftingFromWool", true);
        p_choppingDegradeChance.setComment("The average number of uses before degrading to the next phase will be 1/DegradeChance. Default is 16.67 average uses.");
        configuration.addCustomCategoryComment("Tools", "Settings for the tools");
        Property p_enableHatchet = configuration.get("Tools", "EnableHatchet", true);
        Property p_enablePick = configuration.get("Tools", "EnablePick", true);
        Property p_enableSpade = configuration.get("Tools", "EnableSpade", true);
        configuration.addCustomCategoryComment("Fibres", "Settings for the fibre collection");
        Property p_enableFibres = configuration.get("Fibres", "EnableFibres", true);
        Property p_dropfibersFromGrass = configuration.get("Fibres", "DropFibresFromGrass", true);
        Property p_dropStringsFromSheep = configuration.get("Fibres", "DropFibresFromGrass", true);
        boolean hasList = configuration.hasCategory("CustomAxes");
        configuration.addCustomCategoryComment("CustomAxes", "Custom Chopping Block axe values for when mods have axes that don't declare themselves to be axes.");
        this.customAxes = configuration.getCategory("CustomAxes");
        configuration.load();
        this.sticksFromLeaves = p_sticksFromLeaves.getBoolean();
        this.sticksFromSaplings = p_sticksFromSaplings.getBoolean();
        this.removeSticksFromPlanks = p_removeSticksFromPlanks.getBoolean();
        this.enableRocks = p_enableRocks.getBoolean();
        this.replaceStoneDrops = p_replaceStoneDrops.getBoolean();
        this.replaceIronOreDrops = p_replaceIronOreDrops.getBoolean();
        this.replaceGoldOreDrops = p_replaceGoldOreDrops.getBoolean();
        this.replaceModOreDrops = p_replaceModOreDrops.getBoolean();
        this.cobbleRequiresClay = p_cobbleRequiresClay.getBoolean();
        this.enableScraping = p_enableScraping.getBoolean();
        this.enableToolScraping = p_enableToolScraping.getBoolean();
        this.enableArmorScraping = p_enableArmorScraping.getBoolean();
        this.enableDryingRack = p_enableDryingRack.getBoolean();
        this.enableJerky = p_enableJerky.getBoolean();
        this.enableMeatRotting = p_enableMeatRotting.getBoolean();
        this.enableRottenDrying = p_enableRottenDrying.getBoolean();
        this.enableMeatDrying = p_enableMeatDrying.getBoolean();
        this.enableLeatherTanning = p_enableLeatherTanning.getBoolean();
        this.enableSaddleCrafting = p_enableSaddleCrafting.getBoolean();
        this.enableNuggets = p_enableNuggets.getBoolean();
        this.enableNuggetRecipes = p_enableNuggetRecipes.getBoolean();
        this.enableChainmailCrafting = p_enableChainmailCrafting.getBoolean();
        this.enableTorchFire = p_enableTorchFire.getBoolean();
        this.enableBread = p_enableBread.getBoolean();
        this.removeVanillaBread = p_removeVanillaBread.getBoolean();
        this.enableChopping = p_enableChopping.getBoolean();
        this.importPlanksRecipes = p_importPlanksRecipes.getBoolean();
        this.removePlanksRecipes = p_removePlanksRecipes.getBoolean();
        this.choppingDegradeChance = (float)p_choppingDegradeChance.getDouble();
        this.choppingExhaustion = (float)p_choppingExhaustion.getDouble();
        this.enableHatchet = p_enableHatchet.getBoolean();
        this.enablePick = p_enablePick.getBoolean();
        this.enableSpade = p_enableSpade.getBoolean();
        this.enableFibres = p_enableFibres.getBoolean();
        this.enableStringCrafting = p_enableStringCrafting.getBoolean();
        this.dropFibersFromGrass = p_dropfibersFromGrass.getBoolean();
        this.dropStringFromSheep = p_dropStringsFromSheep.getBoolean();
        boolean anyDefault = !p_enableDryingRack.wasRead();
        anyDefault = anyDefault || !p_sticksFromSaplings.wasRead();
        anyDefault = anyDefault || !p_removeSticksFromPlanks.wasRead();
        anyDefault = anyDefault || !p_enableRocks.wasRead();
        anyDefault = anyDefault || !p_replaceStoneDrops.wasRead();
        anyDefault = anyDefault || !p_replaceIronOreDrops.wasRead();
        anyDefault = anyDefault || !p_replaceGoldOreDrops.wasRead();
        anyDefault = anyDefault || !p_replaceModOreDrops.wasRead();
        anyDefault = anyDefault || !p_cobbleRequiresClay.wasRead();
        anyDefault = anyDefault || !p_enableScraping.wasRead();
        anyDefault = anyDefault || !p_enableToolScraping.wasRead();
        anyDefault = anyDefault || !p_enableArmorScraping.wasRead();
        anyDefault = anyDefault || !p_enableDryingRack.wasRead();
        anyDefault = anyDefault || !p_enableMeatRotting.wasRead();
        anyDefault = anyDefault || !p_enableJerky.wasRead();
        anyDefault = anyDefault || !p_enableRottenDrying.wasRead();
        anyDefault = anyDefault || !p_enableMeatDrying.wasRead();
        anyDefault = anyDefault || !p_enableLeatherTanning.wasRead();
        anyDefault = anyDefault || !p_enableSaddleCrafting.wasRead();
        anyDefault = anyDefault || !p_enableNuggets.wasRead();
        anyDefault = anyDefault || !p_enableNuggetRecipes.wasRead();
        anyDefault = anyDefault || !p_enableChainmailCrafting.wasRead();
        anyDefault = anyDefault || !p_enableTorchFire.wasRead();
        anyDefault = anyDefault || !p_enableBread.wasRead();
        anyDefault = anyDefault || !p_removeVanillaBread.wasRead();
        anyDefault = anyDefault || !p_enableChopping.wasRead();
        anyDefault = anyDefault || !p_importPlanksRecipes.wasRead();
        anyDefault = anyDefault || !p_removePlanksRecipes.wasRead();
        anyDefault = anyDefault || !p_choppingDegradeChance.wasRead();
        anyDefault = anyDefault || !p_choppingExhaustion.wasRead();
        anyDefault = anyDefault || !p_enableHatchet.wasRead();
        anyDefault = anyDefault || !p_enablePick.wasRead();
        anyDefault = anyDefault || !p_enableSpade.wasRead();
        anyDefault = anyDefault || !p_enableStringCrafting.wasRead();
        anyDefault = anyDefault || !p_dropfibersFromGrass.wasRead();
        anyDefault = anyDefault || !p_enableFibres.wasRead();
        anyDefault = anyDefault || !p_dropStringsFromSheep.wasRead();
        boolean bl = anyDefault = anyDefault || !hasList;
        if (anyDefault) {
            configuration.save();
        }
    }

    public void parseChoppingAxes() {
        for (Map.Entry entry : this.customAxes.entrySet()) {
            String key = (String)entry.getKey();
            int level = ((Property)entry.getValue()).getInt(-1);
            if (level < 0) continue;
            Matcher matcher = this.itemRegex.matcher(key);
            if (!matcher.matches()) {
                Survivalist.logger.warn("Could not parse chopping item " + key);
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(matcher.group("item")));
            if (item == null) {
                Survivalist.logger.warn("Could not parse chopping item " + key);
                continue;
            }
            String metaString = matcher.group("meta");
            int meta = Strings.isNullOrEmpty((String)metaString) ? 0 : Integer.parseInt(metaString);
            ItemStack stack = new ItemStack(item, 1, meta);
            this.customChoppingAxes.add((Pair<ItemStack, Integer>)Pair.of((Object)stack, (Object)level));
        }
    }

    public int getAxeLevel(ItemStack stack) {
        for (Pair<ItemStack, Integer> customAxe : this.customChoppingAxes) {
            if (!ItemStack.func_185132_d((ItemStack)((ItemStack)customAxe.getLeft()), (ItemStack)stack)) continue;
            return (Integer)customAxe.getRight();
        }
        return -1;
    }
}

