/*
 * Decompiled with CFR 0.152.
 */
package drones.entities;

import com.google.common.base.Optional;
import com.mojang.authlib.GameProfile;
import drones.Drones;
import drones.configs.ConfigHandler;
import drones.entities.EntityDroneLaserBeam;
import drones.entities.ai.EntityAIDroneOwnerHurtByTarget;
import drones.entities.ai.EntityAIDroneOwnerHurtTarget;
import drones.entities.ai.EntityDroneFollowOwner;
import drones.entities.ai.FlyingMoveHelper;
import drones.entities.ai.PathNavigateFlying;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPlayerDrone
extends EntityCreature {
    public int animationTicks;
    public int prevAnimationTicks;
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityPlayerDrone.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityPlayerDrone.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityPlayerDrone(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.4f);
        this.field_70765_h = new FlyingMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AILaserAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityMob.class, 4.0f, 0.75, 0.75));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityDroneFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDroneOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDroneOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.getOwnerId() == null) {
            nbt.func_74778_a("OwnerUUID", "");
        } else {
            nbt.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        String s;
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("OwnerUUID", 8)) {
            s = nbt.func_74779_i("OwnerUUID");
        } else {
            String s1 = nbt.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uuid));
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.75);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ConfigHandler.PLAYER_DRONE_HEALTH);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a((double)ConfigHandler.PLAYER_DRONE_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected float func_70647_i() {
        return 2.0f;
    }

    protected SoundEvent func_184639_G() {
        return Drones.DRONE_SOUND;
    }

    protected SoundEvent func_184601_bQ() {
        return Drones.DRONE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return Drones.BROKEN;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(Drones.DRONE_SOUND, 0.25f, 2.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (ConfigHandler.DRONE_DROPS) {
            if (this.field_70170_p.field_73012_v.nextInt(50) == 0) {
                ItemStack stack = new ItemStack(Items.field_151105_aU).func_151001_c("Definitely Not Darkosto's Birthday Cake");
                this.func_70099_a(stack, 1.0f);
            }
            if (this.field_70170_p.field_73012_v.nextInt(5) == 0) {
                this.func_70099_a(new ItemStack(Items.field_151042_j), 1.0f);
            }
            if (this.field_70170_p.field_73012_v.nextInt(5) == 0) {
                this.func_70099_a(new ItemStack(Items.field_151137_ax), 1.0f);
            }
        }
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.prevAnimationTicks = this.animationTicks;
            if (this.animationTicks < 360) {
                this.animationTicks += 60;
            }
            if (this.animationTicks >= 360) {
                this.animationTicks -= 360;
                this.prevAnimationTicks -= 360;
            }
        }
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.3;
        }
        super.func_70071_h_();
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateFlying((EntityLiving)this, worldIn);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean shouldAttackEntity(EntityLivingBase entityTarget, EntityLivingBase entityTarget2) {
        if (!(entityTarget instanceof EntityCreeper) && !(entityTarget instanceof EntityGhast)) {
            EntityPlayerDrone drone;
            if (entityTarget instanceof EntityPlayerDrone && (drone = (EntityPlayerDrone)entityTarget).getOwner() == entityTarget2) {
                return false;
            }
            return entityTarget instanceof EntityPlayer && entityTarget2 instanceof EntityPlayer && !((EntityPlayer)entityTarget2).func_96122_a((EntityPlayer)entityTarget) ? false : !(entityTarget instanceof EntityHorse) || !((EntityHorse)entityTarget).func_110248_bS();
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return flag;
    }

    public ItemStack getOwnerHead() {
        return EntityPlayerDrone.createHeadFor(((EntityPlayer)this.getOwner()).func_146103_bH());
    }

    public static ItemStack createHeadFor(GameProfile profile) {
        ItemStack stack = new ItemStack(Items.field_151144_bL, 1, 3);
        stack.func_77982_d(new NBTTagCompound());
        NBTTagCompound profileData = new NBTTagCompound();
        NBTUtil.func_180708_a((NBTTagCompound)profileData, (GameProfile)profile);
        stack.func_77978_p().func_74782_a("SkullOwner", (NBTBase)profileData);
        return stack;
    }

    static class AILaserAttack
    extends EntityAIBase {
        private final EntityPlayerDrone parentEntity;
        public int attackTimer;

        public AILaserAttack(EntityPlayerDrone drone) {
            this.parentEntity = drone;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            if (!this.parentEntity.field_70170_p.field_72995_K) {
                double d0 = 64.0;
                World world = this.parentEntity.field_70170_p;
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 576.0 && entitylivingbase.func_70068_e((Entity)this.parentEntity) > 64.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                    double targetZ;
                    double targetY;
                    double targetX;
                    ++this.attackTimer;
                    if (this.attackTimer == 20) {
                        EntityDroneLaserBeam missile1 = new EntityDroneLaserBeam(world, this.parentEntity, ConfigHandler.LASER_DAMAGE);
                        targetX = entitylivingbase.field_70165_t + entitylivingbase.field_70159_w - this.parentEntity.field_70165_t;
                        targetY = entitylivingbase.field_70163_u - this.parentEntity.field_70163_u + 1.0;
                        targetZ = entitylivingbase.field_70161_v + entitylivingbase.field_70179_y - this.parentEntity.field_70161_v;
                        missile1.func_70186_c(targetX, targetY, targetZ, 1.0f, 0.0f);
                        double directionLeft = Math.toRadians(this.parentEntity.field_70761_aq - 30.0f);
                        missile1.func_70107_b(this.parentEntity.field_70165_t + -Math.sin(directionLeft) * 0.5, this.parentEntity.field_70163_u + 0.25, this.parentEntity.field_70161_v + Math.cos(directionLeft) * 0.5);
                        world.func_72838_d((Entity)missile1);
                        world.func_184148_a((EntityPlayer)null, this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v, Drones.LASER_SOUND, SoundCategory.HOSTILE, 2.0f, 1.0f);
                    }
                    if (this.attackTimer == 30) {
                        EntityDroneLaserBeam missile2 = new EntityDroneLaserBeam(world, this.parentEntity, ConfigHandler.LASER_DAMAGE);
                        targetX = entitylivingbase.field_70165_t + entitylivingbase.field_70159_w - this.parentEntity.field_70165_t;
                        targetY = entitylivingbase.field_70163_u - this.parentEntity.field_70163_u + 1.0;
                        targetZ = entitylivingbase.field_70161_v + entitylivingbase.field_70179_y - this.parentEntity.field_70161_v;
                        missile2.func_70186_c(targetX, targetY, targetZ, 1.0f, 0.0f);
                        double directionRight = Math.toRadians(this.parentEntity.field_70761_aq + 30.0f);
                        missile2.func_70107_b(this.parentEntity.field_70165_t + -Math.sin(directionRight) * 0.5, this.parentEntity.field_70163_u + 0.25, this.parentEntity.field_70161_v + Math.cos(directionRight) * 0.5);
                        world.func_72838_d((Entity)missile2);
                        world.func_184148_a((EntityPlayer)null, this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v, Drones.LASER_SOUND, SoundCategory.HOSTILE, 2.0f, 1.0f);
                        this.attackTimer = -40;
                    }
                } else if (this.attackTimer > 0) {
                    --this.attackTimer;
                }
                this.parentEntity.setAttacking(this.attackTimer > 10);
            }
        }
    }
}

