/*
 * Decompiled with CFR 0.152.
 */
package drones.entities;

import drones.Drones;
import drones.configs.ConfigHandler;
import drones.entities.EntitySawBlade;
import drones.entities.ai.FlyingMoveHelper;
import drones.entities.ai.PathNavigateFlying;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityDrone
extends EntityMob
implements IEntityAdditionalSpawnData {
    public int animationTicks;
    public int prevAnimationTicks;
    private static final DataParameter<Boolean> HAS_SAW = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityDrone(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.4f);
        this.field_70765_h = new FlyingMoveHelper((EntityCreature)this);
        if (world != null && !world.field_72995_K && world.func_72820_D() > (long)(ConfigHandler.SAW_DRONE_SPAWN_DELAY * 24000)) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AISawAttack(this));
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        if (ConfigHandler.DRONE_ATTACK_MOBS) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true, false, null));
        }
        if (ConfigHandler.DRONE_ATTACK_CREATURES) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, null));
        }
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_SAW, (Object)true);
    }

    public void setSaw(boolean saw) {
        this.field_70180_af.func_187227_b(HAS_SAW, (Object)saw);
    }

    public boolean getSaw() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_SAW);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("hasSaw", this.getSaw());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(HAS_SAW, (Object)nbt.func_74767_n("hasSaw"));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.75);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ConfigHandler.DRONE_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)ConfigHandler.DRONE_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70601_bi() {
        float light;
        long spawnDelay;
        long worldTime = this.field_70170_p.func_72820_D();
        if (worldTime > (spawnDelay = (long)(ConfigHandler.DRONE_SPAWN_DELAY * 24000)) && (light = this.func_70013_c(1.0f)) >= 0.0f) {
            return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
        }
        return false;
    }

    public int func_70641_bl() {
        int amountDay = ConfigHandler.DRONE_MAX_IN_CHUNK_DAY;
        int amountNight = ConfigHandler.DRONE_MAX_IN_CHUNK_NIGHT;
        if (this.field_70170_p.func_72935_r()) {
            return amountDay;
        }
        return amountNight;
    }

    protected boolean func_70814_o() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        return this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, blockpos) < 8;
    }

    protected float func_70647_i() {
        return 2.0f;
    }

    protected SoundEvent func_184639_G() {
        return Drones.DRONE_SOUND;
    }

    protected SoundEvent func_184601_bQ() {
        return Drones.DRONE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return Drones.BROKEN;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(Drones.DRONE_SOUND, 1.0f, 2.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (ConfigHandler.DRONE_DROPS) {
            if (this.field_70170_p.field_73012_v.nextInt(50) == 0) {
                ItemStack stack = new ItemStack(Items.field_151105_aU).func_151001_c("Darkosto's Birthday Cake");
                this.func_70099_a(stack, 1.0f);
            }
            if (this.field_70170_p.field_73012_v.nextInt(5) == 0) {
                this.func_70099_a(new ItemStack(Items.field_151042_j), 1.0f);
            }
            if (this.field_70170_p.field_73012_v.nextInt(5) == 0) {
                this.func_70099_a(new ItemStack(Items.field_151137_ax), 1.0f);
            }
            if (this.field_70170_p.field_73012_v.nextInt(25) == 0 && Loader.isModLoaded((String)"libVulpes")) {
                this.func_70099_a(new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("libvulpes:productingot")), 1, 7), 1.0f);
            }
        }
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            this.prevAnimationTicks = this.animationTicks;
            if (this.animationTicks < 360) {
                this.animationTicks += 60;
            }
            if (this.animationTicks >= 360) {
                this.animationTicks -= 360;
                this.prevAnimationTicks -= 360;
            }
        }
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.3;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72820_D() < (long)(ConfigHandler.DRONE_SPAWN_DELAY * 24000)) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateFlying((EntityLiving)this, worldIn);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70686_a(Class entity) {
        return EntityDrone.class != entity;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            int duration;
            if (super.func_70652_k(entity) && entity instanceof EntityLivingBase && (duration = ConfigHandler.SLOWNESS_EFFECT_DURATION) > 0) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration * 20, 0));
            }
            return true;
        }
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.getSaw());
    }

    public void readSpawnData(ByteBuf buffer) {
        this.setSaw(buffer.readBoolean());
    }

    static class AISawAttack
    extends EntityAIBase {
        private final EntityDrone parentEntity;
        public int attackTimer;

        public AISawAttack(EntityDrone drone) {
            this.parentEntity = drone;
        }

        public boolean func_75250_a() {
            return this.parentEntity.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.parentEntity.func_70638_az() != null && this.parentEntity.getSaw();
        }

        public void func_75249_e() {
            this.parentEntity.getSaw();
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            if (!this.parentEntity.field_70170_p.field_72995_K && entitylivingbase.func_70068_e((Entity)this.parentEntity) < 576.0 && entitylivingbase.func_70068_e((Entity)this.parentEntity) > 36.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                EntitySawBlade saw = new EntitySawBlade(world, (EntityLivingBase)this.parentEntity);
                double targetX = entitylivingbase.field_70165_t + entitylivingbase.field_70159_w - this.parentEntity.field_70165_t;
                double targetY = entitylivingbase.field_70163_u - this.parentEntity.field_70163_u + 1.0;
                double targetZ = entitylivingbase.field_70161_v + entitylivingbase.field_70179_y - this.parentEntity.field_70161_v;
                saw.func_70186_c(targetX, targetY, targetZ, 0.5f, 0.0f);
                double direction = Math.toRadians(this.parentEntity.field_70761_aq);
                saw.func_70107_b(this.parentEntity.field_70165_t + -Math.sin(direction) * 0.8, this.parentEntity.field_70163_u + 0.4, this.parentEntity.field_70161_v + Math.cos(direction) * 0.8);
                world.func_72838_d((Entity)saw);
                this.parentEntity.setSaw(false);
            }
        }
    }
}

