/*
 * Decompiled with CFR 0.152.
 */
package drones.configs;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration CONFIG;
    public static int DRONE_MIN_SPAWN_SIZE;
    public static int DRONE_MAX_SPAWN_SIZE;
    public static int DRONE_SPAWN_PROBABILITY;
    public static int DRONE_MAX_IN_CHUNK_DAY;
    public static int DRONE_MAX_IN_CHUNK_NIGHT;
    public static int DRONE_SPAWN_DELAY;
    public static int SAW_DRONE_SPAWN_DELAY;
    public static float DRONE_HEALTH;
    public static float DRONE_ATTACK_DAMAGE;
    public static float PLAYER_DRONE_HEALTH;
    public static float PLAYER_DRONE_ATTACK_DAMAGE;
    public static int SLOWNESS_EFFECT_DURATION;
    public static boolean DRONE_DROPS;
    public static boolean DRONE_ATTACK_MOBS;
    public static boolean DRONE_ATTACK_CREATURES;
    public static boolean SAW_BLOCK_BREAK;
    public static int SAW_BLOCK_BREAK_DELAY;
    public static boolean SAW_EXPLODE;
    public static int SAW_EXPLODE_DELAY;
    public static float LASER_DAMAGE;
    public static boolean LASER_FIRE_DAMAGE;
    public static int LASER_BURN_TIME;
    public final String[] usedCategories = new String[]{"Drone Spawn Settings", "Drone Attack Settings", "Player Drone Settings"};

    public void loadConfig(FMLPreInitializationEvent event) {
        this.CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        this.CONFIG.load();
        this.syncConfigs();
    }

    private void syncConfigs() {
        DRONE_MIN_SPAWN_SIZE = this.CONFIG.get("Drone Spawn Settings", "Default Spawn Group Minimum Size", 1).getInt(1);
        DRONE_MAX_SPAWN_SIZE = this.CONFIG.get("Drone Spawn Settings", "Default Spawn Group Maximum Size", 3).getInt(3);
        DRONE_SPAWN_PROBABILITY = this.CONFIG.get("Drone Spawn Settings", "Default Spawn Chance Weight", 10).getInt(10);
        DRONE_MAX_IN_CHUNK_DAY = this.CONFIG.get("Drone Spawn Settings", "Max Spawned in Chunk Daytime (Light Level >= 5)", 1).getInt(1);
        DRONE_MAX_IN_CHUNK_NIGHT = this.CONFIG.get("Drone Spawn Settings", "Max Spawned in Chunk Nighttime (Light Level < 5)", 3).getInt(3);
        DRONE_SPAWN_DELAY = this.CONFIG.get("Drone Spawn Settings", "Delay Time in Days Before Drones Spawn", 1).getInt(1);
        SAW_DRONE_SPAWN_DELAY = this.CONFIG.get("Drone Spawn Settings", "Delay Time in Days Before Drones Can Shoot Saw Blades", 1).getInt(1);
        DRONE_DROPS = this.CONFIG.get("Drone Spawn Settings", "Drone Drops On", true).getBoolean(true);
        DRONE_HEALTH = this.CONFIG.getFloat("Drones Health", "Drone Attack Settings", 15.0f, 1.0f, Float.MAX_VALUE, "");
        DRONE_ATTACK_DAMAGE = this.CONFIG.getFloat("Drones Attack Damage", "Drone Attack Settings", 4.0f, 1.0f, Float.MAX_VALUE, "");
        SLOWNESS_EFFECT_DURATION = this.CONFIG.get("Drone Attack Settings", "Slowness Effect Duration (Seconds)", 5).getInt(5);
        DRONE_ATTACK_MOBS = this.CONFIG.get("Drone Attack Settings", "Drones Attack Monsters", false).getBoolean(false);
        DRONE_ATTACK_CREATURES = this.CONFIG.get("Drone Attack Settings", "Drones Attack Everything (Except Drones)", false).getBoolean(false);
        SAW_BLOCK_BREAK = this.CONFIG.get("Drone Attack Settings", "Saw Blades Break Blocks", false).getBoolean(false);
        SAW_BLOCK_BREAK_DELAY = this.CONFIG.get("Drone Attack Settings", "Delay Time in Days Before Saw Blades Break Blocks", 1).getInt(1);
        SAW_EXPLODE = this.CONFIG.get("Drone Attack Settings", "Saw Blades Explode on Breaking", false).getBoolean(false);
        SAW_EXPLODE_DELAY = this.CONFIG.get("Drone Attack Settings", "Delay Time in Days Before Saw Blades Start to Explode", 1).getInt(1);
        PLAYER_DRONE_HEALTH = this.CONFIG.getFloat("Player Drones Health", "Player Drone Settings", 15.0f, 1.0f, Float.MAX_VALUE, "");
        PLAYER_DRONE_ATTACK_DAMAGE = this.CONFIG.getFloat("Player Drones Attack Damage", "Player Drone Settings", 4.0f, 1.0f, Float.MAX_VALUE, "");
        LASER_DAMAGE = this.CONFIG.get("Player Drone Settings", "Damage caused by Player Drone Laser", 4).getInt(4);
        LASER_FIRE_DAMAGE = this.CONFIG.get("Player Drone Settings", "Enable Player Drone Laser Fire Damage", true).getBoolean(true);
        LASER_BURN_TIME = this.CONFIG.get("Player Drone Settings", "Player Drone Laser Fire Burn Time in Seconds", 10).getInt(10);
        if (this.CONFIG.hasChanged()) {
            this.CONFIG.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("drones")) {
            this.syncConfigs();
        }
    }
}

