/*
 * Decompiled with CFR 0.152.
 */
package drones;

import drones.ModRecipes;
import drones.configs.ConfigHandler;
import drones.entities.EntityDrone;
import drones.entities.EntityDroneLaserBeam;
import drones.entities.EntityPlayerDrone;
import drones.entities.EntitySawBlade;
import drones.items.ItemDroneConstructor;
import drones.items.ItemDroneDisruptor;
import drones.network.DisruptorMessage;
import drones.network.DisruptorPacketHandler;
import drones.proxy.CommonProxy;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="drones", name="drones", version="0.1.17", guiFactory="drones.configs.ConfigGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class Drones {
    @Mod.Instance(value="drones")
    public static Drones INSTANCE;
    @SidedProxy(clientSide="drones.proxy.ClientProxy", serverSide="drones.proxy.CommonProxy")
    public static CommonProxy PROXY;
    public static Item DRONE_DISRUPTOR;
    public static Item DRONE_CONSTRUCTOR;
    public static SoundEvent DRONE_SOUND;
    public static SoundEvent DRONE_HURT;
    public static SoundEvent BROKEN;
    public static SoundEvent SAW_BLADE;
    public static SoundEvent DISRUPTOR_SOUND;
    public static SoundEvent LASER_SOUND;
    public static SimpleNetworkWrapper NETWORK_WRAPPER;
    static int startEntityId;
    public static CreativeTabs TAB;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.INSTANCE.loadConfig(event);
        EntityRegistry.registerModEntity(EntityDrone.class, (String)"Drone", (int)1, (Object)this, (int)120, (int)1, (boolean)true);
        Drones.registerEntityEgg(EntityDrone.class, -256, -48326583);
        EntityRegistry.registerModEntity(EntitySawBlade.class, (String)"SawBlade", (int)2, (Object)this, (int)120, (int)1, (boolean)true);
        for (Biome allBiomes : ForgeRegistries.BIOMES.getValues()) {
            if (BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.END)) continue;
            EntityRegistry.addSpawn(EntityDrone.class, (int)ConfigHandler.DRONE_SPAWN_PROBABILITY, (int)ConfigHandler.DRONE_MIN_SPAWN_SIZE, (int)ConfigHandler.DRONE_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
        }
        EntityRegistry.registerModEntity(EntityPlayerDrone.class, (String)"PlayerDrone", (int)3, (Object)this, (int)120, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityDroneLaserBeam.class, (String)"Laser", (int)4, (Object)this, (int)120, (int)1, (boolean)true);
        DRONE_DISRUPTOR = new ItemDroneDisruptor();
        GameRegistry.register((IForgeRegistryEntry)((Item)DRONE_DISRUPTOR.setRegistryName("drones", "drone_disruptor")).func_77655_b("drones.drone_disruptor"));
        DRONE_CONSTRUCTOR = new ItemDroneConstructor();
        GameRegistry.register((IForgeRegistryEntry)((Item)DRONE_CONSTRUCTOR.setRegistryName("drones", "drone_constructor")).func_77655_b("drones.drone_constructor"));
        NETWORK_WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("drones");
        NETWORK_WRAPPER.registerMessage(DisruptorPacketHandler.class, DisruptorMessage.class, 0, Side.CLIENT);
        ModRecipes.addRecipes();
        PROXY.registerRenderers();
    }

    public static int getUniqueEntityId() {
        while (EntityList.func_90035_a((int)(++startEntityId)) != null) {
        }
        return startEntityId;
    }

    public static void registerEntityEgg(Class<? extends Entity> entity, int baseColor, int spotColor) {
        int id = Drones.getUniqueEntityId();
        EntityList.func_75618_a(entity, (String)"Drone", (int)id);
        EntityList.field_75627_a.put("Drone", new EntityList.EntityEggInfo("Drone", baseColor, spotColor));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        DRONE_SOUND = (SoundEvent)new SoundEvent(new ResourceLocation("drones", "drone_sound")).setRegistryName("drones", "drone_sound");
        GameRegistry.register((IForgeRegistryEntry)DRONE_SOUND);
        DRONE_HURT = (SoundEvent)new SoundEvent(new ResourceLocation("drones", "drone_hurt")).setRegistryName("drones", "drone_hurt");
        GameRegistry.register((IForgeRegistryEntry)DRONE_HURT);
        BROKEN = (SoundEvent)new SoundEvent(new ResourceLocation("drones", "broken")).setRegistryName("drones", "broken");
        GameRegistry.register((IForgeRegistryEntry)BROKEN);
        SAW_BLADE = (SoundEvent)new SoundEvent(new ResourceLocation("drones", "saw_blade")).setRegistryName("drones", "saw_blade");
        GameRegistry.register((IForgeRegistryEntry)SAW_BLADE);
        DISRUPTOR_SOUND = (SoundEvent)new SoundEvent(new ResourceLocation("drones", "disruptor")).setRegistryName("drones", "disruptor");
        GameRegistry.register((IForgeRegistryEntry)DISRUPTOR_SOUND);
        LASER_SOUND = (SoundEvent)new SoundEvent(new ResourceLocation("drones", "laser")).setRegistryName("drones", "laser");
        GameRegistry.register((IForgeRegistryEntry)LASER_SOUND);
        MinecraftForge.EVENT_BUS.register((Object)ConfigHandler.INSTANCE);
    }

    static {
        startEntityId = 1;
        TAB = new CreativeTabs("drones"){

            public Item func_78016_d() {
                return DRONE_DISRUPTOR;
            }
        };
    }
}

