/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mcmultipart.microblock;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import reborncore.mcmultipart.microblock.BlockMicroMaterial;
import reborncore.mcmultipart.microblock.IMicroMaterial;
import reborncore.mcmultipart.microblock.IMicroblock;
import reborncore.mcmultipart.microblock.MicroblockClass;
import reborncore.mcmultipart.microblock.MicroblockDelegate;
import reborncore.mcmultipart.multipart.MultipartRegistry;
import reborncore.mcmultipart.raytrace.PartMOP;

public class MicroblockRegistry {
    private static final Map<String, IMicroMaterial> materials = new LinkedHashMap<String, IMicroMaterial>();
    private static final Set<MicroblockClass> microClasses = new HashSet<MicroblockClass>();

    public static void registerMicroClass(MicroblockClass microClass) {
        microClasses.add(microClass);
        MultipartRegistry.registerPartFactory(microClass, microClass.getType());
    }

    public static <T extends IMicroMaterial> T registerMaterial(T material) {
        if (material == null) {
            throw new NullPointerException("Attempting to register a null micro material!");
        }
        String name = material.getName();
        if (materials.containsKey(name)) {
            throw new IllegalArgumentException("Attempting to register a micro material with a name that's already in use!");
        }
        materials.put(name, material);
        return material;
    }

    public static BlockMicroMaterial registerMaterial(IBlockState blockState, float hardness) {
        return MicroblockRegistry.registerMaterial(new BlockMicroMaterial(blockState, hardness));
    }

    public static BlockMicroMaterial registerMaterial(IBlockState blockState) {
        return MicroblockRegistry.registerMaterial(new BlockMicroMaterial(blockState));
    }

    public static BlockMicroMaterial registerMaterial(Block block, int meta) {
        return MicroblockRegistry.registerMaterial(block.func_176203_a(meta));
    }

    public static BlockMicroMaterial[] registerMaterial(Block block, int fromMeta, int toMeta) {
        BlockMicroMaterial[] materials = new BlockMicroMaterial[toMeta - fromMeta + 1];
        for (int i = fromMeta; i <= toMeta; ++i) {
            materials[i - fromMeta] = MicroblockRegistry.registerMaterial(block, i);
        }
        return materials;
    }

    public static BlockMicroMaterial registerMaterial(Block block) {
        return MicroblockRegistry.registerMaterial(block.func_176223_P());
    }

    public static Collection<IMicroMaterial> getRegisteredMaterials() {
        return Collections.unmodifiableCollection(materials.values());
    }

    public static IMicroMaterial getMaterial(String name) {
        return materials.get(name);
    }

    static {
        MicroblockRegistry.registerMaterial(Blocks.field_150348_b, 0, 6);
        MicroblockRegistry.registerMaterial(Blocks.field_150347_e);
        MicroblockRegistry.registerMaterial(Blocks.field_150344_f, 0, 5);
        MicroblockRegistry.registerMaterial(Blocks.field_150368_y);
        MicroblockRegistry.registerMaterial(Blocks.field_150322_A, 0, 2);
        MicroblockRegistry.registerMaterial(Blocks.field_150325_L, 0, 15);
        MicroblockRegistry.registerMaterial(Blocks.field_150340_R);
        MicroblockRegistry.registerMaterial(Blocks.field_150339_S);
        MicroblockRegistry.registerMaterial(Blocks.field_150336_V);
        MicroblockRegistry.registerMaterial(Blocks.field_150342_X);
        MicroblockRegistry.registerMaterial(Blocks.field_150341_Y);
        MicroblockRegistry.registerMaterial(Blocks.field_150343_Z);
        MicroblockRegistry.registerMaterial(Blocks.field_150484_ah);
        MicroblockRegistry.registerMaterial(Blocks.field_150423_aK);
        MicroblockRegistry.registerMaterial(Blocks.field_150424_aL);
        MicroblockRegistry.registerMaterial(Blocks.field_150425_aM);
        MicroblockRegistry.registerMaterial(Blocks.field_150417_aV, 0, 3);
        MicroblockRegistry.registerMaterial(Blocks.field_150385_bj);
        MicroblockRegistry.registerMaterial(Blocks.field_150377_bs);
        MicroblockRegistry.registerMaterial(Blocks.field_150475_bE);
        MicroblockRegistry.registerMaterial(Blocks.field_150371_ca, 0, 2);
        MicroblockRegistry.registerMaterial(Blocks.field_150406_ce, 0, 15);
        MicroblockRegistry.registerMaterial(Blocks.field_180397_cI, 0, 2);
        MicroblockRegistry.registerMaterial(Blocks.field_150407_cf);
        MicroblockRegistry.registerMaterial(Blocks.field_150405_ch);
        MicroblockRegistry.registerMaterial(Blocks.field_150402_ci);
        MicroblockRegistry.registerMaterial(Blocks.field_150432_aD);
        MicroblockRegistry.registerMaterial(Blocks.field_150403_cj);
        MicroblockRegistry.registerMaterial(Blocks.field_180395_cM, 0, 2);
        MicroblockRegistry.registerMaterial(Blocks.field_150359_w);
        MicroblockRegistry.registerMaterial((Block)Blocks.field_150399_cn, 0, 15);
        MicroblockRegistry.registerMaterial(Blocks.field_150428_aP);
        MicroblockRegistry.registerMaterial(Blocks.field_150426_aN);
        MicroblockRegistry.registerMaterial(Blocks.field_180398_cJ);
        MicroblockRegistry.registerMaterial(Blocks.field_150451_bX);
        MicroblockRegistry.registerMaterial(new BlockMicroMaterial(Blocks.field_150462_ai.func_176223_P()).withDelegate(new Function<Tuple<IMicroblock, Boolean>, MicroblockDelegate>(){

            public MicroblockDelegate apply(Tuple<IMicroblock, Boolean> input) {
                return new CraftingTableMicroblockDelegate((IMicroblock)input.func_76341_a());
            }
        }));
    }

    private static class InterfaceMicroCraftingTable
    implements IInteractionObject {
        private final IMicroblock microblock;

        public InterfaceMicroCraftingTable(IMicroblock microblock) {
            this.microblock = microblock;
        }

        public String func_70005_c_() {
            return null;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(Blocks.field_150462_ai.func_149739_a() + ".name", new Object[0]);
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
            return new ContainerWorkbench(playerInventory, this.microblock.getWorld(), this.microblock.getPos()){

                public boolean func_75145_c(EntityPlayer player) {
                    BlockPos pos = microblock.getPos();
                    return microblock.getContainer() == null ? false : player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
                }
            };
        }

        public String func_174875_k() {
            return "minecraft:crafting_table";
        }
    }

    private static final class CraftingTableMicroblockDelegate
    extends MicroblockDelegate {
        public CraftingTableMicroblockDelegate(IMicroblock delegated) {
            super(delegated);
        }

        @Override
        public Optional<Boolean> onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, PartMOP hit) {
            if (!this.delegated.getWorld().field_72995_K) {
                player.func_180468_a((IInteractionObject)new InterfaceMicroCraftingTable(this.delegated));
                player.func_71029_a(StatList.field_188062_ab);
            }
            return Optional.of((Object)true);
        }

        @Override
        public void onRemoved() {
        }
    }
}

