/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mcmultipart.microblock;

import java.util.Collection;
import java.util.UUID;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import reborncore.mcmultipart.microblock.IMicroblock;
import reborncore.mcmultipart.microblock.IMicroblockContainerTile;
import reborncore.mcmultipart.multipart.IMultipart;
import reborncore.mcmultipart.multipart.IMultipartContainer;
import reborncore.mcmultipart.multipart.MultipartContainer;
import reborncore.mcmultipart.multipart.PartSlot;

public class MicroblockContainer
implements IMultipartContainer {
    private IMicroblockContainerTile microTile;
    private MultipartContainer container;

    public MicroblockContainer(IMicroblockContainerTile microTile) {
        this.microTile = microTile;
        this.container = new MultipartContainer(microTile, false);
    }

    public MultipartContainer getPartContainer() {
        return this.container;
    }

    @Override
    public World getWorldIn() {
        return this.container.getWorldIn();
    }

    @Override
    public BlockPos getPosIn() {
        return this.container.getPosIn();
    }

    public Collection<? extends IMicroblock> getParts() {
        return this.container.getParts();
    }

    @Override
    public IMicroblock getPartInSlot(PartSlot slot) {
        return (IMicroblock)this.container.getPartInSlot(slot);
    }

    @Override
    public boolean canAddPart(IMultipart part) {
        if (!(part instanceof IMicroblock)) {
            return false;
        }
        IMicroblock mb = (IMicroblock)part;
        if (!this.microTile.canAddMicroblock(mb)) {
            return false;
        }
        return this.container.canAddPart(part);
    }

    @Override
    public boolean canReplacePart(IMultipart oldPart, IMultipart newPart) {
        if (!(oldPart instanceof IMicroblock)) {
            return false;
        }
        if (!(newPart instanceof IMicroblock)) {
            return false;
        }
        IMicroblock mb = (IMicroblock)newPart;
        if (!this.microTile.canAddMicroblock(mb)) {
            return false;
        }
        return this.container.canReplacePart(oldPart, newPart);
    }

    @Override
    public void addPart(IMultipart part) {
        if (!(part instanceof IMicroblock)) {
            throw new IllegalArgumentException("Attemtped to add a part that's not a microblock!");
        }
        this.container.addPart(part);
    }

    @Override
    public void removePart(IMultipart part) {
        if (!(part instanceof IMicroblock)) {
            throw new IllegalArgumentException("Attemtped to remove a part that's not a microblock!");
        }
        this.container.removePart(part);
    }

    @Override
    public UUID getPartID(IMultipart part) {
        return this.container.getPartID(part);
    }

    @Override
    public IMultipart getPartFromID(UUID id) {
        return this.container.getPartFromID(id);
    }

    @Override
    public void addPart(UUID id, IMultipart part) {
        this.container.addPart(id, part);
    }

    @Override
    public boolean occlusionTest(IMultipart part, IMultipart ... ignored) {
        if (!(part instanceof IMicroblock) || !this.microTile.canAddMicroblock((IMicroblock)part)) {
            return false;
        }
        return this.container.occlusionTest(part, ignored);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, PartSlot slot, EnumFacing facing) {
        return this.container.hasCapability(capability, slot, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, PartSlot slot, EnumFacing facing) {
        return this.container.getCapability(capability, slot, facing);
    }
}

