/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.api.power.IPowerConfig;
import reborncore.common.RebornCoreConfig;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.forge.ForgePowerManager;
import reborncore.common.tile.TileBase;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2")})
public abstract class TileEnergyBase
extends TileBase
implements IEnergyInterfaceTile,
IListInfoProvider,
ITickable,
IEnergyReceiver,
IEnergyProvider,
IEnergyTile,
IEnergySink,
IEnergySource {
    public EnumPowerTier tier;
    private double energy;
    private int capacity;
    private ForgePowerManager forgePowerManager;
    protected boolean addedToEnet;

    public TileEnergyBase(EnumPowerTier tier, int capacity) {
        this.tier = tier;
        this.capacity = capacity;
    }

    public void updateEntity() {
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateEntity();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energy = compound.func_74769_h("energy");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74780_a("energy", this.energy);
        return super.func_189515_b(compound);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public EnumFacing getFacingEnum() {
        Block block = this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c();
        if (block instanceof BlockMachineBase) {
            return ((BlockMachineBase)block).getFacing(this.func_145831_w().func_180495_p(this.func_174877_v()));
        }
        return null;
    }

    @Override
    public void addInfo(List<String> info, boolean isRealTile) {
        info.add(TextFormatting.LIGHT_PURPLE + "Energy buffer Size " + TextFormatting.GREEN + PowerSystem.getLocaliszedPower(this.getMaxPower()));
        if (this.getMaxInput() > 0.0) {
            info.add(TextFormatting.LIGHT_PURPLE + "Max Input " + TextFormatting.GREEN + PowerSystem.getLocaliszedPower(this.getMaxInput()));
        }
        if (this.getMaxOutput() > 0.0) {
            info.add(TextFormatting.LIGHT_PURPLE + "Max Output " + TextFormatting.GREEN + PowerSystem.getLocaliszedPower(this.getMaxOutput()));
        }
        info.add(TextFormatting.LIGHT_PURPLE + "Tier " + TextFormatting.GREEN + (Object)((Object)this.getTier()));
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public void setEnergy(double energy) {
        this.energy = Math.min(0.0, Math.max((double)this.capacity, energy));
    }

    @Override
    public double getMaxPower() {
        return this.capacity;
    }

    @Override
    public boolean canAddEnergy(double energy) {
        return this.energy + energy <= this.getMaxPower();
    }

    @Override
    public double addEnergy(double energy) {
        return this.addEnergy(energy, false);
    }

    @Override
    public double addEnergy(double energy, boolean simulate) {
        double _taken = energy - (this.energy + energy > (double)this.capacity ? this.energy + energy - (double)this.capacity : 0.0);
        if (!simulate) {
            this.energy = Math.min(this.energy + energy, (double)this.capacity);
            if (this.energy > (double)this.capacity) {
                this.energy = this.capacity;
            }
        }
        return _taken;
    }

    @Override
    public boolean canUseEnergy(double energy) {
        return energy <= this.energy;
    }

    @Override
    public double useEnergy(double energy) {
        return this.useEnergy(energy, false);
    }

    @Override
    public double useEnergy(double energy, boolean simulate) {
        double _used = energy - (this.energy - energy < 0.0 ? 0.0 - this.energy - energy : 0.0);
        if (!simulate) {
            this.energy = Math.max(0.0, this.energy - energy);
        }
        return _used;
    }

    @Override
    public double getMaxOutput() {
        return this.tier.getMaxOutput();
    }

    @Override
    public double getMaxInput() {
        return this.tier.getMaxInput();
    }

    @Override
    public EnumPowerTier getTier() {
        return this.tier;
    }

    public int getEnergyScaled(int scale) {
        return (int)(this.energy * (double)scale / this.getMaxPower());
    }

    public IPowerConfig getPowerConfig() {
        return RebornCoreConfig.getRebornPower();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        if (!this.getPowerConfig().rf()) {
            return false;
        }
        return this.canAcceptEnergy(from) || this.canProvideEnergy(from);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.getPowerConfig().rf()) {
            return 0;
        }
        if (!this.canAcceptEnergy(from)) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored(null) - this.getEnergyStored(null), Math.min((int)this.getMaxInput() * RebornCoreConfig.euPerRF, maxReceive *= RebornCoreConfig.euPerRF));
        if (!simulate) {
            this.setEnergy(this.getEnergy() + (double)energyReceived);
        }
        return energyReceived / RebornCoreConfig.euPerRF;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        if (!this.getPowerConfig().rf()) {
            return 0;
        }
        return (int)this.getEnergy() * RebornCoreConfig.euPerRF;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        if (!this.getPowerConfig().rf()) {
            return 0;
        }
        return (int)this.getMaxPower() * RebornCoreConfig.euPerRF;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (!this.getPowerConfig().rf()) {
            return 0;
        }
        if (!this.canProvideEnergy(from)) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(null), Math.min(maxExtract *= RebornCoreConfig.euPerRF, maxExtract));
        if (!simulate) {
            this.setEnergy(this.energy - (double)energyExtracted);
        }
        return energyExtracted * RebornCoreConfig.euPerRF;
    }

    @Optional.Method(modid="IC2")
    public void onLoaded() {
        if (this.getPowerConfig().eu() && !this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    @Optional.Method(modid="IC2")
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.getPowerConfig().eu() && this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return 0.0;
        }
        return Math.min(this.getMaxPower() - this.getEnergy(), this.getMaxInput());
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return this.tier.ordinal();
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.setEnergy(this.getEnergy() + amount);
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return false;
        }
        return this.canAcceptEnergy(enumFacing);
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return false;
        }
        return this.canProvideEnergy(enumFacing);
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return 0.0;
        }
        return Math.min(this.getEnergy(), this.getMaxOutput());
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        this.useEnergy((int)amount);
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return this.tier.ordinal();
    }
}

