/*
 * Decompiled with CFR 0.152.
 */
package reborncore;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import reborncore.common.LootManager;
import reborncore.common.util.CraftingHelper;

public class RebornRegistry {
    public static LootManager.InnerPool lp = new LootManager.InnerPool();

    public static void registerBlock(Block block, String name) {
        block.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block), (ResourceLocation)block.getRegistryName());
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemclass, String name) {
        block.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)block);
        try {
            ItemBlock itemBlock = itemclass.getConstructor(Block.class).newInstance(block);
            itemBlock.setRegistryName(name);
            GameRegistry.register((IForgeRegistryEntry)itemBlock);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void registerItem(Item item, ResourceLocation name) {
        GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)name);
    }

    public static void addShapedOreRecipe(ItemStack output, Object parm) {
        CraftingHelper.addShapedOreRecipe(output, parm);
    }

    public static void addShapelessOreRecipe(ItemStack output, Object parm) {
        CraftingHelper.addShapelessOreRecipe(output, parm);
    }

    public static void addLoot(Item item, double chance, ResourceLocation list) {
        lp.addItem(LootManager.createLootEntry(item, chance, list));
    }

    public static void addLoot(Item item, int minSize, int maxSize, double chance, ResourceLocation list) {
        lp.addItem(LootManager.createLootEntry(item, minSize, maxSize, chance, list));
    }

    public static void addLoot(Item item, int ordinal, int minSize, int maxSize, double chance, ResourceLocation list) {
        lp.addItem(LootManager.createLootEntry(item, ordinal, minSize, maxSize, chance, list));
    }
}

