/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Handlers;

import PegBeard.DungeonTactics.Reference.Reference;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DTConfigHandler {
    public static Configuration configuration;
    public static boolean sitting;
    public static boolean diplomas;
    public static boolean seasonal;
    public static int enchantIDS;
    public static boolean modifyLoot;
    public static boolean extraMaterials;
    public static boolean invisNoArmour;
    public static int hearts;
    public static int extraHearts;
    public static int boneCharms;
    public static int breakCharms;
    public static int potionFish;
    public static boolean oreClusters;
    public static boolean oreClustersOverride;
    public static String[] ironOverride;
    public static String[] goldOverride;
    public static String[] tinOverride;
    public static String[] copperOverride;
    public static String[] leadOverride;
    public static String[] silverOverride;
    public static int lootbags;
    public static int bagDropRange;
    public static String[] foodDrops;
    public static String[] oreDrops;
    public static String[] recordDrops;
    public static String[] toolDrops;
    public static String[] bookDrops;
    public static String[] potionDrops;
    public static String[] ducttapeWhite;
    public static String[] ducttapeBlack;
    public static boolean netherGold;
    public static int flowers;
    public static String[] flowerBiomes;
    public static boolean treasures;
    public static boolean dungeons;
    public static int shipSpacing;
    public static int dungeonSpacing;
    public static int dungeonMinHeight;
    public static int dungeonMaxHeight;
    public static int netherDungeonChance;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            DTConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        sitting = configuration.getBoolean("RP-Sitting", "1-Feature", true, "Set 'false' to disable sitting.");
        diplomas = configuration.getBoolean("RP-Achievement Diplomas", "1-Feature", true, "Set 'false' to disable Achievement Diplomas.");
        seasonal = configuration.getBoolean("E-Seasonal Events", "1-Feature", true, "Set 'false' to disable Seasonal Events, because you have no sense of fun, you monster.");
        enchantIDS = configuration.getInt("C-Enchant IDs", "1-Feature", 80, 80, 200, "This will set the start number for DT Enchantment IDS.");
        modifyLoot = configuration.getBoolean("C-Modify Loot Pools", "1-Feature", true, "Set 'false' to disable loot pool manipulation - this stop the mod from adding to vanilla loot pools.");
        extraMaterials = configuration.getBoolean("C-Modded Material Weapons", "1-Feature", true, "Set 'false' to disable extra weapons for modded resources.");
        invisNoArmour = configuration.getBoolean("1-Invisiblity Removes Armour", "1-Feature", true, "If 'true' armour will be unequiped and placed into the inventory of players with invisibility.");
        hearts = configuration.getInt("2-Heart Drops", "1-Feature", 20, 0, 100, "Percentage chance for Heart Drops. Set to 100 for guarenteed drops, 0 to disable.");
        extraHearts = configuration.getInt("3-Extra Hearts", "1-Feature", 20, 0, 60, "Maximum amount of extra hearts allowed.");
        boneCharms = configuration.getInt("4-Bone Charm Drops", "1-Feature", 10, 0, 100, "Percentage chance for Bone Charms to be dropped. Set to 100 for guarenteed drops, 0 to disable.");
        breakCharms = configuration.getInt("5-Bone Charm Break Chance", "1-Feature", 7, 1, 20, "Percentage chance for Bone Charms to break on use. Set to 1 to break on every use.");
        potionFish = configuration.getInt("6-Potion Fish Catch Chance", "1-Feature", 7, 0, 100, "Weight for catching Potion Fish, when fishing - 0 will disable, vanilla fish weight is 10.");
        oreClusters = configuration.getBoolean("7-Ore Clusters", "1-Feature", true, "Set 'false' to disable fortunable metal ore drops.");
        oreClustersOverride = configuration.getBoolean("1-Cluster Output Override", "4-OreClusterOverrides", false, "Set 'true' to override Ore Cluster smelting outputs.");
        ironOverride = configuration.getStringList("2-Iron Override", "4-OreClusterOverrides", Reference.IRONOVERRIDEDEFAULT, "If empty output will be automatically assigned. Example= minecraft:iron_ingot or 265. If specified item does not exist, cluster will not be smeltable.");
        goldOverride = configuration.getStringList("3-Gold Override", "4-OreClusterOverrides", Reference.GOLDOVERRIDEDEFAULT, "If empty output will be automatically assigned. Example= minecraft:gold_ingot or 266. If specified item does not exist, cluster will not be smeltable.");
        tinOverride = configuration.getStringList("4-Tin Override", "4-OreClusterOverrides", Reference.TINOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        copperOverride = configuration.getStringList("5-Copper Override", "4-OreClusterOverrides", Reference.COPPEROVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        leadOverride = configuration.getStringList("6-Lead Override", "4-OreClusterOverrides", Reference.LEADOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        silverOverride = configuration.getStringList("7-Silver Override", "4-OreClusterOverrides", Reference.SILVEROVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        lootbags = configuration.getInt("8-Loot Bag Drops", "1-Feature", 10, 0, 100, "Percentage chance for Loot Bags. Set to 100 for guarenteed drops, 0 to disable.");
        bagDropRange = configuration.getInt("9-Loot Bag Drop Range", "1-Feature", 2, 1, 10, "Max amount of items for Loot Bags to drop. Record Bags are always 1");
        foodDrops = configuration.getStringList("1-Food Bag Drops", "2-Lootbaglists", Reference.FOODDROPSDEFAULT, "List of drops from Food Bags - use ';' to specify meta, or '~' to specify wildcard range. Example 'minecraft:dye;9' or 'minecraft:dye~16'.");
        oreDrops = configuration.getStringList("2-Ore Bag Drops", "2-Lootbaglists", Reference.OREDROPSDEFAULT, "List of drops from Ore Bags - use ';' to specify meta, or '~' to specify wildcard range. Example 'minecraft:dye;9' or 'minecraft:dye~16'.");
        toolDrops = configuration.getStringList("3-Tools Bag Drops", "2-Lootbaglists", Reference.TOOLDROPSDEFAULT, "List of drops from Tool Bags - use ';' to specify meta, or '~' to specify wildcard range. Example 'minecraft:dye;9' or 'minecraft:dye~16'.");
        bookDrops = configuration.getStringList("4-Book Bag Drops", "2-Lootbaglists", Reference.BOOKDROPSDEFAULT, "List of drops from Book Bags - ALL enchanted books should be added automatically, this list is only for additional items - use ';' to specify meta, or '~' to specify wildcard range. Example 'minecraft:dye;9' or 'minecraft:dye~16'.");
        potionDrops = configuration.getStringList("5-Potion Bag Drops", "2-Lootbaglists", Reference.POTIONDROPSDEFAULT, "List of drops from Potion Bags - Vanilla potions are hardcoded, this list is only for additional/modded items - use ';' to specify meta, or '~' to specify wildcard range. Example 'minecraft:dye;9' or 'minecraft:dye~16'.");
        recordDrops = configuration.getStringList("6-Record Bag Drops", "2-Lootbaglists", Reference.RECORDDROPSDEFAULT, "List of drops from Record Bags - use ';' to specify meta, or '~' to specify wildcard range. Example 'minecraft:dye;9' or 'minecraft:dye~16'.");
        ducttapeWhite = configuration.getStringList("1-Ductape White List", "3-Ducttapableslists", Reference.DUCTTAPEWHITELISTDEFAULT, "White List of items that can be repaired with Duct Tape. Weapons, tools, and armour should be detected by default.");
        ducttapeBlack = configuration.getStringList("2-Ductape Black List", "3-Ducttapableslists", Reference.DUCTTAPEBLACKLISTDEFAULT, "Black List of items that can not be repaired with Duct Tape. Example 'minecraft:fishing_rod'.");
        netherGold = configuration.getBoolean("1-Nether Gold", "5-World", true, "Set 'false' to disable Nether Gold from being generated.");
        flowers = configuration.getInt("2-Flower Generation", "5-World", 32, 0, 100, "Set higher for more Dungeon Tactics Flowers.");
        flowerBiomes = configuration.getStringList("1-Flower Biomes", "6-WorldGen", Reference.FLOWERBIOMESDEFAULT, "Whitelist of biomes where Dungeon Tactics Flowers can be generated (only effects worldgen).");
        treasures = configuration.getBoolean("3-Treasure Boxes", "5-World", true, "Set 'false' to disable Dungeon Tactics treasure boxes.");
        dungeons = configuration.getBoolean("4-Dungeon Generation", "5-World", true, "Set 'false' to disable Dungeon Tactics structures.");
        shipSpacing = configuration.getInt("5-Ship Spacing", "5-World", 500, 50, 5000, "Rough distance between Ships (Only generated in oceans).");
        dungeonSpacing = configuration.getInt("6-Dungeon Spacing", "5-World", 1000, 50, 5000, "Rough distance between Towers/Dungeons.");
        dungeonMinHeight = configuration.getInt("7-Dungeon MinHeight", "5-World", 3, 0, 20, "Minimum floors for towers to generate (Setting this higher than 'Max Height' will make all towers this height).");
        dungeonMaxHeight = configuration.getInt("8-Dungeon MaxHeight", "5-World", 10, 0, 20, "Maximum floors for towers to generate.");
        netherDungeonChance = configuration.getInt("9-Nether Variant Chance", "5-World", 9, 0, 100, "Percentage chance for Towers/Dungeons to be 'Nether themed'. This only effects Overworld Towers/Dungeons. Set to 100 for guarenteed chance, 0 to disable.");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("dungeontactics")) {
            DTConfigHandler.loadConfiguration();
        }
    }

    static {
        sitting = true;
        diplomas = true;
        seasonal = true;
        enchantIDS = 80;
        modifyLoot = true;
        extraMaterials = true;
        invisNoArmour = true;
        hearts = 20;
        extraHearts = 20;
        boneCharms = 10;
        breakCharms = 7;
        potionFish = 7;
        oreClusters = true;
        oreClustersOverride = false;
        ironOverride = Reference.IRONOVERRIDEDEFAULT;
        goldOverride = Reference.GOLDOVERRIDEDEFAULT;
        tinOverride = Reference.TINOVERRIDEDEFAULT;
        copperOverride = Reference.COPPEROVERRIDEDEFAULT;
        leadOverride = Reference.LEADOVERRIDEDEFAULT;
        silverOverride = Reference.SILVEROVERRIDEDEFAULT;
        lootbags = 10;
        bagDropRange = 2;
        foodDrops = Reference.FOODDROPSDEFAULT;
        oreDrops = Reference.OREDROPSDEFAULT;
        recordDrops = Reference.RECORDDROPSDEFAULT;
        toolDrops = Reference.TOOLDROPSDEFAULT;
        bookDrops = Reference.BOOKDROPSDEFAULT;
        potionDrops = Reference.POTIONDROPSDEFAULT;
        ducttapeWhite = Reference.DUCTTAPEWHITELISTDEFAULT;
        ducttapeBlack = Reference.DUCTTAPEBLACKLISTDEFAULT;
        netherGold = true;
        flowers = 32;
        flowerBiomes = Reference.FLOWERBIOMESDEFAULT;
        treasures = true;
        dungeons = true;
        shipSpacing = 500;
        dungeonSpacing = 1000;
        dungeonMinHeight = 3;
        dungeonMaxHeight = 10;
        netherDungeonChance = 9;
    }
}

