/*
 * Decompiled with CFR 0.152.
 */
package PegBeard.DungeonTactics.Blocks.TileEntities;

import PegBeard.DungeonTactics.Blocks.DTFanBlock;
import PegBeard.DungeonTactics.Handlers.DTBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DTFlamerTile
extends TileEntity
implements ITickable {
    public boolean isPowered = false;
    public int range = 5;

    public void whilePowered(World world, BlockPos pos, IBlockState state, Random rand) {
        List list;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)DTFanBlock.FACING);
        BlockPos frontPos = new BlockPos(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() + facing.func_96559_d(), pos.func_177952_p() + facing.func_82599_e());
        Block block = world.func_180495_p(frontPos).func_177230_c();
        if (!this.canPass(block) && !this.notObstructed(world, null, facing) && (!block.func_176205_b((IBlockAccess)world, frontPos) || block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, frontPos, facing) || block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, frontPos, facing.func_176734_d()) || block instanceof BlockLiquid)) {
            return;
        }
        this.tryBurn(world, facing, rand);
        if (world.func_175687_A(pos) > 0 && !(list = world.func_72872_a(EntityLivingBase.class, this.getDirection(state))).isEmpty()) {
            for (EntityLivingBase entity : list) {
                double d0 = this.getDistanceSqToEntity((Entity)entity);
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                float j = (float)(d1 * 10.0 + 0.5);
                if (!this.notObstructed(world, (Entity)entity, facing)) {
                    return;
                }
                if (entity == null) continue;
                entity.func_70097_a(DamageSource.field_76372_a, j);
                if (entity.func_70027_ad() || rand.nextInt(3) != 0) continue;
                if (j < 1.0f) {
                    j = 1.0f;
                }
                entity.func_70015_d(2 + (int)j);
            }
        }
    }

    public void func_73660_a() {
        if (this.isPowered) {
            this.whilePowered(this.func_145831_w(), this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().field_73012_v);
        }
    }

    public AxisAlignedBB getDirection(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)DTFanBlock.FACING);
        int r = this.range;
        switch (facing) {
            case NORTH: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177964_d(r).func_177952_p() + 1.0);
            }
            case EAST: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177965_g(r).func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177970_e(r).func_177952_p() + 1.0);
            }
            case WEST: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177985_f(r).func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 1.0);
            }
            case UP: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177981_b(r).func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 1.0);
            }
            case DOWN: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177979_c(r).func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 1.0);
            }
        }
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177964_d(r).func_177952_p() + 1.0);
    }

    public boolean notObstructed(World world, Entity entity, EnumFacing facing) {
        for (int i = 1; i < this.range; ++i) {
            BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()).func_177967_a(facing, i);
            Block block = world.func_180495_p(pos).func_177230_c();
            if (this.canPass(block) || block.func_176205_b((IBlockAccess)world, pos) && !block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, pos, facing) && !block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, pos, facing.func_176734_d()) && !(block instanceof BlockLiquid)) continue;
            this.tryBurn(world, facing, world.field_73012_v);
            if (entity != null && !(entity.func_180425_c().func_177954_c((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()) > pos.func_177954_c((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()))) continue;
            return false;
        }
        return true;
    }

    public void tryBurn(World world, EnumFacing facing, Random rand) {
        if (world.func_82736_K().func_82766_b("doFireTick")) {
            for (int i = 1; i < this.range; ++i) {
                BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()).func_177967_a(facing, i);
                Block block = world.func_180495_p(pos).func_177230_c();
                if (block != Blocks.field_150350_a && block.isFlammable((IBlockAccess)world, pos, facing.func_176734_d()) && rand.nextInt(100) == 0) {
                    world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 2);
                }
                if (!this.canPass(block) && (!block.func_176205_b((IBlockAccess)world, pos) || block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, pos, facing) || block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, pos, facing.func_176734_d()) || block instanceof BlockLiquid)) {
                    return;
                }
                if (block != Blocks.field_150350_a || !world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) || rand.nextInt(1000) != 0) continue;
                world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 2);
            }
        }
    }

    public boolean canPass(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150376_bx || block == Blocks.field_150333_U || block == Blocks.field_180389_cP || block instanceof BlockFence || block == Blocks.field_150411_aY || block == DTBlocks.poweredFence || block == Blocks.field_150488_af || block == Blocks.field_150429_aA || block == Blocks.field_150437_az || block == Blocks.field_150473_bD || block == Blocks.field_150480_ab;
    }

    public double getDistanceSqToEntity(Entity entity) {
        double d0 = (double)this.func_174877_v().func_177958_n() - entity.field_70165_t;
        double d1 = (double)this.func_174877_v().func_177956_o() - entity.field_70163_u;
        double d2 = (double)this.func_174877_v().func_177952_p() - entity.field_70161_v;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("isPowered", this.isPowered);
        return super.func_189515_b(nbttagcompound);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.isPowered = nbttagcompound.func_74767_n("isPowered");
    }
}

