/*
 * Decompiled with CFR 0.152.
 */
package net.konwboy.tumbleweed.common;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import net.konwboy.tumbleweed.Tumbleweed;
import net.konwboy.tumbleweed.common.Config;
import net.konwboy.tumbleweed.common.EntityTumbleweed;
import net.konwboy.tumbleweed.common.MessageWind;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommonEventHandler {
    private static final Random RAND = new Random();
    private static final int TRY_SPAWN_TICKS = 200;
    private static final int CHANGE_WIND_TICKS = 2400;
    private static final int MOB_COUNT_DIV = 289;
    private int serverTicks;

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (world.func_82737_E() % 200L == 0L) {
            this.trySpawn(world);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.serverTicks % 2400 == 0) {
            if (RAND.nextBoolean()) {
                Tumbleweed.windX *= -1.0f;
            }
            if (RAND.nextBoolean()) {
                Tumbleweed.windZ *= -1.0f;
            }
            Tumbleweed.network.sendToAll((IMessage)new MessageWind(Tumbleweed.windX, Tumbleweed.windZ));
        }
        ++this.serverTicks;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Tumbleweed.network.sendTo((IMessage)new MessageWind(Tumbleweed.windX, Tumbleweed.windZ), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("tumbleweed")) {
            Config.load();
        }
    }

    private void trySpawn(World world) {
        HashSet eligibleChunksForSpawning = Sets.newHashSet();
        int chunks = 0;
        for (EntityPlayer entityplayer : world.field_73010_i) {
            if (entityplayer.func_175149_v()) continue;
            int playerX = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int playerZ = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            for (int x = -8; x <= 8; ++x) {
                for (int z = -8; z <= 8; ++z) {
                    boolean flag = x == -8 || x == 8 || z == -8 || z == 8;
                    ChunkPos chunkcoordintpair = new ChunkPos(x + playerX, z + playerZ);
                    if (eligibleChunksForSpawning.contains(chunkcoordintpair)) continue;
                    ++chunks;
                    if (flag || !world.func_175723_af().func_177730_a(chunkcoordintpair)) continue;
                    eligibleChunksForSpawning.add(chunkcoordintpair);
                }
            }
        }
        BlockPos spawnPoint = world.func_175694_M();
        int current = world.func_72907_a(EntityTumbleweed.class);
        int max = 35 * chunks / 289;
        for (ChunkPos chunkcoordintpair : eligibleChunksForSpawning) {
            int z;
            int y;
            int x;
            if (current > max) break;
            if (!(world.field_73012_v.nextDouble() < Config.getSpawnChance())) continue;
            BlockPos blockpos = CommonEventHandler.getRandomChunkPosition(world, chunkcoordintpair.field_77276_a, chunkcoordintpair.field_77275_b);
            BlockPos spawner = null;
            int r = 4;
            for (x = -r; x < r; ++x) {
                block5: for (y = -r; y < r; ++y) {
                    for (z = -r; z < r; ++z) {
                        BlockPos check = new BlockPos(blockpos.func_177958_n() + x, blockpos.func_177956_o() + y, blockpos.func_177952_p() + z);
                        IBlockState state = world.func_180495_p(check);
                        Block block = state.func_177230_c();
                        Config.Metadata meta = new Config.Metadata(block.getRegistryName(), block.func_176201_c(state));
                        if (!Config.getSpawningBlocks().contains(meta) || !world.func_175710_j(check)) continue;
                        spawner = check;
                        continue block5;
                    }
                }
            }
            if (spawner == null) continue;
            x = spawner.func_177958_n();
            y = spawner.func_177956_o();
            z = spawner.func_177952_p();
            Biome biome = world.func_180494_b(spawner);
            if ((!Config.getBiomeWhitelist().isEmpty() || !BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || !BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) && !Config.getBiomeWhitelist().contains(biome.getRegistryName()) || world.func_175636_b((double)x, (double)y, (double)z, 24.0) || !(spawnPoint.func_177954_c((double)x, (double)y, (double)z) >= 576.0)) continue;
            EntityTumbleweed entity = new EntityTumbleweed(world);
            entity.func_70012_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0f, 0.0f);
            if (!entity.isNotColliding()) continue;
            ++current;
            world.func_72838_d((Entity)entity);
        }
    }

    private static BlockPos getRandomChunkPosition(World worldIn, int x, int z) {
        Chunk chunk = worldIn.func_72964_e(x, z);
        int i = x * 16 + worldIn.field_73012_v.nextInt(16);
        int j = z * 16 + worldIn.field_73012_v.nextInt(16);
        int k = chunk.func_177433_f(new BlockPos(i, 0, j)) + 1;
        return new BlockPos(i, k, j);
    }
}

