/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.events;

import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IBackpack;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.config.ConfigHandler;
import gr8pefish.ironbackpacks.container.backpack.ContainerBackpack;
import gr8pefish.ironbackpacks.container.backpack.InventoryBackpack;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import gr8pefish.ironbackpacks.items.upgrades.UpgradeMethods;
import gr8pefish.ironbackpacks.util.Logger;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class IronBackpacksEventHelper {
    private static Pattern pattern = Pattern.compile("((?<modid>.*?):)?(?<item>[^@]*)(@(?<damage>\\d+|[*])(x(?<size>\\d+))?)?");

    protected static ArrayList<ArrayList<ItemStack>> getFilterCrafterAndRestockerBackpacks(EntityPlayer player) {
        ArrayList<ItemStack> filterBackpacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> crafterTinyBackpacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> crafterSmallBackpacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> crafterBackpacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> restockerBackpacks = new ArrayList<ItemStack>();
        ArrayList<ArrayList<ItemStack>> returnArray = new ArrayList<ArrayList<ItemStack>>();
        IronBackpacksEventHelper.getEventBackpacks(PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player), filterBackpacks, crafterTinyBackpacks, crafterSmallBackpacks, crafterBackpacks, restockerBackpacks, player);
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            IronBackpacksEventHelper.getEventBackpacks(stack, filterBackpacks, crafterTinyBackpacks, crafterSmallBackpacks, crafterBackpacks, restockerBackpacks, player);
        }
        returnArray.add(filterBackpacks);
        returnArray.add(crafterTinyBackpacks);
        returnArray.add(crafterSmallBackpacks);
        returnArray.add(crafterBackpacks);
        returnArray.add(restockerBackpacks);
        return returnArray;
    }

    protected static void getEventBackpacks(ItemStack backpack, ArrayList<ItemStack> filterBackpacks, ArrayList<ItemStack> crafterTinyBackpacks, ArrayList<ItemStack> crafterSmallBackpacks, ArrayList<ItemStack> crafterBackpacks, ArrayList<ItemStack> restockerBackpacks, EntityPlayer player) {
        if (backpack != null && backpack.func_77973_b() != null && backpack.func_77973_b() instanceof IBackpack) {
            ArrayList<ItemStack> upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(backpack);
            IronBackpacksEventHelper.addToLists(backpack, filterBackpacks, crafterTinyBackpacks, crafterSmallBackpacks, crafterBackpacks, restockerBackpacks, upgrades);
            if (UpgradeMethods.hasDepthUpgrade(upgrades)) {
                ItemBackpack itemBackpack = (ItemBackpack)backpack.func_77973_b();
                ContainerBackpack container = new ContainerBackpack(new InventoryBackpack(player, backpack));
                for (int j = 0; j < container.getInventoryBackpack().func_70302_i_(); ++j) {
                    ItemStack nestedBackpack = container.getInventoryBackpack().func_70301_a(j);
                    if (nestedBackpack == null || nestedBackpack.func_77973_b() == null || !(nestedBackpack.func_77973_b() instanceof IBackpack)) continue;
                    IronBackpacksEventHelper.addToLists(nestedBackpack, filterBackpacks, crafterTinyBackpacks, crafterSmallBackpacks, crafterBackpacks, restockerBackpacks, IronBackpacksHelper.getUpgradesAppliedFromNBT(nestedBackpack));
                }
            }
        }
    }

    protected static void addToLists(ItemStack stack, ArrayList<ItemStack> filterBackpacks, ArrayList<ItemStack> crafterTinyBackpacks, ArrayList<ItemStack> crafterSmallBackpacks, ArrayList<ItemStack> crafterBackpacks, ArrayList<ItemStack> restockerBackpacks, ArrayList<ItemStack> upgrades) {
        if (UpgradeMethods.hasFilterBasicUpgrade(upgrades) || UpgradeMethods.hasFilterModSpecificUpgrade(upgrades) || UpgradeMethods.hasFilterFuzzyUpgrade(upgrades) || UpgradeMethods.hasFilterOreDictUpgrade(upgrades) || UpgradeMethods.hasFilterVoidUpgrade(upgrades) || UpgradeMethods.hasFilterAdvancedUpgrade(upgrades) || UpgradeMethods.hasFilterMiningUpgrade(upgrades)) {
            filterBackpacks.add(stack);
        }
        if (UpgradeMethods.hasCraftingTinyUpgrade(upgrades)) {
            crafterTinyBackpacks.add(stack);
        }
        if (UpgradeMethods.hasCraftingSmallUpgrade(upgrades)) {
            crafterSmallBackpacks.add(stack);
        }
        if (UpgradeMethods.hasCraftingUpgrade(upgrades)) {
            crafterBackpacks.add(stack);
        }
        if (UpgradeMethods.hasRestockingUpgrade(upgrades)) {
            restockerBackpacks.add(stack);
        }
    }

    protected static boolean checkRestockingUpgradeItemPickup(EntityItemPickupEvent event, ArrayList<ItemStack> backpackStacks) {
        boolean doFilter = true;
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                boolean shouldSave = false;
                ItemBackpack itemBackpack = (ItemBackpack)backpack.func_77973_b();
                ContainerBackpack container = new ContainerBackpack(new InventoryBackpack(event.getEntityPlayer(), backpack));
                if (!(event.getEntityPlayer().field_71070_bA instanceof ContainerBackpack)) {
                    ArrayList<ItemStack> restockerItems = UpgradeMethods.getRestockingItems(backpack);
                    block1: for (ItemStack restockerItem : restockerItems) {
                        if (restockerItem == null) continue;
                        boolean foundSlot = false;
                        ItemStack stackToResupply = null;
                        Slot slotToResupply = null;
                        for (int i = itemBackpack.getSize(backpack); i < itemBackpack.getSize(backpack) + 36; ++i) {
                            ItemStack tempItem;
                            Slot tempSlot = container.func_75139_a(i);
                            if (tempSlot == null || !tempSlot.func_75216_d() || !IronBackpacksHelper.areItemsEqualAndStackable(tempItem = tempSlot.func_75211_c(), restockerItem)) continue;
                            foundSlot = true;
                            slotToResupply = tempSlot;
                            stackToResupply = tempItem;
                            break;
                        }
                        if (!foundSlot) continue;
                        boolean done = false;
                        if (IronBackpacksHelper.areItemsEqualForStacking(event.getItem().func_92059_d(), stackToResupply)) {
                            int amountToResupply = stackToResupply.func_77976_d() - stackToResupply.field_77994_a;
                            if (event.getItem().func_92059_d().field_77994_a >= amountToResupply) {
                                done = true;
                                shouldSave = true;
                            } else {
                                doFilter = false;
                                done = false;
                            }
                        }
                        if (done) continue;
                        for (int i = 0; i < itemBackpack.getSize(backpack); ++i) {
                            int amountToResupply;
                            ItemStack stackUpdated;
                            ItemStack tempItem;
                            Slot tempSlot = container.func_75139_a(i);
                            if (tempSlot == null || !tempSlot.func_75216_d() || !IronBackpacksHelper.areItemsEqualForStacking(tempItem = tempSlot.func_75211_c(), stackToResupply)) continue;
                            if (IronBackpacksHelper.areItemsEqualForStacking(event.getItem().func_92059_d(), stackToResupply)) {
                                stackUpdated = event.getEntityPlayer().field_71071_by.func_70301_a(slotToResupply.getSlotIndex());
                                amountToResupply = stackToResupply.func_77976_d() - stackUpdated.field_77994_a - event.getItem().func_92059_d().field_77994_a;
                                if (tempItem.field_77994_a >= amountToResupply) {
                                    tempSlot.func_75209_a(amountToResupply);
                                    event.getEntityPlayer().field_71071_by.func_70299_a(slotToResupply.getSlotIndex(), new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d() - event.getItem().func_92059_d().field_77994_a, stackToResupply.func_77952_i()));
                                    container.func_75134_a(event.getEntityPlayer());
                                    continue block1;
                                }
                                tempSlot.func_75209_a(tempItem.field_77994_a);
                                event.getEntityPlayer().field_71071_by.func_70299_a(slotToResupply.getSlotIndex(), new ItemStack(stackToResupply.func_77973_b(), stackUpdated.field_77994_a + tempItem.field_77994_a, stackToResupply.func_77952_i()));
                            } else {
                                stackUpdated = event.getEntityPlayer().field_71071_by.func_70301_a(slotToResupply.getSlotIndex());
                                amountToResupply = stackToResupply.func_77976_d() - stackUpdated.field_77994_a;
                                if (tempItem.field_77994_a >= amountToResupply) {
                                    tempSlot.func_75209_a(amountToResupply);
                                    slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d(), stackToResupply.func_77952_i()));
                                    container.func_75134_a(event.getEntityPlayer());
                                    continue block1;
                                }
                                tempSlot.func_75209_a(tempItem.field_77994_a);
                                event.getEntityPlayer().field_71071_by.func_70299_a(slotToResupply.getSlotIndex(), new ItemStack(stackToResupply.func_77973_b(), stackUpdated.field_77994_a + tempItem.field_77994_a, stackToResupply.func_77952_i()));
                            }
                            shouldSave = true;
                        }
                    }
                }
                if (!shouldSave) continue;
                container.func_75134_a(event.getEntityPlayer());
            }
        }
        return doFilter;
    }

    protected static ItemStack checkRestockerUpgradeItemUse(PlayerInteractEvent.RightClickItem event, ArrayList<ItemStack> backpackStacks) {
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                ItemBackpack itemBackpack = (ItemBackpack)backpack.func_77973_b();
                ContainerBackpack container = new ContainerBackpack(new InventoryBackpack(event.getEntityPlayer(), backpack));
                if (event.getEntityPlayer().field_71070_bA instanceof ContainerBackpack) continue;
                container.sort();
                ArrayList<ItemStack> restockerItems = UpgradeMethods.getRestockingItems(backpack);
                for (ItemStack restockerItem : restockerItems) {
                    int i;
                    if (restockerItem == null) continue;
                    boolean foundSlot = false;
                    ItemStack stackToResupply = null;
                    Slot slotToResupply = null;
                    for (i = itemBackpack.getSize(backpack); i < itemBackpack.getSize(backpack) + 36; ++i) {
                        Slot tempSlot = container.func_75139_a(i);
                        if (tempSlot == null || !tempSlot.func_75216_d()) continue;
                        ItemStack tempItem = tempSlot.func_75211_c();
                        if (!IronBackpacksHelper.areItemsEqualForStacking(event.getItemStack(), restockerItem) || !IronBackpacksHelper.areItemsEqualAndStackable(tempItem, restockerItem)) continue;
                        foundSlot = true;
                        slotToResupply = tempSlot;
                        stackToResupply = tempItem;
                        break;
                    }
                    if (!foundSlot) continue;
                    for (i = 0; i < itemBackpack.getSize(backpack); ++i) {
                        ItemStack backpackItemStack;
                        Slot backpackSlot = container.func_75139_a(i);
                        if (backpackSlot == null || !backpackSlot.func_75216_d() || !IronBackpacksHelper.areItemsEqualForStacking(stackToResupply, backpackItemStack = backpackSlot.func_75211_c())) continue;
                        int amountToResupply = stackToResupply.func_77976_d() - stackToResupply.field_77994_a;
                        if (backpackItemStack.field_77994_a >= amountToResupply) {
                            backpackSlot.func_75209_a(amountToResupply);
                            container.sort();
                            container.func_75134_a(event.getEntityPlayer());
                            return new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d(), stackToResupply.func_77952_i());
                        }
                        backpackSlot.func_75209_a(backpackItemStack.field_77994_a);
                        container.sort();
                        container.func_75134_a(event.getEntityPlayer());
                        return new ItemStack(stackToResupply.func_77973_b(), stackToResupply.field_77994_a + backpackItemStack.field_77994_a, stackToResupply.func_77952_i());
                    }
                }
            }
        }
        return null;
    }

    protected static ItemStack checkRestockerUpgradeItemPlace(EntityPlayer player, EnumHand hand, ItemStack toResupply, ArrayList<ItemStack> backpackStacks) {
        block5: {
            if (backpackStacks.isEmpty()) break block5;
            for (ItemStack backpack : backpackStacks) {
                ItemBackpack itemBackpack = (ItemBackpack)backpack.func_77973_b();
                ContainerBackpack container = new ContainerBackpack(new InventoryBackpack(player, backpack));
                if (player.field_71070_bA instanceof ContainerBackpack) continue;
                container.sort();
                ArrayList<ItemStack> restockerItems = UpgradeMethods.getRestockingItems(backpack);
                for (ItemStack restockerItem : restockerItems) {
                    int i;
                    ItemStack stackToResupply;
                    boolean foundSlot;
                    block7: {
                        Slot slotToResupply;
                        block6: {
                            if (restockerItem == null) continue;
                            foundSlot = false;
                            stackToResupply = null;
                            slotToResupply = null;
                            if (hand != EnumHand.OFF_HAND) break block6;
                            if (!IronBackpacksHelper.areItemsEqualForStacking(toResupply, restockerItem) || !IronBackpacksHelper.areItemsEqualAndStackable(toResupply, restockerItem)) break block7;
                            stackToResupply = toResupply;
                            foundSlot = true;
                            break block7;
                        }
                        for (i = itemBackpack.getSize(backpack); i < itemBackpack.getSize(backpack) + 36; ++i) {
                            Slot tempSlot = container.func_75139_a(i);
                            if (tempSlot == null || !tempSlot.func_75216_d()) continue;
                            ItemStack tempItem = tempSlot.func_75211_c();
                            if (!IronBackpacksHelper.areItemsEqualForStacking(toResupply, restockerItem) || !IronBackpacksHelper.areItemsEqualAndStackable(tempItem, restockerItem)) continue;
                            foundSlot = true;
                            slotToResupply = tempSlot;
                            stackToResupply = tempItem;
                            break;
                        }
                    }
                    if (!foundSlot) continue;
                    for (i = 0; i < itemBackpack.getSize(backpack); ++i) {
                        ItemStack backpackItemStack;
                        Slot backpackSlot = container.func_75139_a(i);
                        if (backpackSlot == null || !backpackSlot.func_75216_d() || !IronBackpacksHelper.areItemsEqualForStacking(stackToResupply, backpackItemStack = backpackSlot.func_75211_c())) continue;
                        int amountToResupply = stackToResupply.func_77976_d() - (stackToResupply.field_77994_a - 1);
                        if (backpackItemStack.field_77994_a >= amountToResupply) {
                            backpackSlot.func_75209_a(amountToResupply);
                            container.sort();
                            container.func_75134_a(player);
                            return new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d(), stackToResupply.func_77952_i());
                        }
                        backpackSlot.func_75209_a(backpackItemStack.field_77994_a);
                        container.sort();
                        container.func_75134_a(player);
                        return new ItemStack(stackToResupply.func_77973_b(), stackToResupply.field_77994_a + backpackItemStack.field_77994_a, stackToResupply.func_77952_i());
                    }
                }
            }
        }
        return null;
    }

    protected static ImmutablePair<ItemStack, Slot> checkRestockerUpgradeArrowLoose(EntityPlayer player, ArrayList<ItemStack> backpackStacks) {
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                ItemBackpack itemBackpack = (ItemBackpack)backpack.func_77973_b();
                ContainerBackpack container = new ContainerBackpack(new InventoryBackpack(player, backpack));
                if (player.field_71070_bA instanceof ContainerBackpack) continue;
                container.sort();
                ArrayList<ItemStack> restockerItems = UpgradeMethods.getRestockingItems(backpack);
                for (ItemStack restockerItem : restockerItems) {
                    int i;
                    if (restockerItem == null || !(restockerItem.func_77973_b() instanceof ItemArrow) && !restockerItem.func_77973_b().getClass().isAssignableFrom(ItemArrow.class)) continue;
                    boolean foundSlot = false;
                    ItemStack stackToResupply = null;
                    Slot slotToResupply = null;
                    for (i = itemBackpack.getSize(backpack); i < itemBackpack.getSize(backpack) + 36; ++i) {
                        ItemStack tempItem;
                        Slot tempSlot = container.func_75139_a(i);
                        if (tempSlot == null || !tempSlot.func_75216_d() || !((tempItem = tempSlot.func_75211_c()).func_77973_b() instanceof ItemArrow) || !IronBackpacksHelper.areItemsEqualForStacking(tempItem, restockerItem) || !IronBackpacksHelper.areItemsEqualAndStackable(tempItem, restockerItem)) continue;
                        foundSlot = true;
                        slotToResupply = tempSlot;
                        stackToResupply = tempItem;
                        break;
                    }
                    if (!foundSlot) continue;
                    for (i = 0; i < itemBackpack.getSize(backpack); ++i) {
                        ItemStack backpackItemStack;
                        Slot backpackSlot = container.func_75139_a(i);
                        if (backpackSlot == null || !backpackSlot.func_75216_d() || !IronBackpacksHelper.areItemsEqualForStacking(stackToResupply, backpackItemStack = backpackSlot.func_75211_c())) continue;
                        int amountToResupply = stackToResupply.func_77976_d() - (stackToResupply.field_77994_a - 1);
                        if (backpackItemStack.field_77994_a >= amountToResupply) {
                            backpackSlot.func_75209_a(amountToResupply);
                            container.sort();
                            container.func_75134_a(player);
                            ItemStack stackToReturn = stackToResupply.func_77946_l();
                            stackToReturn.field_77994_a = stackToResupply.func_77976_d();
                            return new ImmutablePair((Object)stackToReturn, (Object)slotToResupply);
                        }
                        backpackSlot.func_75209_a(backpackItemStack.field_77994_a);
                        container.sort();
                        container.func_75134_a(player);
                        ItemStack stackToReturn = stackToResupply.func_77946_l();
                        stackToReturn.field_77994_a = stackToResupply.field_77994_a + backpackItemStack.field_77994_a;
                        return new ImmutablePair((Object)stackToReturn, (Object)slotToResupply);
                    }
                }
            }
        }
        return null;
    }

    protected static void checkCrafterUpgrade(EntityItemPickupEvent event, ArrayList<ItemStack> backpackStacks, int craftingGridDiameterToFill) {
        boolean shouldSave = false;
        if (!backpackStacks.isEmpty()) {
            CraftingManager craftingManager = CraftingManager.func_77594_a();
            for (ItemStack backpack : backpackStacks) {
                ArrayList<ItemStack> crafterItems;
                shouldSave = false;
                if (event.getEntityPlayer().field_71070_bA instanceof ContainerBackpack) continue;
                ItemBackpack itemBackpack = (ItemBackpack)backpack.func_77973_b();
                ContainerBackpack container = new ContainerBackpack(new InventoryBackpack(event.getEntityPlayer(), backpack));
                container.sort();
                if (container.getInventoryBackpack().func_70301_a(container.getInventoryBackpack().func_70302_i_()) != null) break;
                ContainerWorkbench containerWorkbench = new ContainerWorkbench(event.getEntityPlayer().field_71071_by, event.getItem().field_70170_p, new BlockPos(0, 0, 0));
                InventoryCrafting inventoryCrafting = new InventoryCrafting((Container)containerWorkbench, 3, 3);
                switch (craftingGridDiameterToFill) {
                    case 1: {
                        crafterItems = UpgradeMethods.getCrafterTinyItems(backpack);
                        break;
                    }
                    case 2: {
                        crafterItems = UpgradeMethods.getCrafterSmallItems(backpack);
                        break;
                    }
                    case 3: {
                        crafterItems = UpgradeMethods.getCrafterItems(backpack);
                        break;
                    }
                    default: {
                        crafterItems = UpgradeMethods.getCrafterItems(backpack);
                        Logger.error("IronBackpacks CraftingUpgrade Error, will probably give the wrong output");
                    }
                }
                for (ItemStack crafterItem : crafterItems) {
                    if (crafterItem == null) continue;
                    block7: for (int index = 0; index < itemBackpack.getSize(backpack); ++index) {
                        ItemStack theStack;
                        Slot theSlot = container.func_75139_a(index);
                        if (theSlot == null || !theSlot.func_75216_d() || (theStack = theSlot.func_75211_c()) == null || theStack.field_77994_a < craftingGridDiameterToFill * craftingGridDiameterToFill || !IronBackpacksHelper.areItemsEqualForStacking(theStack, crafterItem)) continue;
                        ItemStack myStack = new ItemStack(theStack.func_77973_b(), 1, theStack.func_77952_i());
                        if (craftingGridDiameterToFill == 2) {
                            inventoryCrafting.func_70299_a(0, myStack);
                            inventoryCrafting.func_70299_a(1, myStack);
                            inventoryCrafting.func_70299_a(3, myStack);
                            inventoryCrafting.func_70299_a(4, myStack);
                        } else {
                            for (int i = 0; i < craftingGridDiameterToFill * craftingGridDiameterToFill; ++i) {
                                inventoryCrafting.func_70299_a(i, myStack);
                            }
                        }
                        ItemStack recipeOutput = craftingManager.func_82787_a(inventoryCrafting, event.getItem().field_70170_p);
                        if (recipeOutput == null) continue;
                        shouldSave = true;
                        int numberOfIterations = (int)Math.floor(theStack.field_77994_a / (craftingGridDiameterToFill * craftingGridDiameterToFill));
                        int numberOfItems = recipeOutput.field_77994_a * numberOfIterations;
                        if (numberOfItems > 64) {
                            ItemStack myRecipeOutput;
                            ItemStack stack;
                            for (int i = 0; i < numberOfIterations && (stack = container.transferStackInSlot(myRecipeOutput = new ItemStack(recipeOutput.func_77973_b(), recipeOutput.field_77994_a, recipeOutput.func_77952_i()))) != null; ++i) {
                                if (stack.field_77994_a != 0) {
                                    Slot slot = container.func_75139_a(itemBackpack.getSize(backpack) - 1);
                                    slot.func_75215_d(new ItemStack(recipeOutput.func_77973_b(), recipeOutput.func_77976_d() - (recipeOutput.field_77994_a - stack.field_77994_a), recipeOutput.func_77952_i()));
                                    continue block7;
                                }
                                theSlot.func_75209_a(1);
                            }
                            continue;
                        }
                        ItemStack myRecipeOutput = new ItemStack(recipeOutput.func_77973_b(), numberOfItems, recipeOutput.func_77952_i());
                        if (container.transferStackInSlot(myRecipeOutput) != null) {
                            theSlot.func_75209_a(theStack.field_77994_a - theStack.field_77994_a % (craftingGridDiameterToFill * craftingGridDiameterToFill));
                        }
                        container.save(event.getEntityPlayer());
                    }
                }
                if (!shouldSave) continue;
                container.sort();
                container.func_75134_a(event.getEntityPlayer());
            }
        }
    }

    protected static void checkFilterUpgrade(EntityItemPickupEvent event, ArrayList<ItemStack> backpackStacks) {
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                ContainerBackpack container = new ContainerBackpack(new InventoryBackpack(event.getEntityPlayer(), backpack));
                if (event.getEntityPlayer().field_71070_bA instanceof ContainerBackpack) continue;
                ArrayList<ItemStack> upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(backpack);
                if (UpgradeMethods.hasFilterBasicUpgrade(upgrades)) {
                    IronBackpacksEventHelper.transferWithBasicFilter(UpgradeMethods.getBasicFilterItems(backpack), event, container);
                }
                if (UpgradeMethods.hasFilterModSpecificUpgrade(upgrades)) {
                    IronBackpacksEventHelper.transferWithModSpecificFilter(UpgradeMethods.getModSpecificFilterItems(backpack), event, container);
                }
                if (UpgradeMethods.hasFilterFuzzyUpgrade(upgrades)) {
                    IronBackpacksEventHelper.transferWithFuzzyFilter(UpgradeMethods.getFuzzyFilterItems(backpack), event, container);
                }
                if (UpgradeMethods.hasFilterOreDictUpgrade(upgrades)) {
                    IronBackpacksEventHelper.transferWithOreDictFilter(UpgradeMethods.getOreDictFilterItems(backpack), IronBackpacksEventHelper.getOreDict(event.getItem().func_92059_d()), event, container);
                }
                if (UpgradeMethods.hasFilterVoidUpgrade(upgrades)) {
                    IronBackpacksEventHelper.deleteWithVoidFilter(UpgradeMethods.getVoidFilterItems(backpack), event);
                }
                if (UpgradeMethods.hasFilterAdvancedUpgrade(upgrades)) {
                    ItemStack[] advFilterItems = UpgradeMethods.getAdvFilterAllItems(backpack);
                    byte[] advFilterButtonStates = UpgradeMethods.getAdvFilterButtonStates(backpack);
                    IronBackpacksEventHelper.transferWithBasicFilter(UpgradeMethods.getAdvFilterBasicItems(advFilterItems, advFilterButtonStates), event, container);
                    IronBackpacksEventHelper.transferWithModSpecificFilter(UpgradeMethods.getAdvFilterModSpecificItems(advFilterItems, advFilterButtonStates), event, container);
                    IronBackpacksEventHelper.transferWithFuzzyFilter(UpgradeMethods.getAdvFilterFuzzyItems(advFilterItems, advFilterButtonStates), event, container);
                    IronBackpacksEventHelper.transferWithOreDictFilter(UpgradeMethods.getAdvFilterOreDictItems(advFilterItems, advFilterButtonStates), IronBackpacksEventHelper.getOreDict(event.getItem().func_92059_d()), event, container);
                    IronBackpacksEventHelper.deleteWithVoidFilter(UpgradeMethods.getAdvFilterVoidItems(advFilterItems, advFilterButtonStates), event);
                }
                if (!UpgradeMethods.hasFilterMiningUpgrade(upgrades)) continue;
                IronBackpacksEventHelper.transferWithMiningFilter(UpgradeMethods.getMiningFilterItems(backpack), IronBackpacksEventHelper.getOreDict(event.getItem().func_92059_d()), event, container);
            }
        }
    }

    private static void transferWithBasicFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event, ContainerBackpack container) {
        boolean shouldSave = false;
        for (ItemStack filterItem : filterItems) {
            ItemStack returned;
            if (filterItem == null || !IronBackpacksHelper.areItemsEqualForStacking(event.getItem().func_92059_d(), filterItem) || (returned = container.transferStackInSlot(event.getItem().func_92059_d())) == null) continue;
            shouldSave = true;
        }
        if (shouldSave) {
            IronBackpacksEventHelper.playItemPickupSound(event);
            container.func_75134_a(event.getEntityPlayer());
        }
    }

    private static void transferWithFuzzyFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event, ContainerBackpack container) {
        boolean shouldSave = false;
        for (ItemStack filterItem : filterItems) {
            ItemStack returned;
            if (filterItem == null || event.getItem().func_92059_d().func_77973_b() != filterItem.func_77973_b() || (returned = container.transferStackInSlot(event.getItem().func_92059_d())) == null) continue;
            shouldSave = true;
        }
        if (shouldSave) {
            IronBackpacksEventHelper.playItemPickupSound(event);
            container.func_75134_a(event.getEntityPlayer());
        }
    }

    private static void transferWithOreDictFilter(ArrayList<ItemStack> filterItems, ArrayList<String> itemEntityOre, EntityItemPickupEvent event, ContainerBackpack container) {
        boolean shouldSave = false;
        for (ItemStack filterItem : filterItems) {
            if (filterItem == null) continue;
            ArrayList<String> filterItemOre = IronBackpacksEventHelper.getOreDict(filterItem);
            if (itemEntityOre == null || filterItemOre == null) continue;
            for (String oreName : itemEntityOre) {
                ItemStack returned;
                if (oreName == null || !filterItemOre.contains(oreName) || (returned = container.transferStackInSlot(event.getItem().func_92059_d())) == null) continue;
                shouldSave = true;
            }
        }
        if (shouldSave) {
            IronBackpacksEventHelper.playItemPickupSound(event);
            container.func_75134_a(event.getEntityPlayer());
        }
    }

    private static void transferWithModSpecificFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event, ContainerBackpack container) {
        boolean shouldSave = false;
        for (ItemStack filterItem : filterItems) {
            ItemStack returned;
            if (filterItem == null || !event.getItem().func_92059_d().func_77973_b().getRegistryName().func_110624_b().equals(filterItem.func_77973_b().getRegistryName().func_110624_b()) || (returned = container.transferStackInSlot(event.getItem().func_92059_d())) == null) continue;
            shouldSave = true;
        }
        if (shouldSave) {
            IronBackpacksEventHelper.playItemPickupSound(event);
            container.func_75134_a(event.getEntityPlayer());
        }
    }

    private static void transferWithMiningFilter(ArrayList<ItemStack> filterItems, ArrayList<String> itemEntityOre, EntityItemPickupEvent event, ContainerBackpack container) {
        boolean shouldSave = false;
        filterItems.add(new ItemStack(Items.field_151044_h, 1, 0));
        IronBackpacksEventHelper.addWhitelistEntriesToFilterItems(filterItems);
        IronBackpacksEventHelper.transferWithBasicFilter(filterItems, event, container);
        if (itemEntityOre != null) {
            for (String oreName : itemEntityOre) {
                ItemStack returned;
                if (oreName == null || !oreName.startsWith("ore") && !oreName.startsWith("gem") && !oreName.startsWith("dust") || (returned = container.transferStackInSlot(event.getItem().func_92059_d())) == null) continue;
                shouldSave = true;
            }
        }
        if (shouldSave) {
            IronBackpacksEventHelper.playItemPickupSound(event);
            container.func_75134_a(event.getEntityPlayer());
        }
    }

    private static void deleteWithVoidFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event) {
        for (ItemStack stack : filterItems) {
            if (stack == null || event.getItem().func_92059_d().func_77973_b() != stack.func_77973_b()) continue;
            event.getItem().func_70106_y();
            event.getItem().func_70071_h_();
            event.setCanceled(true);
        }
    }

    private static ArrayList<String> getOreDict(ItemStack itemStack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)itemStack);
        ArrayList<String> retList = new ArrayList<String>();
        if (ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0 && !retList.contains(OreDictionary.getOreName((int)ids[i]))) {
                    retList.add(OreDictionary.getOreName((int)ids[i]));
                    continue;
                }
                retList.add(OreDictionary.getOreName((int)ids[i]));
            }
        }
        return retList.isEmpty() ? null : retList;
    }

    private static ArrayList<ItemStack> addWhitelistEntriesToFilterItems(ArrayList<ItemStack> filterItems) {
        String[] whitelistEntries;
        for (String entry : whitelistEntries = ConfigHandler.filterMiningUpgradeWhitelist) {
            ItemStack stack = IronBackpacksEventHelper.getItemStackFromString(entry);
            if (stack == null) continue;
            filterItems.add(stack);
        }
        return filterItems;
    }

    private static ItemStack getItemStackFromString(String str) {
        Item item;
        int size;
        Matcher matcher = pattern.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        String itemString = matcher.group("item");
        if (itemString == null) {
            return null;
        }
        String modid = matcher.group("modid");
        if (modid == null) {
            modid = "minecraft";
        }
        int damage = 0;
        String strDamage = matcher.group("damage");
        if (strDamage != null) {
            damage = strDamage.equals("*") ? Short.MAX_VALUE : Integer.parseInt(matcher.group("damage"));
        }
        int n = size = matcher.group("size") == null ? 1 : Integer.parseInt(matcher.group("size"));
        if (size == 0) {
            size = 1;
        }
        if ((item = Item.func_111206_d((String)(modid + ":" + itemString))) == null) {
            return null;
        }
        return new ItemStack(item, size, damage);
    }

    private static void playItemPickupSound(EntityItemPickupEvent event) {
        Random random = new Random();
        EntityPlayerMP playerMP = (EntityPlayerMP)event.getEntityPlayer();
        playerMP.field_71135_a.func_147359_a((Packet)new SPacketCustomSound("minecraft:entity.item.pickup", SoundCategory.PLAYERS, playerMP.func_174791_d().field_72450_a, playerMP.func_174791_d().field_72448_b, playerMP.func_174791_d().field_72449_c, 0.3f, ((random.nextFloat() - random.nextFloat()) * 0.7f + 1.0f) * 2.0f));
    }

    public static void handleIndirectRestock(EntityPlayer player, ArrayList<ItemStack> backpackStacks, ItemStack toResupply) {
        int playerSlotIndexToRestockTo = 0;
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                ItemBackpack itemBackpack = (ItemBackpack)backpack.func_77973_b();
                ContainerBackpack container = new ContainerBackpack(new InventoryBackpack(player, backpack));
                if (player.field_71070_bA instanceof ContainerBackpack) continue;
                ArrayList<ItemStack> restockerItems = UpgradeMethods.getRestockingItems(backpack);
                for (ItemStack restockerItem : restockerItems) {
                    int i;
                    boolean foundSlot = false;
                    boolean useOffhand = false;
                    if (restockerItem == null || !IronBackpacksHelper.areItemsEqualAndStackable(toResupply, restockerItem)) continue;
                    if (IronBackpacksEventHelper.sameItemForRestocking(player.field_71071_by.field_184439_c[0], restockerItem)) {
                        foundSlot = true;
                        useOffhand = true;
                    } else {
                        for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                            if (!IronBackpacksEventHelper.sameItemForRestocking(player.field_71071_by.func_70301_a(i), restockerItem)) continue;
                            foundSlot = true;
                            playerSlotIndexToRestockTo = i;
                            break;
                        }
                    }
                    if (!foundSlot) continue;
                    for (i = 0; i < itemBackpack.getSize(backpack); ++i) {
                        ItemStack backpackItemStack;
                        Slot backpackSlot = container.func_75139_a(i);
                        if (backpackSlot == null || !backpackSlot.func_75216_d() || !IronBackpacksHelper.areItemsEqualAndStackable(useOffhand ? player.field_71071_by.field_184439_c[0] : player.field_71071_by.field_70462_a[playerSlotIndexToRestockTo], backpackItemStack = backpackSlot.func_75211_c())) continue;
                        ItemStack stackToResupply = useOffhand ? player.field_71071_by.field_184439_c[0] : player.field_71071_by.field_70462_a[playerSlotIndexToRestockTo];
                        int amountToResupply = stackToResupply.func_77976_d() - stackToResupply.field_77994_a;
                        if (backpackItemStack.field_77994_a >= amountToResupply) {
                            backpackSlot.func_75209_a(amountToResupply);
                            container.func_75134_a(player);
                            if (useOffhand) {
                                player.field_71071_by.field_184439_c[0].field_77994_a = stackToResupply.func_77976_d();
                            } else {
                                player.field_71071_by.field_70462_a[playerSlotIndexToRestockTo].field_77994_a = stackToResupply.func_77976_d();
                            }
                            player.field_71071_by.func_70296_d();
                            return;
                        }
                        backpackSlot.func_75209_a(backpackItemStack.field_77994_a);
                        container.func_75134_a(player);
                        if (useOffhand) {
                            player.field_71071_by.field_184439_c[0].field_77994_a += backpackItemStack.field_77994_a;
                        } else {
                            player.field_71071_by.field_70462_a[playerSlotIndexToRestockTo].field_77994_a += backpackItemStack.field_77994_a;
                        }
                        player.field_71071_by.func_70296_d();
                    }
                }
            }
        }
    }

    public static void handleDirectRestock(EntityPlayer player, ArrayList<ItemStack> backpackStacks, ItemStack toResupply, boolean preEvent) {
        int extraCost;
        int n = extraCost = preEvent ? 1 : 0;
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                ItemBackpack itemBackpack = (ItemBackpack)backpack.func_77973_b();
                ContainerBackpack container = new ContainerBackpack(new InventoryBackpack(player, backpack));
                if (player.field_71070_bA instanceof ContainerBackpack) continue;
                ArrayList<ItemStack> restockerItems = UpgradeMethods.getRestockingItems(backpack);
                for (ItemStack restockerItem : restockerItems) {
                    boolean foundSlot = false;
                    boolean useOffhand = false;
                    if (restockerItem == null || !IronBackpacksHelper.areItemsEqualAndStackable(toResupply, restockerItem)) continue;
                    if (IronBackpacksEventHelper.sameItemForRestocking(player.func_184582_a(EntityEquipmentSlot.OFFHAND), restockerItem)) {
                        foundSlot = true;
                        useOffhand = true;
                    } else if (IronBackpacksEventHelper.sameItemForRestocking(player.func_184582_a(EntityEquipmentSlot.MAINHAND), restockerItem)) {
                        foundSlot = true;
                        useOffhand = false;
                    } else {
                        Logger.warn("Error with restocking. Please create a bug report detailing your actions on Github.");
                    }
                    if (!foundSlot) continue;
                    boolean firstRestock = true;
                    for (int i = 0; i < itemBackpack.getSize(backpack); ++i) {
                        ItemStack copy;
                        ItemStack stackToResupply;
                        ItemStack backpackItemStack;
                        Slot backpackSlot = container.func_75139_a(i);
                        if (backpackSlot == null || !backpackSlot.func_75216_d() || !IronBackpacksHelper.areItemsEqualAndStackable(useOffhand ? player.func_184582_a(EntityEquipmentSlot.OFFHAND) : player.func_184582_a(EntityEquipmentSlot.MAINHAND), backpackItemStack = backpackSlot.func_75211_c())) continue;
                        ItemStack itemStack = stackToResupply = useOffhand ? player.func_184582_a(EntityEquipmentSlot.OFFHAND) : player.func_184582_a(EntityEquipmentSlot.MAINHAND);
                        if (stackToResupply.field_77994_a + backpackItemStack.field_77994_a >= stackToResupply.func_77976_d()) {
                            backpackSlot.func_75209_a(stackToResupply.func_77976_d() - stackToResupply.field_77994_a + extraCost);
                            container.func_75134_a(player);
                            copy = stackToResupply.func_77946_l();
                            copy.field_77994_a = copy.func_77976_d();
                            if (useOffhand) {
                                player.func_184201_a(EntityEquipmentSlot.OFFHAND, copy);
                            } else {
                                player.func_184201_a(EntityEquipmentSlot.MAINHAND, copy);
                            }
                            player.field_71071_by.func_70296_d();
                            return;
                        }
                        backpackSlot.func_75209_a(backpackItemStack.field_77994_a);
                        container.func_75134_a(player);
                        copy = stackToResupply.func_77946_l();
                        copy.field_77994_a += backpackItemStack.field_77994_a;
                        if (firstRestock) {
                            copy.field_77994_a -= extraCost;
                        }
                        if (useOffhand) {
                            player.func_184201_a(EntityEquipmentSlot.OFFHAND, copy);
                        } else {
                            player.func_184201_a(EntityEquipmentSlot.MAINHAND, copy);
                        }
                        player.field_71071_by.func_70296_d();
                        firstRestock = false;
                    }
                }
            }
        }
    }

    private static boolean sameItemForRestocking(ItemStack toFill, ItemStack toSupply) {
        if (toFill != null && toSupply != null) {
            return IronBackpacksHelper.areItemsEqualAndStackable(toFill, toSupply);
        }
        return false;
    }
}

