/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.container.alternateGui;

import gr8pefish.ironbackpacks.api.client.gui.button.ButtonNames;
import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IBackpack;
import gr8pefish.ironbackpacks.api.items.upgrades.ItemIConfigurableUpgrade;
import gr8pefish.ironbackpacks.api.register.ItemIUpgradeRegistry;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.container.slot.BackpackSlot;
import gr8pefish.ironbackpacks.container.slot.NestingBackpackSlot;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import gr8pefish.ironbackpacks.items.upgrades.UpgradeMethods;
import gr8pefish.ironbackpacks.registry.GuiButtonRegistry;
import gr8pefish.ironbackpacks.registry.ItemRegistry;
import gr8pefish.ironbackpacks.util.Logger;
import gr8pefish.ironbackpacks.util.NBTUtils;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryAlternateGui
implements IInventory {
    private ItemStack backpackStack;
    private EntityPlayer player;
    private ItemStack[] inventory;
    private ArrayList<ItemStack> upgrades;
    private int invSize;
    protected ItemStack[] advFilterStacks;
    protected byte[] advFilterButtonStates;
    protected int advFilterButtonStartPoint;

    public InventoryAlternateGui(EntityPlayer player, ItemStack backpackStack) {
        this.backpackStack = backpackStack;
        this.player = player;
        this.upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(backpackStack);
        this.invSize = UpgradeMethods.getAlternateGuiUpgradeSlots(this.upgrades);
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.advFilterButtonStates = new byte[18];
        Arrays.fill(this.advFilterButtonStates, (byte)GuiButtonRegistry.getButton(ButtonNames.EXACT).getId());
        this.advFilterButtonStartPoint = 0;
        this.advFilterStacks = new ItemStack[18];
        this.readFromNBT(backpackStack.func_77978_p());
    }

    public int getAdvFilterButtonStartPoint() {
        return this.advFilterButtonStartPoint;
    }

    public byte[] getAdvFilterButtonStates() {
        return this.advFilterButtonStates;
    }

    public ItemStack getBackpackStack() {
        return this.backpackStack;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public int func_70302_i_() {
        return this.invSize;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return slotIndex >= this.func_70302_i_() || slotIndex < 0 ? null : this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (this.inventory[slotIndex] != null) {
            if (this.inventory[slotIndex].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slotIndex];
                this.inventory[slotIndex] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[slotIndex].func_77979_a(amount);
            if (this.inventory[slotIndex].field_77994_a == 0) {
                this.inventory[slotIndex] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (slotIndex >= 0 && slotIndex < this.inventory.length) {
            this.inventory[slotIndex] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_70005_c_() {
        return ((ItemBackpack)this.backpackStack.func_77973_b()).getName(this.backpackStack);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = null;
        if (this.inventory[index] != null) {
            stack = this.inventory[index];
            this.inventory[index] = null;
        }
        return stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack itemStack) {
        if (UpgradeMethods.hasFilterBasicUpgrade(this.upgrades) || UpgradeMethods.hasFilterFuzzyUpgrade(this.upgrades) || UpgradeMethods.hasFilterModSpecificUpgrade(this.upgrades) || UpgradeMethods.hasFilterOreDictUpgrade(this.upgrades) || UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades) || UpgradeMethods.hasFilterMiningUpgrade(this.upgrades) || UpgradeMethods.hasFilterVoidUpgrade(this.upgrades)) {
            if (UpgradeMethods.hasNestingUpgrade(this.upgrades)) {
                NestingBackpackSlot myslot = new NestingBackpackSlot(this, index, 0, 0, this.backpackStack);
                return myslot.acceptsStack(itemStack);
            }
            BackpackSlot mySlot = new BackpackSlot(this, index, 0, 0);
            return mySlot.acceptsStack(itemStack);
        }
        if (UpgradeMethods.hasRestockingUpgrade(this.upgrades)) {
            return itemStack.func_77985_e();
        }
        if (UpgradeMethods.hasCraftingTinyUpgrade(this.upgrades)) {
            return itemStack.func_77985_e();
        }
        if (UpgradeMethods.hasCraftingSmallUpgrade(this.upgrades)) {
            return itemStack.func_77985_e();
        }
        if (UpgradeMethods.hasCraftingUpgrade(this.upgrades)) {
            return itemStack.func_77985_e();
        }
        Logger.error("Impossible error in isItemValidForSlot in InventoryAlternateGui");
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    public void setAdvFilterButtonType(int index, int typeToSetTo) {
        this.advFilterButtonStates[index] = (byte)typeToSetTo;
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        if (this.backpackStack != null) {
            this.save();
        }
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.backpackStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
        }
        this.writeToNBT(nbtTagCompound);
        this.backpackStack.func_77982_d(nbtTagCompound);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound tagCompound;
        int i;
        NBTTagList tagList;
        nbtTagCompound = this.findParentItemStack(this.player).func_77978_p();
        if (nbtTagCompound == null) {
            Logger.warn("Error saving in inventory alternate gui.");
        }
        int startIndex = 0;
        if (UpgradeMethods.hasCraftingUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("Condenser", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasCraftingSmallUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("CondenserSmall", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasCraftingTinyUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("CondenserTiny", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasFilterBasicUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterBasic", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasFilterFuzzyUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterFuzzy", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasFilterOreDictUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterOreDict", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasFilterModSpecificUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterModSpecific", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasFilterVoidUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (i = startIndex; i < startIndex + 9; ++i) {
                if (this.inventory[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterVoid", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades)) {
            NBTTagList tagListAllSlots = new NBTTagList();
            for (i = 0; i < 18; ++i) {
                if (this.advFilterStacks[i] == null) continue;
                tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.advFilterStacks[i].func_77955_b(tagCompound);
                tagListAllSlots.func_74742_a((NBTBase)tagCompound);
            }
            byte[] byteArray = new byte[18];
            for (int i2 = 0; i2 < 18; ++i2) {
                byteArray[i2] = this.advFilterButtonStates[i2];
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterAdvAllSlots", (NBTBase)tagListAllSlots);
            nbtTagCompound.func_74782_a("FilterAdvButtons", (NBTBase)new NBTTagByteArray(byteArray));
            nbtTagCompound.func_74782_a("FilterAdvStart", (NBTBase)new NBTTagByte((byte)this.advFilterButtonStartPoint));
        }
        if (UpgradeMethods.hasFilterMiningUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (int i3 = startIndex; i3 < startIndex + 9; ++i3) {
                if (this.inventory[i3] == null) continue;
                NBTTagCompound tagCompound2 = new NBTTagCompound();
                tagCompound2.func_74774_a("Slot", (byte)i3);
                this.inventory[i3].func_77955_b(tagCompound2);
                tagList.func_74742_a((NBTBase)tagCompound2);
            }
            startIndex += 9;
            nbtTagCompound.func_74782_a("FilterMining", (NBTBase)tagList);
        }
        if (UpgradeMethods.hasRestockingUpgrade(this.upgrades)) {
            tagList = new NBTTagList();
            for (int i4 = startIndex; i4 < startIndex + 9; ++i4) {
                if (this.inventory[i4] == null) continue;
                NBTTagCompound tagCompound3 = new NBTTagCompound();
                tagCompound3.func_74774_a("Slot", (byte)i4);
                this.inventory[i4].func_77955_b(tagCompound3);
                tagList.func_74742_a((NBTBase)tagCompound3);
            }
            nbtTagCompound.func_74782_a("Hopper", (NBTBase)tagList);
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.backpackStack = this.findParentItemStack(this.player);
        if (this.backpackStack != null && (nbtTagCompound = this.backpackStack.func_77978_p()) != null) {
            NBTTagCompound stackTag;
            NBTTagList tagList;
            this.inventory = new ItemStack[this.func_70302_i_()];
            boolean hasUpgradeRemoved = false;
            int indexRemoved = 0;
            if (nbtTagCompound.func_74764_b("RemovedAltGui")) {
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound.func_74775_l("RemovedAltGui"));
                ItemIConfigurableUpgrade altGuiUpgrade = ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack);
                indexRemoved = ItemIUpgradeRegistry.getUninflatedIndexOfConfigurableUpgrade(altGuiUpgrade);
                hasUpgradeRemoved = true;
                nbtTagCompound.func_82580_o("RemovedAltGui");
            }
            boolean hasUpgradeAdded = false;
            int indexAdded = 0;
            if (nbtTagCompound.func_74764_b("AddedAltGui")) {
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound.func_74775_l("AddedAltGui"));
                ItemIConfigurableUpgrade altGuiUpgrade = ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack);
                indexAdded = ItemIUpgradeRegistry.getUninflatedIndexOfConfigurableUpgrade(altGuiUpgrade);
                hasUpgradeAdded = true;
                nbtTagCompound.func_82580_o("AddedAltGui");
            }
            if (!UpgradeMethods.hasCraftingUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("Condenser");
            }
            if (nbtTagCompound.func_74764_b("Condenser")) {
                tagList = nbtTagCompound.func_150295_c("Condenser", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    stackTag = tagList.func_150305_b(i);
                    byte j = stackTag.func_74771_c("Slot");
                    if (i < 0 || i > 9) continue;
                    this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                }
            }
            if (!UpgradeMethods.hasCraftingSmallUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("CondenserSmall");
            }
            if (nbtTagCompound.func_74764_b("CondenserSmall")) {
                tagList = nbtTagCompound.func_150295_c("CondenserSmall", 10);
                this.loadStacksWithShifting(tagList, hasUpgradeRemoved, indexRemoved, hasUpgradeAdded, indexAdded, ItemRegistry.craftingSmallUpgrade);
            }
            if (!UpgradeMethods.hasCraftingTinyUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("CondenserTiny");
            }
            if (nbtTagCompound.func_74764_b("CondenserTiny")) {
                tagList = nbtTagCompound.func_150295_c("CondenserTiny", 10);
                this.loadStacksWithShifting(tagList, hasUpgradeRemoved, indexRemoved, hasUpgradeAdded, indexAdded, ItemRegistry.craftingTinyUpgrade);
            }
            if (!UpgradeMethods.hasFilterBasicUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterBasic");
            }
            if (nbtTagCompound.func_74764_b("FilterBasic")) {
                tagList = nbtTagCompound.func_150295_c("FilterBasic", 10);
                this.loadStacksWithShifting(tagList, hasUpgradeRemoved, indexRemoved, hasUpgradeAdded, indexAdded, ItemRegistry.filterBasicUpgrade);
            }
            if (!UpgradeMethods.hasFilterFuzzyUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterFuzzy");
            }
            if (nbtTagCompound.func_74764_b("FilterFuzzy")) {
                tagList = nbtTagCompound.func_150295_c("FilterFuzzy", 10);
                this.loadStacksWithShifting(tagList, hasUpgradeRemoved, indexRemoved, hasUpgradeAdded, indexAdded, ItemRegistry.filterFuzzyUpgrade);
            }
            if (!UpgradeMethods.hasFilterOreDictUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterOreDict");
            }
            if (nbtTagCompound.func_74764_b("FilterOreDict")) {
                tagList = nbtTagCompound.func_150295_c("FilterOreDict", 10);
                this.loadStacksWithShifting(tagList, hasUpgradeRemoved, indexRemoved, hasUpgradeAdded, indexAdded, ItemRegistry.filterOreDictUpgrade);
            }
            if (!UpgradeMethods.hasFilterModSpecificUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterModSpecific");
            }
            if (nbtTagCompound.func_74764_b("FilterModSpecific")) {
                tagList = nbtTagCompound.func_150295_c("FilterModSpecific", 10);
                this.loadStacksWithShifting(tagList, hasUpgradeRemoved, indexRemoved, hasUpgradeAdded, indexAdded, ItemRegistry.filterModSpecificUpgrade);
            }
            if (!UpgradeMethods.hasFilterVoidUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterVoid");
            }
            if (nbtTagCompound.func_74764_b("FilterVoid")) {
                tagList = nbtTagCompound.func_150295_c("FilterVoid", 10);
                this.loadStacksWithShifting(tagList, hasUpgradeRemoved, indexRemoved, hasUpgradeAdded, indexAdded, ItemRegistry.filterVoidUpgrade);
            }
            if (!UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterAdvAllSlots");
                nbtTagCompound.func_82580_o("FilterAdvButtons");
                nbtTagCompound.func_82580_o("FilterAdvStart");
            } else {
                if (nbtTagCompound.func_74764_b("FilterAdvAllSlots")) {
                    tagList = nbtTagCompound.func_150295_c("FilterAdvAllSlots", 10);
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        stackTag = tagList.func_150305_b(i);
                        this.advFilterStacks[stackTag.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                    }
                }
                if (nbtTagCompound.func_74764_b("FilterAdvButtons")) {
                    byte[] bytes = ((NBTTagByteArray)nbtTagCompound.func_74781_a("FilterAdvButtons")).func_150292_c();
                    for (int i = 0; i < bytes.length; ++i) {
                        if (bytes[i] == 0) {
                            bytes[i] = (byte)GuiButtonRegistry.getButton(ButtonNames.EXACT).getId();
                        }
                        this.advFilterButtonStates[i] = bytes[i];
                    }
                }
                if (nbtTagCompound.func_74764_b("FilterAdvStart")) {
                    this.advFilterButtonStartPoint = nbtTagCompound.func_74771_c("FilterAdvStart");
                }
            }
            if (!UpgradeMethods.hasFilterMiningUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("FilterMining");
            }
            if (nbtTagCompound.func_74764_b("FilterMining")) {
                tagList = nbtTagCompound.func_150295_c("FilterMining", 10);
                this.loadStacksWithShifting(tagList, hasUpgradeRemoved, indexRemoved, hasUpgradeAdded, indexAdded, ItemRegistry.filterMiningUpgrade);
            }
            if (!UpgradeMethods.hasRestockingUpgrade(this.upgrades)) {
                nbtTagCompound.func_82580_o("Hopper");
            }
            if (nbtTagCompound.func_74764_b("Hopper")) {
                tagList = nbtTagCompound.func_150295_c("Hopper", 10);
                this.loadStacksWithShifting(tagList, hasUpgradeRemoved, indexRemoved, hasUpgradeAdded, indexAdded, ItemRegistry.restockingUpgrade);
            }
        }
    }

    private boolean shouldShiftAdded(boolean hasUpgradeAdded, int indexAdded, ItemIConfigurableUpgrade ItemIConfigurableUpgrade2) {
        return hasUpgradeAdded && indexAdded < ItemIUpgradeRegistry.getUninflatedIndexOfConfigurableUpgrade(ItemIConfigurableUpgrade2);
    }

    private boolean shouldShiftRemoved(boolean hasUpgradeRemoved, int indexRemoved, ItemIConfigurableUpgrade ItemIConfigurableUpgrade2) {
        return hasUpgradeRemoved && indexRemoved < ItemIUpgradeRegistry.getUninflatedIndexOfConfigurableUpgrade(ItemIConfigurableUpgrade2);
    }

    private void loadStacksWithShifting(NBTTagList tagList, boolean hasUpgradeRemoved, int indexRemoved, boolean hasUpgradeAdded, int indexAdded, ItemIConfigurableUpgrade ItemIConfigurableUpgrade2) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            int j;
            NBTTagCompound stackTag = tagList.func_150305_b(i);
            int n = j = this.shouldShiftRemoved(hasUpgradeRemoved, indexRemoved, ItemIConfigurableUpgrade2) ? stackTag.func_74771_c("Slot") - 9 : stackTag.func_74771_c("Slot");
            if (this.shouldShiftAdded(hasUpgradeAdded, indexAdded, ItemIConfigurableUpgrade2)) {
                j += 9;
            }
            if (i < 0 || i > 9) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
    }

    public ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (NBTUtils.hasUUID(this.backpackStack)) {
            UUID parentUUID = new UUID(this.backpackStack.func_77978_p().func_74763_f("MostSigUUID"), this.backpackStack.func_77978_p().func_74763_f("LeastSigUUID"));
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IBackpack) || !NBTUtils.hasUUID(itemStack) || itemStack.func_77978_p().func_74763_f("MostSigUUID") != parentUUID.getMostSignificantBits() || itemStack.func_77978_p().func_74763_f("LeastSigUUID") != parentUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
            ItemStack equipped = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)entityPlayer);
            if (equipped != null && equipped.func_77973_b() instanceof IBackpack && NBTUtils.hasUUID(equipped) && equipped.func_77978_p().func_74763_f("MostSigUUID") == parentUUID.getMostSignificantBits() && equipped.func_77978_p().func_74763_f("LeastSigUUID") == parentUUID.getLeastSignificantBits()) {
                return equipped;
            }
        }
        return null;
    }
}

