/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.capabilities.player;

import gr8pefish.ironbackpacks.capabilities.IronBackpacksCapabilities;
import java.util.concurrent.Callable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class PlayerWearingBackpackCapabilities
implements ICapabilitySerializable<NBTTagCompound> {
    public static final String CAP_PACK_TAG = "ironbackpacks";
    private ItemStack equippedBackpack = null;
    private ItemStack currentBackpack = null;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return IronBackpacksCapabilities.WEARING_BACKPACK_CAPABILITY != null && capability == IronBackpacksCapabilities.WEARING_BACKPACK_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(IronBackpacksCapabilities.WEARING_BACKPACK_CAPABILITY != null && capability == IronBackpacksCapabilities.WEARING_BACKPACK_CAPABILITY ? this : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList tagList = new NBTTagList();
        NBTTagCompound equipped = new NBTTagCompound();
        ItemStack equippedBackpack = this.getEquippedBackpack();
        if (equippedBackpack != null) {
            equippedBackpack.func_77955_b(equipped);
        } else {
            equipped.func_74757_a("noEquipped", false);
        }
        tagList.func_74742_a((NBTBase)equipped);
        NBTTagCompound current = new NBTTagCompound();
        ItemStack currentBackpack = this.getCurrentBackpack();
        if (currentBackpack != null) {
            currentBackpack.func_77955_b(current);
        } else {
            current.func_74757_a("noCurrent", false);
        }
        tagList.func_74742_a((NBTBase)current);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(CAP_PACK_TAG, (NBTBase)tagList);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        NBTTagList tagList = compound.func_150295_c(CAP_PACK_TAG, 10);
        if (!tagList.func_150305_b(0).func_74764_b("noEquipped")) {
            try {
                this.setEquippedBackpack(ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(0)));
            }
            catch (NullPointerException e) {
                this.setEquippedBackpack(null);
            }
        } else {
            this.setEquippedBackpack(null);
        }
        if (!tagList.func_150305_b(1).func_74764_b("noCurrent")) {
            try {
                this.setCurrentBackpack(ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(1)));
            }
            catch (NullPointerException e) {
                this.setCurrentBackpack(null);
            }
        } else {
            this.setCurrentBackpack(null);
        }
    }

    public ItemStack getEquippedBackpack() {
        return this.equippedBackpack;
    }

    public void setEquippedBackpack(ItemStack stack) {
        this.equippedBackpack = stack;
    }

    public ItemStack getCurrentBackpack() {
        return this.currentBackpack;
    }

    public void setCurrentBackpack(ItemStack stack) {
        this.currentBackpack = stack;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(PlayerWearingBackpackCapabilities.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
    }

    public static ItemStack getEquippedBackpack(EntityLivingBase livingBase) {
        PlayerWearingBackpackCapabilities cap = IronBackpacksCapabilities.getWearingBackpackCapability((EntityPlayer)livingBase);
        if (cap != null) {
            return cap.getEquippedBackpack();
        }
        return null;
    }

    public static void setEquippedBackpack(EntityLivingBase livingBase, ItemStack stack) {
        PlayerWearingBackpackCapabilities cap = IronBackpacksCapabilities.getWearingBackpackCapability((EntityPlayer)livingBase);
        if (cap != null) {
            cap.setEquippedBackpack(stack);
        }
    }

    public static ItemStack getCurrentBackpack(EntityLivingBase livingBase) {
        PlayerWearingBackpackCapabilities cap = IronBackpacksCapabilities.getWearingBackpackCapability((EntityPlayer)livingBase);
        if (cap != null) {
            return cap.getCurrentBackpack();
        }
        return null;
    }

    public static void setCurrentBackpack(EntityLivingBase livingBase, ItemStack stack) {
        PlayerWearingBackpackCapabilities cap = IronBackpacksCapabilities.getWearingBackpackCapability((EntityPlayer)livingBase);
        if (cap != null) {
            cap.setCurrentBackpack(stack);
        }
    }

    public static void reset(EntityLivingBase livingBase) {
        PlayerWearingBackpackCapabilities.setCurrentBackpack(livingBase, null);
        PlayerWearingBackpackCapabilities.setEquippedBackpack(livingBase, null);
    }

    public static class Factory
    implements Callable<PlayerWearingBackpackCapabilities> {
        @Override
        public PlayerWearingBackpackCapabilities call() throws Exception {
            return null;
        }
    }

    public static class Storage
    implements Capability.IStorage<PlayerWearingBackpackCapabilities> {
        public NBTBase writeNBT(Capability<PlayerWearingBackpackCapabilities> capability, PlayerWearingBackpackCapabilities instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<PlayerWearingBackpackCapabilities> capability, PlayerWearingBackpackCapabilities instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

