/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.capabilities.player;

import gr8pefish.ironbackpacks.capabilities.IronBackpacksCapabilities;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class PlayerDeathBackpackCapabilities
implements ICapabilitySerializable<NBTTagCompound> {
    public static final String CAP_DEATH_PACK_TAG = "ironbackpacks.death";
    private ArrayList<ItemStack> eternityPacks = new ArrayList();
    private ItemStack equippedBackpack = null;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return IronBackpacksCapabilities.DEATH_BACKPACK_CAPABILITY != null && capability == IronBackpacksCapabilities.DEATH_BACKPACK_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(IronBackpacksCapabilities.DEATH_BACKPACK_CAPABILITY != null && capability == IronBackpacksCapabilities.DEATH_BACKPACK_CAPABILITY ? this : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList tagList = new NBTTagList();
        NBTTagCompound equipped = new NBTTagCompound();
        if (this.equippedBackpack != null) {
            this.equippedBackpack.func_77955_b(equipped);
        } else {
            equipped.func_74757_a("noEquipped", false);
        }
        tagList.func_74742_a((NBTBase)equipped);
        if (this.eternityPacks != null && this.eternityPacks.size() > 0) {
            for (ItemStack pack : this.eternityPacks) {
                NBTTagCompound saved = new NBTTagCompound();
                pack.func_77955_b(saved);
                tagList.func_74742_a((NBTBase)saved);
            }
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(CAP_DEATH_PACK_TAG, (NBTBase)tagList);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        NBTTagList tagList = compound.func_150295_c(CAP_DEATH_PACK_TAG, 10);
        if (!tagList.func_150305_b(0).func_74764_b("noEquipped")) {
            try {
                this.equippedBackpack = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(0));
            }
            catch (NullPointerException e) {
                this.equippedBackpack = null;
            }
        } else {
            this.equippedBackpack = null;
        }
        if (tagList.func_74745_c() >= 1) {
            for (int i = 1; i < tagList.func_74745_c(); ++i) {
                if (tagList.func_150305_b(i) == null) continue;
                this.eternityPacks.add(ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i)));
            }
        }
    }

    public ItemStack getEquippedBackpack() {
        return this.equippedBackpack;
    }

    public void setEquippedBackpack(ItemStack stack) {
        this.equippedBackpack = stack;
    }

    public ArrayList<ItemStack> getEternityBackpacks() {
        return this.eternityPacks;
    }

    public void setEternityBackpacks(ArrayList<ItemStack> packs) {
        this.eternityPacks = packs;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(PlayerDeathBackpackCapabilities.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
    }

    public static ItemStack getEquippedBackpack(EntityLivingBase livingBase) {
        PlayerDeathBackpackCapabilities cap = IronBackpacksCapabilities.getDeathBackpackCapability((EntityPlayer)livingBase);
        if (cap != null) {
            return cap.getEquippedBackpack();
        }
        return null;
    }

    public static void setEquippedBackpack(EntityLivingBase livingBase, ItemStack stack) {
        PlayerDeathBackpackCapabilities cap = IronBackpacksCapabilities.getDeathBackpackCapability((EntityPlayer)livingBase);
        if (cap != null) {
            cap.setEquippedBackpack(stack);
        }
    }

    public static ArrayList<ItemStack> getEternityBackpacks(EntityLivingBase livingBase) {
        PlayerDeathBackpackCapabilities cap = IronBackpacksCapabilities.getDeathBackpackCapability((EntityPlayer)livingBase);
        if (cap != null) {
            return cap.getEternityBackpacks();
        }
        return null;
    }

    public static void setEternityBackpacks(EntityLivingBase livingBase, ArrayList<ItemStack> stacks) {
        PlayerDeathBackpackCapabilities cap = IronBackpacksCapabilities.getDeathBackpackCapability((EntityPlayer)livingBase);
        if (cap != null) {
            cap.setEternityBackpacks(stacks);
        }
    }

    public static void reset(EntityLivingBase livingBase) {
        PlayerDeathBackpackCapabilities.setEquippedBackpack(livingBase, null);
        PlayerDeathBackpackCapabilities.setEternityBackpacks(livingBase, new ArrayList<ItemStack>());
    }

    public static class Factory
    implements Callable<PlayerDeathBackpackCapabilities> {
        @Override
        public PlayerDeathBackpackCapabilities call() throws Exception {
            return null;
        }
    }

    public static class Storage
    implements Capability.IStorage<PlayerDeathBackpackCapabilities> {
        public NBTBase writeNBT(Capability<PlayerDeathBackpackCapabilities> capability, PlayerDeathBackpackCapabilities instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<PlayerDeathBackpackCapabilities> capability, PlayerDeathBackpackCapabilities instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

