/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.world.gen;

import com.dooglamoo.citiesmod.CitiesMod;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoubleStoneSlab;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCity
implements IWorldGenerator {
    private static final long SALT = 7374354L;
    private int chunkXBase = Integer.MAX_VALUE;
    private int chunkZBase = Integer.MAX_VALUE;
    private int city1X = Integer.MAX_VALUE;
    private int city1Z = Integer.MAX_VALUE;
    private int city2X = Integer.MAX_VALUE;
    private int city2Z = Integer.MAX_VALUE;
    private long seed;
    private static float WEB_CHANCE = 0.1f;
    public static float ironFrameChance = 1.0f;
    public static float streetLightChance = 0.3f;
    public static float glassInWindowChance = 0.8f;
    public static boolean spawnersInBuildings = true;
    public static boolean blazeSpawners = false;
    private static final byte NONE = 0;
    private static final byte ROAD = 1;
    private static final byte ROAD_RAIL = 3;
    private static final byte ROAD_DEPOT = 5;
    private static final byte NAN = -1;
    private static final byte AIR = 0;
    private static final byte RNS = 1;
    private static final byte REW = 2;
    private static final byte RNE = 3;
    private static final byte RNW = 4;
    private static final byte RSE = 5;
    private static final byte RSW = 6;
    private static final byte LNP = 7;
    private static final byte LSO = 8;
    private static final byte LEO = 9;
    private static final byte LWP = 10;
    private static final byte PLK = 11;
    private static final byte CBL = 12;
    private static final Block[] fence = new Block[]{Blocks.field_180407_aO, Blocks.field_180408_aP, Blocks.field_180404_aQ, Blocks.field_180403_aR, Blocks.field_180405_aT, Blocks.field_180406_aS};
    private final byte[][] scm = new byte[][]{{-1, -1, -1, -1, 11, 0, 0, 1, 1, 0, 0, 11, -1, -1, -1, -1}, {-1, -1, -1, -1, 11, 0, 0, 1, 1, 0, 0, 11, -1, -1, -1, -1}, {-1, -1, -1, -1, 11, 0, 0, 1, 1, 0, 0, 11, -1, -1, -1, -1}, {-1, -1, -1, -1, 11, 5, 2, 4, 1, 0, 0, 11, -1, -1, -1, -1}, {11, 11, 11, 11, 11, 1, 0, 0, 1, 0, 0, 11, 11, 11, 11, 11}, {0, 0, 0, 0, 0, 5, 2, 2, 4, 2, 6, 2, 6, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0, 10, 0, 1, 0, 1, 0, 0, 0}, {2, 2, 2, 2, 2, 6, 8, 12, 12, 0, 1, 0, 3, 2, 2, 2}, {2, 2, 2, 6, 0, 1, 0, 12, 12, 7, 3, 2, 2, 2, 2, 2}, {0, 0, 0, 1, 0, 1, 0, 9, 0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 3, 2, 3, 2, 5, 2, 2, 4, 0, 0, 0, 0, 0}, {11, 11, 11, 11, 11, 0, 0, 1, 0, 0, 1, 11, 11, 11, 11, 11}, {-1, -1, -1, -1, 11, 0, 0, 1, 5, 2, 4, 11, -1, -1, -1, -1}, {-1, -1, -1, -1, 11, 0, 0, 1, 1, 0, 0, 11, -1, -1, -1, -1}, {-1, -1, -1, -1, 11, 0, 0, 1, 1, 0, 0, 11, -1, -1, -1, -1}, {-1, -1, -1, -1, 11, 0, 0, 1, 1, 0, 0, 11, -1, -1, -1, -1}};
    private int city1Size = 19;
    private int city2Size = 19;
    private static final int MIN_BLOCK_SIZE = 2;
    private static final int MAX_BLOCK_SIZE = 6;
    private byte[][] roads1;
    private byte[][] roads2;
    private Block sidewalkDefault = null;
    private int sidewalk0MetaDefault = 0;
    private int sidewalk1MetaDefault = 0;
    private int sidewalk2MetaDefault = 0;
    private int wood0MetaDefault = 0;
    private int wood1MetaDefault = 0;
    private int wood2MetaDefault = 0;

    public WorldGenCity() {
        this.init(new Random(0L), 0L);
    }

    private void init(Random rand, long seed) {
        this.city1Size = rand.nextInt(15) + 19;
        this.city2Size = rand.nextInt(15) + 19;
        this.city1X = (Math.abs((int)(seed - 7374354L >> 3)) % 2000 + 1000) / 16 * ((seed - 7374354L >> 3 & 1L) == 0L ? 1 : -1);
        this.city1Z = (Math.abs((int)(seed + 7374354L >> 9)) % 2000 + 1000) / 16 * ((seed + 7374354L >> 9 & 1L) == 0L ? 1 : -1);
        this.city2X = (Math.abs((int)(seed - 7374354L >> 13)) % 2000 + 1000) / 16 * ((seed - 7374354L >> 13 & 1L) == 0L ? 1 : -1);
        this.city2Z = (Math.abs((int)(seed + 7374354L >> 11)) % 2000 + 1000) / 16 * ((seed + 7374354L >> 11 & 1L) == 0L ? 1 : -1);
        this.roads1 = new byte[this.city1Size][this.city1Size];
        this.roadNetwork(this.roads1, rand, 0, this.city1Size - 1, 0, this.city1Size - 1, 2.0f);
        this.roads2 = new byte[this.city2Size][this.city2Size];
        this.roadNetwork(this.roads2, rand, 0, this.city2Size - 1, 0, this.city2Size - 1, 2.0f);
        this.chunkXBase = (Math.abs((int)(seed - 7374354L >> 7)) % 500 + 500) / 16 * ((seed - 7374354L >> 7 & 1L) == 0L ? 1 : -1);
        this.chunkZBase = (Math.abs((int)(seed + 7374354L >> 5)) % 500 + 500) / 16 * ((seed + 7374354L >> 5 & 1L) == 0L ? 1 : -1);
        this.sidewalkDefault = Blocks.field_150348_b;
        this.sidewalk0MetaDefault = rand.nextInt(7);
        this.sidewalk1MetaDefault = rand.nextInt(7);
        this.sidewalk2MetaDefault = rand.nextInt(7);
        this.wood0MetaDefault = rand.nextInt(6);
        this.wood1MetaDefault = rand.nextInt(6);
        this.wood2MetaDefault = rand.nextInt(6);
        this.seed = seed;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() != 0 || !world.func_72912_H().func_76089_r()) {
            return;
        }
        if (world.func_72905_C() != this.seed) {
            this.init(random, world.func_72905_C());
        }
        if (chunkX >= this.city1X && chunkX < this.city1X + this.city1Size && chunkZ >= this.city1Z && chunkZ < this.city1Z + this.city1Size) {
            boolean flat = world.func_175624_G() == WorldType.field_77138_c;
            int yBase = flat ? 4 : 64;
            boolean ocean = false;
            Block filler = Blocks.field_150346_d;
            Block light = Blocks.field_150426_aN;
            Block sidewalk = this.sidewalkDefault;
            int sidewalkMeta = this.sidewalk1MetaDefault;
            int woodMeta = this.wood1MetaDefault;
            Biome b = world.func_180494_b(new BlockPos(chunkX * 16 + 8, 64, chunkZ * 16 + 8));
            if (b.func_185359_l().endsWith("Ocean")) {
                yBase = 40;
                light = Blocks.field_180398_cJ;
                sidewalk = Blocks.field_180397_cI;
                sidewalkMeta = 0;
                ocean = true;
            } else if (b.func_185359_l().startsWith("Mesa Plateau") || b.func_185359_l().startsWith("Savanna Plateau") || b.func_185359_l().startsWith("Extreme Hills")) {
                yBase = 76;
            } else if (b.func_185359_l().startsWith("Desert")) {
                filler = Blocks.field_150354_m;
            }
            if (this.roads1[chunkX - this.city1X][chunkZ - this.city1Z] != 0) {
                boolean cart;
                boolean rail;
                boolean bl = flat ? false : (rail = this.roads1[chunkX - this.city1X][chunkZ - this.city1Z] == 3 || this.roads1[chunkX - this.city1X][chunkZ - this.city1Z] == 5);
                boolean bl2 = flat ? false : (cart = this.roads1[chunkX - this.city1X][chunkZ - this.city1Z] == 5);
                if (chunkX - this.city1X > 0 && this.roads1[chunkX - this.city1X - 1][chunkZ - this.city1Z] != 0 || chunkX - this.city1X < this.city1Size - 1 && this.roads1[chunkX - this.city1X + 1][chunkZ - this.city1Z] != 0) {
                    if (chunkZ - this.city1Z > 0 && this.roads1[chunkX - this.city1X][chunkZ - this.city1Z - 1] != 0 || chunkZ - this.city1Z < this.city1Size - 1 && this.roads1[chunkX - this.city1X][chunkZ - this.city1Z + 1] != 0) {
                        int xStart = chunkX << 4;
                        int xEnd = xStart + 15;
                        int zStart = chunkZ << 4;
                        int zEnd = zStart + 15;
                        this.generateIntersection(world, random, yBase, xStart, xEnd, zStart, zEnd, this.sidewalkDefault, this.sidewalk1MetaDefault, filler, fence[woodMeta], woodMeta, rail);
                    } else {
                        int xStart = chunkX << 4;
                        int xEnd = xStart + 15;
                        int zStart = chunkZ << 4;
                        int zEnd = zStart + 15;
                        this.generateRoad(world, random, yBase, xStart, xEnd, zStart, zEnd, EnumFacing.WEST, this.sidewalkDefault, this.sidewalk1MetaDefault, filler, fence[woodMeta], light, woodMeta, rail, cart);
                    }
                } else {
                    int xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    this.generateRoad(world, random, yBase, xStart, xEnd, zStart, zEnd, EnumFacing.NORTH, this.sidewalkDefault, this.sidewalk1MetaDefault, filler, fence[woodMeta], light, woodMeta, rail, cart);
                }
            } else {
                int xStart;
                float c = random.nextFloat();
                float modifier = 0.125f;
                for (int i = 1; i <= 4; ++i) {
                    if (chunkX - this.city1X + i < this.roads1.length && this.roads1[chunkX - this.city1X + i][chunkZ - this.city1Z] != 0) {
                        modifier = 1.0f / (float)i;
                        break;
                    }
                    if (chunkX - this.city1X - i >= 0 && this.roads1[chunkX - this.city1X - i][chunkZ - this.city1Z] != 0) {
                        modifier = 1.0f / (float)i;
                        break;
                    }
                    if (chunkZ - this.city1Z + i < this.roads1.length && this.roads1[chunkX - this.city1X][chunkZ - this.city1Z + i] != 0) {
                        modifier = 1.0f / (float)i;
                        break;
                    }
                    if (chunkZ - this.city1Z - i < 0 || this.roads1[chunkX - this.city1X][chunkZ - this.city1Z - i] == 0) continue;
                    modifier = 1.0f / (float)i;
                    break;
                }
                if (c < 0.3125f * modifier) {
                    int slabMeta;
                    float n;
                    BlockSlab slab;
                    int zEnd;
                    int zStart;
                    int xEnd;
                    if (random.nextFloat() < 0.75f) {
                        xStart = chunkX << 4;
                        xEnd = xStart + 7;
                        zStart = chunkZ << 4;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk1MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                    if (random.nextFloat() < 0.75f) {
                        xStart = (chunkX << 4) + 8;
                        xEnd = xStart + 7;
                        zStart = chunkZ << 4;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk1MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                    if (random.nextFloat() < 0.75f) {
                        xStart = chunkX << 4;
                        xEnd = xStart + 7;
                        zStart = (chunkZ << 4) + 8;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk1MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                    if (random.nextFloat() < 0.75f) {
                        xStart = (chunkX << 4) + 8;
                        xEnd = xStart + 7;
                        zStart = (chunkZ << 4) + 8;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk1MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                } else if (c < 0.5625f * modifier) {
                    xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.2f) {
                        slab = Blocks.field_150376_bx;
                    } else if (n < 0.25f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.3f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150376_bx) {
                        slabMeta = random.nextInt(6);
                    } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 1;
                    }
                    this.generateFactory(world, random, yBase, xStart, xEnd, zStart, zEnd, 15, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk1MetaDefault, (Block)slab, slabMeta, random.nextInt(6), ocean);
                } else if (c < 0.75f * modifier) {
                    xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.2f) {
                        slab = Blocks.field_150376_bx;
                    } else if (n < 0.25f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.3f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150376_bx) {
                        slabMeta = random.nextInt(6);
                    } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 1;
                    }
                    this.generateFactory(world, random, yBase, xStart, xEnd, zStart, zEnd, 31, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk1MetaDefault, (Block)slab, slabMeta, random.nextInt(6), ocean);
                } else if (c < 0.8125f * modifier) {
                    xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.05f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.1f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 0;
                    }
                    Block stone = Blocks.field_150348_b;
                    int stoneMeta = random.nextInt(7);
                    if (random.nextFloat() < 0.1f) {
                        stone = Blocks.field_180397_cI;
                        stoneMeta = random.nextInt(3);
                    }
                    this.generateTower(world, random, yBase, xStart, xEnd, zStart, zEnd, 63, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk1MetaDefault, (Block)slab, slabMeta, stone, stoneMeta, random.nextInt(16), random.nextInt(16), random.nextInt(6), ocean);
                } else if (c < 0.83f * modifier) {
                    xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.05f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.1f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 0;
                    }
                    Block stone = Blocks.field_150348_b;
                    int stoneMeta = random.nextInt(7);
                    if (random.nextFloat() < 0.1f) {
                        stone = Blocks.field_180397_cI;
                        stoneMeta = random.nextInt(3);
                    }
                    this.generateTower(world, random, yBase, xStart, xEnd, zStart, zEnd, 127, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk1MetaDefault, (Block)slab, slabMeta, stone, stoneMeta, random.nextInt(16), random.nextInt(16), random.nextInt(6), ocean);
                }
            }
            return;
        }
        if (chunkX >= this.city2X && chunkX < this.city2X + this.city2Size && chunkZ >= this.city2Z && chunkZ < this.city2Z + this.city2Size) {
            boolean flat = world.func_175624_G() == WorldType.field_77138_c;
            int yBase = flat ? 4 : 64;
            boolean ocean = false;
            Block filler = Blocks.field_150346_d;
            Block light = Blocks.field_150426_aN;
            Block sidewalk = this.sidewalkDefault;
            int sidewalkMeta = this.sidewalk2MetaDefault;
            int woodMeta = this.wood2MetaDefault;
            Biome b = world.func_180494_b(new BlockPos(chunkX * 16 + 8, 64, chunkZ * 16 + 8));
            if (b.func_185359_l().endsWith("Ocean")) {
                yBase = 40;
                light = Blocks.field_180398_cJ;
                sidewalk = Blocks.field_180397_cI;
                sidewalkMeta = 0;
                ocean = true;
            } else if (b.func_185359_l().startsWith("Mesa Plateau") || b.func_185359_l().startsWith("Savanna Plateau") || b.func_185359_l().startsWith("Extreme Hills")) {
                yBase = 76;
            } else if (b.func_185359_l().startsWith("Desert")) {
                filler = Blocks.field_150354_m;
            }
            if (this.roads2[chunkX - this.city2X][chunkZ - this.city2Z] != 0) {
                boolean cart;
                boolean rail;
                boolean bl = flat ? false : (rail = this.roads2[chunkX - this.city2X][chunkZ - this.city2Z] == 3 || this.roads2[chunkX - this.city2X][chunkZ - this.city2Z] == 5);
                boolean bl3 = flat ? false : (cart = this.roads2[chunkX - this.city2X][chunkZ - this.city2Z] == 5);
                if (chunkX - this.city2X > 0 && this.roads2[chunkX - this.city2X - 1][chunkZ - this.city2Z] != 0 || chunkX - this.city2X < this.city2Size - 1 && this.roads2[chunkX - this.city2X + 1][chunkZ - this.city2Z] != 0) {
                    if (chunkZ - this.city2Z > 0 && this.roads2[chunkX - this.city2X][chunkZ - this.city2Z - 1] != 0 || chunkZ - this.city2Z < this.city2Size - 1 && this.roads2[chunkX - this.city2X][chunkZ - this.city2Z + 1] != 0) {
                        int xStart = chunkX << 4;
                        int xEnd = xStart + 15;
                        int zStart = chunkZ << 4;
                        int zEnd = zStart + 15;
                        this.generateIntersection(world, random, yBase, xStart, xEnd, zStart, zEnd, this.sidewalkDefault, this.sidewalk2MetaDefault, filler, fence[woodMeta], woodMeta, rail);
                    } else {
                        int xStart = chunkX << 4;
                        int xEnd = xStart + 15;
                        int zStart = chunkZ << 4;
                        int zEnd = zStart + 15;
                        this.generateRoad(world, random, yBase, xStart, xEnd, zStart, zEnd, EnumFacing.WEST, this.sidewalkDefault, this.sidewalk2MetaDefault, filler, fence[woodMeta], light, woodMeta, rail, cart);
                    }
                } else {
                    int xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    this.generateRoad(world, random, yBase, xStart, xEnd, zStart, zEnd, EnumFacing.NORTH, this.sidewalkDefault, this.sidewalk2MetaDefault, filler, fence[woodMeta], light, woodMeta, rail, cart);
                }
            } else {
                int xStart;
                float c = random.nextFloat();
                float modifier = 0.125f;
                for (int i = 1; i <= 4; ++i) {
                    if (chunkX - this.city2X + i < this.roads2.length && this.roads2[chunkX - this.city2X + i][chunkZ - this.city2Z] != 0) {
                        modifier = 1.0f / (float)i;
                        break;
                    }
                    if (chunkX - this.city2X - i >= 0 && this.roads2[chunkX - this.city2X - i][chunkZ - this.city2Z] != 0) {
                        modifier = 1.0f / (float)i;
                        break;
                    }
                    if (chunkZ - this.city2Z + i < this.roads2.length && this.roads2[chunkX - this.city2X][chunkZ - this.city2Z + i] != 0) {
                        modifier = 1.0f / (float)i;
                        break;
                    }
                    if (chunkZ - this.city2Z - i < 0 || this.roads2[chunkX - this.city2X][chunkZ - this.city2Z - i] == 0) continue;
                    modifier = 1.0f / (float)i;
                    break;
                }
                if (c < 0.3125f * modifier) {
                    int slabMeta;
                    float n;
                    BlockSlab slab;
                    int zEnd;
                    int zStart;
                    int xEnd;
                    if (random.nextFloat() < 0.75f) {
                        xStart = chunkX << 4;
                        xEnd = xStart + 7;
                        zStart = chunkZ << 4;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk2MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                    if (random.nextFloat() < 0.75f) {
                        xStart = (chunkX << 4) + 8;
                        xEnd = xStart + 7;
                        zStart = chunkZ << 4;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk2MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                    if (random.nextFloat() < 0.75f) {
                        xStart = chunkX << 4;
                        xEnd = xStart + 7;
                        zStart = (chunkZ << 4) + 8;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk2MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                    if (random.nextFloat() < 0.75f) {
                        xStart = (chunkX << 4) + 8;
                        xEnd = xStart + 7;
                        zStart = (chunkZ << 4) + 8;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk2MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                } else if (c < 0.5625f * modifier) {
                    xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.2f) {
                        slab = Blocks.field_150376_bx;
                    } else if (n < 0.25f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.3f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150376_bx) {
                        slabMeta = random.nextInt(6);
                    } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 1;
                    }
                    this.generateFactory(world, random, yBase, xStart, xEnd, zStart, zEnd, 15, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk2MetaDefault, (Block)slab, slabMeta, random.nextInt(6), ocean);
                } else if (c < 0.75f * modifier) {
                    xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.2f) {
                        slab = Blocks.field_150376_bx;
                    } else if (n < 0.25f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.3f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150376_bx) {
                        slabMeta = random.nextInt(6);
                    } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 1;
                    }
                    this.generateFactory(world, random, yBase, xStart, xEnd, zStart, zEnd, 31, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk2MetaDefault, (Block)slab, slabMeta, random.nextInt(6), ocean);
                } else if (c < 0.8125f * modifier) {
                    xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.05f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.1f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 0;
                    }
                    Block stone = Blocks.field_150348_b;
                    int stoneMeta = random.nextInt(7);
                    if (random.nextFloat() < 0.1f) {
                        stone = Blocks.field_180397_cI;
                        stoneMeta = random.nextInt(3);
                    }
                    this.generateTower(world, random, yBase, xStart, xEnd, zStart, zEnd, 63, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk2MetaDefault, (Block)slab, slabMeta, stone, stoneMeta, random.nextInt(16), random.nextInt(16), random.nextInt(6), ocean);
                } else if (c < 0.83f * modifier) {
                    xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.05f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.1f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 0;
                    }
                    Block stone = Blocks.field_150348_b;
                    int stoneMeta = random.nextInt(7);
                    if (random.nextFloat() < 0.1f) {
                        stone = Blocks.field_180397_cI;
                        stoneMeta = random.nextInt(3);
                    }
                    this.generateTower(world, random, yBase, xStart, xEnd, zStart, zEnd, 127, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk2MetaDefault, (Block)slab, slabMeta, stone, stoneMeta, random.nextInt(16), random.nextInt(16), random.nextInt(6), ocean);
                }
            }
            return;
        }
        if (chunkX >= this.chunkXBase - 4 && chunkX <= this.chunkXBase + 4 && chunkZ >= this.chunkZBase - 4 && chunkZ <= this.chunkZBase + 4) {
            boolean flat = world.func_175624_G() == WorldType.field_77138_c;
            int yBase = flat ? 4 : 64;
            boolean ocean = false;
            Block filler = Blocks.field_150346_d;
            Block light = Blocks.field_150426_aN;
            Block sidewalk = null;
            int sidewalkMeta = -1;
            int woodMeta = this.wood0MetaDefault;
            Biome b = world.func_180494_b(new BlockPos(chunkX * 16 + 8, 64, chunkZ * 16 + 8));
            if (b.func_185359_l().endsWith("Ocean")) {
                yBase = 40;
                light = Blocks.field_180398_cJ;
                sidewalk = Blocks.field_180397_cI;
                sidewalkMeta = 0;
                ocean = true;
            } else if (b.func_185359_l().startsWith("Mesa Plateau") || b.func_185359_l().startsWith("Savanna Plateau") || b.func_185359_l().startsWith("Extreme Hills")) {
                yBase = 76;
            } else if (b.func_185359_l().startsWith("Desert")) {
                filler = Blocks.field_150354_m;
            }
            if (chunkX == this.chunkXBase && chunkZ == this.chunkZBase) {
                int xStart = chunkX << 4;
                int xEnd = xStart + 15;
                int zStart = chunkZ << 4;
                int zEnd = zStart + 15;
                this.generateIntersection(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk0MetaDefault, filler, fence[woodMeta], woodMeta, true);
            } else if (chunkZ == this.chunkZBase) {
                int xStart = chunkX << 4;
                int xEnd = xStart + 15;
                int zStart = chunkZ << 4;
                int zEnd = zStart + 15;
                this.generateRoad(world, random, yBase, xStart, xEnd, zStart, zEnd, EnumFacing.WEST, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk0MetaDefault, filler, fence[woodMeta], light, woodMeta, true, random.nextFloat() < 0.25f);
            } else if (chunkX == this.chunkXBase) {
                int xStart = chunkX << 4;
                int xEnd = xStart + 15;
                int zStart = chunkZ << 4;
                int zEnd = zStart + 15;
                this.generateRoad(world, random, yBase, xStart, xEnd, zStart, zEnd, EnumFacing.NORTH, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk0MetaDefault, filler, fence[woodMeta], light, woodMeta, true, random.nextFloat() < 0.25f);
            } else {
                float c = random.nextFloat();
                if (c < 0.3125f) {
                    int slabMeta;
                    float n;
                    BlockSlab slab;
                    int zEnd;
                    int zStart;
                    int xEnd;
                    int xStart;
                    if (random.nextFloat() < 0.75f) {
                        xStart = chunkX << 4;
                        xEnd = xStart + 7;
                        zStart = chunkZ << 4;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk0MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                    if (random.nextFloat() < 0.75f) {
                        xStart = (chunkX << 4) + 8;
                        xEnd = xStart + 7;
                        zStart = chunkZ << 4;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk0MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                    if (random.nextFloat() < 0.75f) {
                        xStart = chunkX << 4;
                        xEnd = xStart + 7;
                        zStart = (chunkZ << 4) + 8;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk0MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                    if (random.nextFloat() < 0.75f) {
                        xStart = (chunkX << 4) + 8;
                        xEnd = xStart + 7;
                        zStart = (chunkZ << 4) + 8;
                        zEnd = zStart + 7;
                        slab = Blocks.field_150333_U;
                        n = random.nextFloat();
                        if (n < 0.2f) {
                            slab = Blocks.field_150376_bx;
                        } else if (n < 0.25f) {
                            slab = Blocks.field_180389_cP;
                        } else if (n < 0.3f) {
                            slab = Blocks.field_185771_cX;
                        }
                        slabMeta = 0;
                        if (slab == Blocks.field_150376_bx) {
                            slabMeta = random.nextInt(6);
                        } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                            slabMeta = 0;
                        }
                        this.generateOffice(world, random, yBase, xStart, xEnd, zStart, zEnd, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk0MetaDefault, (Block)slab, slabMeta, random.nextInt(16), random.nextInt(6));
                    }
                } else if (c < 0.5625f) {
                    int xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.2f) {
                        slab = Blocks.field_150376_bx;
                    } else if (n < 0.25f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.3f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150376_bx) {
                        slabMeta = random.nextInt(6);
                    } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 1;
                    }
                    this.generateFactory(world, random, yBase, xStart, xEnd, zStart, zEnd, 15, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk0MetaDefault, (Block)slab, slabMeta, random.nextInt(6), ocean);
                } else if (c < 0.75f) {
                    int xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.2f) {
                        slab = Blocks.field_150376_bx;
                    } else if (n < 0.25f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.3f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150376_bx) {
                        slabMeta = random.nextInt(6);
                    } else if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 1;
                    }
                    this.generateFactory(world, random, yBase, xStart, xEnd, zStart, zEnd, 31, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk0MetaDefault, (Block)slab, slabMeta, random.nextInt(6), ocean);
                } else if (c < 0.8125f) {
                    int xStart = chunkX << 4;
                    int xEnd = xStart + 15;
                    int zStart = chunkZ << 4;
                    int zEnd = zStart + 15;
                    BlockSlab slab = Blocks.field_150333_U;
                    float n = random.nextFloat();
                    if (n < 0.05f) {
                        slab = Blocks.field_180389_cP;
                    } else if (n < 0.1f) {
                        slab = Blocks.field_185771_cX;
                    }
                    int slabMeta = 0;
                    if (slab == Blocks.field_150333_U && (slabMeta = random.nextInt(8)) == 2) {
                        slabMeta = 0;
                    }
                    Block stone = Blocks.field_150348_b;
                    int stoneMeta = random.nextInt(7);
                    if (random.nextFloat() < 0.1f) {
                        stone = Blocks.field_180397_cI;
                        stoneMeta = random.nextInt(3);
                    }
                    this.generateTower(world, random, yBase, xStart, xEnd, zStart, zEnd, 63, sidewalk != null ? sidewalk : this.sidewalkDefault, sidewalk != null ? sidewalkMeta : this.sidewalk0MetaDefault, (Block)slab, slabMeta, stone, stoneMeta, random.nextInt(16), random.nextInt(16), random.nextInt(6), ocean);
                }
            }
            return;
        }
    }

    private void generateIntersection(World world, Random rand, int yPos, int xStart, int xEnd, int zStart, int zEnd, Block sidewalk, int sidewalkMeta, Block filler, Block fence, int plankMeta, boolean rail) {
        int yStart = yPos - 12;
        int yEnd = yPos + 3;
        for (int y = yStart; y <= yEnd; ++y) {
            for (int x = xStart; x <= xEnd; ++x) {
                for (int z = zStart; z <= zEnd; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    if (rail && y == yPos - 5) {
                        if ((x <= xStart + 4 || x >= xEnd - 4) && (z <= zStart + 4 || z >= zEnd - 4)) continue;
                        float c = rand.nextFloat();
                        if (c < 0.001f) {
                            world.func_180501_a(blockPos, Blocks.field_180399_cE.func_176223_P(), 2);
                            continue;
                        }
                        if (c < 0.005f) {
                            world.func_180501_a(blockPos, Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.COBBLESTONE), 2);
                            continue;
                        }
                        if (c < 0.02f) {
                            world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                        continue;
                    }
                    if (rail && y == yPos - 4) {
                        switch (this.scm[z - zStart][x - xStart]) {
                            case 0: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: {
                                world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                                break;
                            }
                            case 11: {
                                float c = rand.nextFloat();
                                if (c < 0.02f) {
                                    world.func_180501_a(blockPos, Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.COBBLESTONE), 2);
                                    break;
                                }
                                if (c < 0.1f) {
                                    world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                    break;
                                }
                                world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                                break;
                            }
                            case 12: {
                                world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                            }
                        }
                        continue;
                    }
                    if (rail && y == yPos - 3) {
                        if ((x <= xStart + 3 || x >= xEnd - 3) && (z <= zStart + 3 || z >= zEnd - 3)) continue;
                        if (!(((x - 4) % 16 != 0 && (x - 11) % 16 != 0 || z >= zStart + 5 && z <= zEnd - 5) && ((z - 4) % 16 != 0 && (z - 11) % 16 != 0 || x >= xStart + 5 && x <= xEnd - 5) && ((x - 7) % 16 != 0 && (x - 8) % 16 != 0 || (z - 7) % 16 != 0 && (z - 8) % 16 != 0))) {
                            if (rand.nextFloat() < 0.2f) {
                                world.func_180501_a(blockPos, Blocks.field_150341_Y.func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        continue;
                    }
                    if (y == yPos - 2) {
                        if (rail && (x > xStart + 3 && x < xEnd - 3 || z > zStart + 3 && z < zEnd - 3)) {
                            if (!(((x - 4) % 16 != 0 && (x - 11) % 16 != 0 || z >= zStart + 5 && z <= zEnd - 5) && ((z - 4) % 16 != 0 && (z - 11) % 16 != 0 || x >= xStart + 5 && x <= xEnd - 5) && ((x - 7) % 16 != 0 && (x - 8) % 16 != 0 || (z - 7) % 16 != 0 && (z - 8) % 16 != 0))) {
                                world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                continue;
                            }
                            if (!(((x - 5) % 16 != 0 && (x - 10) % 16 != 0 || z >= zStart + 5 && z <= zEnd - 5) && ((z - 5) % 16 != 0 && (z - 10) % 16 != 0 || x >= xStart + 5 && x <= xEnd - 5) && ((x - 6) % 16 != 0 && (x - 9) % 16 != 0 || (z - 7) % 16 != 0 && (z - 8) % 16 != 0) && ((z - 6) % 16 != 0 && (z - 9) % 16 != 0 || (x - 7) % 16 != 0 && (x - 8) % 16 != 0))) {
                                EnumFacing dir = (x - 5) % 16 == 0 || (x - 9) % 16 == 0 ? EnumFacing.WEST : ((x - 10) % 16 == 0 || (x - 6) % 16 == 0 ? EnumFacing.EAST : ((z - 5) % 16 == 0 || (z - 9) % 16 == 0 ? EnumFacing.NORTH : EnumFacing.SOUTH));
                                IBlockState state = Blocks.field_150390_bg.func_176223_P();
                                state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)dir).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                                world.func_180501_a(blockPos, state, 2);
                                continue;
                            }
                            if (!(rand.nextFloat() < 0.98f)) continue;
                            world.func_175656_a(blockPos, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                        continue;
                    }
                    if (y == yPos - 1) {
                        if (x < xStart + 2 || x > xEnd - 2) {
                            if (z < zStart + 3 || z > zEnd - 3) {
                                world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                                continue;
                            }
                            if ((z - 3) % 16 == 0 || (z - 12) % 16 == 0) {
                                int dir = (z - 12) % 16 == 0 ? 2 : 3;
                                world.func_180501_a(blockPos, Blocks.field_150370_cb.func_176203_a(dir), 2);
                                continue;
                            }
                            if ((z - 6) % 16 == 0 || (z - 9) % 16 == 0) {
                                world.func_180501_a(blockPos, Blocks.field_150333_U.func_176203_a(7), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150333_U.func_176203_a(3), 2);
                            continue;
                        }
                        if (z < zStart + 2 || z > zEnd - 2) {
                            if (x < xStart + 3 || x > xEnd - 3) {
                                world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                                continue;
                            }
                            if ((x - 3) % 16 == 0 || (x - 12) % 16 == 0) {
                                int dir = (x - 3) % 16 == 0 ? 1 : 0;
                                world.func_180501_a(blockPos, Blocks.field_150370_cb.func_176203_a(dir), 2);
                                continue;
                            }
                            if ((x - 6) % 16 == 0 || (x - 9) % 16 == 0) {
                                world.func_180501_a(blockPos, Blocks.field_150333_U.func_176203_a(7), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150333_U.func_176203_a(3), 2);
                            continue;
                        }
                        if (!((x - 3) % 16 != 0 && (x - 12) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                            world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                            continue;
                        }
                        if (!((x - 2) % 16 != 0 && (x - 13) % 16 != 0 || (z - 2) % 16 != 0 && (z - 13) % 16 != 0)) {
                            if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150349_c || world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150346_d) continue;
                            world.func_180501_a(blockPos, filler.func_176223_P(), 2);
                            continue;
                        }
                        if ((x - 4) % 16 == 0 || (x - 11) % 16 == 0 || (z - 4) % 16 == 0 || (z - 11) % 16 == 0) {
                            if ((x < xStart + 5 && x > xStart + 2 || x > xEnd - 5 && x < xEnd - 2) && (z < zStart + 5 && z > zStart + 2 || z > zEnd - 5 && z < zEnd - 2)) {
                                int dir = 3;
                                if ((x - 11) % 16 == 0) {
                                    dir = 0;
                                } else if ((x - 4) % 16 == 0) {
                                    dir = 1;
                                } else if ((z - 11) % 16 == 0) {
                                    dir = 2;
                                }
                                world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                                continue;
                            }
                            if (x == xStart + 2 || x == xEnd - 2 || z == zStart + 2 || z == zEnd - 2) {
                                int dir = 3;
                                if (x == xStart + 2) {
                                    dir = 0;
                                } else if (x == xEnd - 2) {
                                    dir = 1;
                                } else if (z == zStart + 2) {
                                    dir = 2;
                                }
                                world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150333_U.func_176203_a(3), 2);
                            continue;
                        }
                        if (!((z - 2) % 16 != 0 && (z - 13) % 16 != 0 || (x - 3) % 16 != 0 && (x - 4) % 16 != 0 && (x - 11) % 16 != 0 && (x - 12) % 16 != 0)) {
                            int dir = 3;
                            if ((x - 12) % 16 == 0) {
                                dir = 0;
                            } else if ((x - 3) % 16 == 0) {
                                dir = 1;
                            } else if ((z - 2) % 16 == 0) {
                                dir = 2;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                            continue;
                        }
                        if (!((x - 2) % 16 != 0 && (x - 13) % 16 != 0 || (z - 3) % 16 != 0 && (z - 4) % 16 != 0 && (z - 11) % 16 != 0 && (z - 12) % 16 != 0)) {
                            int dir = 3;
                            if (((z - 4) % 16 == 0 || (z - 11) % 16 == 0) && (x - 13) % 16 == 0) {
                                dir = 0;
                            } else if (((z - 4) % 16 == 0 || (z - 11) % 16 == 0) && (x - 2) % 16 == 0) {
                                dir = 1;
                            } else if ((z - 12) % 16 == 0) {
                                dir = 2;
                            } else if ((z - 3) % 16 == 0) {
                                dir = 3;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150333_U.func_176203_a(3), 2);
                        continue;
                    }
                    if (y < yPos || (x - 3) % 16 != 0 && (x - 12) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0) continue;
                    world.func_180501_a(blockPos, fence.func_176223_P(), 2);
                }
            }
        }
    }

    private void generateRoad(World world, Random rand, int yPos, int xStart, int xEnd, int zStart, int zEnd, EnumFacing facing, Block sidewalk, int sidewalkMeta, Block filler, Block fence, Block light, int plankMeta, boolean rail, boolean cart) {
        BlockPos blockPos;
        int z;
        int x;
        int yTop;
        int y;
        int yStart = yPos - 61;
        int yEnd = yPos + 3;
        for (y = yTop = rail ? yPos - 6 : yPos - 3; y >= yStart; --y) {
            for (x = xStart; x <= xEnd; ++x) {
                for (z = zStart; z <= zEnd; ++z) {
                    IBlockState state;
                    blockPos = new BlockPos(x, y, z);
                    if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                        if ((z - 3) % 16 != 0 && (z - 12) % 16 != 0 || (x - 5) % 16 != 0 && (x - 6) % 16 != 0 && (x - 9) % 16 != 0 && (x - 10) % 16 != 0 || !world.func_180495_p(blockPos).func_185904_a().func_76224_d() && world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a && !world.func_180495_p(blockPos).func_185904_a().func_76222_j() || y != yTop && (Item.func_150898_a((Block)(state = world.func_180495_p(blockPos.func_177984_a())).func_177230_c()) != Item.func_150898_a((Block)sidewalk) || state.func_177230_c().func_180651_a(state) != sidewalkMeta)) continue;
                        world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                        continue;
                    }
                    if ((x - 3) % 16 != 0 && (x - 12) % 16 != 0 || (z - 5) % 16 != 0 && (z - 6) % 16 != 0 && (z - 9) % 16 != 0 && (z - 10) % 16 != 0 || !world.func_180495_p(blockPos).func_185904_a().func_76224_d() && world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a && !world.func_180495_p(blockPos).func_185904_a().func_76222_j() || y != yTop && (Item.func_150898_a((Block)(state = world.func_180495_p(blockPos.func_177984_a())).func_177230_c()) != Item.func_150898_a((Block)sidewalk) || state.func_177230_c().func_180651_a(state) != sidewalkMeta)) continue;
                    world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                }
            }
        }
        for (y = yTop + 1; y <= yEnd; ++y) {
            for (x = xStart; x <= xEnd; ++x) {
                for (z = zStart; z <= zEnd; ++z) {
                    blockPos = new BlockPos(x, y, z);
                    if (rail && y == yPos - 5) {
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            if (x <= xStart + 4 || x >= xEnd - 4) continue;
                            float c = rand.nextFloat();
                            if (c < 0.001f) {
                                world.func_180501_a(blockPos, Blocks.field_180399_cE.func_176223_P(), 2);
                                continue;
                            }
                            if (c < 0.005f) {
                                world.func_180501_a(blockPos, Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.COBBLESTONE), 2);
                                continue;
                            }
                            if (c < 0.02f) {
                                world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                            continue;
                        }
                        if (z <= zStart + 4 || z >= zEnd - 4) continue;
                        float c = rand.nextFloat();
                        if (c < 0.001f) {
                            world.func_180501_a(blockPos, Blocks.field_180399_cE.func_176223_P(), 2);
                            continue;
                        }
                        if (c < 0.005f) {
                            world.func_180501_a(blockPos, Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.COBBLESTONE), 2);
                            continue;
                        }
                        if (c < 0.02f) {
                            world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                        continue;
                    }
                    if (rail && y == yPos - 4) {
                        EntityMinecartChest entityminecartchest;
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            if ((x - 7) % 16 == 0 || (x - 8) % 16 == 0) {
                                float c = rand.nextFloat();
                                if ((x - 8) % 16 == 0 && c < 0.1f) {
                                    world.func_180501_a(blockPos, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH), 2);
                                    if (z > zStart) {
                                        world.func_180501_a(blockPos.func_177978_c(), Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH), 2);
                                    }
                                    if (!(c < 0.003f)) continue;
                                    entityminecartchest = new EntityMinecartChest(world, (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
                                    entityminecartchest.func_184289_a(LootTableList.field_186424_f, rand.nextLong());
                                    world.func_72838_d((Entity)entityminecartchest);
                                    continue;
                                }
                                world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                                continue;
                            }
                            if ((x - 6) % 16 == 0 || (x - 9) % 16 == 0) {
                                world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                                continue;
                            }
                            if ((x - 4) % 16 == 0 || (x - 5) % 16 == 0 || (x - 10) % 16 == 0 || (x - 11) % 16 == 0) {
                                float c = rand.nextFloat();
                                if (c < 0.02f) {
                                    world.func_180501_a(blockPos, Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.COBBLESTONE), 2);
                                    continue;
                                }
                                if (c < 0.08f) {
                                    world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                    continue;
                                }
                                world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                                continue;
                            }
                            if (x >= xStart + 4 && x <= xEnd - 4 || !cart) continue;
                            world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                            continue;
                        }
                        if ((z - 7) % 16 == 0 || (z - 8) % 16 == 0) {
                            float c = rand.nextFloat();
                            if ((z - 8) % 16 == 0 && c < 0.1f) {
                                world.func_180501_a(blockPos, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST), 2);
                                if (x > xStart) {
                                    world.func_180501_a(blockPos.func_177976_e(), Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST), 2);
                                }
                                if (!(c < 0.003f)) continue;
                                entityminecartchest = new EntityMinecartChest(world, (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
                                entityminecartchest.func_184289_a(LootTableList.field_186424_f, rand.nextLong());
                                world.func_72838_d((Entity)entityminecartchest);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                            continue;
                        }
                        if ((z - 6) % 16 == 0 || (z - 9) % 16 == 0) {
                            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                            continue;
                        }
                        if ((z - 4) % 16 == 0 || (z - 5) % 16 == 0 || (z - 10) % 16 == 0 || (z - 11) % 16 == 0) {
                            float c = rand.nextFloat();
                            if (c < 0.02f) {
                                world.func_180501_a(blockPos, Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.COBBLESTONE), 2);
                                continue;
                            }
                            if (c < 0.08f) {
                                world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                            continue;
                        }
                        if (z >= zStart + 4 && z <= zEnd - 4 || !cart) continue;
                        world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                        continue;
                    }
                    if (rail && y == yPos - 3) {
                        if (!(cart || (x - 4) % 16 != 0 && (x - 11) % 16 != 0 || (z - 4) % 16 != 0 && (z - 11) % 16 != 0)) {
                            if (rand.nextFloat() < WEB_CHANCE) {
                                world.func_180501_a(blockPos, Blocks.field_150321_G.func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                            continue;
                        }
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            if (x < xStart + (cart ? 0 : 4) || x > xEnd - (cart ? 0 : 4)) continue;
                            if (x == xStart + (cart ? 0 : 4) || x == xEnd - (cart ? 0 : 4) || cart && (x < xStart + 5 || x > xEnd - 5) && (z % 16 == 0 || (z - 15) % 16 == 0)) {
                                if (rand.nextFloat() < 0.2f) {
                                    world.func_180501_a(blockPos, Blocks.field_150341_Y.func_176223_P(), 2);
                                    continue;
                                }
                                world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                continue;
                            }
                            if (cart && (((x - 1) % 16 == 0 || (x - 2) % 16 == 0) && (z - 4) % 16 == 0 || ((x - 14) % 16 == 0 || (x - 13) % 16 == 0) && (z - 11) % 16 == 0)) {
                                int dir = z < zStart + 8 ? 3 : 2;
                                world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                            continue;
                        }
                        if (z < zStart + (cart ? 0 : 4) || z > zEnd - (cart ? 0 : 4)) continue;
                        if (z == zStart + (cart ? 0 : 4) || z == zEnd - (cart ? 0 : 4) || cart && (z < zStart + 5 || z > zEnd - 5) && (x % 16 == 0 || (x - 15) % 16 == 0)) {
                            if (rand.nextFloat() < 0.2f) {
                                world.func_180501_a(blockPos, Blocks.field_150341_Y.func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                            continue;
                        }
                        if (cart && (((z - 1) % 16 == 0 || (z - 2) % 16 == 0) && (x - 4) % 16 == 0 || ((z - 14) % 16 == 0 || (z - 13) % 16 == 0) && (x - 11) % 16 == 0)) {
                            int dir = x < xStart + 8 ? 1 : 0;
                            world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        continue;
                    }
                    if (y == yPos - 2) {
                        IBlockState state;
                        if (rail && (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH)) {
                            if (x <= xStart + (cart ? 0 : 4) || x >= xEnd - (cart ? 0 : 4) || cart && (x < xStart + 5 || x > xEnd - 5) && (z % 16 == 0 || (z - 15) % 16 == 0)) {
                                world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                continue;
                            }
                            if (cart && (((x - 1) % 16 == 0 || (x - 2) % 16 == 0) && (z - 3) % 16 == 0 || ((x - 14) % 16 == 0 || (x - 13) % 16 == 0) && (z - 12) % 16 == 0)) {
                                int dir = z < zStart + 8 ? 3 : 2;
                                world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                                continue;
                            }
                            if (!((cart || (x - 5) % 16 != 0 && (x - 10) % 16 != 0) && (!cart || (z >= zStart + 1 && z <= zEnd - 1 || (x - 5) % 16 != 0 && (x - 10) % 16 != 0) && (x >= xStart + 5 && x <= xEnd - 5 || (z - 1) % 16 != 0 && (z - 14) % 16 != 0)))) {
                                EnumFacing dir = !cart ? (x < xStart + 8 ? EnumFacing.WEST : EnumFacing.EAST) : ((z - 1) % 16 == 0 ? EnumFacing.NORTH : ((z - 14) % 16 == 0 ? EnumFacing.SOUTH : ((x - 5) % 16 == 0 ? EnumFacing.WEST : EnumFacing.EAST)));
                                state = Blocks.field_150390_bg.func_176223_P();
                                state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)dir).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                                world.func_180501_a(blockPos, state, 2);
                                continue;
                            }
                            if (cart) {
                                world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                                continue;
                            }
                            if (!(rand.nextFloat() < 0.98f)) continue;
                            world.func_175656_a(blockPos, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
                            continue;
                        }
                        if (rail && (facing == EnumFacing.EAST || facing == EnumFacing.WEST)) {
                            if (z <= zStart + (cart ? 0 : 4) || z >= zEnd - (cart ? 0 : 4) || cart && (z < zStart + 5 || z > zEnd - 5) && (x % 16 == 0 || (x - 15) % 16 == 0)) {
                                world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                continue;
                            }
                            if (cart && (((z - 1) % 16 == 0 || (z - 2) % 16 == 0) && (x - 3) % 16 == 0 || ((z - 14) % 16 == 0 || (z - 13) % 16 == 0) && (x - 12) % 16 == 0)) {
                                int dir = x < xStart + 8 ? 1 : 0;
                                world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                                continue;
                            }
                            if (!((cart || (z - 5) % 16 != 0 && (z - 10) % 16 != 0) && (!cart || (x >= xStart + 1 && x <= xEnd - 1 || (z - 5) % 16 != 0 && (z - 10) % 16 != 0) && (z >= zStart + 5 && z <= zEnd - 5 || (x - 1) % 16 != 0 && (x - 14) % 16 != 0)))) {
                                EnumFacing dir = !cart ? (z < zStart + 8 ? EnumFacing.NORTH : EnumFacing.SOUTH) : ((x - 1) % 16 == 0 ? EnumFacing.WEST : ((x - 14) % 16 == 0 ? EnumFacing.EAST : ((z - 5) % 16 == 0 ? EnumFacing.NORTH : EnumFacing.SOUTH)));
                                state = Blocks.field_150390_bg.func_176223_P();
                                state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)dir).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                                world.func_180501_a(blockPos, state, 2);
                                continue;
                            }
                            if (cart) {
                                world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                                continue;
                            }
                            if (!(rand.nextFloat() < 0.98f)) continue;
                            world.func_175656_a(blockPos, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                        continue;
                    }
                    if (y == yPos - 1) {
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            if (x % 16 == 0 || (x - 1) % 16 == 0 || (x - 14) % 16 == 0 || (x - 15) % 16 == 0 || cart && z % 16 != 0 && (z - 15) % 16 != 0 && ((x - 2) % 16 == 0 || (x - 3) % 16 == 0 || (x - 12) % 16 == 0 || (x - 13) % 16 == 0)) {
                                if (cart && (((x - 1) % 16 == 0 || (x - 2) % 16 == 0) && z > zStart + 1 && z < zStart + 7 || ((x - 14) % 16 == 0 || (x - 13) % 16 == 0) && z > zEnd - 7 && z < zEnd - 1)) {
                                    if ((z - 2) % 16 == 0 || (z - 13) % 16 == 0) {
                                        int dir = z < zStart + 8 ? 3 : 2;
                                        world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                                        continue;
                                    }
                                    world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                                    continue;
                                }
                                world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                                continue;
                            }
                            if ((x - 4) % 16 == 0 || (x - 11) % 16 == 0) {
                                int dir;
                                int n = dir = (x - 4) % 16 == 0 ? 1 : 0;
                                if ((z - 0) % 16 == 0) {
                                    dir = 2;
                                } else if ((z - 15) % 16 == 0) {
                                    dir = 3;
                                }
                                world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                                continue;
                            }
                            if (x > xStart + 4 && x < xEnd - 4) {
                                world.func_180501_a(blockPos, Blocks.field_150333_U.func_176203_a(3), 2);
                                continue;
                            }
                            if (!((z - 0) % 16 != 0 && (z - 15) % 16 != 0 || (x - 3) % 16 != 0 && (x - 12) % 16 != 0)) {
                                world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a((x - 3) % 16 == 0 ? 1 : 0), 2);
                                continue;
                            }
                            if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150349_c || world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150346_d) continue;
                            world.func_180501_a(blockPos, filler.func_176223_P(), 2);
                            continue;
                        }
                        if (z % 16 == 0 || (z - 1) % 16 == 0 || (z - 14) % 16 == 0 || (z - 15) % 16 == 0 || cart && x % 16 != 0 && (x - 15) % 16 != 0 && ((z - 2) % 16 == 0 || (z - 3) % 16 == 0 || (z - 12) % 16 == 0 || (z - 13) % 16 == 0)) {
                            if (cart && (((z - 1) % 16 == 0 || (z - 2) % 16 == 0) && x > xStart + 1 && x < xStart + 7 || ((z - 14) % 16 == 0 || (z - 13) % 16 == 0) && x > xEnd - 7 && x < xEnd - 1)) {
                                if ((x - 2) % 16 == 0 || (x - 13) % 16 == 0) {
                                    int dir = x < xStart + 8 ? 1 : 0;
                                    world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                                    continue;
                                }
                                if (world.func_175623_d(blockPos)) continue;
                                world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                            continue;
                        }
                        if ((z - 4) % 16 == 0 || (z - 11) % 16 == 0) {
                            int dir;
                            int n = dir = (z - 4) % 16 == 0 ? 3 : 2;
                            if ((x - 0) % 16 == 0) {
                                dir = 0;
                            } else if ((x - 15) % 16 == 0) {
                                dir = 1;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(dir), 2);
                            continue;
                        }
                        if (z > zStart + 4 && z < zEnd - 4) {
                            world.func_180501_a(blockPos, Blocks.field_150333_U.func_176203_a(3), 2);
                            continue;
                        }
                        if (!((x - 0) % 16 != 0 && (x - 15) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                            world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a((z - 3) % 16 == 0 ? 3 : 2), 2);
                            continue;
                        }
                        if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150349_c || world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150346_d) continue;
                        world.func_180501_a(blockPos, filler.func_176223_P(), 2);
                        continue;
                    }
                    if (y < yPos) continue;
                    if (!(y >= yEnd || (x - 3) % 16 != 0 && (x - 12) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                        if (y == yEnd - 1) {
                            if (!(rand.nextFloat() < streetLightChance)) continue;
                            world.func_175656_a(blockPos, light.func_176223_P());
                            continue;
                        }
                        world.func_180501_a(blockPos, fence.func_176223_P(), 2);
                        continue;
                    }
                    if (cart && y == yPos && (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) && (x < xStart + 4 && z > zStart + ((x - 1) % 16 == 0 || (x - 2) % 16 == 0 ? 6 : 3) && z < zEnd - 7 || x > xEnd - 4 && z < zEnd - ((x - 14) % 16 == 0 || (x - 13) % 16 == 0 ? 6 : 3) && z > zStart + 7)) {
                        world.func_180501_a(blockPos, Blocks.field_150411_aY.func_176223_P(), 2);
                        continue;
                    }
                    if (!cart || y != yPos || facing != EnumFacing.EAST && facing != EnumFacing.WEST || (z >= zStart + 4 || x <= xStart + ((z - 1) % 16 == 0 || (z - 2) % 16 == 0 ? 6 : 3) || x >= xEnd - 7) && (z <= zEnd - 4 || x >= xEnd - ((z - 14) % 16 == 0 || (z - 13) % 16 == 0 ? 6 : 3) || x <= xStart + 7)) continue;
                    world.func_180501_a(blockPos, Blocks.field_150411_aY.func_176223_P(), 2);
                }
            }
        }
    }

    private void generateOffice(World world, Random rand, int yPos, int xStart, int xEnd, int zStart, int zEnd, Block sidewalk, int sidewalkMeta, Block slab, int slabMeta, int glassMeta, int plankMeta) {
        BlockPos blockPos;
        int z;
        int x;
        int yTop;
        int y;
        int yStart = yPos - 1;
        int yEnd = yPos + 15;
        for (y = yTop = yPos - 2; y >= yStart - 60; --y) {
            for (x = xStart; x <= xEnd; ++x) {
                for (z = zStart; z <= zEnd; ++z) {
                    IBlockState state;
                    blockPos = new BlockPos(x, y, z);
                    if (x != xStart + 1 && x != xEnd - 1 || z != zStart + 1 && z != zEnd - 1 || world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a && !world.func_180495_p(blockPos).func_185904_a().func_76224_d() && !world.func_180495_p(blockPos).func_185904_a().func_76222_j() || y != yTop && (Item.func_150898_a((Block)(state = world.func_180495_p(blockPos.func_177984_a())).func_177230_c()) != Item.func_150898_a((Block)sidewalk) || state.func_177230_c().func_180651_a(state) != sidewalkMeta)) continue;
                    world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                }
            }
        }
        for (y = yTop + 1; y <= yEnd; ++y) {
            for (x = xStart; x <= xEnd; ++x) {
                for (z = zStart; z <= zEnd; ++z) {
                    blockPos = new BlockPos(x, y, z);
                    if (x == xStart + 3 || x == xStart + 4 || z == zStart + 3 || z == zStart + 4) {
                        if (y == yStart + 1 || y == yStart + 2) {
                            if (x <= xStart || x >= xEnd || z <= zStart || z >= zEnd) continue;
                            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                            continue;
                        }
                        if (y == yStart + 3 && (x == xStart || x == xEnd || z == zStart || z == zEnd)) {
                            int dir = 2;
                            if ((x - 15) % 16 == 0 || (x - 7) % 16 == 0) {
                                dir = 1;
                            } else if (x % 16 == 0 || (x - 8) % 16 == 0) {
                                dir = 0;
                            } else if ((z - 15) % 16 == 0 || (z - 7) % 16 == 0) {
                                dir = 3;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(4 | dir), 2);
                        }
                    }
                    if (x < xStart + 1 || x > xEnd - 1 || z < zStart + 1 || z > zEnd - 1) continue;
                    if (x == xStart + 1 || x == xEnd - 1 || z == zStart + 1 || z == zEnd - 1) {
                        if ((yEnd - y) % 4 == 0 || y < yStart + 4 || (x - 6) % 16 == 0 || (x - 9) % 16 == 0 || (z - 6) % 16 == 0 || (z - 9) % 16 == 0 || (x == xStart + 1 || x == xEnd - 1) && (z == zStart + 1 || z == zEnd - 1)) {
                            if (slab == Blocks.field_150333_U) {
                                switch (slabMeta) {
                                    case 0: {
                                        world.func_180501_a(blockPos, Blocks.field_150334_T.func_176223_P(), 2);
                                        break;
                                    }
                                    case 1: {
                                        world.func_180501_a(blockPos, Blocks.field_150322_A.func_176223_P(), 2);
                                        break;
                                    }
                                    case 2: {
                                        world.func_180501_a(blockPos, Blocks.field_150417_aV.func_176223_P(), 2);
                                        break;
                                    }
                                    case 3: {
                                        world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                        break;
                                    }
                                    case 4: {
                                        world.func_180501_a(blockPos, Blocks.field_150336_V.func_176223_P(), 2);
                                        break;
                                    }
                                    case 5: {
                                        world.func_180501_a(blockPos, Blocks.field_150417_aV.func_176223_P(), 2);
                                        break;
                                    }
                                    case 6: {
                                        world.func_180501_a(blockPos, Blocks.field_150385_bj.func_176223_P(), 2);
                                        break;
                                    }
                                    case 7: {
                                        world.func_180501_a(blockPos, Blocks.field_150371_ca.func_176223_P(), 2);
                                    }
                                }
                            } else if (slab == Blocks.field_180389_cP) {
                                world.func_180501_a(blockPos, Blocks.field_180395_cM.func_176223_P(), 2);
                            } else if (slab == Blocks.field_185771_cX) {
                                world.func_180501_a(blockPos, Blocks.field_185767_cT.func_176223_P(), 2);
                            } else {
                                world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(slabMeta), 2);
                            }
                        } else if (rand.nextFloat() < glassInWindowChance) {
                            world.func_180501_a(blockPos, Blocks.field_150399_cn.func_176203_a(glassMeta), 2);
                        }
                    }
                    if (x < xStart + 2 || x > xEnd - 2 || z < zStart + 2 || z > zEnd - 2) continue;
                    if (y == yStart) {
                        world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                        continue;
                    }
                    if (!((x - 5) % 16 != 0 && (x - 10) % 16 != 0 || (z - 5) % 16 != 0 && (z - 10) % 16 != 0)) {
                        world.func_180501_a(blockPos, Blocks.field_150468_ap.func_176203_a((z - 10) % 16 == 0 ? 3 : 2), 2);
                        continue;
                    }
                    if ((yEnd - y) % 4 == 0) {
                        if (!((x - 4) % 16 != 0 && (x - 11) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                            if (!(rand.nextFloat() < WEB_CHANCE)) continue;
                            world.func_180501_a(blockPos, Blocks.field_150321_G.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                        continue;
                    }
                    if (y != yEnd && y > yStart + 1 && (yEnd + 1 - y) % 4 == 0) {
                        if (!((x - 4) % 16 != 0 && (x - 11) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                            world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        continue;
                    }
                    world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
    }

    private void generateFactory(World world, Random rand, int yPos, int xStart, int xEnd, int zStart, int zEnd, int maxHeight, Block sidewalk, int sidewalkMeta, Block slab, int slabMeta, int plankMeta, boolean ocean) {
        BlockPos blockPos;
        int z;
        int x;
        int yTop;
        int y;
        int yStart = yPos - 1;
        int yEnd = yPos + maxHeight;
        for (y = yTop = yPos - 2; y >= yStart - 60; --y) {
            for (x = xStart; x <= xEnd; ++x) {
                for (z = zStart; z <= zEnd; ++z) {
                    IBlockState state;
                    blockPos = new BlockPos(x, y, z);
                    if (x != xStart + 1 && x != xEnd - 1 || z != zStart + 1 && z != zEnd - 1 || world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a && !world.func_180495_p(blockPos).func_185904_a().func_76224_d() && !world.func_180495_p(blockPos).func_185904_a().func_76222_j() || y != yTop && (Item.func_150898_a((Block)(state = world.func_180495_p(blockPos.func_177984_a())).func_177230_c()) != Item.func_150898_a((Block)sidewalk) || state.func_177230_c().func_180651_a(state) != sidewalkMeta)) continue;
                    world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                }
            }
        }
        for (y = yTop + 1; y <= yEnd; ++y) {
            for (x = xStart; x <= xEnd; ++x) {
                for (z = zStart; z <= zEnd; ++z) {
                    blockPos = new BlockPos(x, y, z);
                    if (!(y != yStart + 1 && y != yStart + 2 || (x - 7) % 16 != 0 && (x - 8) % 16 != 0 && (z - 7) % 16 != 0 && (z - 8) % 16 != 0)) {
                        if (x <= xStart + 1 || x >= xEnd - 1 || z <= zStart + 1 || z >= zEnd - 1) continue;
                        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        continue;
                    }
                    if (!(x % 16 != 0 && (x - 15) % 16 != 0 && z % 16 != 0 && (z - 15) % 16 != 0 || ((yEnd - y) % 16 != 0 || y == yStart) && (y != yStart + 4 || x >= xStart + 3 && x <= xEnd - 3 || z >= zStart + 3 && z <= zEnd - 3))) {
                        int dir = 2;
                        if ((x - 15) % 16 == 0) {
                            dir = 1;
                        } else if (x % 16 == 0) {
                            dir = 0;
                        } else if ((z - 15) % 16 == 0) {
                            dir = 3;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150390_bg.func_176203_a(4 | dir), 2);
                    }
                    if (x == xStart || x == xEnd || z == zStart || z == zEnd) continue;
                    if ((x - 1) % 16 == 0 || (x - 14) % 16 == 0 || (z - 1) % 16 == 0 || (z - 14) % 16 == 0) {
                        if ((yEnd - y) % 16 == 0 && y != yStart || ((x - 1) % 16 == 0 || (x - 2) % 16 == 0 || (x - 13) % 16 == 0 || (x - 14) % 16 == 0) && ((z - 1) % 16 == 0 || (z - 2) % 16 == 0 || (z - 13) % 16 == 0 || (z - 14) % 16 == 0)) {
                            float c = rand.nextFloat();
                            world.func_180501_a(blockPos, Blocks.field_150417_aV.func_176203_a(c < 0.2f ? 1 : (c < 0.4f ? 2 : 0)), 2);
                        } else if ((yEnd - y) % 4 == 0 && y != yStart) {
                            world.func_180501_a(blockPos, slab.func_176203_a(8 | slabMeta), 2);
                        }
                    }
                    if (x == xStart + 1 || x == xEnd - 1 || z == zStart + 1 || z == zEnd - 1) continue;
                    if ((x - 2) % 16 == 0 || (x - 13) % 16 == 0 || (z - 2) % 16 == 0 || (z - 13) % 16 == 0) {
                        if (y > yStart + 4 && (yEnd - y) % 4 != 0 && ((x - 3) % 16 == 0 || (x - 4) % 16 == 0 || (x - 7) % 16 == 0 || (x - 8) % 16 == 0 || (x - 11) % 16 == 0 || (x - 12) % 16 == 0 || (z - 3) % 16 == 0 || (z - 4) % 16 == 0 || (z - 7) % 16 == 0 || (z - 8) % 16 == 0 || (z - 11) % 16 == 0 || (z - 12) % 16 == 0)) {
                            if (rand.nextFloat() < glassInWindowChance) {
                                world.func_180501_a(blockPos, Blocks.field_150410_aZ.func_176223_P(), 2);
                            }
                        } else if (slab == Blocks.field_150333_U) {
                            switch (slabMeta) {
                                case 0: {
                                    world.func_180501_a(blockPos, Blocks.field_150334_T.func_176223_P(), 2);
                                    break;
                                }
                                case 1: {
                                    world.func_180501_a(blockPos, Blocks.field_150322_A.func_176223_P(), 2);
                                    break;
                                }
                                case 2: {
                                    world.func_180501_a(blockPos, Blocks.field_150417_aV.func_176223_P(), 2);
                                    break;
                                }
                                case 3: {
                                    world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                    break;
                                }
                                case 4: {
                                    world.func_180501_a(blockPos, Blocks.field_150336_V.func_176223_P(), 2);
                                    break;
                                }
                                case 5: {
                                    world.func_180501_a(blockPos, Blocks.field_150417_aV.func_176223_P(), 2);
                                    break;
                                }
                                case 6: {
                                    world.func_180501_a(blockPos, Blocks.field_150385_bj.func_176223_P(), 2);
                                    break;
                                }
                                case 7: {
                                    world.func_180501_a(blockPos, Blocks.field_150371_ca.func_176223_P(), 2);
                                }
                            }
                        } else if (slab == Blocks.field_180389_cP) {
                            world.func_180501_a(blockPos, Blocks.field_180395_cM.func_176223_P(), 2);
                        } else if (slab == Blocks.field_185771_cX) {
                            world.func_180501_a(blockPos, Blocks.field_185767_cT.func_176223_P(), 2);
                        } else {
                            world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(slabMeta), 2);
                        }
                    }
                    if (x == xStart + 2 || x == xEnd - 2 || z == zStart + 2 || z == zEnd - 2) continue;
                    if (y == yStart) {
                        world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                        continue;
                    }
                    if ((x == xStart + 6 || x == xEnd - 6) && z == zStart + 3) {
                        world.func_180501_a(blockPos, Blocks.field_150468_ap.func_176203_a(3), 2);
                        continue;
                    }
                    if ((yEnd - y) % 4 == 0 && (x != xStart + 6 && x != xEnd - 6 || z != zStart + 3)) {
                        if (!((x - 4) % 16 != 0 && (x - 11) % 16 != 0 || (z - 4) % 16 != 0 && (z - 11) % 16 != 0)) {
                            if (!(rand.nextFloat() < WEB_CHANCE)) continue;
                            world.func_180501_a(blockPos, Blocks.field_150321_G.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                        continue;
                    }
                    if (y != yEnd && y > yStart + 1 && (yEnd + 1 - y) % 4 == 0) {
                        if (!((x - 4) % 16 != 0 && (x - 11) % 16 != 0 || (z - 4) % 16 != 0 && (z - 11) % 16 != 0)) {
                            float c = rand.nextFloat();
                            if (c < 0.0125f) {
                                world.func_180501_a(blockPos, Blocks.field_150486_ae.func_176223_P(), 2);
                                IInventory chest = (IInventory)world.func_175625_s(blockPos);
                                if (!CitiesMod.serverOnly) {
                                    ItemStack coinPouch = new ItemStack(CitiesMod.coinPouch);
                                    coinPouch.func_82841_c(rand.nextInt(401) + 100);
                                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), coinPouch);
                                }
                                LootContext lc = new LootContext.Builder((WorldServer)world).func_186471_a();
                                if (c >= 0.00625f) {
                                    world.func_184146_ak().func_186521_a(LootTableList.field_186423_e).func_186460_a(chest, rand, lc);
                                    continue;
                                }
                                if (c >= 0.00275f) {
                                    world.func_184146_ak().func_186521_a(LootTableList.field_186429_k).func_186460_a(chest, rand, lc);
                                    continue;
                                }
                                if (c >= 0.00125f) {
                                    world.func_184146_ak().func_186521_a(LootTableList.field_186424_f).func_186460_a(chest, rand, lc);
                                    continue;
                                }
                                if (c >= 3.75E-4f) {
                                    world.func_184146_ak().func_186521_a(LootTableList.field_186422_d).func_186460_a(chest, rand, lc);
                                    continue;
                                }
                                world.func_184146_ak().func_186521_a(LootTableList.field_186430_l).func_186460_a(chest, rand, lc);
                                continue;
                            }
                            if (c < 0.015f) {
                                if (ocean) {
                                    world.func_175656_a(blockPos, Blocks.field_150360_v.func_176223_P());
                                    continue;
                                }
                                if (spawnersInBuildings) {
                                    world.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 2);
                                    ((TileEntityMobSpawner)world.func_175625_s(blockPos)).func_145881_a().func_98272_a("Skeleton");
                                    continue;
                                }
                                world.func_180501_a(blockPos, Blocks.field_150462_ai.func_176223_P(), 2);
                                continue;
                            }
                            if (c < 0.0175f) {
                                if (ocean) {
                                    world.func_175656_a(blockPos, Blocks.field_150360_v.func_176223_P());
                                    continue;
                                }
                                if (spawnersInBuildings) {
                                    world.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 2);
                                    ((TileEntityMobSpawner)world.func_175625_s(blockPos)).func_145881_a().func_98272_a("Zombie");
                                    continue;
                                }
                                world.func_180501_a(blockPos, Blocks.field_150462_ai.func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(blockPos, Blocks.field_150462_ai.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        continue;
                    }
                    world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
    }

    private void generateTower(World world, Random rand, int yPos, int xStart, int xEnd, int zStart, int zEnd, int maxHeight, Block sidewalk, int sidewalkMeta, Block slab, int slabMeta, Block stone, int stoneMeta, int glassMeta, int carpetMeta, int plankMeta, boolean ocean) {
        BlockPos blockPos;
        int z;
        int x;
        int y;
        int yStart = yPos - 1;
        int yEnd = yPos + maxHeight;
        int yTop = yPos - 2;
        boolean iron = rand.nextFloat() < ironFrameChance;
        for (y = yTop; y >= yStart - 60; --y) {
            for (x = xStart + 1; x <= xEnd - 1; ++x) {
                for (z = zStart + 1; z <= zEnd - 1; ++z) {
                    IBlockState state;
                    blockPos = new BlockPos(x, y, z);
                    if (x != xStart + 1 && x != xEnd - 1 || z != zStart + 1 && z != zEnd - 1 || world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a && !world.func_180495_p(blockPos).func_185904_a().func_76224_d() && !world.func_180495_p(blockPos).func_185904_a().func_76222_j() || y != yTop && (Item.func_150898_a((Block)(state = world.func_180495_p(blockPos.func_177984_a())).func_177230_c()) != Item.func_150898_a((Block)sidewalk) || state.func_177230_c().func_180651_a(state) != sidewalkMeta)) continue;
                    world.func_180501_a(blockPos, sidewalk.func_176203_a(sidewalkMeta), 2);
                }
            }
        }
        for (y = yTop + 1; y <= yEnd; ++y) {
            for (x = xStart + 1; x <= xEnd - 1; ++x) {
                for (z = zStart + 1; z <= zEnd - 1; ++z) {
                    blockPos = new BlockPos(x, y, z);
                    if (!(y != yStart + 1 && y != yStart + 2 || (x - 7) % 16 != 0 && (x - 8) % 16 != 0 && (z - 7) % 16 != 0 && (z - 8) % 16 != 0)) {
                        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        continue;
                    }
                    if ((x - 1) % 16 == 0 || (x - 14) % 16 == 0 || (z - 1) % 16 == 0 || (z - 14) % 16 == 0) {
                        if (!((x - 1) % 16 != 0 && (x - 14) % 16 != 0 || (z - 1) % 16 != 0 && (z - 14) % 16 != 0)) {
                            if (iron) {
                                world.func_180501_a(blockPos, Blocks.field_150339_S.func_176223_P(), 2);
                            } else {
                                world.func_180501_a(blockPos, Blocks.field_150334_T.func_176223_P().func_177226_a((IProperty)BlockDoubleStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.STONE).func_177226_a((IProperty)BlockDoubleStoneSlab.field_176555_b, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        } else if ((yEnd - y) % 16 == 0) {
                            if (slab == Blocks.field_150333_U) {
                                switch (slabMeta) {
                                    case 0: {
                                        world.func_180501_a(blockPos, Blocks.field_150334_T.func_176223_P(), 2);
                                        break;
                                    }
                                    case 1: {
                                        world.func_180501_a(blockPos, Blocks.field_150322_A.func_176223_P(), 2);
                                        break;
                                    }
                                    case 2: {
                                        world.func_180501_a(blockPos, Blocks.field_150417_aV.func_176223_P(), 2);
                                        break;
                                    }
                                    case 3: {
                                        world.func_180501_a(blockPos, Blocks.field_150347_e.func_176223_P(), 2);
                                        break;
                                    }
                                    case 4: {
                                        world.func_180501_a(blockPos, Blocks.field_150336_V.func_176223_P(), 2);
                                        break;
                                    }
                                    case 5: {
                                        world.func_180501_a(blockPos, Blocks.field_150417_aV.func_176223_P(), 2);
                                        break;
                                    }
                                    case 6: {
                                        world.func_180501_a(blockPos, Blocks.field_150385_bj.func_176223_P(), 2);
                                        break;
                                    }
                                    case 7: {
                                        world.func_180501_a(blockPos, Blocks.field_150371_ca.func_176223_P(), 2);
                                    }
                                }
                            } else if (slab == Blocks.field_180389_cP) {
                                world.func_180501_a(blockPos, Blocks.field_180395_cM.func_176223_P(), 2);
                            } else if (slab == Blocks.field_185771_cX) {
                                world.func_180501_a(blockPos, Blocks.field_185767_cT.func_176223_P(), 2);
                            }
                        } else if (rand.nextFloat() < glassInWindowChance) {
                            world.func_180501_a(blockPos, Blocks.field_150399_cn.func_176203_a(glassMeta), 2);
                        }
                    }
                    if (x == xStart + 1 || x == xEnd - 1 || z == zStart + 1 || z == zEnd - 1) continue;
                    if (y == yStart) {
                        world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                        continue;
                    }
                    if ((yEnd - y) % 4 == 0) {
                        if (!((x - 3) % 16 != 0 && (x - 12) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                            if (rand.nextFloat() < WEB_CHANCE) {
                                world.func_180501_a(blockPos, Blocks.field_150321_G.func_176223_P(), 2);
                            }
                        } else if (x < xStart + 5 || x > xEnd - 5 || z < zStart + 5 || z > zEnd - 5) {
                            world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                        }
                    } else if (y != yEnd && y > yStart + 1 && (yEnd + 1 - y) % 4 == 0) {
                        if (!((x - 3) % 16 != 0 && (x - 12) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                            float c = rand.nextFloat();
                            if (c < 0.0125f) {
                                world.func_180501_a(blockPos, Blocks.field_150486_ae.func_176223_P(), 2);
                                IInventory chest = (IInventory)world.func_175625_s(blockPos);
                                if (!CitiesMod.serverOnly) {
                                    ItemStack coinPouch = new ItemStack(CitiesMod.coinPouch);
                                    coinPouch.func_82841_c(rand.nextInt(801) + 200);
                                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), coinPouch);
                                }
                                LootContext lc = new LootContext.Builder((WorldServer)world).func_186471_a();
                                if (c >= 0.00625f) {
                                    world.func_184146_ak().func_186521_a(LootTableList.field_186423_e).func_186460_a(chest, rand, lc);
                                } else if (c >= 0.00275f) {
                                    world.func_184146_ak().func_186521_a(LootTableList.field_186429_k).func_186460_a(chest, rand, lc);
                                } else if (c >= 0.00125f) {
                                    world.func_184146_ak().func_186521_a(LootTableList.field_186424_f).func_186460_a(chest, rand, lc);
                                } else if (c >= 3.75E-4f) {
                                    world.func_184146_ak().func_186521_a(LootTableList.field_186422_d).func_186460_a(chest, rand, lc);
                                } else {
                                    world.func_184146_ak().func_186521_a(LootTableList.field_186430_l).func_186460_a(chest, rand, lc);
                                }
                            } else if (c < 0.0175f) {
                                if (ocean) {
                                    world.func_175656_a(blockPos, Blocks.field_150360_v.func_176223_P());
                                } else if (spawnersInBuildings) {
                                    world.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 2);
                                    if (blazeSpawners) {
                                        ((TileEntityMobSpawner)world.func_175625_s(blockPos)).func_145881_a().func_98272_a("Blaze");
                                    } else {
                                        ((TileEntityMobSpawner)world.func_175625_s(blockPos)).func_145881_a().func_98272_a("CaveSpider");
                                    }
                                } else {
                                    world.func_180501_a(blockPos, Blocks.field_150342_X.func_176223_P(), 2);
                                }
                            } else if (c < 0.025f) {
                                if (ocean) {
                                    world.func_175656_a(blockPos, Blocks.field_150360_v.func_176223_P());
                                } else if (spawnersInBuildings) {
                                    world.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 2);
                                    ((TileEntityMobSpawner)world.func_175625_s(blockPos)).func_145881_a().func_98272_a("Skeleton");
                                } else {
                                    world.func_180501_a(blockPos, Blocks.field_150342_X.func_176223_P(), 2);
                                }
                            } else {
                                world.func_180501_a(blockPos, Blocks.field_150342_X.func_176223_P(), 2);
                            }
                        } else if (x < xStart + 5 || x > xEnd - 5 || z < zStart + 5 || z > zEnd - 5) {
                            if (rand.nextFloat() < 0.9f) {
                                world.func_180501_a(blockPos, Blocks.field_150404_cg.func_176203_a(carpetMeta), 2);
                            } else {
                                world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                            }
                        }
                    } else if (x < xStart + 5 || x > xEnd - 5 || z < zStart + 5 || z > zEnd - 5) {
                        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                    if (x < xStart + 5 || x > xEnd - 5 || z < zStart + 5 || z > zEnd - 5) continue;
                    if (!((yEnd + 1 - y) % 4 != 0 && (yEnd + 2 - y) % 4 != 0 || (x - 5) % 16 != 0 && (x - 10) % 16 != 0 || (z - 7) % 16 != 0 && (z - 8) % 16 != 0)) {
                        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                    } else if ((x - 5) % 16 == 0 || (x - 10) % 16 == 0 || (z - 5) % 16 == 0 || (z - 10) % 16 == 0) {
                        world.func_180501_a(blockPos, stone.func_176203_a(stoneMeta), 2);
                    }
                    if (x < xStart + 6 || x > xEnd - 6 || z < zStart + 6 || z > zEnd - 6) continue;
                    if ((yEnd - y) % 4 == 0 && (x != xStart + 6 && x != xEnd - 6 || z != zStart + 6)) {
                        if ((z - 8) % 16 == 0 && (x - 8) % 16 == 0) {
                            if (!(rand.nextFloat() < WEB_CHANCE)) continue;
                            world.func_180501_a(blockPos, Blocks.field_150321_G.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150344_f.func_176203_a(plankMeta), 2);
                        continue;
                    }
                    if (!(y == yStart + 1 || (yEnd + 1 - y) % 4 != 0 || (z - 7) % 16 != 0 && (z - 8) % 16 != 0 || (x - 7) % 16 != 0 && (x - 8) % 16 != 0)) {
                        if (rand.nextFloat() < 0.9f) {
                            world.func_180501_a(blockPos, Blocks.field_150404_cg.func_176203_a(carpetMeta), 2);
                            continue;
                        }
                        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                        continue;
                    }
                    if ((x == xStart + 6 || x == xEnd - 6) && z == zStart + 6) {
                        world.func_180501_a(blockPos, Blocks.field_150468_ap.func_176203_a(3), 2);
                        continue;
                    }
                    world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
    }

    private void roadNetwork(byte[][] roads, Random rand, int xStart, int xEnd, int yStart, int yEnd, float subwaychance) {
        boolean h = yEnd - yStart <= 6 ? false : (xEnd - xStart <= 6 ? true : rand.nextBoolean());
        if (h) {
            if (yEnd - yStart <= 6) {
                return;
            }
            int line = rand.nextInt(yEnd - yStart - 4) + yStart + 2;
            float chance = rand.nextFloat();
            for (int i = xStart; i <= xEnd; ++i) {
                roads[i][line] = chance < subwaychance ? (rand.nextFloat() < 0.2f ? 5 : 3) : 1;
            }
            this.roadNetwork(roads, rand, xStart, xEnd, yStart, line - 1, subwaychance / 2.0f);
            this.roadNetwork(roads, rand, xStart, xEnd, line + 1, yEnd, subwaychance / 2.0f);
        } else {
            if (xEnd - xStart <= 6) {
                return;
            }
            int line = rand.nextInt(xEnd - xStart - 4) + xStart + 2;
            float chance = rand.nextFloat();
            for (int i = yStart; i <= yEnd; ++i) {
                roads[line][i] = chance < subwaychance ? (rand.nextFloat() < 0.2f ? 5 : 3) : 1;
            }
            this.roadNetwork(roads, rand, xStart, line - 1, yStart, yEnd, subwaychance / 2.0f);
            this.roadNetwork(roads, rand, line + 1, xEnd, yStart, yEnd, subwaychance / 2.0f);
        }
    }
}

