/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.inventory;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public final class UtilInventory {
    private static final InventoryCrafting craftMatrix = new InventoryCrafting(new Container(){

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }, 3, 3);

    private UtilInventory() {
    }

    public static ItemStack addItemToInventory(IInventory inventory, ItemStack stack) {
        ItemStack itemstack1;
        int j;
        int i = inventory.func_70302_i_();
        for (j = 0; j < i && stack != null && stack.field_77994_a > 0; ++j) {
            itemstack1 = inventory.func_70301_a(j);
            if (itemstack1 == null || !UtilInventory.canCombine(itemstack1, stack)) continue;
            stack = UtilInventory.addItemToSlot(inventory, stack, j);
        }
        for (j = 0; j < i && stack != null && stack.field_77994_a > 0; ++j) {
            itemstack1 = inventory.func_70301_a(j);
            if (itemstack1 != null) continue;
            stack = UtilInventory.addItemToSlot(inventory, stack, j);
        }
        if (stack != null && stack.field_77994_a == 0) {
            stack = null;
        }
        return stack;
    }

    private static ItemStack addItemToSlot(IInventory inventory, ItemStack stack, int index) {
        ItemStack itemstack1 = inventory.func_70301_a(index);
        if (inventory.func_94041_b(index, stack)) {
            int max;
            boolean flag = false;
            if (itemstack1 == null) {
                int max2 = Math.min(stack.func_77976_d(), inventory.func_70297_j_());
                if (max2 >= stack.field_77994_a) {
                    inventory.func_70299_a(index, stack);
                    stack = null;
                } else {
                    inventory.func_70299_a(index, stack.func_77979_a(max2));
                }
                flag = true;
            } else if (UtilInventory.canCombine(itemstack1, stack) && (max = Math.min(stack.func_77976_d(), inventory.func_70297_j_())) > itemstack1.field_77994_a) {
                int size = Math.min(stack.field_77994_a, max - itemstack1.field_77994_a);
                stack.field_77994_a -= size;
                itemstack1.field_77994_a += size;
                boolean bl = flag = size > 0;
            }
            if (flag) {
                inventory.func_70296_d();
            }
        }
        return stack;
    }

    private static final boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77960_j() != stack2.func_77960_j() ? false : (stack1.field_77994_a > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }

    public static boolean isSlotsFull(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack != null && stack.field_77994_a != 0) continue;
            return false;
        }
        return true;
    }

    public static ItemStack findItem(IInventory inventory, ItemStack request) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a < request.field_77994_a || stack.func_77973_b() != request.func_77973_b()) continue;
            return inventory.func_70298_a(i, request.field_77994_a);
        }
        return null;
    }

    public static ItemStack findItemCompatibleSlab(World world, IInventory inventory, ItemStack slab) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            craftMatrix.func_174888_l();
            craftMatrix.func_70299_a(0, stack);
            craftMatrix.func_70299_a(1, stack);
            craftMatrix.func_70299_a(2, stack);
            if (stack == null || stack.field_77994_a < 1 || !ItemStack.func_77989_b((ItemStack)CraftingManager.func_77594_a().func_82787_a(craftMatrix, world), (ItemStack)slab)) continue;
            return inventory.func_70298_a(i, 1);
        }
        return null;
    }

    public static ItemStack findItemMeta(IInventory inventory, ItemStack request) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a < request.field_77994_a || stack.func_77973_b() != request.func_77973_b() || stack.func_77960_j() != request.func_77960_j()) continue;
            return inventory.func_70298_a(i, request.field_77994_a);
        }
        return null;
    }

    public static ItemStack findItemMetaWithMin(IInventory inventory, int min, ItemStack request) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a < min || stack.func_77973_b() != request.func_77973_b() || request.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != request.func_77960_j()) continue;
            return inventory.func_70298_a(i, request.field_77994_a);
        }
        return null;
    }

    public static ItemStack findItemCompatibleSlabWithMin(World world, IInventory inventory, int min, ItemStack slab) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            craftMatrix.func_174888_l();
            craftMatrix.func_70299_a(0, stack);
            craftMatrix.func_70299_a(1, stack);
            craftMatrix.func_70299_a(2, stack);
            if (stack == null || stack.field_77994_a < min || !ItemStack.func_77989_b((ItemStack)CraftingManager.func_77594_a().func_82787_a(craftMatrix, world), (ItemStack)slab)) continue;
            return inventory.func_70298_a(i, 1);
        }
        return null;
    }

    public static ItemStack findItems(IInventory inventory, ItemStack ... requests) {
        for (int arg = 0; arg < requests.length; ++arg) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null || stack.field_77994_a < requests[arg].field_77994_a || stack.func_77973_b() != requests[arg].func_77973_b()) continue;
                return inventory.func_70298_a(i, requests[arg].field_77994_a);
            }
        }
        return null;
    }

    public static ItemStack findItemsMeta(IInventory inventory, ItemStack ... requests) {
        for (int arg = 0; arg < requests.length; ++arg) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null || stack.field_77994_a < requests[arg].field_77994_a || stack.func_77973_b() != requests[arg].func_77973_b() || stack.func_77960_j() != requests[arg].func_77960_j()) continue;
                return inventory.func_70298_a(i, requests[arg].field_77994_a);
            }
        }
        return null;
    }

    public static int findItem(IInventory inventory, Item item, int amount) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a < amount || stack.func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static int findItem(IInventory inventory, Item item, int amount, int meta) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a < amount || stack.func_77973_b() != item || stack.func_77960_j() != meta) continue;
            return i;
        }
        return -1;
    }

    public static int findItem(IInventory inventory, Item item) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0 || stack.func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static int findItemCompatibleSlabSlot(World world, IInventory inventory, ItemStack slab) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            craftMatrix.func_174888_l();
            craftMatrix.func_70299_a(0, stack);
            craftMatrix.func_70299_a(1, stack);
            craftMatrix.func_70299_a(2, stack);
            if (stack == null || stack.field_77994_a <= 0 || !ItemStack.func_77989_b((ItemStack)CraftingManager.func_77594_a().func_82787_a(craftMatrix, world), (ItemStack)slab)) continue;
            return i;
        }
        return -1;
    }

    public static int findItemDictionary(IInventory inventory, List<ItemStack> stacks) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackTarget;
            ItemStack stack = inventory.func_70301_a(i);
            ItemStack itemStack = stackTarget = stack != null ? new ItemStack(stack.func_77973_b(), 1, Short.MAX_VALUE) : null;
            if (stack == null || stack.field_77994_a <= 0 || !OreDictionary.containsMatch((boolean)false, stacks, (ItemStack[])new ItemStack[]{stackTarget})) continue;
            return i;
        }
        return -1;
    }

    public static int findItem(IInventory inventory, Class c, int amount) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a < amount || !c.isInstance(stack.func_77973_b())) continue;
            return i;
        }
        return -1;
    }

    public static int findItems(IInventory inventory, Item ... requests) {
        for (int arg = 0; arg < requests.length; ++arg) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null || stack.field_77994_a < 0 || stack.func_77973_b() != requests[arg]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int findFood(IInventory inventory, int amount, float quality) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemFood food;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemFood) || stack.field_77994_a < amount || (float)(food = (ItemFood)stack.func_77973_b()).func_150905_g(stack) + (float)food.func_150905_g(stack) * food.func_150906_h(stack) * 2.0f < quality) continue;
            return i;
        }
        return -1;
    }
}

