/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.inventory;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public final class AutoRecipes {
    private static final ItemStack coal_8 = new ItemStack(Items.field_151044_h, 8, 0);
    private static final ItemStack charcoal_8 = new ItemStack(Items.field_151044_h, 8, 1);
    private static final ItemStack coal_2 = new ItemStack(Items.field_151044_h, 2, 0);
    private static final ItemStack charcoal_2 = new ItemStack(Items.field_151044_h, 2, 1);
    private static final ItemStack stonebrick_6 = new ItemStack(Item.func_150898_a((Block)Blocks.field_150417_aV), 6);
    private static final ItemStack quartzblock_6 = new ItemStack(Item.func_150898_a((Block)Blocks.field_150371_ca), 6);
    private static final ItemStack quartzblock = new ItemStack(Item.func_150898_a((Block)Blocks.field_150371_ca));
    private static final ItemStack cobblestone = new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e));
    private static final ItemStack glass_6 = new ItemStack(Item.func_150898_a((Block)Blocks.field_150359_w), 6);
    private static final ItemStack book_3 = new ItemStack(Items.field_151122_aG, 3);
    public static List<ItemStack> logWood = new ArrayList<ItemStack>();
    public static List<ItemStack> plankWood = new ArrayList<ItemStack>();
    public static List<ItemStack> slabWood = new ArrayList<ItemStack>();
    public static List<ItemStack> stone = new ArrayList<ItemStack>();
    public static List<ItemStack> blockGlass = new ArrayList<ItemStack>();
    public static List<ItemStack> minable = new ArrayList<ItemStack>();
    public static List<ItemStack> ores = new ArrayList<ItemStack>();
    public static List<Item> banned = new ArrayList<Item>();
    public static List<String> minableWhiteList;
    public static List<String> oreWhiteList;
    public static List<String> importBlackList;
    private static final InventoryCrafting craftMatrix;

    private AutoRecipes() {
    }

    public static void init() {
        logWood.addAll(OreDictionary.getOres((String)"logWood"));
        plankWood.addAll(OreDictionary.getOres((String)"plankWood"));
        slabWood.addAll(OreDictionary.getOres((String)"slabWood"));
        for (String name : OreDictionary.getOreNames()) {
            if (name.startsWith("ore")) {
                ores.addAll(OreDictionary.getOres((String)name));
                continue;
            }
            if (name.startsWith("grass")) {
                minable.addAll(OreDictionary.getOres((String)name));
                continue;
            }
            if (name.startsWith("dirt")) {
                minable.addAll(OreDictionary.getOres((String)name));
                continue;
            }
            if (name.startsWith("gravel")) {
                minable.addAll(OreDictionary.getOres((String)name));
                continue;
            }
            if (name.startsWith("sand")) {
                minable.addAll(OreDictionary.getOres((String)name));
                continue;
            }
            if (name.startsWith("stone")) {
                stone.addAll(OreDictionary.getOres((String)name));
                minable.addAll(OreDictionary.getOres((String)name));
                continue;
            }
            if (!name.startsWith("blockGlass")) continue;
            blockGlass.addAll(OreDictionary.getOres((String)name));
        }
        minable.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150405_ch), 1, Short.MAX_VALUE));
        minable.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150406_ce), 1, Short.MAX_VALUE));
        minable.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150418_aU), 1, Short.MAX_VALUE));
        minable.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150424_aL), 1, Short.MAX_VALUE));
        ores.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150435_aG), 1, Short.MAX_VALUE));
        if (minableWhiteList != null) {
            for (String name : minableWhiteList) {
                Block block = Block.func_149684_b((String)name);
                if (block != null) {
                    minable.add(new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE));
                    continue;
                }
                System.out.println("No block found with name: " + name);
            }
        }
        if (oreWhiteList != null) {
            for (String name : oreWhiteList) {
                Block block = Block.func_149684_b((String)name);
                if (block != null) {
                    ores.add(new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE));
                    continue;
                }
                System.out.println("No block found with name: " + name);
            }
        }
        if (importBlackList != null) {
            for (String name : importBlackList) {
                Item item = Item.func_111206_d((String)name);
                if (item != null) {
                    banned.add(item);
                    continue;
                }
                Block block = Block.func_149684_b((String)name);
                if (block != null) {
                    banned.add(Item.func_150898_a((Block)block));
                    continue;
                }
                System.out.println("No block or item found with name: " + name);
            }
        }
    }

    public static ItemStack make8SticksFromLog(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = null;
        int found = UtilInventory.findItemDictionary(inventory, logWood);
        if (found >= 0) {
            received = inventory.func_70298_a(found, 1);
        }
        if (received == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = logWood.iterator();
            while (iterator.hasNext() && (received = lot.requestItem(world, pos, stack = iterator.next())) == null) {
            }
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Items.field_151055_y, 8);
    }

    public static ItemStack make4SticksFromPlanks(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedPlank = null;
        int found = UtilInventory.findItemDictionary(inventory, plankWood);
        if (found >= 0 && inventory.func_70301_a((int)found).field_77994_a >= 2) {
            receivedPlank = inventory.func_70298_a(found, 2);
        }
        if (receivedPlank == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = plankWood.iterator();
            while (iterator.hasNext() && (receivedPlank = lot.requestItem(world, pos, new ItemStack((stack = iterator.next()).func_77973_b(), 2, stack.func_77960_j()))) == null) {
            }
        }
        if (receivedPlank == null) {
            return null;
        }
        return new ItemStack(Items.field_151055_y, 4);
    }

    public static ItemStack make32TorchesFromCoalAndLogs(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedCoal = UtilInventory.findItemsMeta(inventory, coal_8, charcoal_8);
        if (receivedCoal == null && (receivedCoal = lot.requestItem(world, pos, coal_8)) == null) {
            receivedCoal = lot.requestItem(world, pos, charcoal_8);
        }
        if (receivedCoal == null) {
            return null;
        }
        ItemStack receivedLogs = null;
        int found = UtilInventory.findItemDictionary(inventory, logWood);
        if (found >= 0) {
            receivedLogs = inventory.func_70298_a(found, 1);
        }
        if (receivedLogs == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = logWood.iterator();
            while (iterator.hasNext() && (receivedLogs = lot.requestItem(world, pos, stack = iterator.next())) == null) {
            }
        }
        if (receivedLogs == null) {
            UtilInventory.addItemToInventory(inventory, receivedCoal);
            return null;
        }
        return new ItemStack(Blocks.field_150478_aa, 32);
    }

    public static ItemStack make8TorchesFromCoalAndPlanks(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedCoal = UtilInventory.findItemsMeta(inventory, coal_2, charcoal_2);
        if (receivedCoal == null && (receivedCoal = lot.requestItem(world, pos, coal_2)) == null) {
            receivedCoal = lot.requestItem(world, pos, charcoal_2);
        }
        if (receivedCoal == null) {
            return null;
        }
        ItemStack receivedPlank = null;
        int found = UtilInventory.findItemDictionary(inventory, plankWood);
        if (found >= 0) {
            receivedPlank = inventory.func_70298_a(found, 1);
        }
        if (receivedPlank == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = plankWood.iterator();
            while (iterator.hasNext() && (receivedPlank = lot.requestItem(world, pos, stack = iterator.next())) == null) {
            }
        }
        if (receivedPlank == null) {
            UtilInventory.addItemToInventory(inventory, receivedCoal);
            return null;
        }
        return new ItemStack(Blocks.field_150478_aa, 8);
    }

    public static ItemStack make4StonebrickStairsFromStonebrick(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItem(inventory, stonebrick_6);
        if (received == null) {
            received = lot.requestItem(world, pos, stonebrick_6);
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Blocks.field_150390_bg, 4);
    }

    public static ItemStack make4QuartzStairsFromQuartzblock(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItem(inventory, quartzblock_6);
        if (received == null) {
            received = lot.requestItem(world, pos, quartzblock_6);
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Blocks.field_150370_cb, 4);
    }

    public static ItemStack make2CobblestoneSlabFromCobblestone(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItem(inventory, cobblestone);
        if (received == null) {
            received = lot.requestItem(world, pos, cobblestone);
        }
        if (received == null) {
            return null;
        }
        return new ItemStack((Block)Blocks.field_150333_U, 2, 3);
    }

    public static ItemStack make2QuartzSlabFromQuartzblock(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItem(inventory, quartzblock);
        if (received == null) {
            received = lot.requestItem(world, pos, quartzblock);
        }
        if (received == null) {
            return null;
        }
        return new ItemStack((Block)Blocks.field_150333_U, 2, 7);
    }

    public static ItemStack make2SlabsFromBlocks(World world, BlockPos pos, Item item, int meta, BlockFounder lot, IInventory inventory) {
        Item block = null;
        int blockMeta = 0;
        int found = UtilInventory.findItemCompatibleSlabSlot(world, inventory, new ItemStack(item, 6, meta));
        if (found < 0) {
            if (item == Item.func_150898_a((Block)Blocks.field_150333_U)) {
                switch (meta) {
                    case 0: {
                        block = Item.func_150898_a((Block)Blocks.field_150348_b);
                        break;
                    }
                    case 1: {
                        block = Item.func_150898_a((Block)Blocks.field_150322_A);
                        break;
                    }
                    case 2: {
                        block = Item.func_150898_a((Block)Blocks.field_150344_f);
                        break;
                    }
                    case 3: {
                        block = Item.func_150898_a((Block)Blocks.field_150347_e);
                        break;
                    }
                    case 4: {
                        block = Item.func_150898_a((Block)Blocks.field_150336_V);
                        break;
                    }
                    case 5: {
                        block = Item.func_150898_a((Block)Blocks.field_150417_aV);
                        break;
                    }
                    case 6: {
                        block = Item.func_150898_a((Block)Blocks.field_150385_bj);
                        break;
                    }
                    case 7: {
                        block = Item.func_150898_a((Block)Blocks.field_150371_ca);
                    }
                }
            } else if (item == Item.func_150898_a((Block)Blocks.field_180389_cP)) {
                block = Item.func_150898_a((Block)Blocks.field_180395_cM);
            } else if (item == Item.func_150898_a((Block)Blocks.field_185771_cX)) {
                block = Item.func_150898_a((Block)Blocks.field_185767_cT);
            } else if (item == Item.func_150898_a((Block)Blocks.field_150376_bx)) {
                block = Item.func_150898_a((Block)Blocks.field_150344_f);
                blockMeta = meta;
            }
        } else {
            ItemStack request = inventory.func_70301_a(found);
            block = request.func_77973_b();
            blockMeta = request.func_77960_j();
        }
        if (block == null) {
            return null;
        }
        ItemStack received = UtilInventory.findItemCompatibleSlabWithMin(world, inventory, 2, new ItemStack(item, 6, meta));
        if (received == null) {
            received = lot.requestItem(world, pos, new ItemStack(block, 1, blockMeta));
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(item, 2, meta);
    }

    public static ItemStack make12FenceFromLogs(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = null;
        int found = UtilInventory.findItemDictionary(inventory, logWood);
        if (found >= 0 && inventory.func_70301_a((int)found).field_77994_a >= 5) {
            received = inventory.func_70298_a(found, 5);
        }
        if (received == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = logWood.iterator();
            while (iterator.hasNext() && (received = lot.requestItem(world, pos, new ItemStack((stack = iterator.next()).func_77973_b(), 5, stack.func_77960_j()))) == null) {
            }
        }
        if (received == null) {
            return null;
        }
        craftMatrix.func_174888_l();
        craftMatrix.func_70299_a(0, received);
        ItemStack plank = CraftingManager.func_77594_a().func_82787_a(craftMatrix, world);
        if (plank == null) {
            UtilInventory.addItemToInventory(inventory, received);
            return null;
        }
        craftMatrix.func_174888_l();
        craftMatrix.func_70299_a(0, plank);
        craftMatrix.func_70299_a(1, new ItemStack(Items.field_151055_y));
        craftMatrix.func_70299_a(2, plank);
        craftMatrix.func_70299_a(3, plank);
        craftMatrix.func_70299_a(4, new ItemStack(Items.field_151055_y));
        craftMatrix.func_70299_a(5, plank);
        ItemStack ret = CraftingManager.func_77594_a().func_82787_a(craftMatrix, world);
        if (ret == null) {
            UtilInventory.addItemToInventory(inventory, received);
            return null;
        }
        return new ItemStack(ret.func_77973_b(), 12, ret.func_77960_j());
    }

    public static ItemStack make3FenceFromPlanks(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = null;
        int found = UtilInventory.findItemDictionary(inventory, plankWood);
        if (found >= 0 && inventory.func_70301_a((int)found).field_77994_a >= 5) {
            received = inventory.func_70298_a(found, 5);
        }
        if (received == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = plankWood.iterator();
            while (iterator.hasNext() && (received = lot.requestItem(world, pos, new ItemStack((stack = iterator.next()).func_77973_b(), 5, stack.func_77960_j()))) == null) {
            }
        }
        if (received == null) {
            return null;
        }
        craftMatrix.func_174888_l();
        craftMatrix.func_70299_a(0, received);
        craftMatrix.func_70299_a(1, new ItemStack(Items.field_151055_y));
        craftMatrix.func_70299_a(2, received);
        craftMatrix.func_70299_a(3, received);
        craftMatrix.func_70299_a(4, new ItemStack(Items.field_151055_y));
        craftMatrix.func_70299_a(5, received);
        ItemStack ret = CraftingManager.func_77594_a().func_82787_a(craftMatrix, world);
        if (ret == null) {
            UtilInventory.addItemToInventory(inventory, received);
            return null;
        }
        return new ItemStack(ret.func_77973_b(), 3, ret.func_77960_j());
    }

    public static ItemStack make24LaddersFromLogs(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = null;
        int found = UtilInventory.findItemDictionary(inventory, logWood);
        if (found >= 0 && inventory.func_70301_a((int)found).field_77994_a >= 7) {
            received = inventory.func_70298_a(found, 7);
        }
        if (received == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = logWood.iterator();
            while (iterator.hasNext() && (received = lot.requestItem(world, pos, new ItemStack((stack = iterator.next()).func_77973_b(), 7, stack.func_77960_j()))) == null) {
            }
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Blocks.field_150468_ap, 24);
    }

    public static ItemStack make24LaddersFromPlanks(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = null;
        int found = UtilInventory.findItemDictionary(inventory, plankWood);
        if (found >= 0 && inventory.func_70301_a((int)found).field_77994_a >= 28) {
            received = inventory.func_70298_a(found, 28);
        }
        if (received == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = plankWood.iterator();
            while (iterator.hasNext() && (received = lot.requestItem(world, pos, new ItemStack((stack = iterator.next()).func_77973_b(), 28, stack.func_77960_j()))) == null) {
            }
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Blocks.field_150468_ap, 24);
    }

    public static ItemStack make16GlassPanesFromGlassBlock(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItem(inventory, glass_6);
        if (received == null) {
            received = lot.requestItem(world, pos, glass_6);
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Blocks.field_150410_aZ, 16);
    }

    public static ItemStack make1CraftingTableFromPlanks(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = null;
        int found = UtilInventory.findItemDictionary(inventory, plankWood);
        if (found >= 0 && inventory.func_70301_a((int)found).field_77994_a >= 4) {
            received = inventory.func_70298_a(found, 4);
        }
        if (received == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = plankWood.iterator();
            while (iterator.hasNext() && (received = lot.requestItem(world, pos, new ItemStack((stack = iterator.next()).func_77973_b(), 4, stack.func_77960_j()))) == null) {
            }
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Blocks.field_150462_ai);
    }

    public static ItemStack make1BookshelvesFromPlanks(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedBooks = UtilInventory.findItem(inventory, book_3);
        if (receivedBooks == null) {
            receivedBooks = lot.requestItem(world, pos, book_3);
        }
        if (receivedBooks == null) {
            return null;
        }
        ItemStack receivedPlank = null;
        int found = UtilInventory.findItemDictionary(inventory, plankWood);
        if (found >= 0 && inventory.func_70301_a((int)found).field_77994_a >= 6) {
            receivedPlank = inventory.func_70298_a(found, 6);
        }
        if (receivedPlank == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = plankWood.iterator();
            while (iterator.hasNext() && (receivedPlank = lot.requestItem(world, pos, new ItemStack((stack = iterator.next()).func_77973_b(), 6, stack.func_77960_j()))) == null) {
            }
        }
        if (receivedPlank == null) {
            UtilInventory.addItemToInventory(inventory, receivedBooks);
            return null;
        }
        return new ItemStack(Blocks.field_150342_X);
    }

    public static ItemStack make4PlanksFromLog(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = null;
        int found = UtilInventory.findItemDictionary(inventory, logWood);
        if (found >= 0) {
            received = inventory.func_70298_a(found, 1);
        }
        if (received == null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = logWood.iterator();
            while (iterator.hasNext() && (received = lot.requestItem(world, pos, stack = iterator.next())) == null) {
            }
        }
        if (received == null) {
            return null;
        }
        craftMatrix.func_174888_l();
        craftMatrix.func_70299_a(0, received);
        ItemStack ret = CraftingManager.func_77594_a().func_82787_a(craftMatrix, world);
        if (ret == null) {
            UtilInventory.addItemToInventory(inventory, received);
            return null;
        }
        return new ItemStack(ret.func_77973_b(), 4, ret.func_77960_j());
    }

    public static ItemStack make4PumpkinSeedFromPumpkin(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItem(inventory, new ItemStack(Blocks.field_150423_aK));
        if (received == null) {
            received = lot.requestItem(world, pos, new ItemStack(Blocks.field_150423_aK));
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Items.field_151080_bb, 4);
    }

    public static ItemStack make1MelonSeedFromMelon(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItem(inventory, new ItemStack(Items.field_151127_ba));
        if (received == null) {
            received = lot.requestItem(world, pos, new ItemStack(Items.field_151127_ba));
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Items.field_151081_bc, 1);
    }

    public static ItemStack make3PaperFrom3Reed(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItem(inventory, new ItemStack(Items.field_151120_aE, 3));
        if (received == null) {
            received = lot.requestItem(world, pos, new ItemStack(Items.field_151120_aE, 3));
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Items.field_151121_aF, 3);
    }

    public static ItemStack make3WhiteFrom1Bone(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151103_aS));
        if (received == null) {
            received = lot.requestItem(world, pos, new ItemStack(Items.field_151103_aS));
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 3, 15);
    }

    public static ItemStack make2RedFrom1Rose(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItemMeta(inventory, new ItemStack((Block)Blocks.field_150398_cm, 1, 4));
        if (received == null) {
            received = lot.requestItem(world, pos, new ItemStack((Block)Blocks.field_150398_cm, 1, 4));
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 2, 1);
    }

    public static ItemStack make2YellowFrom1Sunflower(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItemMeta(inventory, new ItemStack((Block)Blocks.field_150398_cm, 1, 0));
        if (received == null) {
            received = lot.requestItem(world, pos, new ItemStack((Block)Blocks.field_150398_cm, 1, 0));
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 2, 11);
    }

    public static ItemStack make4OrangeFrom1Rose1Sunflower(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedRose = UtilInventory.findItemMeta(inventory, new ItemStack((Block)Blocks.field_150398_cm, 1, 4));
        if (receivedRose == null) {
            receivedRose = lot.requestItem(world, pos, new ItemStack((Block)Blocks.field_150398_cm, 1, 4));
        }
        if (receivedRose == null) {
            return null;
        }
        ItemStack receivedSunflower = UtilInventory.findItemMeta(inventory, new ItemStack((Block)Blocks.field_150398_cm, 1, 0));
        if (receivedSunflower == null) {
            receivedSunflower = lot.requestItem(world, pos, new ItemStack((Block)Blocks.field_150398_cm, 1, 0));
        }
        if (receivedSunflower == null) {
            UtilInventory.addItemToInventory(inventory, receivedRose);
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 4, 14);
    }

    public static ItemStack make2LightblueFrom1Lapis1White(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedLapis = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 1, 4));
        if (receivedLapis == null) {
            receivedLapis = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 4));
        }
        if (receivedLapis == null) {
            return null;
        }
        ItemStack receivedWhite = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 1, 15));
        if (receivedWhite == null) {
            receivedWhite = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 15));
        }
        if (receivedWhite == null) {
            UtilInventory.addItemToInventory(inventory, receivedLapis);
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 2, 12);
    }

    public static ItemStack make3LightgrayFrom1Ink2White(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedInk = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 1, 0));
        if (receivedInk == null) {
            receivedInk = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 0));
        }
        if (receivedInk == null) {
            return null;
        }
        ItemStack receivedWhite = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 2, 15));
        if (receivedWhite == null) {
            receivedWhite = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 2, 15));
        }
        if (receivedWhite == null) {
            UtilInventory.addItemToInventory(inventory, receivedInk);
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 3, 7);
    }

    public static ItemStack make2CyanFrom1Green1Lapis(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedLapis = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 1, 4));
        if (receivedLapis == null) {
            receivedLapis = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 4));
        }
        if (receivedLapis == null) {
            return null;
        }
        ItemStack receivedGreen = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 1, 2));
        if (receivedGreen == null) {
            receivedGreen = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 2));
        }
        if (receivedGreen == null) {
            UtilInventory.addItemToInventory(inventory, receivedLapis);
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 2, 6);
    }

    public static ItemStack make4PurpleFrom1Rose2Lapis(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedLapis = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 2, 4));
        if (receivedLapis == null) {
            receivedLapis = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 2, 4));
        }
        if (receivedLapis == null) {
            return null;
        }
        ItemStack receivedRose = UtilInventory.findItemMeta(inventory, new ItemStack((Block)Blocks.field_150398_cm, 1, 4));
        if (receivedRose == null) {
            receivedRose = lot.requestItem(world, pos, new ItemStack((Block)Blocks.field_150398_cm, 1, 4));
        }
        if (receivedRose == null) {
            UtilInventory.addItemToInventory(inventory, receivedLapis);
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 4, 5);
    }

    public static ItemStack make2GrayFrom1Ink1White(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedInk = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 1, 0));
        if (receivedInk == null) {
            receivedInk = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 0));
        }
        if (receivedInk == null) {
            return null;
        }
        ItemStack receivedWhite = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 1, 15));
        if (receivedWhite == null) {
            receivedWhite = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 15));
        }
        if (receivedWhite == null) {
            UtilInventory.addItemToInventory(inventory, receivedInk);
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 2, 8);
    }

    public static ItemStack make2LimeFrom1Green1White(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack receivedGreen = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 1, 2));
        if (receivedGreen == null) {
            receivedGreen = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 2));
        }
        if (receivedGreen == null) {
            return null;
        }
        ItemStack receivedWhite = UtilInventory.findItemMeta(inventory, new ItemStack(Items.field_151100_aR, 1, 15));
        if (receivedWhite == null) {
            receivedWhite = lot.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 15));
        }
        if (receivedWhite == null) {
            UtilInventory.addItemToInventory(inventory, receivedGreen);
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 2, 10);
    }

    public static ItemStack make2PinkFrom1Peony(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItemMeta(inventory, new ItemStack((Block)Blocks.field_150398_cm, 1, 5));
        if (received == null) {
            received = lot.requestItem(world, pos, new ItemStack((Block)Blocks.field_150398_cm, 1, 5));
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 2, 9);
    }

    public static ItemStack make2MagentaFrom1Lilac(World world, BlockPos pos, BlockFounder lot, IInventory inventory) {
        ItemStack received = UtilInventory.findItemMeta(inventory, new ItemStack((Block)Blocks.field_150398_cm, 1, 1));
        if (received == null) {
            received = lot.requestItem(world, pos, new ItemStack((Block)Blocks.field_150398_cm, 1, 1));
        }
        if (received == null) {
            return null;
        }
        return new ItemStack(Items.field_151100_aR, 2, 13);
    }

    static {
        craftMatrix = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return false;
            }
        }, 3, 3);
    }
}

