/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.common;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockBuilding;
import com.dooglamoo.citiesmod.block.BlockDistributor;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.BlockRoad;
import com.dooglamoo.citiesmod.block.BlockTower;
import com.dooglamoo.citiesmod.block.BlockWarehouse;
import com.dooglamoo.citiesmod.common.CitiesFMLCommonHandler;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.world.gen.WorldGenCity;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHandler {
    public static Configuration config;
    public static final String PRICE_CATEGORY = "prices";
    public static final String ECONOMY_CATEGORY = "economy";
    public static final String CONSTRUCTION_CATEGORY = "construction";
    public static final String INDUSTRY_CATEGORY = "industry";
    public static final String CITIES_CATEGORY = "cities";

    public static void init(File file) {
        config = new Configuration(file);
        ConfigHandler.syncConfig();
    }

    public static void syncConfig() {
        String category = "general";
        ArrayList<String> propOrder = new ArrayList<String>();
        CitiesMod.serverOnly = ConfigHandler.getBoolean("serverOnly", category, false, "If true, only structure generation and locating services are enabled and clients do not need the mod installed.", propOrder);
        AutoRecipes.minableWhiteList = Arrays.asList(ConfigHandler.getStringList("extraMinableBlockWhitelist", category, new String[0], "List of additional blocks that can be mined by industries.", null, propOrder));
        AutoRecipes.oreWhiteList = Arrays.asList(ConfigHandler.getStringList("extraOreBlockWhitelist", category, new String[0], "List of additional valuable ore blocks that can be mined out of the walls of a Mineshaft.", null, propOrder));
        AutoRecipes.importBlackList = Arrays.asList(ConfigHandler.getStringList("buildingImportBlacklist", category, new String[0], "List of items or blocks that buildings should not import from the global market.", null, propOrder));
        config.setCategoryPropertyOrder(category, propOrder);
        config.getCategory(category).remove((Object)"laddersInBuildings");
        config.getCategory(category).remove((Object)"noDestroyBlockList");
        category = ECONOMY_CATEGORY;
        propOrder = new ArrayList();
        BlockFounder.feeExemptionThreshold = ConfigHandler.getInt("feeExemptionThreshold", category, 50, 0, 65535, "Industries holding less than this amount of money are exempt from paying any fees or investments.", propOrder);
        BlockBuilding.investmentFeeRate = ConfigHandler.getFloat("investmentFeeRate", category, 0.02f, 0.0f, 1.0f, "Each building charges this percentage when collecting investments each day from non-exempt industries in it's area until it reaches it's minimum investment amount.", propOrder);
        BlockDistributor.feeRate = ConfigHandler.getFloat("distributorFeeRate", category, 0.03f, 0.0f, 1.0f, "Each distributor charges this percentage when collecting fees each day from non-exempt industries in it's area.", propOrder);
        BlockDistributor.maxFee = ConfigHandler.getInt("distributorMaxFee", category, 1000, 0, 65535, "The maximum fee a distributor can collect from an industry during it's collection tick.", propOrder);
        BlockWarehouse.feeRate = ConfigHandler.getFloat("warehouseFeeRate", category, 0.015f, 0.0f, 1.0f, "Each warehouse charges this percentage when collecting fees twice a day from non-exempt distributors in it's area.", propOrder);
        BlockWarehouse.maxFee = ConfigHandler.getInt("warehouseMaxFee", category, 500, 0, 65535, "The maximum fee a warehouse can collect from a distributor during it's collection tick.", propOrder);
        Market.showPriceTooltip = ConfigHandler.getBoolean("showPriceTooltip", category, true, "If true and an item has a money value that is greater than 0, shows the money value of the item in the item tooltip.", propOrder);
        BlockTower.largeTowerImport = ConfigHandler.getBoolean("largeTowerImport", category, true, "Set to false to disable importing of diamonds, obsidian, golden apples, etc.", propOrder);
        BlockFounder.expertMode = ConfigHandler.getBoolean("expertMode", category, false, "If set to true, the only ways of getting money into the game are loot chests, emerald crafted coin pouches, and selling items to the Global Market. Makes the game more challenging.", propOrder);
        Market.marketDisabled = !ConfigHandler.getBoolean("globalMarketEnabled", category, true, "If true, buildings are allowed to import and export items on the Global Market, otherwise importing and exporting are disabled.", propOrder);
        config.setCategoryPropertyOrder(category, propOrder);
        category = CONSTRUCTION_CATEGORY;
        propOrder = new ArrayList();
        BlockBuilding.lightingChance = ConfigHandler.getFloat("lightInBuildings", category, 0.3f, 0.0f, 1.0f, "Percentage of the building that is lighted during construction. 0.0 == fully dark, 1.0 == fully lighted.", propOrder);
        BlockBuilding.specifyLadder = !ConfigHandler.getBoolean("laddersInBuildings", category, true, "If true, buildings get ladders by default, otherwise, user can choose by placing a ladder in the building inventory.", propOrder);
        BlockRoad.bridgeSupports = ConfigHandler.getBoolean("bridgeSupports", category, true, "If false, roads will not build supports in open space under the road. Should be false in things like Skyblock maps for example.", propOrder);
        config.setCategoryPropertyOrder(category, propOrder);
        category = INDUSTRY_CATEGORY;
        propOrder = new ArrayList();
        BlockFounder.fireDisasterChance = ConfigHandler.getFloat("fireDisasterChance", category, 0.0025f, 0.0f, 1.0f, "Chance each tick for fire at Lumbermill. 0.0 == never, 0.1 == about once a day, 1.0 == every tick.", propOrder);
        BlockFounder.droughtDisasterChance = ConfigHandler.getFloat("droughtDisasterChance", category, 0.0025f, 0.0f, 1.0f, "Chance each tick for drought at Farm. 0.0 == never, 0.1 == about once a day, 1.0 == every tick.", propOrder);
        BlockFounder.blightDisasterChance = ConfigHandler.getFloat("blightDisasterChance", category, 0.0025f, 0.0f, 1.0f, "Chance each tick for blight at Garden. 0.0 == never, 0.1 == about once a day, 1.0 == every tick.", propOrder);
        BlockFounder.invasionDisasterChance = ConfigHandler.getFloat("invasionDisasterChance", category, 0.0f, 0.0f, 1.0f, "Chance each tick for ghast invasion at Tower. 0.0 == never, 0.1 == about once a day, 1.0 == every tick.", propOrder);
        BlockFounder.outOfBusinessDisasterChance = ConfigHandler.getFloat("outOfBusinessDisasterChance", category, 0.01f, 0.0f, 0.1f, "Chance each time industry fails to eat that it will go out of business. 0.0 == never, 0.1 == every time.", propOrder);
        BlockFounder.showInventoryFullMsg = ConfigHandler.getBoolean("showInventoryFullMsg", category, false, "If true, displays a chat msg every time an industry can't work because of a full inventory.", propOrder);
        CitiesFMLCommonHandler.nameAtCrafting = ConfigHandler.getBoolean("nameAtCrafting", category, false, "Set to true to have players names automatically added to crafted industry blocks.", propOrder);
        CitiesMod.disableRecipeFarm = ConfigHandler.getBoolean("disableRecipeFarm", category, false, "Set to true to disable Farm crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeLumbermill = ConfigHandler.getBoolean("disableRecipeLumbermill", category, false, "Set to true to disable Lumbermill crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeQuarry = ConfigHandler.getBoolean("disableRecipeQuarry", category, false, "Set to true to disable Quarry crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeFishery = ConfigHandler.getBoolean("disableRecipeFishery", category, false, "Set to true to disable Fishery crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeGarden = ConfigHandler.getBoolean("disableRecipeGarden", category, false, "Set to true to disable Garden crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeRanch = ConfigHandler.getBoolean("disableRecipeRanch", category, false, "Set to true to disable Ranch crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeDistributor = ConfigHandler.getBoolean("disableRecipeDistributor", category, false, "Set to true to disable Distributor crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeWarehouse = ConfigHandler.getBoolean("disableRecipeWarehouse", category, false, "Set to true to disable Warehouse crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeBulldozer = ConfigHandler.getBoolean("disableRecipeBulldozer", category, false, "Set to true to disable Bulldozer crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeCarpenter = ConfigHandler.getBoolean("disableRecipeCarpenter", category, false, "Set to true to disable Carpenter crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeBakery = ConfigHandler.getBoolean("disableRecipeBakery", category, false, "Set to true to disable Bakery crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeBlacksmith = ConfigHandler.getBoolean("disableRecipeBlacksmith", category, false, "Set to true to disable Blacksmith crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeMineshaft = ConfigHandler.getBoolean("disableRecipeMineshaft", category, false, "Set to true to disable Mineshaft crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeTextile = ConfigHandler.getBoolean("disableRecipeTextile", category, false, "Set to true to disable Textile crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeStonemason = ConfigHandler.getBoolean("disableRecipeStonemason", category, false, "Set to true to disable Stonemason crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeCraftsman = ConfigHandler.getBoolean("disableRecipeCraftsman", category, false, "Set to true to disable Craftsman crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeSeller = ConfigHandler.getBoolean("disableRecipeSeller", category, false, "Set to true to disable Seller crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeBuyer = ConfigHandler.getBoolean("disableRecipeBuyer", category, false, "Set to true to disable Buyer crafting recipe in survival.", propOrder);
        CitiesMod.disableRecipeTaxcollector = ConfigHandler.getBoolean("disableRecipeTaxcollector", category, false, "Set to true to disable Taxcollector crafting recipe in survival.", propOrder);
        config.setCategoryPropertyOrder(category, propOrder);
        category = CITIES_CATEGORY;
        propOrder = new ArrayList();
        WorldGenCity.ironFrameChance = ConfigHandler.getFloat("ironFrameChance", category, 1.0f, 0.0f, 1.0f, "Percentage of Towers that generate with iron blocks instead of smooth double stone slabs. 0.0 == none use iron blocks, 1.0 == all use iron blocks.", propOrder);
        WorldGenCity.streetLightChance = ConfigHandler.getFloat("streetLightChance", category, 0.3f, 0.0f, 1.0f, "Percentage of street light posts that generate with a light (glowstone/sea lantern.) 0.0 == none, 1.0 == all.", propOrder);
        WorldGenCity.glassInWindowChance = ConfigHandler.getFloat("glassInWindowChance", category, 0.8f, 0.7f, 1.0f, "Percentage of glass in a buildings windows. 0.7 == very broken windows, 1.0 == unbroken windows", propOrder);
        WorldGenCity.spawnersInBuildings = ConfigHandler.getBoolean("spawnersInBuildings", category, true, "If false, no mob spawners will generate in buildings.", propOrder);
        WorldGenCity.blazeSpawners = ConfigHandler.getBoolean("blazeSpawners", category, false, "If true, blaze spawners will generate in place of cave spider spawners in Towers.", propOrder);
        config.setCategoryPropertyOrder(category, propOrder);
        category = PRICE_CATEGORY;
        for (Map.Entry<String, Integer> entry : Market.prices.entrySet()) {
            entry.setValue(config.getInt(entry.getKey(), category, entry.getValue().intValue(), 0, 65535, ""));
        }
        for (Map.Entry<String, Integer> entry : config.getCategory(category).getValues().entrySet()) {
            if (Market.prices.containsKey(entry.getKey())) continue;
            Market.prices.put(entry.getKey(), ((Property)entry.getValue()).getInt(0));
        }
        config.save();
    }

    private static String[] getStringList(String name, String category, String[] defaultValue, String comment, String[] validValues, List<String> propOrder) {
        propOrder.add(name);
        return config.getStringList(name, category, defaultValue, comment, validValues, "config.property." + name);
    }

    private static int getInt(String name, String category, int defaultValue, int minValue, int maxValue, String comment, List<String> propOrder) {
        propOrder.add(name);
        return config.getInt(name, category, defaultValue, minValue, maxValue, comment, "config.property." + name);
    }

    private static float getFloat(String name, String category, float defaultValue, float minValue, float maxValue, String comment, List<String> propOrder) {
        propOrder.add(name);
        return config.getFloat(name, category, defaultValue, minValue, maxValue, comment, "config.property." + name);
    }

    private static boolean getBoolean(String name, String category, boolean defaultValue, String comment, List<String> propOrder) {
        propOrder.add(name);
        return config.getBoolean(name, category, defaultValue, comment, "config.property." + name);
    }
}

