/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import com.dooglamoo.citiesmod.tileentity.TileEntityFounder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockWarehouse
extends BlockFounder {
    protected static final float TWICEPERDAY_CHANCE = 0.2f;
    protected List<IInventory> inventories = new ArrayList<IInventory>();
    public static float feeRate = 0.015f;
    public static int maxFee = 500;

    public BlockWarehouse() {
        super(3, 0, 8);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        this.inventories.clear();
        super.func_180645_a(world, pos, state, rand);
        this.findInventories(world);
        this.restock(world, pos);
        if (this.chance <= 0.2f) {
            this.collectFee(world, pos);
            this.requestGoods(world, pos);
        }
    }

    @Override
    public boolean canContain(IFounder block) {
        return true;
    }

    @Override
    public boolean canBeContainedIn(IFounder block) {
        return block.isBuilding();
    }

    @Override
    public int minInventory() {
        return 1;
    }

    @Override
    public IFounder.DISTRIBUTOR_PRIORITY getDistributorPriority() {
        return IFounder.DISTRIBUTOR_PRIORITY.PRIORITY_3;
    }

    @Override
    public boolean canAcceptPayment() {
        return true;
    }

    @Override
    protected List<IInventory> getDistributors(World world, BlockPos pos) {
        if (this.distributors == null) {
            this.distributors = new ArrayList();
            ArrayList<IInventory> distributors1 = new ArrayList<IInventory>();
            ArrayList<IInventory> distributors2 = new ArrayList<IInventory>();
            List list = world.field_175730_i;
            block4: for (int i = 0; i < list.size(); ++i) {
                Block block;
                TileEntity t = (TileEntity)list.get(i);
                if (!(t.func_145835_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= 7225.0) || !((block = t.func_145838_q()) instanceof IFounder) || ((IFounder)block).getDistributorPriority() == IFounder.DISTRIBUTOR_PRIORITY.PRIORITY_0 || !((IFounder)block).canRequestFrom()) continue;
                switch (((IFounder)block).getDistributorPriority()) {
                    case PRIORITY_1: {
                        distributors1.add((IInventory)t);
                        continue block4;
                    }
                    case PRIORITY_2: {
                        distributors2.add((IInventory)t);
                        continue block4;
                    }
                }
            }
            if (!distributors1.isEmpty()) {
                Collections.shuffle(distributors1, world.field_73012_v);
                this.distributors.addAll(distributors1);
            }
            if (!distributors2.isEmpty()) {
                Collections.shuffle(distributors2, world.field_73012_v);
                this.distributors.addAll(distributors2);
            }
        }
        return this.distributors;
    }

    private void collectFee(World world, BlockPos pos) {
        if (this.coinPouch == null) {
            return;
        }
        List<IInventory> list = this.getDistributors(world, pos);
        for (int i = 0; i < list.size(); ++i) {
            int amount;
            IInventory distributor = list.get(i);
            int vendorMoney = UtilInventory.findItem(distributor, CitiesMod.coinPouch);
            if (vendorMoney < 0 || (amount = distributor.func_70301_a(vendorMoney).func_82838_A()) < feeExemptionThreshold) continue;
            int cost = Math.min(maxFee, (int)((float)amount * feeRate));
            distributor.func_70301_a(vendorMoney).func_82841_c(distributor.func_70301_a(vendorMoney).func_82838_A() - cost);
            this.coinPouch.func_82841_c(this.coinPouch.func_82838_A() + cost);
        }
    }

    private void requestGoods(World world, BlockPos pos) {
        for (int i = 0; i < this.inventories.size(); ++i) {
            IInventory storage = this.inventories.get(i);
            for (int j = 0; j < storage.func_70302_i_(); ++j) {
                ItemStack stack = storage.func_70301_a(j);
                if (stack == null || stack.field_77994_a >= Math.min(stack.func_77976_d(), this.inventory.func_70297_j_())) continue;
                int num = Math.min(stack.func_77976_d(), this.inventory.func_70297_j_()) - stack.field_77994_a;
                ItemStack received = this.requestItem(world, pos, new ItemStack(stack.func_77973_b(), Math.min(num, 8), stack.func_77960_j()), false);
                if (received == null) continue;
                stack.field_77994_a += received.field_77994_a;
            }
        }
    }

    private void restock(World world, BlockPos pos) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a >= Math.min(stack.func_77976_d(), this.inventory.func_70297_j_())) continue;
            int num = Math.min(stack.func_77976_d(), this.inventory.func_70297_j_()) - stack.field_77994_a;
            ItemStack received = this.pullItem(world, pos, new ItemStack(stack.func_77973_b(), num, stack.func_77960_j()));
            if (received == null) continue;
            stack.field_77994_a += received.field_77994_a;
        }
    }

    private ItemStack pullItem(World world, BlockPos pos, ItemStack item) {
        for (int i = 0; i < this.inventories.size(); ++i) {
            IInventory storage = this.inventories.get(i);
            for (int j = 0; j < storage.func_70302_i_(); ++j) {
                ItemStack stack = storage.func_70301_a(j);
                if (stack == null || stack.field_77994_a <= 1 || stack.func_77973_b() != item.func_77973_b() || stack.func_77960_j() != item.func_77960_j()) continue;
                return storage.func_70298_a(j, Math.min(stack.field_77994_a - 1, item.field_77994_a));
            }
        }
        return null;
    }

    private void findInventories(World world) {
        List allTEs = world.field_147482_g;
        Predicate<TileEntity> prTileEntity = new Predicate<TileEntity>(){

            @Override
            public boolean test(TileEntity t) {
                return t instanceof IInventory && !(t instanceof TileEntityFounder) && !(t instanceof TileEntityHopper) && t.func_174877_v().func_177958_n() >= BlockWarehouse.this.xStart && t.func_174877_v().func_177958_n() < BlockWarehouse.this.xEnd && t.func_174877_v().func_177956_o() >= BlockWarehouse.this.yStart && t.func_174877_v().func_177956_o() < BlockWarehouse.this.yEnd && t.func_174877_v().func_177952_p() >= BlockWarehouse.this.zStart && t.func_174877_v().func_177952_p() < BlockWarehouse.this.zEnd;
            }
        };
        for (TileEntity t : allTEs.stream().filter(prTileEntity).collect(Collectors.toList())) {
            this.inventories.add((IInventory)t);
        }
        List allEs = world.func_72872_a(EntityMinecartChest.class, new AxisAlignedBB((double)this.xStart, (double)this.yStart, (double)this.zStart, (double)this.xEnd, (double)this.yEnd, (double)this.zEnd));
        for (EntityMinecartChest t : allEs) {
            this.inventories.add((IInventory)t);
        }
        Collections.shuffle(this.inventories, world.field_73012_v);
    }
}

