/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockBuilding;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import com.dooglamoo.citiesmod.tileentity.TileEntityFounder;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockTower
extends BlockBuilding {
    protected static final ItemStack carpet = new ItemStack(Blocks.field_150404_cg);
    protected static final ItemStack iron_block = new ItemStack(Blocks.field_150339_S);
    protected static final ItemStack bookshelf = new ItemStack(Blocks.field_150342_X);
    protected static final ItemStack stone = new ItemStack(Blocks.field_150348_b);
    protected static final ItemStack prismarine = new ItemStack(Blocks.field_180397_cI);
    private static final int MIN_INVEST1 = 64000;
    private static final int MIN_INVEST2 = 128000;
    public static boolean largeTowerImport = true;
    private final float MIN_QUALITY;

    public BlockTower(int maxHeight) {
        super(maxHeight, -1, 16, maxHeight <= 64 ? 64000 : 128000, 4);
        float f = this.MIN_QUALITY = maxHeight <= 64 ? 13.0f : 16.0f;
        if (maxHeight <= 64) {
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150339_S));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150371_ca));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150385_bj));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150475_bE));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150340_R));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150368_y));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150451_bX));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_180399_cE));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150406_ce));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150407_cf));
        } else {
            this.trades.add(Items.field_151045_i);
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150484_ah));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150343_Z));
            this.trades.add(Items.field_151153_ao);
            this.trades.add(Items.field_151150_bK);
            this.trades.add(Items.field_179556_br);
        }
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        this.seller = null;
        this.buyer = null;
        if (this.chance <= 0.1f) {
            if (this.coinPouch == null || this.coinPouch.func_82838_A() < this.MIN_INVESTMENT) {
                // empty if block
            }
            this.collectInvestment(world, pos, this.MIN_INVESTMENT);
            if (!this.eat(world, pos, this.MIN_COMMUNITY, this.MIN_QUALITY)) {
                return;
            }
        }
        if (this.build(world, pos, 68.27f, this.chance < invasionDisasterChance, rand) && !Market.marketDisabled) {
            this.exportGoods(world, pos);
            if (this.maxHeight <= 64 || largeTowerImport) {
                this.importGoods(world, pos);
            }
        }
    }

    private boolean build(World world, BlockPos pos, float amount, boolean disaster, Random rand) {
        boolean ladderFill = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150468_ap)) >= 0;
        for (int y = this.yStart; y <= this.yEnd; ++y) {
            for (int x = this.xStart + 1; x <= this.xEnd - 1; ++x) {
                for (int z = this.zStart + 1; z <= this.zEnd - 1; ++z) {
                    ItemStack stack;
                    ItemStack target;
                    ItemStack item;
                    ItemStack received;
                    int found;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (y == pos.func_177956_o()) {
                        if (this.seller == null && Block.func_149680_a((Block)block, (Block)CitiesMod.sellerBlock)) {
                            this.seller = (TileEntityFounder)world.func_175625_s(blockPos);
                        }
                        if (this.buyer == null && Block.func_149680_a((Block)block, (Block)CitiesMod.buyerBlock)) {
                            this.buyer = (TileEntityFounder)world.func_175625_s(blockPos);
                        }
                    }
                    if (block instanceof BlockFounder || (y == this.yStart + 1 || y == this.yStart + 2) && ((x - 7) % 16 == 0 || (x - 8) % 16 == 0 || (z - 7) % 16 == 0 || (z - 8) % 16 == 0)) continue;
                    if ((x - 1) % 16 == 0 || (x - 14) % 16 == 0 || (z - 1) % 16 == 0 || (z - 14) % 16 == 0) {
                        if (!((x - 1) % 16 != 0 && (x - 14) % 16 != 0 || (z - 1) % 16 != 0 && (z - 14) % 16 != 0)) {
                            if (!Block.func_149680_a((Block)block, (Block)Blocks.field_150339_S)) {
                                ItemStack received2 = UtilInventory.findItem(this.inventory, iron_block);
                                if (received2 == null) {
                                    received2 = this.requestItem(world, pos, iron_block);
                                }
                                if (received2 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150339_S.func_149739_a() + ".name", new Object[0]);
                                    return false;
                                }
                                world.func_175656_a(blockPos, Blocks.field_150339_S.func_176223_P());
                                amount -= 1.3f;
                                if (amount <= 0.0f) {
                                    return false;
                                }
                            }
                        } else if ((this.yEnd - y) % 16 == 0) {
                            ItemStack target2 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block != Blocks.field_150334_T && block != Blocks.field_180388_cO && block != Blocks.field_185770_cW && block != Blocks.field_150322_A && block != Blocks.field_150347_e && block != Blocks.field_150336_V && block != Blocks.field_150417_aV && block != Blocks.field_150385_bj && block != Blocks.field_150371_ca && block != Blocks.field_180395_cM && block != Blocks.field_185767_cT && (world.func_180495_p(blockPos).func_185904_a().func_76222_j() || OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target2}))) {
                                found = UtilInventory.findItems(this.inventory, Item.func_150898_a((Block)Blocks.field_150333_U), Item.func_150898_a((Block)Blocks.field_180389_cP), Item.func_150898_a((Block)Blocks.field_185771_cX));
                                if (found < 0) {
                                    this.complain(world, "tile.founder.building.msg.slab", new Object[0]);
                                    return false;
                                }
                                ItemStack itemSlab = this.inventory.func_70301_a(found);
                                received = null;
                                List<ItemStack> items = this.getItemFromSlab(world, itemSlab);
                                if (items.isEmpty()) {
                                    this.complain(world, "tile.founder.building.msg.slab", new Object[0]);
                                    return false;
                                }
                                for (ItemStack request : items) {
                                    Block requestBlock = Block.func_149634_a((Item)request.func_77973_b());
                                    if (!Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150348_b) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150322_A) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150347_e) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150336_V) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150417_aV) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150385_bj) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150371_ca) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_180395_cM) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_185767_cT)) continue;
                                    received = UtilInventory.findItemMetaWithMin(this.inventory, 2, request);
                                    if (received == null) {
                                        received = this.requestItem(world, pos, request);
                                    }
                                    if (received == null) continue;
                                    break;
                                }
                                if (received == null) {
                                    this.complainResult(world, lastResult, items.get(0).func_77973_b().func_77667_c(items.get(0)) + ".name", new Object[0]);
                                    return false;
                                }
                                if (received.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150348_b)) {
                                    world.func_175656_a(blockPos, Blocks.field_150334_T.func_176223_P());
                                } else {
                                    world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(received.func_77960_j()));
                                }
                                amount -= 1.3f;
                                if (amount <= 0.0f) {
                                    return false;
                                }
                            }
                        } else if (world.func_180495_p(blockPos).func_185904_a() == Material.field_151579_a) {
                            int found2 = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.blockGlass);
                            if (found2 < 0) {
                                this.complain(world, "tile.founder.building.msg.glass", new Object[0]);
                                return false;
                            }
                            ItemStack item2 = this.inventory.func_70301_a(found2).func_77946_l();
                            item2.field_77994_a = 1;
                            ItemStack received3 = UtilInventory.findItemMetaWithMin(this.inventory, 2, item2);
                            if (received3 == null) {
                                received3 = this.requestItem(world, pos, item2);
                            }
                            if (received3 == null) {
                                this.complainResult(world, lastResult, item2.func_77973_b().func_77667_c(item2) + ".name", new Object[0]);
                                return false;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received3.func_77973_b()).func_176203_a(received3.func_77960_j()));
                            amount -= 1.3f;
                            if (amount <= 0.0f) {
                                return false;
                            }
                        }
                    }
                    if (x == this.xStart + 1 || x == this.xEnd - 1 || z == this.zStart + 1 || z == this.zEnd - 1) continue;
                    if (y == this.yStart) {
                        if ((x == this.xStart + 6 || x == this.xEnd - 6) && z == this.zStart + 6) {
                            ItemStack stack2;
                            if (specifyLadder && !ladderFill) continue;
                            ItemStack target3 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block == Blocks.field_150468_ap || block == Blocks.field_150415_aT || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target3})) continue;
                            ItemStack received4 = UtilInventory.findItemMetaWithMin(this.inventory, 2, ladder);
                            if (received4 == null && (stack2 = AutoRecipes.make24LaddersFromPlanks(world, pos, this, this.inventory)) != null) {
                                received4 = stack2.func_77979_a(1);
                                if (stack2.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, stack2);
                                }
                            }
                            if (received4 == null) {
                                this.complainResult(world, lastResult, "tile.wood.name", new Object[0]);
                                return false;
                            }
                            world.func_175656_a(blockPos, Blocks.field_150468_ap.func_176203_a(3));
                            amount -= 1.3f;
                            if (!(amount <= 0.0f)) continue;
                            return false;
                        }
                        ItemStack target4 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target4}) || block == Blocks.field_150468_ap || block == Blocks.field_150415_aT || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target4})) continue;
                        found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                        if (found < 0) {
                            this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                            return false;
                        }
                        item = this.inventory.func_70301_a(found).func_77946_l();
                        item.field_77994_a = 1;
                        received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                        if (received == null) {
                            received = this.requestItem(world, pos, item);
                        }
                        if (received == null) {
                            this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)item.func_77973_b()).func_176203_a(item.func_77960_j()));
                        amount -= 1.3f;
                        if (!(amount <= 0.0f)) continue;
                        return false;
                    }
                    if ((this.yEnd - y) % 4 == 0) {
                        ItemStack target5;
                        if (!((x - 3) % 16 != 0 && (x - 12) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                            ItemStack target6 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (!OreDictionary.containsMatch((boolean)false, AutoRecipes.blockGlass, (ItemStack[])new ItemStack[]{target6}) && block != Blocks.field_150426_aN && block != Blocks.field_180398_cJ && (world.func_180495_p(blockPos).func_185904_a().func_76222_j() || OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target6}))) {
                                ItemStack received5;
                                ItemStack item3;
                                int found3;
                                if (y != this.yEnd && world.field_73012_v.nextFloat() <= lightingChance) {
                                    found3 = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150426_aN));
                                    if (found3 < 0) {
                                        found3 = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180398_cJ));
                                    }
                                    if (found3 < 0) {
                                        TextComponentTranslation light = new TextComponentTranslation("%s/%s", new Object[]{new TextComponentTranslation(Blocks.field_150426_aN.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_180398_cJ.func_149739_a() + ".name", new Object[0])});
                                        this.complain(world, "tile.founder.building.msg.light", light);
                                        return false;
                                    }
                                    item3 = this.inventory.func_70301_a(found3).func_77946_l();
                                    item3.field_77994_a = 1;
                                    received5 = UtilInventory.findItemMetaWithMin(this.inventory, 2, item3);
                                    if (received5 == null) {
                                        received5 = this.requestItem(world, pos, item3);
                                    }
                                    if (received5 == null) {
                                        this.complainResult(world, lastResult, item3.func_77973_b().func_77667_c(item3) + ".name", new Object[0]);
                                        return false;
                                    }
                                } else {
                                    found3 = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.blockGlass);
                                    if (found3 < 0) {
                                        this.complain(world, "tile.founder.building.msg.glass", new Object[0]);
                                        return false;
                                    }
                                    item3 = this.inventory.func_70301_a(found3).func_77946_l();
                                    item3.field_77994_a = 1;
                                    received5 = UtilInventory.findItemMetaWithMin(this.inventory, 2, item3);
                                    if (received5 == null) {
                                        received5 = this.requestItem(world, pos, item3);
                                    }
                                    if (received5 == null) {
                                        this.complainResult(world, lastResult, item3.func_77973_b().func_77667_c(item3) + ".name", new Object[0]);
                                        return false;
                                    }
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received5.func_77973_b()).func_176203_a(received5.func_77960_j()));
                                amount -= 1.3f;
                                if (amount <= 0.0f) {
                                    return false;
                                }
                            }
                        } else if (!(x >= this.xStart + 5 && x <= this.xEnd - 5 && z >= this.zStart + 5 && z <= this.zEnd - 5 || OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target5 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE)}) || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target5}))) {
                            found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                            if (found < 0) {
                                this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                                return false;
                            }
                            item = this.inventory.func_70301_a(found).func_77946_l();
                            item.field_77994_a = 1;
                            received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                            if (received == null) {
                                received = this.requestItem(world, pos, item);
                            }
                            if (received == null) {
                                this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                return false;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)item.func_77973_b()).func_176203_a(item.func_77960_j()));
                            amount -= 1.3f;
                            if (amount <= 0.0f) {
                                return false;
                            }
                        }
                    } else if (y != this.yEnd && y > this.yStart + 1 && (this.yEnd + 1 - y) % 4 == 0) {
                        if (!((x - 3) % 16 != 0 && (x - 12) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                            if (Block.func_149680_a((Block)block, (Block)Blocks.field_150474_ac)) {
                                this.complain(world, "tile.founder.building.msg.security", new Object[0]);
                                return false;
                            }
                            if (world.func_180495_p(blockPos).func_185904_a().func_76222_j()) {
                                ItemStack received6 = UtilInventory.findItem(this.inventory, bookshelf);
                                if (received6 == null) {
                                    received6 = this.requestItem(world, pos, bookshelf);
                                }
                                if (received6 == null) {
                                    received6 = AutoRecipes.make1BookshelvesFromPlanks(world, pos, this, this.inventory);
                                }
                                if (received6 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150342_X.func_149739_a() + ".name", new Object[0]);
                                    return false;
                                }
                                world.func_175656_a(blockPos, Blocks.field_150342_X.func_176223_P());
                                amount -= 1.3f;
                                if (amount <= 0.0f) {
                                    return false;
                                }
                            }
                        } else if ((x < this.xStart + 5 || x > this.xEnd - 5 || z < this.zStart + 5 || z > this.zEnd - 5) && world.func_175623_d(new BlockPos(x, y, z))) {
                            int found4 = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150404_cg));
                            if (found4 < 0) {
                                this.complain(world, "tile.founder.building.msg.carpet", new Object[0]);
                                return false;
                            }
                            ItemStack item4 = this.inventory.func_70301_a(found4).func_77946_l();
                            item4.field_77994_a = 1;
                            ItemStack received7 = UtilInventory.findItemMetaWithMin(this.inventory, 2, item4);
                            if (received7 == null) {
                                received7 = this.requestItem(world, pos, item4);
                            }
                            if (received7 == null) {
                                this.complainResult(world, lastResult, item4.func_77973_b().func_77667_c(item4) + ".name", new Object[0]);
                                return false;
                            }
                            world.func_175656_a(blockPos, Blocks.field_150404_cg.func_176203_a(item4.func_77960_j()));
                            amount -= 1.3f;
                            if (amount <= 0.0f) {
                                return false;
                            }
                        }
                    }
                    if (x < this.xStart + 5 || x > this.xEnd - 5 || z < this.zStart + 5 || z > this.zEnd - 5) continue;
                    if (((this.yEnd + 1 - y) % 4 != 0 && (this.yEnd + 2 - y) % 4 != 0 || (x - 5) % 16 != 0 && (x - 10) % 16 != 0 || (z - 7) % 16 != 0 && (z - 8) % 16 != 0) && ((x - 5) % 16 == 0 || (x - 10) % 16 == 0 || (z - 5) % 16 == 0 || (z - 10) % 16 == 0) && !OreDictionary.containsMatch((boolean)false, AutoRecipes.stone, (ItemStack[])new ItemStack[]{target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE)}) && block != Blocks.field_180397_cI && (world.func_180495_p(blockPos).func_185904_a().func_76222_j() || OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}))) {
                        int found5 = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.stone);
                        if (found5 < 0) {
                            found5 = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180397_cI));
                        }
                        if (found5 < 0) {
                            this.complain(world, "tile.founder.building.msg.stone", new Object[0]);
                            return false;
                        }
                        ItemStack item5 = this.inventory.func_70301_a(found5).func_77946_l();
                        item5.field_77994_a = 1;
                        received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item5);
                        if (received == null) {
                            received = this.requestItem(world, pos, item5);
                        }
                        if (received == null) {
                            this.complainResult(world, lastResult, item5.func_77973_b().func_77667_c(item5) + ".name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(received.func_77960_j()));
                        amount -= 1.3f;
                        if (amount <= 0.0f) {
                            return false;
                        }
                    }
                    if (x < this.xStart + 6 || x > this.xEnd - 6 || z < this.zStart + 6 || z > this.zEnd - 6) continue;
                    if ((this.yEnd - y) % 4 == 0 && (x != this.xStart + 6 && x != this.xEnd - 6 || z != this.zStart + 6)) {
                        if ((z - 8) % 16 == 0 && (x - 8) % 16 == 0) {
                            target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block == Blocks.field_150426_aN || block == Blocks.field_180398_cJ || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                            int found6 = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150426_aN));
                            if (found6 < 0) {
                                found6 = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180398_cJ));
                            }
                            if (found6 < 0) {
                                TextComponentTranslation light = new TextComponentTranslation("%s/%s", new Object[]{new TextComponentTranslation(Blocks.field_150426_aN.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_180398_cJ.func_149739_a() + ".name", new Object[0])});
                                this.complain(world, "tile.founder.building.msg.light", light);
                                return false;
                            }
                            ItemStack item6 = this.inventory.func_70301_a(found6).func_77946_l();
                            item6.field_77994_a = 1;
                            received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item6);
                            if (received == null) {
                                received = this.requestItem(world, pos, item6);
                            }
                            if (received == null) {
                                this.complainResult(world, lastResult, item6.func_77973_b().func_77667_c(item6) + ".name", new Object[0]);
                                return false;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176223_P());
                            amount -= 1.3f;
                            if (!(amount <= 0.0f)) continue;
                            return false;
                        }
                        target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target}) || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                        int found7 = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                        if (found7 < 0) {
                            this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                            return false;
                        }
                        ItemStack item7 = this.inventory.func_70301_a(found7).func_77946_l();
                        item7.field_77994_a = 1;
                        received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item7);
                        if (received == null) {
                            received = this.requestItem(world, pos, item7);
                        }
                        if (received == null) {
                            this.complainResult(world, lastResult, item7.func_77973_b().func_77667_c(item7) + ".name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)item7.func_77973_b()).func_176203_a(item7.func_77960_j()));
                        amount -= 1.3f;
                        if (!(amount <= 0.0f)) continue;
                        return false;
                    }
                    if (!(y == this.yStart + 1 || (this.yEnd + 1 - y) % 4 != 0 || (z - 7) % 16 != 0 && (z - 8) % 16 != 0 || (x - 7) % 16 != 0 && (x - 8) % 16 != 0)) {
                        if (!world.func_175623_d(new BlockPos(x, y, z))) continue;
                        int found8 = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150404_cg));
                        if (found8 < 0) {
                            this.complain(world, "tile.founder.building.msg.carpet", new Object[0]);
                            return false;
                        }
                        ItemStack item8 = this.inventory.func_70301_a(found8).func_77946_l();
                        item8.field_77994_a = 1;
                        ItemStack received8 = UtilInventory.findItemMetaWithMin(this.inventory, 2, item8);
                        if (received8 == null) {
                            received8 = this.requestItem(world, pos, item8);
                        }
                        if (received8 == null) {
                            this.complainResult(world, lastResult, item8.func_77973_b().func_77667_c(item8) + ".name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Blocks.field_150404_cg.func_176203_a(item8.func_77960_j()));
                        amount -= 1.3f;
                        if (!(amount <= 0.0f)) continue;
                        return false;
                    }
                    if (x != this.xStart + 6 && x != this.xEnd - 6 || z != this.zStart + 6 || specifyLadder && !ladderFill) continue;
                    target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                    if (block == Blocks.field_150468_ap || block == Blocks.field_150415_aT || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                    ItemStack received9 = UtilInventory.findItemMetaWithMin(this.inventory, 2, ladder);
                    if (received9 == null && (stack = AutoRecipes.make24LaddersFromPlanks(world, pos, this, this.inventory)) != null) {
                        received9 = stack.func_77979_a(1);
                        if (stack.field_77994_a > 0) {
                            UtilInventory.addItemToInventory(this.inventory, stack);
                        }
                    }
                    if (received9 == null) {
                        this.complainResult(world, lastResult, "tile.wood.name", new Object[0]);
                        return false;
                    }
                    world.func_175656_a(blockPos, Blocks.field_150468_ap.func_176203_a(3));
                    amount -= 1.3f;
                    if (!(amount <= 0.0f)) continue;
                    return false;
                }
            }
        }
        this.addStatsToPlayers(world, this.maxHeight <= 64 ? 23 : 24);
        if (disaster && !world.field_72995_K) {
            EntityGhast entity = new EntityGhast(world);
            entity.func_96094_a("Thgirw");
            entity.func_110163_bv();
            if (BlockTower.findSpawnPos(pos, (EntityLiving)entity, rand, 50)) {
                world.func_72838_d((Entity)entity);
                this.complainCritical(world, "tile.founder.tower.msg.disaster", new Object[0]);
            }
        }
        return true;
    }

    private static boolean findSpawnPos(BlockPos pos, EntityLiving entity, Random rand, int tries) {
        for (int i = 0; i < tries; ++i) {
            entity.func_70107_b((double)(rand.nextInt(64) + (pos.func_177958_n() - 32)), (double)(pos.func_177956_o() + rand.nextInt(32) + 32), (double)(rand.nextInt(64) + (pos.func_177952_p() - 32)));
            if (!entity.func_70058_J()) continue;
            return true;
        }
        return false;
    }
}

