/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockTextile
extends BlockFounder {
    private static final ItemStack wool_2 = new ItemStack(Blocks.field_150325_L, 2, 0);
    private static final ItemStack leather = new ItemStack(Items.field_151116_aA, 1);
    private static final ItemStack paper_3 = new ItemStack(Items.field_151121_aF, 3);

    public BlockTextile() {
        super(3, 0, 8);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        if (this.chance <= 0.1f && !this.eat(world, pos, 1, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 18000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            if (showInventoryFullMsg) {
                this.complain(world, "tile.founder.msg.full", new Object[0]);
            }
            return;
        }
        this.craftCarpet(world, pos, 4);
        this.craftBooks(world, pos, 3);
    }

    @Override
    public boolean canContain(IFounder block) {
        return true;
    }

    @Override
    public boolean canBeContainedIn(IFounder block) {
        return block.isBuilding();
    }

    @Override
    public int minInventory() {
        return 1;
    }

    private void craftCarpet(World world, BlockPos pos, int amount) {
        while (amount > 0) {
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            ItemStack receivedDye = null;
            int found = UtilInventory.findItem(this.inventory, Items.field_151100_aR);
            if (found >= 0) {
                ItemStack stack;
                ItemStack item = this.inventory.func_70301_a(found).func_77946_l();
                item.field_77994_a = 2;
                receivedDye = UtilInventory.findItemMetaWithMin(this.inventory, 3, item);
                if (receivedDye == null) {
                    receivedDye = this.requestItem(world, pos, item);
                }
                if (receivedDye == null && (stack = this.craftDye(world, pos, item.func_77960_j())) != null) {
                    receivedDye = stack.func_77979_a(1);
                    if (stack.field_77994_a > 0) {
                        UtilInventory.addItemToInventory(this.inventory, stack);
                    }
                }
                if (receivedDye == null) {
                    this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                    return;
                }
            }
            ItemStack received = UtilInventory.findItemMeta(this.inventory, wool_2);
            if (received == null) {
                received = this.requestItem(world, pos, wool_2);
            }
            if (received == null) {
                if (receivedDye != null) {
                    UtilInventory.addItemToInventory(this.inventory, receivedDye);
                }
                this.complainResult(world, lastResult, Blocks.field_150325_L.func_149739_a() + ".name", new Object[0]);
                return;
            }
            int color = 15 - (receivedDye != null ? receivedDye.func_77960_j() : 15);
            this.addItemToInventory(new ItemStack(Blocks.field_150404_cg, 3, color), this.coinPouch);
            --amount;
        }
    }

    private void craftBooks(World world, BlockPos pos, int amount) {
        int books = UtilInventory.findItem(this.inventory, Items.field_151122_aG, 3);
        if (books >= 0) {
            return;
        }
        while (amount > 0) {
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            ItemStack receivedLeather = UtilInventory.findItem(this.inventory, leather);
            if (receivedLeather == null) {
                receivedLeather = this.requestItem(world, pos, leather);
            }
            if (receivedLeather == null) {
                this.complainResult(world, lastResult, Items.field_151116_aA.func_77658_a() + ".name", new Object[0]);
                return;
            }
            ItemStack receivedPaper = UtilInventory.findItem(this.inventory, paper_3);
            if (receivedPaper == null && (receivedPaper = this.requestItem(world, pos, paper_3)) == null) {
                receivedPaper = AutoRecipes.make3PaperFrom3Reed(world, pos, this, this.inventory);
            }
            if (receivedPaper == null) {
                UtilInventory.addItemToInventory(this.inventory, receivedLeather);
                this.complainResult(world, lastResult, Items.field_151121_aF.func_77658_a() + ".name", new Object[0]);
                return;
            }
            this.addItemToInventory(new ItemStack(Items.field_151122_aG, 1), this.coinPouch);
            --amount;
        }
    }

    private ItemStack craftDye(World world, BlockPos pos, int dyeMeta) {
        switch (dyeMeta) {
            case 1: {
                return AutoRecipes.make2RedFrom1Rose(world, pos, this, this.inventory);
            }
            case 5: {
                return AutoRecipes.make4PurpleFrom1Rose2Lapis(world, pos, this, this.inventory);
            }
            case 6: {
                return AutoRecipes.make2CyanFrom1Green1Lapis(world, pos, this, this.inventory);
            }
            case 7: {
                return AutoRecipes.make3LightgrayFrom1Ink2White(world, pos, this, this.inventory);
            }
            case 8: {
                return AutoRecipes.make2GrayFrom1Ink1White(world, pos, this, this.inventory);
            }
            case 9: {
                return AutoRecipes.make2PinkFrom1Peony(world, pos, this, this.inventory);
            }
            case 10: {
                return AutoRecipes.make2LimeFrom1Green1White(world, pos, this, this.inventory);
            }
            case 11: {
                return AutoRecipes.make2YellowFrom1Sunflower(world, pos, this, this.inventory);
            }
            case 12: {
                return AutoRecipes.make2LightblueFrom1Lapis1White(world, pos, this, this.inventory);
            }
            case 13: {
                return AutoRecipes.make2MagentaFrom1Lilac(world, pos, this, this.inventory);
            }
            case 14: {
                return AutoRecipes.make4OrangeFrom1Rose1Sunflower(world, pos, this, this.inventory);
            }
        }
        return null;
    }
}

